/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.po;

import de.uka.ilkd.key.java.Expression;
import de.uka.ilkd.key.java.JavaInfo;
import de.uka.ilkd.key.java.PrettyPrinter;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.Statement;
import de.uka.ilkd.key.java.StatementBlock;
import de.uka.ilkd.key.java.abstraction.KeYJavaType;
import de.uka.ilkd.key.java.reference.ReferencePrefix;
import de.uka.ilkd.key.java.statement.MethodBodyStatement;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.IProgramMethod;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.LocationVariable;
import de.uka.ilkd.key.logic.op.Modality;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.proof.init.AbstractOperationPO;
import de.uka.ilkd.key.proof.init.IPersistablePO;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.proof.init.ProofOblInput;
import de.uka.ilkd.key.speclang.PositionedString;
import de.uka.ilkd.key.speclang.njml.JmlIO;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.key_project.util.collection.ImmutableArray;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;
import org.key_project.util.java.ObjectUtil;

public class ProgramMethodPO
extends AbstractOperationPO {
    private IProgramMethod pm;
    private String precondition;

    public ProgramMethodPO(InitConfig initConfig, String name, IProgramMethod pm, String precondition) {
        super(initConfig, name);
        assert (pm != null);
        this.pm = pm;
        this.precondition = precondition;
    }

    public ProgramMethodPO(InitConfig initConfig, String name, IProgramMethod pm, String precondition, boolean addUninterpretedPredicate, boolean addSymbolicExecutionLabel) {
        super(initConfig, name, addUninterpretedPredicate, addSymbolicExecutionLabel);
        assert (pm != null);
        this.pm = pm;
        this.precondition = precondition;
    }

    public IProgramMethod getProgramMethod() {
        return this.pm;
    }

    protected boolean isTransactionApplicable() {
        return false;
    }

    protected KeYJavaType getCalleeKeYJavaType() {
        return this.pm.getContainerType();
    }

    protected ImmutableList<StatementBlock> buildOperationBlocks(ImmutableList<LocationVariable> formalParVars, ProgramVariable selfVar, ProgramVariable resultVar, Services services) {
        IProgramMethod pm = this.getProgramMethod();
        ImmutableArray args = new ImmutableArray((Object[])((Expression[])formalParVars.toArray((Object[])new ProgramVariable[formalParVars.size()])));
        MethodBodyStatement mbs = new MethodBodyStatement(pm, (ReferencePrefix)selfVar, (IProgramVariable)resultVar, args);
        StatementBlock result = new StatementBlock((Statement)mbs);
        return ImmutableSLList.nil().prepend((Object[])new StatementBlock[]{null, result, null, null});
    }

    protected Term generateMbyAtPreDef(ProgramVariable selfVar, ImmutableList<ProgramVariable> paramVars, Services services) {
        return this.tb.tt();
    }

    protected Term getPre(List<LocationVariable> modHeaps, ProgramVariable selfVar, ImmutableList<ProgramVariable> paramVars, Map<LocationVariable, LocationVariable> atPreVars, Services services) {
        if (this.precondition != null && !this.precondition.isEmpty()) {
            JmlIO io = new JmlIO().services(services).classType(this.getCalleeKeYJavaType()).selfVar(selfVar).parameters(paramVars);
            PositionedString ps = new PositionedString(this.precondition);
            return io.parseExpression(ps);
        }
        return this.tb.tt();
    }

    protected Term getPost(List<LocationVariable> modHeaps, ProgramVariable selfVar, ImmutableList<ProgramVariable> paramVars, ProgramVariable resultVar, ProgramVariable exceptionVar, Map<LocationVariable, LocationVariable> atPreVars, Services services) {
        return this.tb.tt();
    }

    protected Term buildFrameClause(List<LocationVariable> modHeaps, Map<Term, Term> heapToAtPre, ProgramVariable selfVar, ImmutableList<ProgramVariable> paramVars, Services services) {
        return this.tb.tt();
    }

    protected Modality getTerminationMarker() {
        return Modality.DIA;
    }

    protected boolean isMakeNamesUnique() {
        return false;
    }

    protected boolean isCopyOfMethodArgumentsUsed() {
        return false;
    }

    protected String buildPOName(boolean transactionFlag) {
        return this.name;
    }

    public int hashCode() {
        return this.pm.hashCode() + (this.precondition != null ? this.precondition.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProgramMethodPO) {
            ProgramMethodPO other = (ProgramMethodPO)((Object)obj);
            return ObjectUtil.equals((Object)this.pm, (Object)other.getProgramMethod()) && ObjectUtil.equals((Object)this.precondition, (Object)other.getPrecondition());
        }
        return false;
    }

    public String getPrecondition() {
        return this.precondition;
    }

    public void fillSaveProperties(Properties properties) throws IOException {
        super.fillSaveProperties(properties);
        properties.setProperty("method", ProgramMethodPO.getProgramMethodSignature(this.getProgramMethod(), true));
        if (this.getPrecondition() != null && !this.getPrecondition().isEmpty()) {
            properties.setProperty("precondition", this.getPrecondition());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProgramMethodSignature(IProgramMethod pm, boolean includeType) throws IOException {
        try (StringWriter sw = new StringWriter();){
            PrettyPrinter x = new PrettyPrinter((Writer)sw);
            if (includeType) {
                KeYJavaType type = pm.getContainerType();
                sw.append(type.getFullName());
                sw.append("#");
            }
            x.printFullMethodSignature(pm);
            String string = sw.toString();
            return string;
        }
    }

    public static IPersistablePO.LoadedPOContainer loadFrom(InitConfig initConfig, Properties properties) throws IOException {
        return new IPersistablePO.LoadedPOContainer((ProofOblInput)new ProgramMethodPO(initConfig, ProgramMethodPO.getName((Properties)properties), ProgramMethodPO.getProgramMethod(initConfig, properties), ProgramMethodPO.getPrecondition(properties), ProgramMethodPO.isAddUninterpretedPredicate((Properties)properties), ProgramMethodPO.isAddSymbolicExecutionLabel((Properties)properties)));
    }

    public static IProgramMethod getProgramMethod(InitConfig initConfig, Properties properties) throws IOException {
        String value = properties.getProperty("method");
        if (value == null) {
            throw new IOException("Property \"method\" is not defined.");
        }
        int classMethodSeparator = value.indexOf("#");
        if (classMethodSeparator < 0) {
            throw new IOException("Property \"method\" does not contain the class method separator \"#\".");
        }
        String className = value.substring(0, classMethodSeparator);
        String signature = value.substring(classMethodSeparator + 1);
        JavaInfo javaInfo = initConfig.getServices().getJavaInfo();
        int breaketsStart = signature.indexOf("(");
        if (breaketsStart < 0) {
            throw new IOException("Method signature \"" + signature + "\" does not contain required character \"(\".");
        }
        int breaketsEnd = signature.lastIndexOf(")");
        if (breaketsEnd < 0) {
            throw new IOException("Method signature \"" + signature + "\" does not contain required character \")\".");
        }
        if (breaketsEnd < breaketsStart) {
            throw new IOException("Method signature has not valid order of chracters \"(\" and \")\".");
        }
        String name = signature.substring(0, breaketsStart);
        String parameters = signature.substring(breaketsStart + 1, breaketsEnd);
        String[] types = parameters.isEmpty() ? new String[]{} : parameters.split(",");
        KeYJavaType type = javaInfo.getKeYJavaType(className.trim());
        if (type == null) {
            throw new IOException("Can't find type \"" + className + "\".");
        }
        ImmutableSLList parameterTypes = ImmutableSLList.nil();
        for (int i = 0; i < types.length; ++i) {
            KeYJavaType paramType = javaInfo.getKeYJavaType(types[i].trim());
            if (paramType == null) {
                throw new IOException("Can't find type \"" + types[i] + "\".");
            }
            parameterTypes = parameterTypes.append((Object)paramType);
        }
        IProgramMethod pm = javaInfo.getProgramMethod(type, name.trim(), (ImmutableList)parameterTypes, type);
        if (pm == null && (pm = javaInfo.getConstructor(type, (ImmutableList)parameterTypes)) == null) {
            throw new IOException("Can't find program method \"" + value + "\".");
        }
        return pm;
    }

    public static String getPrecondition(Properties properties) {
        return properties.getProperty("precondition");
    }

    protected Term getGlobalDefs(LocationVariable heap, Term heapTerm, Term selfTerm, ImmutableList<Term> paramTerms, Services services) {
        return null;
    }

    public KeYJavaType getContainerType() {
        return this.getProgramMethod().getContainerType();
    }
}

