/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.po;

import de.uka.ilkd.key.java.Position;
import de.uka.ilkd.key.java.ProgramElement;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.Statement;
import de.uka.ilkd.key.java.StatementBlock;
import de.uka.ilkd.key.java.StatementContainer;
import de.uka.ilkd.key.java.abstraction.KeYJavaType;
import de.uka.ilkd.key.java.reference.ExecutionContext;
import de.uka.ilkd.key.java.reference.IExecutionContext;
import de.uka.ilkd.key.java.reference.ReferencePrefix;
import de.uka.ilkd.key.java.reference.TypeRef;
import de.uka.ilkd.key.java.reference.TypeReference;
import de.uka.ilkd.key.java.statement.Branch;
import de.uka.ilkd.key.java.statement.BranchStatement;
import de.uka.ilkd.key.java.statement.MethodFrame;
import de.uka.ilkd.key.java.statement.Return;
import de.uka.ilkd.key.java.visitor.UndeclaredProgramVariableCollector;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.IProgramMethod;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.LocationVariable;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.proof.init.IPersistablePO;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.proof.init.ProofOblInput;
import de.uka.ilkd.key.symbolic_execution.po.ProgramMethodPO;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;
import org.key_project.util.java.ObjectUtil;

public class ProgramMethodSubsetPO
extends ProgramMethodPO {
    private UndeclaredProgramVariableCollector undeclaredVariableCollector;
    private Position startPosition;
    private Position endPosition;

    public ProgramMethodSubsetPO(InitConfig initConfig, String name, IProgramMethod pm, String precondition, Position startPosition, Position endPosition) {
        super(initConfig, name, pm, precondition);
        assert (startPosition != null);
        assert (endPosition != null);
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    public ProgramMethodSubsetPO(InitConfig initConfig, String name, IProgramMethod pm, String precondition, Position startPosition, Position endPosition, boolean addUninterpretedPredicate, boolean addSymbolicExecutionLabel) {
        super(initConfig, name, pm, precondition, addUninterpretedPredicate, addSymbolicExecutionLabel);
        assert (startPosition != null);
        assert (endPosition != null);
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    @Override
    protected ImmutableList<StatementBlock> buildOperationBlocks(ImmutableList<LocationVariable> formalParVars, ProgramVariable selfVar, ProgramVariable resultVar, Services services) {
        KeYJavaType type = this.getCalleeKeYJavaType();
        IProgramMethod pm = this.getProgramMethod();
        LinkedList<Statement> statementsToExecute = new LinkedList<Statement>();
        this.collectStatementsToExecute(statementsToExecute, (StatementContainer)pm.getBody());
        Statement[] statements = statementsToExecute.toArray(new Statement[statementsToExecute.size()]);
        StatementBlock blockToExecute = new StatementBlock(statements);
        MethodFrame mf = new MethodFrame((IProgramVariable)(this.endsWithReturn(statements) ? resultVar : null), (IExecutionContext)new ExecutionContext((TypeReference)new TypeRef(type), pm, (ReferencePrefix)selfVar), blockToExecute);
        StatementBlock result = new StatementBlock((Statement)mf);
        this.undeclaredVariableCollector = new UndeclaredProgramVariableCollector((ProgramElement)result, services);
        this.undeclaredVariableCollector.start();
        LinkedHashSet undeclaredVariables = this.undeclaredVariableCollector.result();
        for (LocationVariable x : undeclaredVariables) {
            this.register((ProgramVariable)x, services);
        }
        return ImmutableSLList.nil().prepend((Object[])new StatementBlock[]{null, result, null, null});
    }

    protected void collectStatementsToExecute(List<Statement> toFill, StatementContainer container) {
        for (int i = 0; i < container.getStatementCount(); ++i) {
            Statement s = container.getStatementAt(i);
            if (s.getEndPosition().compareTo(this.startPosition) > 0 && s.getEndPosition().compareTo(this.endPosition) <= 0) {
                toFill.add(s);
                continue;
            }
            if (s instanceof StatementContainer) {
                this.collectStatementsToExecute(toFill, (StatementContainer)s);
                continue;
            }
            if (!(s instanceof BranchStatement)) continue;
            BranchStatement bs = (BranchStatement)s;
            for (int j = 0; j < bs.getBranchCount(); ++j) {
                Branch branch = bs.getBranchAt(j);
                this.collectStatementsToExecute(toFill, (StatementContainer)branch);
            }
        }
    }

    protected boolean endsWithReturn(Statement[] statements) {
        if (statements != null && statements.length >= 1) {
            return statements[statements.length - 1] instanceof Return;
        }
        return false;
    }

    @Override
    protected Term getPre(List<LocationVariable> modHeaps, ProgramVariable selfVar, ImmutableList<ProgramVariable> paramVars, Map<LocationVariable, LocationVariable> atPreVars, Services services) {
        ImmutableList<ProgramVariable> paramVarsList = ProgramMethodSubsetPO.convert(this.undeclaredVariableCollector.result());
        return super.getPre(modHeaps, selfVar, paramVarsList, atPreVars, services);
    }

    protected Term buildFreePre(ProgramVariable selfVar, KeYJavaType selfKJT, ImmutableList<ProgramVariable> paramVars, List<LocationVariable> heaps, Services proofServices) {
        ImmutableList<ProgramVariable> paramVarsList = ProgramMethodSubsetPO.convert(this.undeclaredVariableCollector.result());
        return super.buildFreePre(selfVar, selfKJT, paramVarsList, heaps, proofServices);
    }

    protected Term ensureUninterpretedPredicateExists(ImmutableList<ProgramVariable> paramVars, ImmutableList<LocationVariable> formalParamVars, ProgramVariable exceptionVar, String name, Services proofServices) {
        ImmutableList<ProgramVariable> paramVarsList = ProgramMethodSubsetPO.convert(this.undeclaredVariableCollector.result());
        return super.ensureUninterpretedPredicateExists(paramVarsList, formalParamVars, exceptionVar, name, proofServices);
    }

    protected static ImmutableList<ProgramVariable> convert(Collection<LocationVariable> c) {
        ImmutableSLList result = ImmutableSLList.nil();
        for (LocationVariable var : c) {
            result = result.append((Object)var);
        }
        return result;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.getStartPosition() != null ? this.getStartPosition().hashCode() : 0) + (this.getEndPosition() != null ? this.getEndPosition().hashCode() : 0);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ProgramMethodSubsetPO) {
            ProgramMethodSubsetPO other = (ProgramMethodSubsetPO)((Object)obj);
            return super.equals(obj) && ObjectUtil.equals((Object)this.getStartPosition(), (Object)other.getStartPosition()) && ObjectUtil.equals((Object)this.getEndPosition(), (Object)other.getEndPosition());
        }
        return false;
    }

    public Position getStartPosition() {
        return this.startPosition;
    }

    public Position getEndPosition() {
        return this.endPosition;
    }

    @Override
    public void fillSaveProperties(Properties properties) throws IOException {
        super.fillSaveProperties(properties);
        if (this.getStartPosition() != null) {
            properties.setProperty("startLine", "" + this.getStartPosition().getLine());
            properties.setProperty("startColumn", "" + this.getStartPosition().getColumn());
        }
        if (this.getEndPosition() != null) {
            properties.setProperty("endLine", "" + this.getEndPosition().getLine());
            properties.setProperty("endColumn", "" + this.getEndPosition().getColumn());
        }
    }

    public static IPersistablePO.LoadedPOContainer loadFrom(InitConfig initConfig, Properties properties) throws IOException {
        return new IPersistablePO.LoadedPOContainer((ProofOblInput)new ProgramMethodSubsetPO(initConfig, ProgramMethodSubsetPO.getName((Properties)properties), ProgramMethodSubsetPO.getProgramMethod(initConfig, properties), ProgramMethodSubsetPO.getPrecondition(properties), ProgramMethodSubsetPO.getStartPosition(properties), ProgramMethodSubsetPO.getEndPosition(properties), ProgramMethodSubsetPO.isAddUninterpretedPredicate((Properties)properties), ProgramMethodSubsetPO.isAddSymbolicExecutionLabel((Properties)properties)));
    }

    protected static Position getStartPosition(Properties properties) throws IOException {
        int columnValue;
        int lineValue;
        String line = properties.getProperty("startLine");
        if (line == null || line.isEmpty()) {
            throw new IOException("Start line property \"startLine\" is not available or empty.");
        }
        String column = properties.getProperty("startColumn");
        if (column == null || column.isEmpty()) {
            throw new IOException("Start column property \"startColumn\" is not available or empty.");
        }
        try {
            lineValue = Integer.parseInt(line);
        }
        catch (NumberFormatException e) {
            throw new IOException("Start line \"" + line + "\" is no valid integer.");
        }
        if (lineValue < 0) {
            throw new IOException("Start line \"" + line + "\" is a negative integer.");
        }
        try {
            columnValue = Integer.parseInt(column);
        }
        catch (NumberFormatException e) {
            throw new IOException("Start column \"" + column + "\" is no valid integer.");
        }
        if (columnValue < 0) {
            throw new IOException("Start column \"" + column + "\" is a negative integer.");
        }
        return new Position(lineValue, columnValue);
    }

    protected static Position getEndPosition(Properties properties) throws IOException {
        int columnValue;
        int lineValue;
        String line = properties.getProperty("endLine");
        if (line == null || line.isEmpty()) {
            throw new IOException("End line property \"endLine\" is not available or empty.");
        }
        String column = properties.getProperty("endColumn");
        if (column == null || column.isEmpty()) {
            throw new IOException("End column property \"endColumn\" is not available or empty.");
        }
        try {
            lineValue = Integer.parseInt(line);
        }
        catch (NumberFormatException e) {
            throw new IOException("End line \"" + line + "\" is no valid integer.");
        }
        if (lineValue < 0) {
            throw new IOException("End line \"" + line + "\" is a negative integer.");
        }
        try {
            columnValue = Integer.parseInt(column);
        }
        catch (NumberFormatException e) {
            throw new IOException("End column \"" + column + "\" is no valid integer.");
        }
        if (columnValue < 0) {
            throw new IOException("End column \"" + column + "\" is a negative integer.");
        }
        return new Position(lineValue, columnValue);
    }
}

