/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.po;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.TermFactory;
import de.uka.ilkd.key.logic.label.FormulaTermLabel;
import de.uka.ilkd.key.logic.label.TermLabel;
import de.uka.ilkd.key.proof.init.AbstractOperationPO;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.proof.init.POExtension;
import de.uka.ilkd.key.proof.init.ProofOblInput;
import de.uka.ilkd.key.symbolic_execution.TruthValueTracingUtil;
import de.uka.ilkd.key.symbolic_execution.profile.SymbolicExecutionJavaProfile;
import org.key_project.util.collection.ImmutableArray;

public class TruthValuePOExtension
implements POExtension {
    public boolean isPOSupported(ProofOblInput po) {
        return po instanceof AbstractOperationPO;
    }

    public Term modifyPostTerm(InitConfig proofConfig, Services services, Term postTerm) {
        if (SymbolicExecutionJavaProfile.isTruthValueEvaluationEnabled(proofConfig)) {
            return this.labelPostTerm(services, postTerm);
        }
        return postTerm;
    }

    protected Term labelPostTerm(Services services, Term term) {
        if (term != null) {
            TermFactory tf = services.getTermFactory();
            if (TruthValueTracingUtil.isLogicOperator(term)) {
                Object[] newSubs = new Term[term.arity()];
                boolean subsChanged = false;
                for (int i = 0; i < newSubs.length; ++i) {
                    Term oldTerm = term.sub(i);
                    newSubs[i] = this.labelPostTerm(services, oldTerm);
                    if (oldTerm == newSubs[i]) continue;
                    subsChanged = true;
                }
                term = subsChanged ? tf.createTerm(term.op(), new ImmutableArray(newSubs), term.boundVars(), term.javaBlock(), term.getLabels()) : term;
            }
            ImmutableArray oldLabels = term.getLabels();
            Object[] newLabels = (TermLabel[])oldLabels.toArray((Object[])new TermLabel[oldLabels.size() + 1]);
            int labelID = services.getCounter("F_LABEL_COUNTER").getCountPlusPlus();
            int labelSubID = FormulaTermLabel.newLabelSubID((Services)services, (int)labelID);
            newLabels[oldLabels.size()] = new FormulaTermLabel(labelID, labelSubID);
            return tf.createTerm(term.op(), term.subs(), term.boundVars(), term.javaBlock(), new ImmutableArray(newLabels));
        }
        return null;
    }
}

