/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.profile;

import de.uka.ilkd.key.logic.label.BlockContractValidityTermLabel;
import de.uka.ilkd.key.logic.label.BlockContractValidityTermLabelFactory;
import de.uka.ilkd.key.logic.label.FormulaTermLabel;
import de.uka.ilkd.key.logic.label.FormulaTermLabelFactory;
import de.uka.ilkd.key.logic.label.SingletonLabelFactory;
import de.uka.ilkd.key.logic.label.SymbolicExecutionTermLabel;
import de.uka.ilkd.key.logic.label.SymbolicExecutionTermLabelFactory;
import de.uka.ilkd.key.logic.label.TermLabelFactory;
import de.uka.ilkd.key.logic.label.TermLabelManager;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.proof.init.JavaProfile;
import de.uka.ilkd.key.proof.init.Profile;
import de.uka.ilkd.key.prover.GoalChooserBuilder;
import de.uka.ilkd.key.rule.BuiltInRule;
import de.uka.ilkd.key.rule.label.BlockContractValidityTermLabelUpdate;
import de.uka.ilkd.key.rule.label.FormulaTermLabelMerger;
import de.uka.ilkd.key.rule.label.FormulaTermLabelRefactoring;
import de.uka.ilkd.key.rule.label.FormulaTermLabelUpdate;
import de.uka.ilkd.key.rule.label.LoopBodyTermLabelUpdate;
import de.uka.ilkd.key.rule.label.LoopInvariantNormalBehaviorTermLabelUpdate;
import de.uka.ilkd.key.rule.label.RemoveInCheckBranchesTermLabelRefactoring;
import de.uka.ilkd.key.rule.label.StayOnFormulaTermLabelPolicy;
import de.uka.ilkd.key.rule.label.StayOnOperatorTermLabelPolicy;
import de.uka.ilkd.key.rule.label.SymbolicExecutionTermLabelUpdate;
import de.uka.ilkd.key.rule.label.TermLabelMerger;
import de.uka.ilkd.key.strategy.StrategyFactory;
import de.uka.ilkd.key.symbolic_execution.rule.ModalitySideProofRule;
import de.uka.ilkd.key.symbolic_execution.rule.QuerySideProofRule;
import de.uka.ilkd.key.symbolic_execution.strategy.SymbolicExecutionGoalChooserBuilder;
import de.uka.ilkd.key.symbolic_execution.strategy.SymbolicExecutionStrategy;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;
import org.key_project.util.collection.ImmutableSet;

public class SymbolicExecutionJavaProfile
extends JavaProfile {
    public static final String NAME = "Java Profile for Symbolic Execution";
    private static final StrategyFactory SYMBOLIC_EXECUTION_FACTORY = new SymbolicExecutionStrategy.Factory();
    private final Boolean truthValueEvaluationEnabled;
    public static SymbolicExecutionJavaProfile defaultInstance;
    public static SymbolicExecutionJavaProfile defaultInstanceWithTruthValueEvaluation;

    public SymbolicExecutionJavaProfile(boolean predicateEvaluationEnabled) {
        this.truthValueEvaluationEnabled = predicateEvaluationEnabled;
        this.initTermLabelManager();
    }

    protected ImmutableSet<GoalChooserBuilder> computeSupportedGoalChooserBuilder() {
        return super.computeSupportedGoalChooserBuilder().add((Object)new SymbolicExecutionGoalChooserBuilder());
    }

    protected void initTermLabelManager() {
        if (this.truthValueEvaluationEnabled != null) {
            super.initTermLabelManager();
        }
    }

    protected ImmutableList<TermLabelManager.TermLabelConfiguration> computeTermLabelConfiguration() {
        ImmutableList result = super.computeTermLabelConfiguration();
        result = result.prepend(SymbolicExecutionJavaProfile.getSymbolicExecutionTermLabelConfigurations(this.truthValueEvaluationEnabled));
        return result;
    }

    public static ImmutableList<TermLabelManager.TermLabelConfiguration> getSymbolicExecutionTermLabelConfigurations(boolean predicateEvaluationEnabled) {
        ImmutableList symExcPolicies = ImmutableSLList.nil().prepend((Object)new StayOnOperatorTermLabelPolicy());
        ImmutableList bcUps = ImmutableSLList.nil().prepend((Object)new BlockContractValidityTermLabelUpdate());
        ImmutableList lbUps = ImmutableSLList.nil().prepend((Object)new LoopBodyTermLabelUpdate());
        ImmutableList nbUps = ImmutableSLList.nil().prepend((Object)new LoopInvariantNormalBehaviorTermLabelUpdate());
        ImmutableList seUps = ImmutableSLList.nil().prepend((Object)new SymbolicExecutionTermLabelUpdate());
        ImmutableList bcRefs = ImmutableSLList.nil().prepend((Object)new RemoveInCheckBranchesTermLabelRefactoring(BlockContractValidityTermLabel.NAME));
        ImmutableList lbRefs = ImmutableSLList.nil().prepend((Object)new RemoveInCheckBranchesTermLabelRefactoring(SymbolicExecutionUtil.LOOP_BODY_LABEL_NAME));
        ImmutableList nbRefs = ImmutableSLList.nil().prepend((Object)new RemoveInCheckBranchesTermLabelRefactoring(SymbolicExecutionUtil.LOOP_INVARIANT_NORMAL_BEHAVIOR_LABEL_NAME));
        ImmutableList seRefs = ImmutableSLList.nil().prepend((Object)new RemoveInCheckBranchesTermLabelRefactoring(SymbolicExecutionTermLabel.NAME));
        ImmutableSLList result = ImmutableSLList.nil();
        result = result.prepend((Object)new TermLabelManager.TermLabelConfiguration(BlockContractValidityTermLabel.NAME, (TermLabelFactory)new BlockContractValidityTermLabelFactory(), null, symExcPolicies, null, null, bcUps, bcRefs, null));
        result = result.prepend((Object)new TermLabelManager.TermLabelConfiguration(SymbolicExecutionUtil.LOOP_BODY_LABEL_NAME, (TermLabelFactory)new SingletonLabelFactory(SymbolicExecutionUtil.LOOP_BODY_LABEL), null, symExcPolicies, null, null, lbUps, lbRefs, null));
        result = result.prepend((Object)new TermLabelManager.TermLabelConfiguration(SymbolicExecutionUtil.LOOP_INVARIANT_NORMAL_BEHAVIOR_LABEL_NAME, (TermLabelFactory)new SingletonLabelFactory(SymbolicExecutionUtil.LOOP_INVARIANT_NORMAL_BEHAVIOR_LABEL), null, symExcPolicies, null, null, nbUps, nbRefs, null));
        result = result.prepend((Object)new TermLabelManager.TermLabelConfiguration(SymbolicExecutionTermLabel.NAME, (TermLabelFactory)new SymbolicExecutionTermLabelFactory(), null, symExcPolicies, null, null, seUps, seRefs, null));
        if (predicateEvaluationEnabled) {
            ImmutableList predPolicies = ImmutableSLList.nil().prepend((Object)new StayOnFormulaTermLabelPolicy());
            ImmutableList predUpdates = ImmutableSLList.nil().prepend((Object)new FormulaTermLabelUpdate());
            ImmutableList predRefs = ImmutableSLList.nil().prepend((Object)new FormulaTermLabelRefactoring());
            result = result.prepend((Object)new TermLabelManager.TermLabelConfiguration(FormulaTermLabel.NAME, (TermLabelFactory)new FormulaTermLabelFactory(), null, predPolicies, null, null, predUpdates, predRefs, (TermLabelMerger)new FormulaTermLabelMerger()));
        }
        return result;
    }

    protected ImmutableSet<StrategyFactory> getStrategyFactories() {
        ImmutableSet set = super.getStrategyFactories();
        set = set.add((Object)SYMBOLIC_EXECUTION_FACTORY);
        return set;
    }

    protected ImmutableList<BuiltInRule> initBuiltInRules() {
        ImmutableList builtInRules = super.initBuiltInRules();
        builtInRules = builtInRules.prepend((Object)QuerySideProofRule.INSTANCE);
        builtInRules = builtInRules.prepend((Object)ModalitySideProofRule.INSTANCE);
        return builtInRules;
    }

    public String name() {
        return NAME;
    }

    public boolean isPredicateEvaluationEnabled() {
        return this.truthValueEvaluationEnabled;
    }

    public static synchronized SymbolicExecutionJavaProfile getDefaultInstance() {
        return SymbolicExecutionJavaProfile.getDefaultInstance(false);
    }

    public static synchronized SymbolicExecutionJavaProfile getDefaultInstance(boolean truthValueEvaluationEnabled) {
        if (!truthValueEvaluationEnabled) {
            if (defaultInstance == null) {
                defaultInstance = new SymbolicExecutionJavaProfile(false);
            }
            return defaultInstance;
        }
        if (defaultInstanceWithTruthValueEvaluation == null) {
            defaultInstanceWithTruthValueEvaluation = new SymbolicExecutionJavaProfile(true);
        }
        return defaultInstanceWithTruthValueEvaluation;
    }

    public static boolean isTruthValueTracingEnabled(Proof proof) {
        if (proof != null && !proof.isDisposed()) {
            return SymbolicExecutionJavaProfile.isTruthValueEvaluationEnabled(proof.getInitConfig());
        }
        return false;
    }

    public static boolean isTruthValueEvaluationEnabled(InitConfig initConfig) {
        if (initConfig != null) {
            return SymbolicExecutionJavaProfile.isTruthValueEvaluationEnabled(initConfig.getProfile());
        }
        return false;
    }

    public static boolean isTruthValueEvaluationEnabled(Profile profile) {
        if (profile instanceof SymbolicExecutionJavaProfile) {
            return ((SymbolicExecutionJavaProfile)profile).isPredicateEvaluationEnabled();
        }
        return false;
    }
}

