/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.rule;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.logic.Named;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.PosInTerm;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.Function;
import de.uka.ilkd.key.logic.op.Operator;
import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.proof.mgt.ProofEnvironment;
import de.uka.ilkd.key.rule.BuiltInRule;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionSideProofUtil;
import de.uka.ilkd.key.util.Pair;
import de.uka.ilkd.key.util.Triple;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class AbstractSideProofRule
implements BuiltInRule {
    protected Function createResultConstant(Services services, Sort sort) {
        String functionName = services.getTermBuilder().newName("QueryResult");
        Function function = new Function(new Name(functionName), sort);
        services.getNamespaces().functions().addSafely((Named)function);
        return function;
    }

    protected Function createResultFunction(Services services, Sort sort) {
        return new Function(new Name(services.getTermBuilder().newName("ResultPredicate")), Sort.FORMULA, new Sort[]{sort});
    }

    protected List<Triple<Term, Set<Term>, Node>> computeResultsAndConditions(Services services, Goal goal, ProofEnvironment sideProofEnvironment, Sequent sequentToProve, Function newPredicate) throws ProofInputException {
        return SymbolicExecutionSideProofUtil.computeResultsAndConditions(services, goal.proof(), sideProofEnvironment, sequentToProve, (Operator)newPredicate, "Side proof rule on node " + goal.node().serialNr() + ".", "METHOD_CONTRACT", "LOOP_INVARIANT", "QUERY_ON", "SPLITTING_DELAYED", true);
    }

    protected static SequentFormula replace(PosInOccurrence pio, Term newTerm, Services services) {
        LinkedList<Pair> indexAndParents = new LinkedList<Pair>();
        Term root = pio.sequentFormula().formula();
        PosInTerm pit = pio.posInTerm();
        int sz = pit.depth();
        for (int i = 0; i < sz; ++i) {
            int next = pit.getIndexAt(i);
            indexAndParents.addFirst(new Pair((Object)next, (Object)root));
            root = root.sub(next);
        }
        root = newTerm;
        for (Pair pair : indexAndParents) {
            Term parent = (Term)pair.second;
            Term[] newSubs = (Term[])parent.subs().toArray((Object[])new Term[parent.arity()]);
            newSubs[((Integer)pair.first).intValue()] = root;
            root = services.getTermFactory().createTerm(parent.op(), newSubs, parent.boundVars(), parent.javaBlock(), parent.getLabels());
        }
        return new SequentFormula(root);
    }

    public boolean isApplicableOnSubTerms() {
        return false;
    }
}

