/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.rule;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.TermBuilder;
import de.uka.ilkd.key.logic.TermServices;
import de.uka.ilkd.key.logic.op.Equality;
import de.uka.ilkd.key.logic.op.Function;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.Junctor;
import de.uka.ilkd.key.logic.op.LocationVariable;
import de.uka.ilkd.key.logic.op.Modality;
import de.uka.ilkd.key.logic.op.Transformer;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.mgt.ProofEnvironment;
import de.uka.ilkd.key.rule.BuiltInRule;
import de.uka.ilkd.key.rule.DefaultBuiltInRuleApp;
import de.uka.ilkd.key.rule.IBuiltInRuleApp;
import de.uka.ilkd.key.rule.RuleAbortException;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.symbolic_execution.rule.AbstractSideProofRule;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionSideProofUtil;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import de.uka.ilkd.key.util.Pair;
import de.uka.ilkd.key.util.Triple;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.key_project.util.collection.ImmutableArray;
import org.key_project.util.collection.ImmutableList;

public class ModalitySideProofRule
extends AbstractSideProofRule {
    public static final ModalitySideProofRule INSTANCE = new ModalitySideProofRule();
    private static final Name NAME = new Name("Evaluate Modality in Side Proof");

    private ModalitySideProofRule() {
    }

    public boolean isApplicable(Goal goal, PosInOccurrence pio) {
        boolean applicable = false;
        if (pio != null && pio.isTopLevel()) {
            if (Transformer.inTransformer((PosInOccurrence)pio)) {
                return false;
            }
            Term term = pio.subTerm();
            if ((term = TermBuilder.goBelowUpdates((Term)term)).op() instanceof Modality && SymbolicExecutionUtil.getSymbolicExecutionLabel(term) == null) {
                Term equalityTerm = term.sub(0);
                if (equalityTerm.op() == Junctor.IMP) {
                    equalityTerm = equalityTerm.sub(0);
                }
                if (equalityTerm.op() == Junctor.NOT) {
                    equalityTerm = equalityTerm.sub(0);
                }
                if (equalityTerm.op() == Equality.EQUALS && (equalityTerm.sub(0).op() instanceof IProgramVariable || equalityTerm.sub(1).op() instanceof IProgramVariable)) {
                    applicable = true;
                }
            }
        }
        return applicable;
    }

    public IBuiltInRuleApp createApp(PosInOccurrence pos, TermServices services) {
        return new DefaultBuiltInRuleApp((BuiltInRule)this, pos);
    }

    public ImmutableList<Goal> apply(Goal goal, Services services, RuleApp ruleApp) throws RuleAbortException {
        try {
            boolean varFirst;
            Term varTerm;
            Term otherTerm;
            PosInOccurrence pio = ruleApp.posInOccurrence();
            Term topLevelTerm = pio.subTerm();
            Pair updatesAndTerm = TermBuilder.goBelowUpdates2((Term)topLevelTerm);
            Term modalityTerm = (Term)updatesAndTerm.second;
            ImmutableList updates = (ImmutableList)updatesAndTerm.first;
            boolean inImplication = false;
            Term equalityTerm = modalityTerm.sub(0);
            if (equalityTerm.op() == Junctor.IMP) {
                inImplication = true;
                equalityTerm = equalityTerm.sub(0);
            }
            boolean negation = false;
            if (equalityTerm.op() == Junctor.NOT) {
                negation = true;
                equalityTerm = equalityTerm.sub(0);
            }
            if (equalityTerm.sub(0).op() instanceof LocationVariable) {
                otherTerm = equalityTerm.sub(1);
                varTerm = equalityTerm.sub(0);
                varFirst = true;
            } else {
                otherTerm = equalityTerm.sub(0);
                varTerm = equalityTerm.sub(1);
                varFirst = false;
            }
            ProofEnvironment sideProofEnv = SymbolicExecutionSideProofUtil.cloneProofEnvironmentWithOwnOneStepSimplifier(goal.proof(), true);
            Services sideProofServices = sideProofEnv.getServicesForEnvironment();
            Sequent sequentToProve = SymbolicExecutionSideProofUtil.computeGeneralSequentToProve(goal.sequent(), pio.sequentFormula());
            Function newPredicate = this.createResultFunction(sideProofServices, varTerm.sort());
            TermBuilder tb = sideProofServices.getTermBuilder();
            Term newTerm = tb.func(newPredicate, varTerm);
            Term newModalityTerm = sideProofServices.getTermFactory().createTerm(modalityTerm.op(), new ImmutableArray((Object[])new Term[]{newTerm}), modalityTerm.boundVars(), modalityTerm.javaBlock(), modalityTerm.getLabels());
            Term newModalityWithUpdatesTerm = tb.applySequential(updates, newModalityTerm);
            sequentToProve = sequentToProve.addFormula(new SequentFormula(newModalityWithUpdatesTerm), false, false).sequent();
            List<Triple<Term, Set<Term>, Node>> conditionsAndResultsMap = this.computeResultsAndConditions(services, goal, sideProofEnv, sequentToProve, newPredicate);
            ImmutableList goals = goal.split(1);
            Goal resultGoal = (Goal)goals.head();
            resultGoal.removeFormula(pio);
            LinkedHashSet<Term> resultTerms = new LinkedHashSet<Term>();
            for (Triple<Term, Set<Term>, Node> conditionsAndResult : conditionsAndResultsMap) {
                Term conditionTerm = tb.and((Iterable)conditionsAndResult.second);
                Term resultEqualityTerm = varFirst ? tb.equals((Term)conditionsAndResult.first, otherTerm) : tb.equals(otherTerm, (Term)conditionsAndResult.first);
                Term resultTerm = pio.isInAntec() ? tb.imp(conditionTerm, resultEqualityTerm) : tb.and(conditionTerm, resultEqualityTerm);
                resultTerms.add(resultTerm);
            }
            if (inImplication) {
                Term newCondition = tb.or(resultTerms);
                if (negation) {
                    newCondition = tb.not(newCondition);
                }
                Term newImplication = tb.imp(newCondition, modalityTerm.sub(0).sub(1));
                Term newImplicationWithUpdates = tb.applySequential(updates, newImplication);
                resultGoal.addFormula(new SequentFormula(newImplicationWithUpdates), pio.isInAntec(), false);
            } else {
                for (Term result : resultTerms) {
                    resultGoal.addFormula(new SequentFormula(result), pio.isInAntec(), false);
                }
            }
            return goals;
        }
        catch (Exception e) {
            throw new RuleAbortException(e.getMessage());
        }
    }

    public Name name() {
        return NAME;
    }

    public String displayName() {
        return NAME.toString();
    }

    public String toString() {
        return this.displayName();
    }
}

