/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.rule;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.logic.PIOPathIterator;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.TermBuilder;
import de.uka.ilkd.key.logic.TermServices;
import de.uka.ilkd.key.logic.op.Equality;
import de.uka.ilkd.key.logic.op.Function;
import de.uka.ilkd.key.logic.op.IProgramMethod;
import de.uka.ilkd.key.logic.op.Junctor;
import de.uka.ilkd.key.logic.op.LocationVariable;
import de.uka.ilkd.key.logic.op.Modality;
import de.uka.ilkd.key.logic.op.Transformer;
import de.uka.ilkd.key.logic.op.UpdateApplication;
import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.mgt.ProofEnvironment;
import de.uka.ilkd.key.rule.BuiltInRule;
import de.uka.ilkd.key.rule.DefaultBuiltInRuleApp;
import de.uka.ilkd.key.rule.IBuiltInRuleApp;
import de.uka.ilkd.key.rule.RuleAbortException;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.symbolic_execution.rule.AbstractSideProofRule;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionSideProofUtil;
import de.uka.ilkd.key.util.Triple;
import java.util.List;
import java.util.Set;
import org.key_project.util.collection.ImmutableList;

public final class QuerySideProofRule
extends AbstractSideProofRule {
    public static final QuerySideProofRule INSTANCE = new QuerySideProofRule();
    private static final Name NAME = new Name("Evaluate Query in Side Proof");

    private QuerySideProofRule() {
    }

    public boolean isApplicable(Goal goal, PosInOccurrence pio) {
        boolean applicable = false;
        if (pio != null) {
            if (Transformer.inTransformer((PosInOccurrence)pio)) {
                return false;
            }
            Term term = pio.subTerm();
            if (term != null && term.op() == Equality.EQUALS) {
                applicable = this.isApplicableQuery(goal, term.sub(0), pio) || this.isApplicableQuery(goal, term.sub(1), pio);
            }
        }
        return applicable;
    }

    protected boolean isApplicableQuery(Goal goal, Term pmTerm, PosInOccurrence pio) {
        if (pmTerm.op() instanceof IProgramMethod && pmTerm.freeVars().isEmpty()) {
            IProgramMethod pm = (IProgramMethod)pmTerm.op();
            Sort nullSort = goal.proof().getJavaInfo().nullSort();
            if (pm.isStatic() || pmTerm.sub(1).sort().extendsTrans(goal.proof().getJavaInfo().objectSort()) && !pmTerm.sub(1).sort().extendsTrans(nullSort)) {
                PIOPathIterator it = pio.iterator();
                while (it.next() != -1) {
                    Term focus = it.getSubTerm();
                    if (!(focus.op() instanceof UpdateApplication) && !(focus.op() instanceof Modality)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public IBuiltInRuleApp createApp(PosInOccurrence pos, TermServices services) {
        return new DefaultBuiltInRuleApp((BuiltInRule)this, pos);
    }

    public ImmutableList<Goal> apply(Goal goal, Services services, RuleApp ruleApp) throws RuleAbortException {
        try {
            boolean varFirst;
            Term varTerm;
            Term queryTerm;
            PosInOccurrence pio = ruleApp.posInOccurrence();
            Sequent goalSequent = goal.sequent();
            SequentFormula equalitySF = pio.sequentFormula();
            Term equalityTerm = pio.subTerm();
            if (equalityTerm.sub(0).op() instanceof LocationVariable) {
                queryTerm = equalityTerm.sub(1);
                varTerm = equalityTerm.sub(0);
                varFirst = true;
            } else {
                queryTerm = equalityTerm.sub(0);
                varTerm = equalityTerm.sub(1);
                varFirst = false;
            }
            Term queryConditionTerm = null;
            if (equalitySF.formula().op() == Junctor.IMP && equalitySF.formula().sub(1) == equalityTerm) {
                queryConditionTerm = equalitySF.formula().sub(0);
            }
            ProofEnvironment sideProofEnv = SymbolicExecutionSideProofUtil.cloneProofEnvironmentWithOwnOneStepSimplifier(goal.proof(), true);
            Services sideProofServices = sideProofEnv.getServicesForEnvironment();
            Sequent sequentToProve = SymbolicExecutionSideProofUtil.computeGeneralSequentToProve(goalSequent, equalitySF);
            Function newPredicate = this.createResultFunction(sideProofServices, queryTerm.sort());
            Term newTerm = sideProofServices.getTermBuilder().func(newPredicate, queryTerm);
            sequentToProve = sequentToProve.addFormula(new SequentFormula(newTerm), false, false).sequent();
            List<Triple<Term, Set<Term>, Node>> conditionsAndResultsMap = this.computeResultsAndConditions(services, goal, sideProofEnv, sequentToProve, newPredicate);
            ImmutableList goals = goal.split(1);
            Goal resultGoal = (Goal)goals.head();
            TermBuilder tb = services.getTermBuilder();
            resultGoal.removeFormula(pio);
            if (pio.isTopLevel() || queryConditionTerm != null) {
                for (Triple<Term, Set<Term>, Node> conditionsAndResult : conditionsAndResultsMap) {
                    Term resultTerm;
                    Term conditionTerm = tb.and((Iterable)conditionsAndResult.second);
                    Term newEqualityTerm = varFirst ? tb.equals(varTerm, (Term)conditionsAndResult.first) : tb.equals((Term)conditionsAndResult.first, varTerm);
                    Term term = resultTerm = pio.isInAntec() ? tb.imp(conditionTerm, newEqualityTerm) : tb.and(conditionTerm, newEqualityTerm);
                    if (queryConditionTerm != null) {
                        resultTerm = tb.imp(queryConditionTerm, resultTerm);
                    }
                    resultGoal.addFormula(new SequentFormula(resultTerm), pio.isInAntec(), false);
                }
            } else {
                Function resultFunction = this.createResultConstant(services, varTerm.sort());
                Term resultFunctionTerm = tb.func(resultFunction);
                resultGoal.addFormula(QuerySideProofRule.replace(pio, varFirst ? tb.equals(resultFunctionTerm, varTerm) : tb.equals(resultFunctionTerm, varTerm), services), pio.isInAntec(), false);
                for (Triple<Term, Set<Term>, Node> conditionsAndResult : conditionsAndResultsMap) {
                    Term conditionTerm = tb.and((Iterable)conditionsAndResult.second);
                    Term resultTerm = tb.imp(conditionTerm, varFirst ? tb.equals(resultFunctionTerm, (Term)conditionsAndResult.first) : tb.equals((Term)conditionsAndResult.first, resultFunctionTerm));
                    resultGoal.addFormula(new SequentFormula(resultTerm), true, false);
                }
            }
            return goals;
        }
        catch (Exception e) {
            throw new RuleAbortException(e.getMessage());
        }
    }

    public Name name() {
        return NAME;
    }

    public String displayName() {
        return NAME.toString();
    }

    public String toString() {
        return this.displayName();
    }

    @Override
    public boolean isApplicableOnSubTerms() {
        return true;
    }
}

