/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.slicing;

import de.uka.ilkd.key.java.NonTerminalProgramElement;
import de.uka.ilkd.key.java.ProgramElement;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.java.expression.operator.CopyAssignment;
import de.uka.ilkd.key.java.reference.ReferencePrefix;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.NodeInfo;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicEquivalenceClass;
import de.uka.ilkd.key.symbolic_execution.slicing.AbstractSlicer;
import de.uka.ilkd.key.symbolic_execution.slicing.Access;
import de.uka.ilkd.key.symbolic_execution.slicing.Location;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.key_project.util.collection.ImmutableArray;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;

public abstract class AbstractBackwardSlicer
extends AbstractSlicer {
    @Override
    public ImmutableArray<Node> doSlicing(Node seedNode, Location seedLocation, ImmutableList<ISymbolicEquivalenceClass> sec) throws ProofInputException {
        Services services = seedNode.proof().getServices();
        Set<Location> relevantLocations = null;
        LinkedList<Node> result = new LinkedList<Node>();
        Map<Location, SortedSet<Location>> oldAliases = null;
        Node previousChild = null;
        while (!(seedNode == null || relevantLocations != null && relevantLocations.isEmpty())) {
            AbstractSlicer.SequentInfo info;
            if (NodeInfo.isSymbolicExecutionRuleApplied((Node)seedNode) && (info = this.analyzeSequent(seedNode, sec)) != null) {
                SourceElement activeStatement = seedNode.getNodeInfo().getActiveStatement();
                Map<Location, SortedSet<Location>> aliases = info.getAliases();
                ReferencePrefix thisReference = info.getThisReference();
                if (relevantLocations == null) {
                    relevantLocations = new HashSet<Location>();
                    relevantLocations.add(this.normalizeAlias(services, seedLocation, info));
                }
                if (this.accept(seedNode, previousChild, services, relevantLocations, info, activeStatement)) {
                    result.add(seedNode);
                }
                if (oldAliases != null) {
                    try {
                        if (activeStatement instanceof CopyAssignment) {
                            SourceElement originalTarget = (SourceElement)((CopyAssignment)activeStatement).getArguments().get(0);
                            ReferencePrefix relevantTarget = this.toReferencePrefix(originalTarget);
                            Location normalizedPrefix = this.normalizeAlias(services, relevantTarget, info);
                            relevantLocations = this.updateOutdatedLocations(services, relevantLocations, aliases, oldAliases, normalizedPrefix, thisReference);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                oldAliases = aliases;
            }
            previousChild = seedNode;
            seedNode = seedNode.parent();
        }
        return new ImmutableArray(result);
    }

    protected abstract boolean accept(Node var1, Node var2, Services var3, Set<Location> var4, AbstractSlicer.SequentInfo var5, SourceElement var6) throws ProofInputException;

    protected void updateRelevantLocations(ProgramElement read, Set<Location> relevantLocations, AbstractSlicer.SequentInfo info, Services services) {
        ReferencePrefix relevantElement = this.toReferencePrefix((SourceElement)read);
        if (relevantElement != null) {
            Location normalizedElement = this.normalizeAlias(services, relevantElement, info);
            relevantLocations.add(normalizedElement);
        } else if (read instanceof NonTerminalProgramElement) {
            NonTerminalProgramElement ntpe = (NonTerminalProgramElement)read;
            for (int i = 0; i < ntpe.getChildCount(); ++i) {
                this.updateRelevantLocations(ntpe.getChildAt(i), relevantLocations, info, services);
            }
        }
    }

    protected Set<Location> updateOutdatedLocations(Services services, Set<Location> oldLocationsToUpdate, Map<Location, SortedSet<Location>> newAliases, Map<Location, SortedSet<Location>> oldAliases, Location outdatedPrefix, ReferencePrefix thisReference) {
        if (!oldLocationsToUpdate.isEmpty()) {
            SortedSet<Location> oldAlternatives;
            SortedSet<Location> newAlternatives = newAliases.get(outdatedPrefix);
            if (newAlternatives == null) {
                newAlternatives = this.createSortedSet();
                newAlternatives.add(outdatedPrefix);
            }
            if ((oldAlternatives = oldAliases.get(outdatedPrefix)) == null) {
                oldAlternatives = this.createSortedSet();
                oldAlternatives.add(outdatedPrefix);
            }
            if (!newAlternatives.equals(oldAlternatives)) {
                ImmutableSLList newAlternativeVariables = ImmutableSLList.nil();
                for (Location newALternative : newAlternatives) {
                    newAlternativeVariables = newAlternativeVariables.prepend(newALternative.getAccesses());
                }
                Location newAlternative = this.findNewAlternative(oldAlternatives, newAlternatives);
                HashSet<Location> newLocations = new HashSet<Location>();
                for (Location oldLocation : oldLocationsToUpdate) {
                    ImmutableList<Access> oldVariables = oldLocation.getAccesses();
                    int commonPrefixLength = AbstractBackwardSlicer.computeFirstCommonPrefixLength(newAlternativeVariables, oldVariables);
                    if (commonPrefixLength >= 1) {
                        if (newAlternative == null) continue;
                        if (commonPrefixLength == oldVariables.size()) {
                            newLocations.add(newAlternative);
                            continue;
                        }
                        ImmutableList oldRemainignVariables = oldVariables.take(commonPrefixLength);
                        ImmutableList newAccesses = newAlternative.getAccesses().append(oldRemainignVariables);
                        newLocations.add(new Location((ImmutableList<Access>)newAccesses));
                        continue;
                    }
                    newLocations.add(oldLocation);
                }
                return newLocations;
            }
            return oldLocationsToUpdate;
        }
        return oldLocationsToUpdate;
    }
}

