/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.slicing;

import de.uka.ilkd.key.java.Expression;
import de.uka.ilkd.key.java.JavaTools;
import de.uka.ilkd.key.java.ProgramElement;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.java.expression.PassiveExpression;
import de.uka.ilkd.key.java.reference.ArrayReference;
import de.uka.ilkd.key.java.reference.ExecutionContext;
import de.uka.ilkd.key.java.reference.FieldReference;
import de.uka.ilkd.key.java.reference.ReferencePrefix;
import de.uka.ilkd.key.java.reference.ThisReference;
import de.uka.ilkd.key.ldt.HeapLDT;
import de.uka.ilkd.key.logic.JavaBlock;
import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.TermBuilder;
import de.uka.ilkd.key.logic.TermServices;
import de.uka.ilkd.key.logic.label.ParameterlessTermLabel;
import de.uka.ilkd.key.logic.label.SymbolicExecutionTermLabel;
import de.uka.ilkd.key.logic.op.ElementaryUpdate;
import de.uka.ilkd.key.logic.op.Equality;
import de.uka.ilkd.key.logic.op.Function;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.Junctor;
import de.uka.ilkd.key.logic.op.LocationVariable;
import de.uka.ilkd.key.logic.op.Operator;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.logic.op.UpdateApplication;
import de.uka.ilkd.key.logic.op.UpdateJunctor;
import de.uka.ilkd.key.logic.op.UpdateableOperator;
import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.proof.mgt.ProofEnvironment;
import de.uka.ilkd.key.prover.impl.ApplyStrategyInfo;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicEquivalenceClass;
import de.uka.ilkd.key.symbolic_execution.slicing.Access;
import de.uka.ilkd.key.symbolic_execution.slicing.Location;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionSideProofUtil;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import de.uka.ilkd.key.util.Pair;
import de.uka.ilkd.key.util.ProofStarter;
import de.uka.ilkd.key.util.SideProofUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.key_project.util.collection.ImmutableArray;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;
import org.key_project.util.java.CollectionUtil;
import org.key_project.util.java.IFilter;
import org.key_project.util.java.ObjectUtil;

public abstract class AbstractSlicer {
    public ImmutableArray<Node> slice(Node seedNode, Term term, ImmutableList<ISymbolicEquivalenceClass> sec) throws ProofInputException {
        return this.slice(seedNode, AbstractSlicer.toLocation(seedNode.proof().getServices(), term), sec);
    }

    public ImmutableArray<Node> slice(Node seedNode, ReferencePrefix seedLocation, ImmutableList<ISymbolicEquivalenceClass> sec) throws ProofInputException {
        PosInOccurrence pio = seedNode.getAppliedRuleApp().posInOccurrence();
        Term topLevel = pio.sequentFormula().formula();
        Term modalityTerm = TermBuilder.goBelowUpdates((Term)topLevel);
        Services services = seedNode.proof().getServices();
        ExecutionContext ec = JavaTools.getInnermostExecutionContext((JavaBlock)modalityTerm.javaBlock(), (Services)services);
        ReferencePrefix thisReference = ec != null ? ec.getRuntimeInstance() : null;
        return this.slice(seedNode, this.toLocation(services, seedLocation, ec, thisReference), sec);
    }

    public ImmutableArray<Node> slice(Node seedNode, Location seedLocation, ImmutableList<ISymbolicEquivalenceClass> sec) throws ProofInputException {
        if (seedNode.getAppliedRuleApp() == null) {
            throw new IllegalStateException("No rule applied on seed Node '" + seedNode.serialNr() + "'.");
        }
        PosInOccurrence pio = seedNode.getAppliedRuleApp().posInOccurrence();
        Term applicationTerm = pio.subTerm();
        Pair pair = TermBuilder.goBelowUpdates2((Term)applicationTerm);
        Term modalityTerm = (Term)pair.second;
        SymbolicExecutionTermLabel label = SymbolicExecutionUtil.getSymbolicExecutionLabel(modalityTerm);
        if (label == null) {
            throw new IllegalStateException("Modality at applied rule does not have the " + SymbolicExecutionTermLabel.NAME + " term label.");
        }
        return this.doSlicing(seedNode, seedLocation, sec);
    }

    protected abstract ImmutableArray<Node> doSlicing(Node var1, Location var2, ImmutableList<ISymbolicEquivalenceClass> var3) throws ProofInputException;

    protected SequentInfo analyzeSequent(Node node, ImmutableList<ISymbolicEquivalenceClass> sec) {
        PosInOccurrence pio = node.getAppliedRuleApp().posInOccurrence();
        Term topLevel = pio.sequentFormula().formula();
        Pair pair = TermBuilder.goBelowUpdates2((Term)topLevel);
        Term modalityTerm = (Term)pair.second;
        SymbolicExecutionTermLabel label = SymbolicExecutionUtil.getSymbolicExecutionLabel(modalityTerm);
        Services services = node.proof().getServices();
        HeapLDT heapLDT = services.getTypeConverter().getHeapLDT();
        if (label != null) {
            ExecutionContext ec = JavaTools.getInnermostExecutionContext((JavaBlock)modalityTerm.javaBlock(), (Services)services);
            ReferencePrefix thisReference = ec != null ? ec.getRuntimeInstance() : null;
            HashMap<Location, SortedSet<Location>> aliases = new HashMap<Location, SortedSet<Location>>();
            HashMap<ProgramVariable, Term> localValues = new HashMap<ProgramVariable, Term>();
            this.analyzeEquivalenceClasses(services, sec, aliases, thisReference);
            this.analyzeSequent(services, node.sequent(), aliases, thisReference);
            this.analyzeUpdates((ImmutableList<Term>)((ImmutableList)pair.first), services, heapLDT, aliases, localValues, ec, thisReference);
            return new SequentInfo(aliases, localValues, ec, thisReference);
        }
        return null;
    }

    protected void analyzeEquivalenceClasses(Services services, ImmutableList<ISymbolicEquivalenceClass> sec, Map<Location, SortedSet<Location>> aliases, ReferencePrefix thisReference) {
        if (sec != null) {
            for (ISymbolicEquivalenceClass eq : sec) {
                ImmutableList<Term> terms = eq.getTerms();
                ArrayList<Location> locations = new ArrayList<Location>(terms.size());
                for (Term term : terms) {
                    Location location;
                    if (!SymbolicExecutionUtil.hasReferenceSort(services, term) || (location = AbstractSlicer.toLocation(services, term)) == null) continue;
                    locations.add(location);
                }
                if (locations.size() < 2) continue;
                Location first = null;
                for (Location location : locations) {
                    if (first == null) {
                        first = location;
                        continue;
                    }
                    this.updateAliases(services, first, location, aliases, thisReference);
                }
            }
        }
    }

    protected void analyzeSequent(Services services, Sequent sequent, Map<Location, SortedSet<Location>> aliases, ReferencePrefix thisReference) {
        Term term;
        for (SequentFormula sf : sequent.antecedent()) {
            term = sf.formula();
            if (Equality.EQUALS != term.op()) continue;
            this.analyzeEquality(services, term, aliases, thisReference);
        }
        for (SequentFormula sf : sequent.succedent()) {
            Term negatedTerm;
            term = sf.formula();
            if (Junctor.NOT != term.op() || Equality.EQUALS != (negatedTerm = term.sub(0)).op()) continue;
            this.analyzeEquality(services, negatedTerm, aliases, thisReference);
        }
    }

    protected void analyzeEquality(Services services, Term equality, Map<Location, SortedSet<Location>> aliases, ReferencePrefix thisReference) {
        Term firstSub = equality.sub(0);
        Term secondSub = equality.sub(1);
        if (SymbolicExecutionUtil.hasReferenceSort(services, firstSub) && SymbolicExecutionUtil.hasReferenceSort(services, secondSub)) {
            Location first = AbstractSlicer.toLocation(services, firstSub);
            Location second = AbstractSlicer.toLocation(services, secondSub);
            if (first != null && second != null) {
                this.updateAliases(services, first, second, aliases, thisReference);
            }
        }
    }

    protected void analyzeUpdates(ImmutableList<Term> updates, Services services, HeapLDT heapLDT, Map<Location, SortedSet<Location>> aliases, Map<ProgramVariable, Term> localValues, ExecutionContext ec, ReferencePrefix thisReference) {
        for (Term update : updates) {
            this.analyzeUpdate(update, services, heapLDT, aliases, localValues, ec, thisReference);
        }
    }

    protected void analyzeUpdate(Term term, Services services, HeapLDT heapLDT, Map<Location, SortedSet<Location>> aliases, Map<ProgramVariable, Term> localValues, ExecutionContext ec, ReferencePrefix thisReference) {
        if (term.op() == UpdateJunctor.PARALLEL_UPDATE || term.op() == UpdateApplication.UPDATE_APPLICATION) {
            for (int i = 0; i < term.arity(); ++i) {
                this.analyzeUpdate(term.sub(i), services, heapLDT, aliases, localValues, ec, thisReference);
            }
        } else if (term.op() instanceof ElementaryUpdate) {
            UpdateableOperator target = ((ElementaryUpdate)term.op()).lhs();
            if (SymbolicExecutionUtil.isHeap((Operator)target, heapLDT)) {
                this.analyzeHeapUpdate(term.sub(0), services, heapLDT, aliases, thisReference);
            } else {
                if (target instanceof ProgramVariable) {
                    localValues.put((ProgramVariable)target, term.sub(0));
                }
                Location sourceLocation = AbstractSlicer.toLocation(services, term.sub(0));
                if (target instanceof ReferencePrefix && sourceLocation != null) {
                    Location targetLocation = this.toLocation(services, (ReferencePrefix)target, ec, thisReference);
                    this.updateAliases(services, targetLocation, sourceLocation, aliases, thisReference);
                }
            }
        } else {
            throw new IllegalArgumentException("Can not analyze update '" + term + "'.");
        }
    }

    protected void analyzeHeapUpdate(Term term, Services services, HeapLDT heapLDT, Map<Location, SortedSet<Location>> aliases, ReferencePrefix thisReference) {
        Function store = heapLDT.getStore();
        Function create = heapLDT.getCreate();
        if (term.op() == store) {
            Location source;
            this.analyzeHeapUpdate(term.sub(0), services, heapLDT, aliases, thisReference);
            if (SymbolicExecutionUtil.hasReferenceSort(services, term.sub(3)) && (source = AbstractSlicer.toLocation(services, term.sub(3))) != null) {
                Location targetPrefix = AbstractSlicer.toLocation(services, term.sub(1));
                Location targetVariable = AbstractSlicer.toLocation(services, term.sub(2));
                this.updateAliases(services, targetPrefix != null ? targetPrefix.append(targetVariable) : targetVariable, source, aliases, thisReference);
            }
        } else if (term.op() == create) {
            this.analyzeHeapUpdate(term.sub(0), services, heapLDT, aliases, thisReference);
        } else if (!(term.op() instanceof IProgramVariable) && !SymbolicExecutionUtil.isHeap(term.op(), heapLDT)) {
            throw new IllegalStateException("Can not analyze heap update '" + term + "'.");
        }
    }

    protected void listModifiedLocations(Term term, Services services, HeapLDT heapLDT, List<Location> listToFill, ExecutionContext ec, ReferencePrefix thisReference, Set<Location> relevantLocations, Node node) throws ProofInputException {
        if (term.op() == UpdateJunctor.PARALLEL_UPDATE || term.op() == UpdateApplication.UPDATE_APPLICATION) {
            for (int i = 0; i < term.arity(); ++i) {
                this.listModifiedLocations(term.sub(i), services, heapLDT, listToFill, ec, thisReference, relevantLocations, node);
            }
        } else if (term.op() instanceof ElementaryUpdate) {
            UpdateableOperator target = ((ElementaryUpdate)term.op()).lhs();
            if (SymbolicExecutionUtil.isBaseHeap((Operator)target, heapLDT)) {
                this.listModifiedHeapLocations(term.sub(0), services, heapLDT, listToFill, thisReference, relevantLocations, node);
            } else if (target instanceof ProgramVariable) {
                listToFill.add(this.toLocation(services, (ReferencePrefix)((ProgramVariable)target), ec, thisReference));
            }
        } else {
            throw new IllegalArgumentException("Can not analyze update '" + term + "'.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void listModifiedHeapLocations(Term term, Services services, HeapLDT heapLDT, List<Location> listToFill, ReferencePrefix thisReference, Set<Location> relevantLocations, Node node) throws ProofInputException {
        if (term.op() == heapLDT.getStore()) {
            Location source;
            this.listModifiedHeapLocations(term.sub(0), services, heapLDT, listToFill, thisReference, relevantLocations, node);
            if (!SymbolicExecutionUtil.hasReferenceSort(services, term.sub(3)) || (source = AbstractSlicer.toLocation(services, term.sub(3))) == null) return;
            Location targetPrefix = AbstractSlicer.toLocation(services, term.sub(1));
            listToFill.add(targetPrefix);
            return;
        }
        if (term.op() == heapLDT.getCreate()) {
            this.listModifiedHeapLocations(term.sub(0), services, heapLDT, listToFill, thisReference, relevantLocations, node);
            return;
        }
        if (term.op() instanceof IProgramVariable) return;
        if (term.op() == heapLDT.getAnon()) {
            if (relevantLocations.isEmpty()) return;
            Term anonHeap = term.sub(2);
            ProofEnvironment sideProofEnv = SymbolicExecutionSideProofUtil.cloneProofEnvironmentWithOwnOneStepSimplifier(node.proof(), true);
            ApplyStrategyInfo info = null;
            try {
                ArrayList<Location> resultLocations = new ArrayList<Location>(relevantLocations.size());
                ArrayList<Term> resultTerms = new ArrayList<Term>(relevantLocations.size());
                ArrayList<Sort> resultSorts = new ArrayList<Sort>(relevantLocations.size());
                for (Location location : relevantLocations) {
                    Term locationTerm = location.toTerm(sideProofEnv.getServicesForEnvironment());
                    if (locationTerm.op() instanceof IProgramVariable) continue;
                    resultLocations.add(location);
                    resultTerms.add(locationTerm);
                    resultSorts.add(locationTerm.sort());
                }
                if (resultTerms.isEmpty()) return;
                Function newPredicate = new Function(new Name(sideProofEnv.getServicesForEnvironment().getTermBuilder().newName("ResultPredicate")), Sort.FORMULA, new ImmutableArray(resultSorts));
                Term newTerm = sideProofEnv.getServicesForEnvironment().getTermBuilder().func(newPredicate, resultTerms.toArray(new Term[resultTerms.size()]));
                Sequent sequentToProve = SymbolicExecutionUtil.createSequentToProveWithNewSuccedent(node, node.getAppliedRuleApp().posInOccurrence(), newTerm);
                ProofStarter starter = SideProofUtil.createSideProof((ProofEnvironment)sideProofEnv, (Sequent)sequentToProve, (String)"Analyze Anon Update");
                info = SymbolicExecutionSideProofUtil.startSideProof(node.proof(), starter, "METHOD_CONTRACT", "LOOP_INVARIANT", "QUERY_ON", "SPLITTING_NORMAL");
                assert (!info.getProof().closed());
                for (Goal goal : info.getProof().openGoals()) {
                    Term operatorTerm = SymbolicExecutionSideProofUtil.extractOperatorTerm(goal, (Operator)newPredicate);
                    assert (operatorTerm != null);
                    for (int i = 0; i < operatorTerm.arity(); ++i) {
                        Term heap;
                        Term valueTerm = SymbolicExecutionUtil.replaceSkolemConstants(goal.sequent(), operatorTerm.sub(i), services);
                        if (valueTerm.arity() < 1 || !anonHeap.equals(heap = valueTerm.sub(0))) continue;
                        listToFill.add((Location)resultLocations.get(i));
                    }
                }
                return;
            }
            finally {
                SymbolicExecutionSideProofUtil.disposeOrStore("Analyze Anon Update", info);
            }
        }
        if (!SymbolicExecutionUtil.isHeap(term.op(), heapLDT)) throw new IllegalStateException("Can not analyze update '" + term + "'.");
        if (relevantLocations.isEmpty()) return;
        ProofEnvironment sideProofEnv = SymbolicExecutionSideProofUtil.cloneProofEnvironmentWithOwnOneStepSimplifier(node.proof(), true);
        ApplyStrategyInfo info = null;
        try {
            ArrayList<Location> resultLocations = new ArrayList<Location>(relevantLocations.size());
            ArrayList<Term> resultTerms = new ArrayList<Term>(relevantLocations.size());
            ArrayList<Sort> resultSorts = new ArrayList<Sort>(relevantLocations.size());
            for (Location location : relevantLocations) {
                Term locationTerm = location.toTerm(sideProofEnv.getServicesForEnvironment());
                if (locationTerm.op() instanceof IProgramVariable) continue;
                resultLocations.add(location);
                resultTerms.add(locationTerm);
                resultSorts.add(locationTerm.sort());
            }
            if (resultTerms.isEmpty()) return;
            Function newPredicate = new Function(new Name(sideProofEnv.getServicesForEnvironment().getTermBuilder().newName("ResultPredicate")), Sort.FORMULA, new ImmutableArray(resultSorts));
            TermBuilder tb = sideProofEnv.getServicesForEnvironment().getTermBuilder();
            Term newTerm = tb.func(newPredicate, resultTerms.toArray(new Term[resultTerms.size()]));
            newTerm = tb.apply(tb.elementary((UpdateableOperator)heapLDT.getHeapForName(HeapLDT.BASE_HEAP_NAME), term), newTerm);
            Sequent sequentToProve = SymbolicExecutionUtil.createSequentToProveWithNewSuccedent(node, null, newTerm);
            ProofStarter starter = SideProofUtil.createSideProof((ProofEnvironment)sideProofEnv, (Sequent)sequentToProve, (String)"Analyze Anon Update");
            info = SymbolicExecutionSideProofUtil.startSideProof(node.proof(), starter, "METHOD_CONTRACT", "LOOP_INVARIANT", "QUERY_ON", "SPLITTING_NORMAL");
            assert (!info.getProof().closed());
            for (Goal goal : info.getProof().openGoals()) {
                Term operatorTerm = SymbolicExecutionSideProofUtil.extractOperatorTerm(goal, (Operator)newPredicate);
                assert (operatorTerm != null);
                for (int i = 0; i < operatorTerm.arity(); ++i) {
                    Term heap;
                    Term valueTerm = SymbolicExecutionUtil.replaceSkolemConstants(goal.sequent(), operatorTerm.sub(i), services);
                    if (valueTerm.arity() < 1 || !(heap = valueTerm.sub(0)).containsLabel(ParameterlessTermLabel.ANON_HEAP_LABEL)) continue;
                    listToFill.add((Location)resultLocations.get(i));
                }
            }
            return;
        }
        finally {
            SymbolicExecutionSideProofUtil.disposeOrStore("Analyze Heap Assignment", info);
        }
    }

    protected void updateAliases(Services services, Location first, Location second, Map<Location, SortedSet<Location>> aliases, ReferencePrefix thisReference) {
        SortedSet<Location> firstValues = aliases.get(first);
        SortedSet<Location> secondValues = aliases.get(second);
        SortedSet<Location> values = null;
        if (firstValues == null && secondValues == null) {
            values = this.createSortedSet();
            aliases.put(first, values);
            aliases.put(second, values);
        } else if (firstValues != null && secondValues == null) {
            values = firstValues;
            aliases.put(second, values);
        } else if (firstValues == null && secondValues != null) {
            values = secondValues;
            aliases.put(first, values);
        } else if (firstValues != null && secondValues != null) {
            values = firstValues;
            for (Location existingLocation : secondValues) {
                aliases.put(existingLocation, values);
            }
            values.addAll(secondValues);
        } else {
            throw new IllegalStateException("Reached a state which should never happen.");
        }
        values.add(first);
        values.add(second);
    }

    protected SortedSet<Location> createSortedSet() {
        return new TreeSet<Location>(new Comparator<Location>(){

            @Override
            public int compare(Location o1, Location o2) {
                int o2DotCount;
                int o1DotCount = o1.getDepth();
                if (o1DotCount < (o2DotCount = o2.getDepth())) {
                    return 1;
                }
                if (o1DotCount > o2DotCount) {
                    return -1;
                }
                return o1.toString().compareTo(o2.toString());
            }
        });
    }

    protected Location normalizeAlias(Services services, ReferencePrefix referencePrefix, SequentInfo info) {
        Location location = this.toLocation(services, referencePrefix, info.getExecutionContext(), info.getThisReference());
        return this.normalizeAlias(services, location, info);
    }

    protected Location normalizeAlias(Services services, Location location, SequentInfo info) {
        ImmutableList<Access> normalizedAccesses = ImmutableSLList.nil();
        for (Access access : location.getAccesses()) {
            Location newLocation;
            Location oldLocation;
            if (access.isArrayIndex()) {
                access = this.normalizeArrayIndex(access, info);
            }
            if ((oldLocation = new Location(normalizedAccesses = normalizedAccesses.append((Object)access))).equals(newLocation = this.computeRepresentativeAlias(oldLocation, info.getAliases()))) continue;
            normalizedAccesses = this.normalizeAlias(services, newLocation, info).getAccesses();
        }
        return new Location(normalizedAccesses);
    }

    protected Access normalizeArrayIndex(Access access, SequentInfo info) {
        ImmutableArray<Term> oldTerms = access.getDimensionExpressions();
        Object[] newTerms = new Term[oldTerms.size()];
        for (int i = 0; i < newTerms.length; ++i) {
            Term value;
            Term oldTerm = (Term)oldTerms.get(i);
            if (oldTerm.op() instanceof ProgramVariable && (value = info.getLocalValues().get((ProgramVariable)oldTerm.op())) != null) {
                oldTerm = value;
            }
            newTerms[i] = oldTerm;
        }
        return new Access((ImmutableArray<Term>)new ImmutableArray(newTerms));
    }

    protected Location computeRepresentativeAlias(Location location, Map<Location, SortedSet<Location>> aliases) {
        Set alternatives = aliases.get(location);
        if (alternatives != null) {
            return (Location)alternatives.iterator().next();
        }
        return location;
    }

    protected ReferencePrefix toReferencePrefix(SourceElement sourceElement) {
        if (sourceElement instanceof PassiveExpression) {
            if (((PassiveExpression)sourceElement).getChildCount() != 1) {
                throw new IllegalStateException("PassiveExpression '" + sourceElement + "' has not exactly one child.");
            }
            sourceElement = ((PassiveExpression)sourceElement).getChildAt(0);
        }
        if (sourceElement instanceof FieldReference) {
            return (FieldReference)sourceElement;
        }
        if (sourceElement instanceof ProgramVariable) {
            return (ProgramVariable)sourceElement;
        }
        if (sourceElement instanceof ArrayReference) {
            return (ArrayReference)sourceElement;
        }
        return null;
    }

    protected boolean removeRelevant(Services services, ReferencePrefix sourceElement, Set<Location> relevantLocations, SequentInfo info) {
        Location normalized = this.normalizeAlias(services, sourceElement, info);
        return this.performRemoveRelevant(services, normalized, relevantLocations, info);
    }

    protected boolean removeRelevant(Services services, Location location, Set<Location> relevantLocations, SequentInfo info) {
        Location normalized = this.normalizeAlias(services, location, info);
        return this.performRemoveRelevant(services, normalized, relevantLocations, info);
    }

    protected boolean performRemoveRelevant(Services services, Location normalized, Set<Location> relevantLocations, SequentInfo info) {
        boolean relevant = false;
        Iterator<Location> iterator = relevantLocations.iterator();
        while (!relevant && iterator.hasNext()) {
            Location next = iterator.next();
            Location nextNormalized = this.normalizeAlias(services, next, info);
            if (!normalized.equals(nextNormalized)) continue;
            iterator.remove();
            relevant = true;
        }
        return relevant;
    }

    protected Location toLocation(Services services, ReferencePrefix prefix, ExecutionContext ec, ReferencePrefix thisReference) {
        ImmutableList<Access> accesses = this.toLocationRecursive(services, prefix, ec, thisReference, (ImmutableList<Access>)ImmutableSLList.nil());
        return new Location(accesses);
    }

    protected ImmutableList<Access> toLocationRecursive(Services services, ReferencePrefix prefix, ExecutionContext ec, ReferencePrefix thisReference, ImmutableList<Access> children) {
        if (prefix instanceof ProgramVariable) {
            return children.prepend((Object)new Access((ProgramVariable)prefix));
        }
        if (prefix instanceof FieldReference) {
            FieldReference fr = (FieldReference)prefix;
            ReferencePrefix parent = fr.getReferencePrefix();
            children = children.prepend((Object)new Access(fr.getProgramVariable()));
            if (parent != null) {
                return this.toLocationRecursive(services, parent, ec, thisReference, (ImmutableList<Access>)children);
            }
            return children;
        }
        if (prefix instanceof ThisReference) {
            if (thisReference instanceof ProgramVariable) {
                return children.prepend((Object)new Access((ProgramVariable)thisReference));
            }
            if (thisReference instanceof FieldReference) {
                return this.toLocationRecursive(services, thisReference, ec, thisReference, (ImmutableList<Access>)children);
            }
            throw new IllegalStateException("Unsupported this reference '" + thisReference + "'.");
        }
        if (prefix instanceof ArrayReference) {
            ArrayReference ar = (ArrayReference)prefix;
            children = children.prepend((Object)new Access(AbstractSlicer.toTerm(services, (ImmutableArray<Expression>)ar.getDimensionExpressions(), ec)));
            return this.toLocationRecursive(services, ar.getReferencePrefix(), ec, thisReference, (ImmutableList<Access>)children);
        }
        throw new IllegalStateException("Unsupported prefix '" + prefix + "'.");
    }

    public static ImmutableArray<Term> toTerm(Services services, ImmutableArray<Expression> expressions, ExecutionContext ec) {
        Object[] terms = new Term[expressions.size()];
        int i = 0;
        for (Expression expression : expressions) {
            terms[i] = AbstractSlicer.toTerm(services, expression, ec);
            ++i;
        }
        return new ImmutableArray(terms);
    }

    public static Term toTerm(Services services, Expression expression, ExecutionContext ec) {
        return services.getTypeConverter().convertToLogicElement((ProgramElement)expression, ec);
    }

    public static Location toLocation(Services services, Term term) {
        if (term.op() instanceof ProgramVariable) {
            return new Location(new Access((ProgramVariable)term.op()));
        }
        if (SymbolicExecutionUtil.isNullSort(term.sort(), services)) {
            return null;
        }
        HeapLDT heapLDT = services.getTypeConverter().getHeapLDT();
        if (term.op() == heapLDT.getSelect(term.sort(), (TermServices)services)) {
            Location prefix = AbstractSlicer.toLocation(services, term.sub(1));
            Term arrayIndex = SymbolicExecutionUtil.getArrayIndex(services, heapLDT, term.sub(2));
            if (arrayIndex != null) {
                return prefix.append(new Access(arrayIndex));
            }
            Location variable = AbstractSlicer.toLocation(services, term.sub(2));
            return prefix != null ? prefix.append(variable) : variable;
        }
        String name = term.op().name().toString();
        int index = name.toString().indexOf("::");
        if (index >= 0) {
            String fullTypeName = name.substring(0, index);
            String fieldName = name.substring(index + 3);
            ProgramVariable pv = services.getJavaInfo().getAttribute(fullTypeName + "::" + fieldName);
            assert (term.op() == services.getTypeConverter().getHeapLDT().getFieldSymbolForPV((LocationVariable)pv, services));
            return new Location(new Access(pv));
        }
        return null;
    }

    protected Location findNewAlternative(SortedSet<Location> oldAlternatives, final SortedSet<Location> newAlternatives) {
        return (Location)CollectionUtil.search(oldAlternatives, (IFilter)new IFilter<Location>(){

            public boolean select(Location element) {
                return !newAlternatives.contains(element);
            }
        });
    }

    public static <T> int computeFirstCommonPrefixLength(ImmutableList<ImmutableList<T>> candidates, ImmutableList<T> toCheck) {
        int commonLength = 0;
        Iterator iter = candidates.iterator();
        while (commonLength < 1 && iter.hasNext()) {
            ImmutableList next = (ImmutableList)iter.next();
            if (!AbstractSlicer.startsWith(toCheck, next)) continue;
            commonLength = next.size();
        }
        return commonLength;
    }

    public static <T> boolean startsWith(ImmutableList<T> list, ImmutableList<T> prefix) {
        if (list.size() >= prefix.size()) {
            Iterator listIter = list.iterator();
            Iterator prefixIter = prefix.iterator();
            boolean same = true;
            while (same && prefixIter.hasNext()) {
                Object prefixNext;
                Object listNext = listIter.next();
                if (ObjectUtil.equals(listNext, prefixNext = prefixIter.next())) continue;
                same = false;
            }
            return same;
        }
        return false;
    }

    protected static class SequentInfo {
        private final Map<Location, SortedSet<Location>> aliases;
        private final Map<ProgramVariable, Term> localValues;
        private final ExecutionContext executionContext;
        private final ReferencePrefix thisReference;

        public SequentInfo(Map<Location, SortedSet<Location>> aliases, Map<ProgramVariable, Term> localValues, ExecutionContext executionContext, ReferencePrefix thisReference) {
            assert (aliases != null);
            assert (localValues != null);
            this.aliases = aliases;
            this.localValues = localValues;
            this.executionContext = executionContext;
            this.thisReference = thisReference;
        }

        public Map<Location, SortedSet<Location>> getAliases() {
            return this.aliases;
        }

        public Map<ProgramVariable, Term> getLocalValues() {
            return this.localValues;
        }

        public ExecutionContext getExecutionContext() {
            return this.executionContext;
        }

        public ReferencePrefix getThisReference() {
            return this.thisReference;
        }
    }
}

