/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.slicing;

import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import org.key_project.util.collection.ImmutableArray;
import org.key_project.util.java.ObjectUtil;

public class Access {
    private final ProgramVariable programVariable;
    private final ImmutableArray<Term> dimensionExpressions;

    public Access(ProgramVariable programVariable) {
        assert (programVariable != null);
        this.programVariable = programVariable;
        this.dimensionExpressions = null;
    }

    public Access(ImmutableArray<Term> dimensionExpressions) {
        assert (dimensionExpressions != null);
        this.programVariable = null;
        this.dimensionExpressions = dimensionExpressions;
    }

    public Access(Term ... dimensionExpressions) {
        assert (dimensionExpressions != null);
        this.programVariable = null;
        this.dimensionExpressions = new ImmutableArray((Object[])dimensionExpressions);
    }

    public ProgramVariable getProgramVariable() {
        return this.programVariable;
    }

    public ImmutableArray<Term> getDimensionExpressions() {
        return this.dimensionExpressions;
    }

    public boolean isArrayIndex() {
        return this.dimensionExpressions != null;
    }

    public int hashCode() {
        int hashcode = 5;
        hashcode = hashcode * 17 + (this.programVariable != null ? this.programVariable.hashCode() : 0);
        hashcode = hashcode * 17 + (this.dimensionExpressions != null ? this.dimensionExpressions.hashCode() : 0);
        return hashcode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Access) {
            Access other = (Access)obj;
            return ObjectUtil.equals((Object)this.programVariable, (Object)other.getProgramVariable()) && ObjectUtil.equals(this.dimensionExpressions, other.getDimensionExpressions());
        }
        return false;
    }

    public String toString() {
        if (this.programVariable != null) {
            return this.programVariable.toString();
        }
        if (this.dimensionExpressions != null) {
            return this.dimensionExpressions.toString();
        }
        return "Undefined";
    }
}

