/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.slicing;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.Function;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.LocationVariable;
import de.uka.ilkd.key.symbolic_execution.slicing.Access;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;
import org.key_project.util.java.ObjectUtil;

public class Location {
    private final ImmutableList<Access> accesses;

    public Location(ImmutableList<Access> accesses) {
        assert (accesses != null);
        this.accesses = accesses;
    }

    public Location(Access ... accesses) {
        assert (accesses != null);
        this.accesses = ImmutableSLList.nil().append((Object[])accesses);
    }

    public ImmutableList<Access> getAccesses() {
        return this.accesses;
    }

    public int getDepth() {
        return this.accesses.size();
    }

    public int hashCode() {
        int hashcode = 5;
        hashcode = hashcode * 17 + (this.accesses != null ? this.accesses.hashCode() : 0);
        return hashcode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Location) {
            Location other = (Location)obj;
            return ObjectUtil.equals(this.accesses, other.getAccesses());
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        boolean afterFirst = false;
        for (Access access : this.accesses) {
            if (afterFirst) {
                sb.append('.');
            } else {
                afterFirst = true;
            }
            sb.append(access);
        }
        return sb.toString();
    }

    public Location append(Location sub) {
        return new Location((ImmutableList<Access>)this.accesses.append(sub.getAccesses()));
    }

    public Location append(Access sub) {
        return new Location((ImmutableList<Access>)this.accesses.append((Object)sub));
    }

    public Term toTerm(Services services) {
        Term parent = null;
        for (Access access : this.accesses) {
            Function function;
            if (access.isArrayIndex()) {
                assert (parent != null);
                assert (access.getDimensionExpressions().size() == 1);
                parent = services.getTermBuilder().dotArr(parent, (Term)access.getDimensionExpressions().get(0));
                continue;
            }
            if (SymbolicExecutionUtil.isStaticVariable((IProgramVariable)access.getProgramVariable())) {
                assert (parent == null);
                function = services.getTypeConverter().getHeapLDT().getFieldSymbolForPV((LocationVariable)access.getProgramVariable(), services);
                parent = services.getTermBuilder().staticDot(access.getProgramVariable().sort(), function);
                continue;
            }
            if (parent == null) {
                assert (parent == null);
                parent = services.getTermBuilder().var(access.getProgramVariable());
                continue;
            }
            if (services.getJavaInfo().getArrayLength() == access.getProgramVariable()) {
                assert (parent != null);
                function = services.getTypeConverter().getHeapLDT().getLength();
                parent = services.getTermBuilder().func(function, parent);
                continue;
            }
            assert (parent != null);
            function = services.getTypeConverter().getHeapLDT().getFieldSymbolForPV((LocationVariable)access.getProgramVariable(), services);
            parent = services.getTermBuilder().dot(access.getProgramVariable().sort(), parent, function);
        }
        return parent;
    }
}

