/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.slicing;

import de.uka.ilkd.key.java.Expression;
import de.uka.ilkd.key.java.ProgramElement;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.java.expression.operator.CopyAssignment;
import de.uka.ilkd.key.java.reference.ReferencePrefix;
import de.uka.ilkd.key.java.statement.MethodBodyStatement;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.UpdateApplication;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.symbolic_execution.slicing.AbstractBackwardSlicer;
import de.uka.ilkd.key.symbolic_execution.slicing.AbstractSlicer;
import de.uka.ilkd.key.symbolic_execution.slicing.Location;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import java.util.LinkedList;
import java.util.Set;
import org.key_project.util.collection.ImmutableArray;

public class ThinBackwardSlicer
extends AbstractBackwardSlicer {
    @Override
    protected boolean accept(Node node, Node previousChild, Services services, Set<Location> relevantLocations, AbstractSlicer.SequentInfo info, SourceElement activeStatement) throws ProofInputException {
        try {
            boolean accept = false;
            if (activeStatement instanceof CopyAssignment) {
                SourceElement originalTarget;
                ReferencePrefix relevantTarget;
                CopyAssignment copyAssignment = (CopyAssignment)activeStatement;
                ImmutableArray arguments = copyAssignment.getArguments();
                if (arguments.size() >= 1 && (relevantTarget = this.toReferencePrefix(originalTarget = (SourceElement)arguments.get(0))) != null && this.removeRelevant(services, relevantTarget, relevantLocations, info)) {
                    accept = true;
                    for (int i = 1; i < arguments.size(); ++i) {
                        Expression read = (Expression)arguments.get(i);
                        this.updateRelevantLocations((ProgramElement)read, relevantLocations, info, services);
                    }
                }
            } else if (activeStatement instanceof MethodBodyStatement) {
                MethodBodyStatement mbs = (MethodBodyStatement)activeStatement;
                IProgramVariable resultVariable = mbs.getResultVariable();
                ReferencePrefix relevantTarget = this.toReferencePrefix((SourceElement)resultVariable);
                if (relevantTarget != null && this.removeRelevant(services, relevantTarget, relevantLocations, info)) {
                    accept = true;
                }
            } else if (SymbolicExecutionUtil.isLoopInvariant(node, node.getAppliedRuleApp()) || SymbolicExecutionUtil.isOperationContract(node, node.getAppliedRuleApp()) || SymbolicExecutionUtil.isBlockSpecificationElement(node, node.getAppliedRuleApp())) {
                PosInOccurrence pio = node.getAppliedRuleApp().posInOccurrence();
                LinkedList<Location> modifiedLocations = new LinkedList<Location>();
                Term loopConditionModalityTerm = SymbolicExecutionUtil.posInOccurrenceInOtherNode(node, pio, previousChild);
                if (loopConditionModalityTerm.op() != UpdateApplication.UPDATE_APPLICATION) {
                    throw new IllegalStateException("Use Loop Invariant/Operation Contract rule implementation has changed at node " + node.serialNr() + ".");
                }
                Term updateTerm = UpdateApplication.getTarget((Term)loopConditionModalityTerm);
                while (updateTerm.op() == UpdateApplication.UPDATE_APPLICATION) {
                    this.listModifiedLocations(UpdateApplication.getUpdate((Term)updateTerm), services, services.getTypeConverter().getHeapLDT(), modifiedLocations, info.getExecutionContext(), info.getThisReference(), relevantLocations, previousChild);
                    updateTerm = UpdateApplication.getTarget((Term)updateTerm);
                }
                for (Location location : modifiedLocations) {
                    if (!this.removeRelevant(services, location, relevantLocations, info)) continue;
                    accept = true;
                }
            }
            return accept;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

