/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.strategy;

import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.prover.StopCondition;
import de.uka.ilkd.key.prover.impl.SingleRuleApplicationInfo;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractCallStackBasedStopCondition
implements StopCondition {
    private Map<Goal, NodeStartEntry> startingCallStackSizePerGoal = new LinkedHashMap<Goal, NodeStartEntry>();

    public int getMaximalWork(int maxApplications, long timeout, Proof proof) {
        this.startingCallStackSizePerGoal.clear();
        return 0;
    }

    public boolean isGoalAllowed(int maxApplications, long timeout, Proof proof, long startTime, int countApplied, Goal goal) {
        if (goal != null) {
            RuleApp ruleApp;
            Node node = goal.node();
            if (SymbolicExecutionUtil.isSymbolicExecutionTreeNode(node, ruleApp = goal.getRuleAppManager().peekNext())) {
                NodeStartEntry startingCallStackSizeEntry = this.startingCallStackSizePerGoal.get(goal);
                if (startingCallStackSizeEntry == null) {
                    Node parentSetNode = SymbolicExecutionUtil.findParentSetNode(node);
                    int startingCallStackSize = SymbolicExecutionUtil.computeStackSize(parentSetNode != null ? parentSetNode.getAppliedRuleApp() : null);
                    startingCallStackSizeEntry = new NodeStartEntry(node, startingCallStackSize);
                    this.startingCallStackSizePerGoal.put(goal, startingCallStackSizeEntry);
                    return true;
                }
                if (node != startingCallStackSizeEntry.getNode()) {
                    int currentCallStackSize = SymbolicExecutionUtil.computeStackSize(ruleApp);
                    if (this.isCallStackSizeReached(startingCallStackSizeEntry.getNodeCallStackSize(), currentCallStackSize)) {
                        Node parentSetNode = SymbolicExecutionUtil.findParentSetNode(node);
                        int parentStackSize = SymbolicExecutionUtil.computeStackSize(parentSetNode.getAppliedRuleApp());
                        return !this.isCallStackSizeReached(startingCallStackSizeEntry.getNodeCallStackSize(), parentStackSize);
                    }
                    return true;
                }
                return true;
            }
            return true;
        }
        return true;
    }

    protected abstract boolean isCallStackSizeReached(int var1, int var2);

    public boolean shouldStop(int maxApplications, long timeout, Proof proof, long startTime, int countApplied, SingleRuleApplicationInfo singleRuleApplicationInfo) {
        if (singleRuleApplicationInfo != null) {
            NodeStartEntry startingCallStackSizeValue;
            Goal goal = singleRuleApplicationInfo.getGoal();
            Node goalNode = goal.node();
            assert (goalNode.childrenCount() == 0);
            Node updatedNode = goalNode.parent();
            if (updatedNode.childrenCount() >= 2 && (startingCallStackSizeValue = this.startingCallStackSizePerGoal.get(goal)) != null) {
                Iterator childIter = updatedNode.childrenIterator();
                while (childIter.hasNext()) {
                    Node next = (Node)childIter.next();
                    Goal nextGoal = next.proof().getGoal(next);
                    if (nextGoal == goal) continue;
                    this.startingCallStackSizePerGoal.put(nextGoal, startingCallStackSizeValue);
                }
            }
        }
        return false;
    }

    public String getStopMessage(int maxApplications, long timeout, Proof proof, long startTime, int countApplied, SingleRuleApplicationInfo singleRuleApplicationInfo) {
        return null;
    }

    private static class NodeStartEntry {
        private Node node;
        private int nodeCallStackSize;

        public NodeStartEntry(Node node, int nodeCallStackSize) {
            this.node = node;
            this.nodeCallStackSize = nodeCallStackSize;
        }

        public Node getNode() {
            return this.node;
        }

        public int getNodeCallStackSize() {
            return this.nodeCallStackSize;
        }
    }
}

