/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.strategy;

import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.NodeInfo;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.prover.impl.SingleRuleApplicationInfo;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.strategy.IBreakpointStopCondition;
import de.uka.ilkd.key.symbolic_execution.strategy.breakpoint.IBreakpoint;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BreakpointStopCondition
implements IBreakpointStopCondition {
    private final Set<IBreakpoint> breakpoints = new HashSet<IBreakpoint>();
    private boolean breakpointHit = false;

    public BreakpointStopCondition(IBreakpoint ... breakpoints) {
        if (breakpoints != null) {
            for (IBreakpoint breakpoint : breakpoints) {
                this.breakpoints.add(breakpoint);
            }
        }
    }

    public int getMaximalWork(int maxApplications, long timeout, Proof proof) {
        this.breakpointHit = false;
        return 0;
    }

    public boolean isGoalAllowed(int maxApplications, long timeout, Proof proof, long startTime, int countApplied, Goal goal) {
        for (IBreakpoint breakpoint : this.breakpoints) {
            breakpoint.updateState(maxApplications, timeout, proof, startTime, countApplied, goal);
        }
        if (goal != null) {
            Node node = goal.node();
            RuleApp ruleApp = goal.getRuleAppManager().peekNext();
            SourceElement activeStatement = NodeInfo.computeActiveStatement((RuleApp)ruleApp);
            this.breakpointHit = this.isBreakpointHit(activeStatement, ruleApp, proof, node);
        }
        return countApplied == 0 || !this.breakpointHit;
    }

    public String getGoalNotAllowedMessage(int maxApplications, long timeout, Proof proof, long startTime, int countApplied, Goal goal) {
        return "Breakpoint hit!";
    }

    public boolean shouldStop(int maxApplications, long timeout, Proof proof, long startTime, int countApplied, SingleRuleApplicationInfo singleRuleApplicationInfo) {
        return false;
    }

    protected boolean isBreakpointHit(SourceElement activeStatement, RuleApp ruleApp, Proof proof, Node node) {
        boolean result = false;
        Iterator<IBreakpoint> iter = this.breakpoints.iterator();
        while (!result && iter.hasNext()) {
            IBreakpoint next = iter.next();
            result = next.isEnabled() && next.isBreakpointHit(activeStatement, ruleApp, proof, node);
        }
        return result;
    }

    public String getStopMessage(int maxApplications, long timeout, Proof proof, long startTime, int countApplied, SingleRuleApplicationInfo singleRuleApplicationInfo) {
        return "Breakpoint hit!";
    }

    @Override
    public void addBreakpoint(IBreakpoint breakpoint) {
        this.breakpoints.add(breakpoint);
    }

    @Override
    public void removeBreakpoint(IBreakpoint breakpoint) {
        this.breakpoints.remove(breakpoint);
    }

    @Override
    public Set<IBreakpoint> getBreakpoints() {
        return this.breakpoints;
    }
}

