/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.strategy;

import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.prover.StopCondition;
import de.uka.ilkd.key.prover.impl.SingleRuleApplicationInfo;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CompoundStopCondition
implements StopCondition {
    private List<StopCondition> children = new LinkedList<StopCondition>();
    private StopCondition lastGoalAllowedChild;
    private StopCondition lastShouldStopChild;

    public CompoundStopCondition(StopCondition ... children) {
        Collections.addAll(this.children, children);
    }

    public void addChildren(StopCondition ... children) {
        Collections.addAll(this.children, children);
    }

    public void removeChild(StopCondition child) {
        this.children.remove(child);
    }

    public int getMaximalWork(int maxApplications, long timeout, Proof proof) {
        for (StopCondition child : this.children) {
            child.getMaximalWork(maxApplications, timeout, proof);
        }
        this.lastGoalAllowedChild = null;
        this.lastShouldStopChild = null;
        return 0;
    }

    public boolean isGoalAllowed(int maxApplications, long timeout, Proof proof, long startTime, int countApplied, Goal goal) {
        boolean allowed = true;
        Iterator<StopCondition> childIter = this.children.iterator();
        while (allowed && childIter.hasNext()) {
            this.lastGoalAllowedChild = childIter.next();
            allowed = this.lastGoalAllowedChild.isGoalAllowed(maxApplications, timeout, proof, startTime, countApplied, goal);
        }
        return allowed;
    }

    public String getGoalNotAllowedMessage(int maxApplications, long timeout, Proof proof, long startTime, int countApplied, Goal goal) {
        return this.lastGoalAllowedChild != null ? this.lastGoalAllowedChild.getGoalNotAllowedMessage(maxApplications, timeout, proof, startTime, countApplied, goal) : null;
    }

    public boolean shouldStop(int maxApplications, long timeout, Proof proof, long startTime, int countApplied, SingleRuleApplicationInfo singleRuleApplicationInfo) {
        boolean stop = false;
        Iterator<StopCondition> childIter = this.children.iterator();
        while (!stop && childIter.hasNext()) {
            this.lastShouldStopChild = childIter.next();
            stop = this.lastShouldStopChild.shouldStop(maxApplications, timeout, proof, startTime, countApplied, singleRuleApplicationInfo);
        }
        return stop;
    }

    public String getStopMessage(int maxApplications, long timeout, Proof proof, long startTime, int countApplied, SingleRuleApplicationInfo singleRuleApplicationInfo) {
        return this.lastShouldStopChild != null ? this.lastShouldStopChild.getStopMessage(maxApplications, timeout, proof, startTime, countApplied, singleRuleApplicationInfo) : null;
    }

    public List<StopCondition> getChildren() {
        return this.children;
    }
}

