/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.strategy;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.ldt.HeapLDT;
import de.uka.ilkd.key.logic.DefaultVisitor;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.Visitor;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.strategy.termgenerator.TermGenerator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class CutHeapObjectsTermGenerator
implements TermGenerator {
    public Iterator<Term> generate(RuleApp app, PosInOccurrence pos, Goal goal) {
        Sequent sequent = goal.sequent();
        LinkedHashSet<Term> topTerms = new LinkedHashSet<Term>();
        for (SequentFormula sf : sequent) {
            topTerms.add(sf.formula());
        }
        HeapLDT heapLDT = goal.node().proof().getServices().getTypeConverter().getHeapLDT();
        LinkedHashSet<Term> equalityTerms = new LinkedHashSet<Term>();
        for (SequentFormula sf : sequent) {
            this.collectEqualityTerms(sf, equalityTerms, topTerms, heapLDT, goal.node().proof().getServices());
        }
        return equalityTerms.iterator();
    }

    protected void collectEqualityTerms(SequentFormula sf, Set<Term> equalityTerms, Set<Term> topTerms, HeapLDT heapLDT, Services services) {
        LinkedHashSet<Term> storeLocations = new LinkedHashSet<Term>();
        this.collectStoreLocations(sf.formula(), storeLocations, heapLDT);
        if (storeLocations.size() >= 2) {
            Term[] storeLocationsArray = storeLocations.toArray(new Term[storeLocations.size()]);
            for (int i = 0; i < storeLocationsArray.length; ++i) {
                for (int j = i + 1; j < storeLocationsArray.length; ++j) {
                    Term negatedEquality;
                    Term equality = services.getTermBuilder().equals(storeLocationsArray[i], storeLocationsArray[j]);
                    if (topTerms.contains(equality) || topTerms.contains(negatedEquality = services.getTermBuilder().not(equality))) continue;
                    equalityTerms.add(negatedEquality);
                }
            }
        }
    }

    protected void collectStoreLocations(Term term, final Set<Term> storeLocations, final HeapLDT heapLDT) {
        term.execPreOrder((Visitor)new DefaultVisitor(){

            public void visit(Term visited) {
                if (visited.op() == heapLDT.getStore()) {
                    storeLocations.add(visited.sub(1));
                }
            }
        });
    }
}

