/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.strategy;

import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.prover.StopCondition;
import de.uka.ilkd.key.prover.impl.SingleRuleApplicationInfo;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExecutedSymbolicExecutionTreeNodesStopCondition
implements StopCondition {
    public static final int MAXIMAL_NUMBER_OF_SET_NODES_TO_EXECUTE_PER_GOAL_IN_COMPLETE_RUN = 1000;
    public static final int MAXIMAL_NUMBER_OF_SET_NODES_TO_EXECUTE_PER_GOAL_FOR_ONE_STEP = 1;
    private int maximalNumberOfSetNodesToExecutePerGoal;
    private final Map<Goal, Integer> executedNumberOfSetNodesPerGoal = new LinkedHashMap<Goal, Integer>();
    private final Map<Node, Boolean> goalAllowedResultPerSetNode = new LinkedHashMap<Node, Boolean>();

    public ExecutedSymbolicExecutionTreeNodesStopCondition() {
        this(1);
    }

    public ExecutedSymbolicExecutionTreeNodesStopCondition(int maximalNumberOfSetNodesToExecutePerGoal) {
        this.maximalNumberOfSetNodesToExecutePerGoal = maximalNumberOfSetNodesToExecutePerGoal;
    }

    public int getMaximalWork(int maxApplications, long timeout, Proof proof) {
        this.executedNumberOfSetNodesPerGoal.clear();
        this.goalAllowedResultPerSetNode.clear();
        return 0;
    }

    public boolean isGoalAllowed(int maxApplications, long timeout, Proof proof, long startTime, int countApplied, Goal goal) {
        if (goal != null) {
            RuleApp ruleApp;
            Node node = goal.node();
            if (SymbolicExecutionUtil.isSymbolicExecutionTreeNode(node, ruleApp = goal.getRuleAppManager().peekNext())) {
                Boolean value = this.goalAllowedResultPerSetNode.get(node);
                if (value == null) {
                    Integer executedNumberOfSetNodes = this.executedNumberOfSetNodesPerGoal.get(goal);
                    if (executedNumberOfSetNodes == null) {
                        executedNumberOfSetNodes = 0;
                    }
                    if (executedNumberOfSetNodes + 1 > this.maximalNumberOfSetNodesToExecutePerGoal) {
                        this.handleNodeLimitExceeded(maxApplications, timeout, proof, startTime, countApplied, goal, node, ruleApp, executedNumberOfSetNodes);
                        return false;
                    }
                    executedNumberOfSetNodes = executedNumberOfSetNodes + 1;
                    this.executedNumberOfSetNodesPerGoal.put(goal, executedNumberOfSetNodes);
                    this.handleNodeLimitNotExceeded(maxApplications, timeout, proof, startTime, countApplied, goal, node, ruleApp, executedNumberOfSetNodes);
                    return true;
                }
                return value;
            }
            return true;
        }
        return true;
    }

    protected void handleNodeLimitExceeded(int maxApplications, long timeout, Proof proof, long startTime, int countApplied, Goal goal, Node node, RuleApp ruleApp, Integer executedNumberOfSetNodes) {
        this.goalAllowedResultPerSetNode.put(node, Boolean.FALSE);
    }

    protected void handleNodeLimitNotExceeded(int maxApplications, long timeout, Proof proof, long startTime, int countApplied, Goal goal, Node node, RuleApp ruleApp, Integer executedNumberOfSetNodes) {
        this.goalAllowedResultPerSetNode.put(node, Boolean.TRUE);
    }

    public String getGoalNotAllowedMessage(int maxApplications, long timeout, Proof proof, long startTime, int countApplied, Goal goal) {
        if (this.maximalNumberOfSetNodesToExecutePerGoal > 1) {
            return "Maximal limit of " + this.maximalNumberOfSetNodesToExecutePerGoal + " symbolic execution tree nodes reached.";
        }
        return "Maximal limit of one symbolic execution tree node reached.";
    }

    public boolean shouldStop(int maxApplications, long timeout, Proof proof, long startTime, int countApplied, SingleRuleApplicationInfo singleRuleApplicationInfo) {
        if (singleRuleApplicationInfo != null) {
            Integer executedValue;
            Goal goal = singleRuleApplicationInfo.getGoal();
            Node goalNode = goal.node();
            assert (goalNode.childrenCount() == 0);
            Node updatedNode = goalNode.parent();
            if (updatedNode.childrenCount() >= 2 && (executedValue = this.executedNumberOfSetNodesPerGoal.get(goal)) != null) {
                Iterator childIter = updatedNode.childrenIterator();
                while (childIter.hasNext()) {
                    Node next = (Node)childIter.next();
                    Goal nextGoal = next.proof().getGoal(next);
                    if (nextGoal == goal) continue;
                    this.executedNumberOfSetNodesPerGoal.put(nextGoal, executedValue);
                }
            }
        }
        return false;
    }

    public String getStopMessage(int maxApplications, long timeout, Proof proof, long startTime, int countApplied, SingleRuleApplicationInfo singleRuleApplicationInfo) {
        return null;
    }

    public int getMaximalNumberOfSetNodesToExecutePerGoal() {
        return this.maximalNumberOfSetNodesToExecutePerGoal;
    }

    public void setMaximalNumberOfSetNodesToExecutePerGoal(int maximalNumberOfSetNodesToExecute) {
        this.maximalNumberOfSetNodesToExecutePerGoal = maximalNumberOfSetNodesToExecute;
    }

    public boolean wasSetNodeExecuted() {
        return !this.executedNumberOfSetNodesPerGoal.isEmpty();
    }

    public Map<Goal, Integer> getExectuedSetNodesPerGoal() {
        return this.executedNumberOfSetNodesPerGoal;
    }
}

