/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.strategy;

import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.init.JavaProfile;
import de.uka.ilkd.key.rule.IfFormulaInstantiation;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.rule.TacletApp;
import de.uka.ilkd.key.strategy.JavaCardDLStrategy;
import de.uka.ilkd.key.strategy.NumberRuleAppCost;
import de.uka.ilkd.key.strategy.RuleAppCost;
import de.uka.ilkd.key.strategy.Strategy;
import de.uka.ilkd.key.strategy.StrategyFactory;
import de.uka.ilkd.key.strategy.StrategyProperties;
import de.uka.ilkd.key.strategy.TopRuleAppCost;
import de.uka.ilkd.key.strategy.definition.StrategySettingsDefinition;
import de.uka.ilkd.key.strategy.feature.Feature;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;

public class SimplifyTermStrategy
extends JavaCardDLStrategy {
    public static final Name name = new Name("Simplify Term Strategy");

    private SimplifyTermStrategy(Proof proof, StrategyProperties sp) {
        super(proof, sp);
    }

    public Name name() {
        return name;
    }

    protected Feature setupApprovalF() {
        Feature superFeature = super.setupApprovalF();
        Feature labelFeature = new Feature(){

            public RuleAppCost computeCost(RuleApp app, PosInOccurrence pos, Goal goal) {
                TacletApp ta;
                Term findTerm;
                boolean hasLabel = false;
                if (pos != null && app instanceof TacletApp && !(findTerm = pos.subTerm()).containsLabel(SymbolicExecutionUtil.RESULT_LABEL) && (ta = (TacletApp)app).ifFormulaInstantiations() != null) {
                    for (IfFormulaInstantiation ifi : ta.ifFormulaInstantiations()) {
                        if (!ifi.getConstrainedFormula().formula().containsLabel(SymbolicExecutionUtil.RESULT_LABEL)) continue;
                        hasLabel = true;
                    }
                }
                return hasLabel ? TopRuleAppCost.INSTANCE : NumberRuleAppCost.create((int)0);
            }
        };
        return SimplifyTermStrategy.add((Feature)labelFeature, (Feature)superFeature);
    }

    public static class Factory
    implements StrategyFactory {
        public Strategy create(Proof proof, StrategyProperties sp) {
            return new SimplifyTermStrategy(proof, sp);
        }

        public Name name() {
            return name;
        }

        public StrategySettingsDefinition getSettingsDefinition() {
            return JavaProfile.DEFAULT.getSettingsDefinition();
        }
    }
}

