/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.strategy;

import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.NodeInfo;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.strategy.IBreakpointStopCondition;
import de.uka.ilkd.key.symbolic_execution.strategy.ExecutedSymbolicExecutionTreeNodesStopCondition;
import de.uka.ilkd.key.symbolic_execution.strategy.breakpoint.IBreakpoint;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SymbolicExecutionBreakpointStopCondition
extends ExecutedSymbolicExecutionTreeNodesStopCondition
implements IBreakpointStopCondition {
    private final Set<IBreakpoint> breakpoints = new HashSet<IBreakpoint>();

    public SymbolicExecutionBreakpointStopCondition(IBreakpoint ... breakpoints) {
        super(Integer.MAX_VALUE);
        if (breakpoints != null) {
            for (IBreakpoint breakpoint : breakpoints) {
                this.breakpoints.add(breakpoint);
            }
        }
    }

    @Override
    public int getMaximalWork(int maxApplications, long timeout, Proof proof) {
        this.setMaximalNumberOfSetNodesToExecutePerGoal(Integer.MAX_VALUE);
        return super.getMaximalWork(maxApplications, timeout, proof);
    }

    @Override
    public boolean isGoalAllowed(int maxApplications, long timeout, Proof proof, long startTime, int countApplied, Goal goal) {
        for (IBreakpoint breakpoint : this.breakpoints) {
            breakpoint.updateState(maxApplications, timeout, proof, startTime, countApplied, goal);
        }
        return super.isGoalAllowed(maxApplications, timeout, proof, startTime, countApplied, goal);
    }

    @Override
    protected void handleNodeLimitNotExceeded(int maxApplications, long timeout, Proof proof, long startTime, int countApplied, Goal goal, Node node, RuleApp ruleApp, Integer executedNumberOfSetNodes) {
        super.handleNodeLimitNotExceeded(maxApplications, timeout, proof, startTime, countApplied, goal, node, ruleApp, executedNumberOfSetNodes);
        SourceElement activeStatement = NodeInfo.computeActiveStatement((RuleApp)ruleApp);
        if (this.isBreakpointHit(activeStatement, ruleApp, proof, node)) {
            this.setMaximalNumberOfSetNodesToExecutePerGoal(executedNumberOfSetNodes);
        }
    }

    protected boolean isBreakpointHit(SourceElement activeStatement, RuleApp ruleApp, Proof proof, Node node) {
        boolean result = false;
        Iterator<IBreakpoint> iter = this.breakpoints.iterator();
        while (!result && iter.hasNext()) {
            IBreakpoint next = iter.next();
            result = next.isEnabled() && next.isBreakpointHit(activeStatement, ruleApp, proof, node);
        }
        return result;
    }

    @Override
    public void addBreakpoint(IBreakpoint breakpoint) {
        this.breakpoints.add(breakpoint);
    }

    @Override
    public void removeBreakpoint(IBreakpoint breakpoint) {
        this.breakpoints.remove(breakpoint);
    }

    @Override
    public Set<IBreakpoint> getBreakpoints() {
        return this.breakpoints;
    }
}

