/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.strategy;

import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.prover.StopCondition;
import de.uka.ilkd.key.prover.impl.DepthFirstGoalChooser;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.key_project.util.collection.ImmutableList;

public class SymbolicExecutionGoalChooser
extends DepthFirstGoalChooser {
    private Set<Goal> goalsToPrefer = new LinkedHashSet<Goal>();
    private StopCondition stopCondition;

    public Goal getNextGoal() {
        if (this.selectedList.size() >= 2) {
            Goal goal = null;
            if (this.stopCondition != null && this.goalsToPrefer.isEmpty()) {
                for (Goal goalToPrefer : this.selectedList) {
                    if (!this.stopCondition.isGoalAllowed(-1, -1L, this.proof, -1L, -1, goalToPrefer)) continue;
                    this.goalsToPrefer.add(goalToPrefer);
                }
            }
            if (this.goalsToPrefer.isEmpty()) {
                for (Goal goalToPrefer : this.selectedList) {
                    this.goalsToPrefer.add(goalToPrefer);
                }
            }
            LinkedHashSet<Goal> goalsWhereStopConditionDoNotAllowNextRule = new LinkedHashSet<Goal>();
            do {
                Goal head;
                RuleApp ruleApp;
                Goal next;
                if ((next = super.getNextGoal()) == null) {
                    return null;
                }
                Node node = next.node();
                if (!SymbolicExecutionUtil.isSymbolicExecutionTreeNode(node, ruleApp = next.getRuleAppManager().peekNext())) {
                    goal = next;
                    continue;
                }
                if (this.goalsToPrefer.remove(next) || this.goalsToPrefer.isEmpty()) {
                    if (this.stopCondition == null || this.stopCondition.isGoalAllowed(-1, -1L, this.proof, -1L, -1, next)) {
                        goal = next;
                    } else if (goalsWhereStopConditionDoNotAllowNextRule.add(next)) {
                        head = (Goal)this.selectedList.head();
                        this.selectedList = this.selectedList.take(1);
                        this.selectedList = this.selectedList.append((Object)head);
                    } else {
                        goal = next;
                    }
                }
                if (goal != null) continue;
                head = (Goal)this.selectedList.head();
                this.selectedList = this.selectedList.take(1);
                this.selectedList = this.selectedList.append((Object)head);
            } while (goal == null);
            return goal;
        }
        return super.getNextGoal();
    }

    public void init(Proof p_proof, ImmutableList<Goal> p_goals) {
        this.goalsToPrefer.clear();
        this.stopCondition = p_proof != null ? p_proof.getSettings().getStrategySettings().getCustomApplyStrategyStopCondition() : null;
        super.init(p_proof, p_goals);
    }

    public void removeGoal(Goal p_goal) {
        super.removeGoal(p_goal);
        this.goalsToPrefer.remove(p_goal);
    }

    public void updateGoalList(Node node, ImmutableList<Goal> newGoals) {
        super.updateGoalList(node, newGoals);
        Iterator<Goal> preferredIter = this.goalsToPrefer.iterator();
        while (preferredIter.hasNext()) {
            Goal next = preferredIter.next();
            if (this.proof.openGoals().contains((Object)next)) continue;
            preferredIter.remove();
        }
    }
}

