/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.strategy;

import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.rulefilter.RuleFilter;
import de.uka.ilkd.key.proof.rulefilter.SetRuleFilter;
import de.uka.ilkd.key.rule.Rule;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.strategy.JavaCardDLStrategy;
import de.uka.ilkd.key.strategy.Strategy;
import de.uka.ilkd.key.strategy.StrategyFactory;
import de.uka.ilkd.key.strategy.StrategyProperties;
import de.uka.ilkd.key.strategy.definition.AbstractStrategyPropertyDefinition;
import de.uka.ilkd.key.strategy.definition.IDefaultStrategyPropertiesFactory;
import de.uka.ilkd.key.strategy.definition.OneOfStrategyPropertyDefinition;
import de.uka.ilkd.key.strategy.definition.StrategyPropertyValueDefinition;
import de.uka.ilkd.key.strategy.definition.StrategySettingsDefinition;
import de.uka.ilkd.key.strategy.feature.BinaryFeature;
import de.uka.ilkd.key.strategy.feature.ConditionalFeature;
import de.uka.ilkd.key.strategy.feature.CountBranchFeature;
import de.uka.ilkd.key.strategy.feature.Feature;
import de.uka.ilkd.key.strategy.feature.RuleSetDispatchFeature;
import de.uka.ilkd.key.strategy.feature.ScaleFeature;
import de.uka.ilkd.key.strategy.feature.instantiator.OneOfCP;
import de.uka.ilkd.key.strategy.termProjection.ProjectionToTerm;
import de.uka.ilkd.key.strategy.termProjection.TermBuffer;
import de.uka.ilkd.key.strategy.termfeature.ContainsLabelFeature;
import de.uka.ilkd.key.symbolic_execution.rule.ModalitySideProofRule;
import de.uka.ilkd.key.symbolic_execution.rule.QuerySideProofRule;
import de.uka.ilkd.key.symbolic_execution.strategy.CutHeapObjectsFeature;
import de.uka.ilkd.key.symbolic_execution.strategy.CutHeapObjectsTermGenerator;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import java.util.ArrayList;

public class SymbolicExecutionStrategy
extends JavaCardDLStrategy {
    public static final Name name = new Name("Symbolic Execution Strategy");
    public static IDefaultStrategyPropertiesFactory DEFAULT_FACTORY = new IDefaultStrategyPropertiesFactory(){

        public StrategyProperties createDefaultStrategyProperties() {
            return SymbolicExecutionStrategy.getSymbolicExecutionStrategyProperties(true, false, false, false, false, false);
        }
    };

    private SymbolicExecutionStrategy(Proof proof, StrategyProperties sp) {
        super(proof, sp);
        RuleSetDispatchFeature costRsd = this.getCostComputationDispatcher();
        this.clearRuleSetBindings(costRsd, "simplify_prog");
        this.bindRuleSet(costRsd, "simplify_prog", 10000L);
        this.clearRuleSetBindings(costRsd, "simplify_prog_subset");
        this.bindRuleSet(costRsd, "simplify_prog_subset", 10000L);
        Feature splitF = ScaleFeature.createScaled((Feature)CountBranchFeature.INSTANCE, (double)-4000.0);
        this.bindRuleSet(costRsd, "split_if", splitF);
        this.bindRuleSet(costRsd, "instanceof_to_exists", SymbolicExecutionStrategy.inftyConst());
        if ("SYMBOLIC_EXECUTION_ALIAS_CHECK_IMMEDIATELY".equals(sp.get((Object)"SYMBOLIC_EXECUTION_ALIAS_CHECK_OPTIONS_KEY"))) {
            RuleSetDispatchFeature instRsd = this.getInstantiationDispatcher();
            this.enableInstantiate();
            TermBuffer buffer = new TermBuffer();
            Feature originalCut = instRsd.get(this.getHeuristic("cut"));
            Feature newCut = this.forEach(buffer, new CutHeapObjectsTermGenerator(), SymbolicExecutionStrategy.add((Feature)this.instantiate("cutFormula", (ProjectionToTerm)buffer), (Feature)SymbolicExecutionStrategy.longConst((long)-10000L)));
            if (originalCut instanceof OneOfCP) {
                this.clearRuleSetBindings(instRsd, "cut");
                this.bindRuleSet(instRsd, "cut", this.oneOf(originalCut, newCut));
            } else {
                this.bindRuleSet(instRsd, "cut", newCut);
            }
            this.disableInstantiate();
        }
    }

    protected Feature setupApprovalF() {
        Feature result = super.setupApprovalF();
        SetRuleFilter depFilter = new SetRuleFilter();
        depFilter.addRuleToSet((Rule)this.getProof().getInitConfig().lookupActiveTaclet(new Name("cut")));
        result = SymbolicExecutionStrategy.add((Feature)result, (Feature)ConditionalFeature.createConditional((RuleFilter)depFilter, (Feature)new CutHeapObjectsFeature()));
        return result;
    }

    protected Feature setupGlobalF(Feature dispatcher) {
        Feature globalF = super.setupGlobalF(dispatcher);
        globalF = SymbolicExecutionStrategy.add((Feature)globalF, (Feature)SymbolicExecutionStrategy.ifZero((Feature)SymbolicExecutionStrategy.not((Feature)new BinaryFeature(){

            protected boolean filter(RuleApp app, PosInOccurrence pos, Goal goal) {
                return pos != null && SymbolicExecutionUtil.hasSymbolicExecutionLabel(pos.subTerm());
            }
        }), (Feature)SymbolicExecutionStrategy.longConst((long)-3000L)));
        globalF = SymbolicExecutionStrategy.add((Feature)globalF, (Feature)SymbolicExecutionStrategy.ifZero((Feature)new ContainsLabelFeature(SymbolicExecutionUtil.LOOP_BODY_LABEL), (Feature)SymbolicExecutionStrategy.longConst((long)-2000L)));
        globalF = SymbolicExecutionStrategy.add((Feature)globalF, (Feature)this.querySideProofFeature());
        globalF = SymbolicExecutionStrategy.add((Feature)globalF, (Feature)this.modalitySideProofFeature());
        return globalF;
    }

    protected Feature modalitySideProofFeature() {
        SetRuleFilter filter = new SetRuleFilter();
        filter.addRuleToSet((Rule)ModalitySideProofRule.INSTANCE);
        if ("SYMBOLIC_EXECUTION_NON_EXECUTION_BRANCH_HIDING_SIDE_PROOF".equals(this.strategyProperties.get((Object)"SYMBOLIC_EXECUTION_NON_EXECUTION_BRANCH_HIDING_OPTIONS_KEY"))) {
            return ConditionalFeature.createConditional((RuleFilter)filter, (Feature)SymbolicExecutionStrategy.longConst((long)-3050L));
        }
        return ConditionalFeature.createConditional((RuleFilter)filter, (Feature)SymbolicExecutionStrategy.inftyConst());
    }

    protected Feature querySideProofFeature() {
        SetRuleFilter filter = new SetRuleFilter();
        filter.addRuleToSet((Rule)QuerySideProofRule.INSTANCE);
        if ("SYMBOLIC_EXECUTION_NON_EXECUTION_BRANCH_HIDING_SIDE_PROOF".equals(this.strategyProperties.get((Object)"SYMBOLIC_EXECUTION_NON_EXECUTION_BRANCH_HIDING_OPTIONS_KEY"))) {
            return ConditionalFeature.createConditional((RuleFilter)filter, (Feature)SymbolicExecutionStrategy.longConst((long)-3050L));
        }
        return ConditionalFeature.createConditional((RuleFilter)filter, (Feature)SymbolicExecutionStrategy.inftyConst());
    }

    public Name name() {
        return name;
    }

    public static StrategyProperties getSymbolicExecutionStrategyProperties(boolean quantifierInstantiationWithSplitting, boolean methodTreatmentContract, boolean loopTreatmentInvariant, boolean blockTreatmentContract, boolean nonExecutionBranchHidingSideProofs, boolean aliasChecks) {
        StrategyProperties sp = new StrategyProperties();
        StrategyProperties.setDefaultStrategyProperties((StrategyProperties)sp, (boolean)quantifierInstantiationWithSplitting, (boolean)methodTreatmentContract, (boolean)loopTreatmentInvariant, (boolean)blockTreatmentContract, (boolean)nonExecutionBranchHidingSideProofs, (boolean)aliasChecks);
        return sp;
    }

    public static class Factory
    implements StrategyFactory {
        public static final String METHOD_TREATMENT_EXPAND = "Inline Methods";
        public static final String METHOD_TREATMENT_CONTRACT = "Use Contracts";
        public static final String LOOP_TREATMENT_EXPAND = "Unroll Loops";
        public static final String LOOP_TREATMENT_INVARIANT = "Use Loop Invariants";
        public static final String BLOCK_TREATMENT_EXPAND = "Expand Blocks";
        public static final String BLOCK_TREATMENT_INVARIANT = "Use Contracts";
        public static final String NON_EXECUTION_BRANCH_HIDING_OFF = "Off";
        public static final String NON_EXECUTION_BRANCH_HIDING_SIDE_PROOF = "On";
        public static final String ALIAS_CHECK_NEVER = "Never";
        public static final String ALIAS_CHECK_IMMEDIATELY = "Immediately";

        public Strategy create(Proof proof, StrategyProperties sp) {
            return new SymbolicExecutionStrategy(proof, sp);
        }

        public Name name() {
            return name;
        }

        public StrategySettingsDefinition getSettingsDefinition() {
            OneOfStrategyPropertyDefinition methodTreatment = new OneOfStrategyPropertyDefinition("METHOD_OPTIONS_KEY", "Method Treatment", new StrategyPropertyValueDefinition[]{new StrategyPropertyValueDefinition("METHOD_EXPAND", METHOD_TREATMENT_EXPAND, null), new StrategyPropertyValueDefinition("METHOD_CONTRACT", "Use Contracts", null)});
            OneOfStrategyPropertyDefinition loopTreatment = new OneOfStrategyPropertyDefinition("LOOP_OPTIONS_KEY", "Loop Treatment", new StrategyPropertyValueDefinition[]{new StrategyPropertyValueDefinition("LOOP_EXPAND", LOOP_TREATMENT_EXPAND, null), new StrategyPropertyValueDefinition("LOOP_INVARIANT", LOOP_TREATMENT_INVARIANT, null)});
            OneOfStrategyPropertyDefinition blockTreatment = new OneOfStrategyPropertyDefinition("BLOCK_OPTIONS_KEY", "Block Treatment", new StrategyPropertyValueDefinition[]{new StrategyPropertyValueDefinition("BLOCK_EXPAND", BLOCK_TREATMENT_EXPAND, null), new StrategyPropertyValueDefinition("BLOCK_CONTRACT_INTERNAL", "Use Contracts", null)});
            OneOfStrategyPropertyDefinition branchHiding = new OneOfStrategyPropertyDefinition("SYMBOLIC_EXECUTION_NON_EXECUTION_BRANCH_HIDING_OPTIONS_KEY", "Non Execution Branch Hiding", new StrategyPropertyValueDefinition[]{new StrategyPropertyValueDefinition("SYMBOLIC_EXECUTION_NON_EXECUTION_BRANCH_HIDING_OFF", NON_EXECUTION_BRANCH_HIDING_OFF, null), new StrategyPropertyValueDefinition("SYMBOLIC_EXECUTION_NON_EXECUTION_BRANCH_HIDING_SIDE_PROOF", NON_EXECUTION_BRANCH_HIDING_SIDE_PROOF, null)});
            OneOfStrategyPropertyDefinition aliasChecks = new OneOfStrategyPropertyDefinition("SYMBOLIC_EXECUTION_ALIAS_CHECK_OPTIONS_KEY", "Alias Checks", new StrategyPropertyValueDefinition[]{new StrategyPropertyValueDefinition("SYMBOLIC_EXECUTION_ALIAS_CHECK_NEVER", ALIAS_CHECK_NEVER, null), new StrategyPropertyValueDefinition("SYMBOLIC_EXECUTION_ALIAS_CHECK_IMMEDIATELY", ALIAS_CHECK_IMMEDIATELY, null)});
            return new StrategySettingsDefinition(false, null, 1000, "Symbolic Execution Options", DEFAULT_FACTORY, new ArrayList(), new AbstractStrategyPropertyDefinition[]{methodTreatment, loopTreatment, blockTreatment, branchHiding, aliasChecks});
        }
    }
}

