/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.strategy.breakpoint;

import de.uka.ilkd.key.java.JavaInfo;
import de.uka.ilkd.key.java.JavaTools;
import de.uka.ilkd.key.java.ProgramElement;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.java.StatementBlock;
import de.uka.ilkd.key.java.StatementContainer;
import de.uka.ilkd.key.java.abstraction.Field;
import de.uka.ilkd.key.java.abstraction.KeYJavaType;
import de.uka.ilkd.key.java.declaration.ParameterDeclaration;
import de.uka.ilkd.key.java.declaration.TypeDeclaration;
import de.uka.ilkd.key.java.reference.ExecutionContext;
import de.uka.ilkd.key.java.visitor.ProgramVariableCollector;
import de.uka.ilkd.key.logic.JavaBlock;
import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.ProgramElementName;
import de.uka.ilkd.key.logic.RenamingTable;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.TermBuilder;
import de.uka.ilkd.key.logic.VariableNamer;
import de.uka.ilkd.key.logic.op.IProgramMethod;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.LocationVariable;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.logic.op.SVSubstitute;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.OpReplacer;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.proof.mgt.ProofEnvironment;
import de.uka.ilkd.key.prover.impl.ApplyStrategyInfo;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.speclang.PositionedString;
import de.uka.ilkd.key.speclang.njml.JmlIO;
import de.uka.ilkd.key.speclang.translation.SLTranslationException;
import de.uka.ilkd.key.symbolic_execution.strategy.breakpoint.AbstractHitCountBreakpoint;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionSideProofUtil;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;

public abstract class AbstractConditionalBreakpoint
extends AbstractHitCountBreakpoint {
    private Term condition;
    private boolean conditionEnabled;
    private String conditionString;
    private ImmutableList<ProgramVariable> varsForCondition;
    private KeYJavaType containerType;
    private Set<LocationVariable> toKeep;
    private Map<SVSubstitute, SVSubstitute> variableNamingMap;
    private Set<LocationVariable> paramVars;
    private ProgramVariable selfVar;
    private IProgramMethod pm;

    public AbstractConditionalBreakpoint(int hitCount, IProgramMethod pm, Proof proof, boolean enabled, boolean conditionEnabled, int methodStart, int methodEnd, KeYJavaType containerType) {
        super(hitCount, proof, enabled);
        this.setPm(pm);
        this.paramVars = new HashSet<LocationVariable>();
        this.setVariableNamingMap(new HashMap<SVSubstitute, SVSubstitute>());
        this.toKeep = new HashSet<LocationVariable>();
        this.containerType = containerType;
        this.conditionEnabled = conditionEnabled;
    }

    @Override
    public void updateState(int maxApplications, long timeout, Proof proof, long startTime, int countApplied, Goal goal) {
        super.updateState(maxApplications, timeout, proof, startTime, countApplied, goal);
        if (goal != null) {
            Node node = goal.node();
            RuleApp ruleApp = goal.getRuleAppManager().peekNext();
            if (this.getVarsForCondition() != null && ruleApp != null && node != null) {
                this.refreshVarMaps(ruleApp, node);
            }
        }
    }

    private void putValuesFromGlobalVars(ProgramVariable varForCondition, Node node, boolean inScope) {
        for (IProgramVariable progVar : node.getLocalProgVars()) {
            if (!inScope || !varForCondition.name().equals((Object)progVar.name()) || this.getVariableNamingMap().get(varForCondition) != null && !this.getVariableNamingMap().get(varForCondition).equals(varForCondition)) continue;
            this.toKeep.add((LocationVariable)progVar);
            this.getVariableNamingMap().put((SVSubstitute)varForCondition, (SVSubstitute)progVar);
        }
    }

    private Map<SVSubstitute, SVSubstitute> getOldMap() {
        HashMap<SVSubstitute, SVSubstitute> oldMap = new HashMap<SVSubstitute, SVSubstitute>();
        for (Map.Entry<SVSubstitute, SVSubstitute> oldEntry : this.getVariableNamingMap().entrySet()) {
            if (!(oldEntry.getKey() instanceof SVSubstitute) || !(oldEntry.getValue() instanceof SVSubstitute)) continue;
            oldMap.put(oldEntry.getKey(), oldEntry.getValue());
        }
        return oldMap;
    }

    private void freeVariablesAfterReturn(Node node, RuleApp ruleApp, boolean inScope) {
        if ((SymbolicExecutionUtil.isMethodReturnNode(node, ruleApp) || SymbolicExecutionUtil.isExceptionalMethodReturnNode(node, ruleApp)) && inScope) {
            this.toKeep.clear();
        }
    }

    private void putValuesFromRenamings(ProgramVariable varForCondition, Node node, boolean inScope, Map<SVSubstitute, SVSubstitute> oldMap, RuleApp ruleApp) {
        boolean found = false;
        ImmutableList renamingTables = node.getRenamingTable();
        if (renamingTables != null && renamingTables.size() > 0) {
            Iterator itr = renamingTables.iterator();
            block0: while (itr.hasNext() && !found) {
                RenamingTable renamingTable = (RenamingTable)itr.next();
                for (Map.Entry entry : renamingTable.getHashMap().entrySet()) {
                    if (!(entry.getKey() instanceof LocationVariable) || !(entry.getValue() instanceof SVSubstitute)) continue;
                    if (VariableNamer.getBasename((Name)((LocationVariable)entry.getKey()).name()).equals((Object)varForCondition.name()) && ((LocationVariable)entry.getKey()).name().toString().contains("#") && this.paramVars.contains(varForCondition)) {
                        if (oldMap.get(varForCondition) != entry.getValue()) {
                            this.toKeep.remove((LocationVariable)oldMap.get(varForCondition));
                        }
                        this.toKeep.add((LocationVariable)entry.getValue());
                        this.getVariableNamingMap().put((SVSubstitute)varForCondition, (SVSubstitute)entry.getValue());
                        found = true;
                        continue block0;
                    }
                    if (!inScope || !((LocationVariable)entry.getKey()).name().equals((Object)varForCondition.name())) continue;
                    if (oldMap.get(varForCondition) != entry.getValue()) {
                        this.toKeep.remove((LocationVariable)oldMap.get(varForCondition));
                    }
                    this.toKeep.add((LocationVariable)entry.getValue());
                    this.getVariableNamingMap().put((SVSubstitute)varForCondition, (SVSubstitute)entry.getValue());
                    found = true;
                    continue block0;
                }
            }
        }
    }

    protected void refreshVarMaps(RuleApp ruleApp, Node node) {
        boolean inScope = this.isInScope(node);
        Map<SVSubstitute, SVSubstitute> oldMap = this.getOldMap();
        for (ProgramVariable varForCondition : this.getVarsForCondition()) {
            this.putValuesFromGlobalVars(varForCondition, node, inScope);
            this.putValuesFromRenamings(varForCondition, node, this.isInScopeForCondition(node), oldMap, ruleApp);
        }
        this.freeVariablesAfterReturn(node, ruleApp, inScope);
    }

    private Term computeTermForCondition(String condition) {
        if (condition == null) {
            return this.getProof().getServices().getTermBuilder().tt();
        }
        this.setSelfVar((ProgramVariable)new LocationVariable(new ProgramElementName(this.getProof().getServices().getTermBuilder().newName("self")), this.containerType, null, false, false));
        ImmutableList<ProgramVariable> varsForCondition = ImmutableSLList.nil();
        if (this.getPm() != null) {
            for (ParameterDeclaration pd : this.getPm().getParameters()) {
                for (Iterator vs : pd.getVariables()) {
                    this.paramVars.add((LocationVariable)vs.getProgramVariable());
                    varsForCondition = varsForCondition.append((Object)((ProgramVariable)vs.getProgramVariable()));
                }
            }
            StatementBlock result = this.getStatementBlock((StatementContainer)this.getPm().getBody());
            ProgramVariableCollector variableCollector = new ProgramVariableCollector((ProgramElement)result, this.getProof().getServices());
            variableCollector.start();
            LinkedHashSet undeclaredVariables = variableCollector.result();
            for (LocationVariable x : undeclaredVariables) {
                varsForCondition = this.saveAddVariable(x, varsForCondition);
            }
        }
        JavaInfo info = this.getProof().getServices().getJavaInfo();
        ImmutableList kjts = info.getAllSupertypes(this.containerType);
        ImmutableSLList globalVars = ImmutableSLList.nil();
        for (KeYJavaType kjtloc : kjts) {
            if (!(kjtloc.getJavaType() instanceof TypeDeclaration)) continue;
            ImmutableList fields = info.getAllFields((TypeDeclaration)kjtloc.getJavaType());
            for (Field field : fields) {
                if (!kjtloc.equals((Object)this.containerType) && field.isPrivate() || ((LocationVariable)field.getProgramVariable()).isImplicit()) continue;
                globalVars = globalVars.append((Object)((ProgramVariable)field.getProgramVariable()));
            }
        }
        varsForCondition = varsForCondition.append((ImmutableList)globalVars);
        this.setVarsForCondition(varsForCondition);
        PositionedString ps = new PositionedString(condition);
        JmlIO io = new JmlIO().services(this.getProof().getServices()).classType(this.containerType).selfVar(this.getSelfVar()).parameters(varsForCondition);
        return io.parseExpression(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean conditionMet(RuleApp ruleApp, Proof proof, Node node) {
        ApplyStrategyInfo info = null;
        try {
            PosInOccurrence pio = ruleApp.posInOccurrence();
            Term term = pio.subTerm();
            this.getProof().getServices().getTermBuilder();
            term = TermBuilder.goBelowUpdates((Term)term);
            ExecutionContext ec = JavaTools.getInnermostExecutionContext((JavaBlock)term.javaBlock(), (Services)proof.getServices());
            if (ec != null) {
                this.getVariableNamingMap().put((SVSubstitute)this.getSelfVar(), (SVSubstitute)ec.getRuntimeInstance());
            }
            OpReplacer replacer = new OpReplacer(this.getVariableNamingMap(), this.getProof().getServices().getTermFactory());
            Term termForSideProof = replacer.replace(this.condition);
            Term toProof = this.getProof().getServices().getTermBuilder().equals(this.getProof().getServices().getTermBuilder().tt(), termForSideProof);
            ProofEnvironment sideProofEnv = SymbolicExecutionSideProofUtil.cloneProofEnvironmentWithOwnOneStepSimplifier(this.getProof(), false);
            Sequent sequent = SymbolicExecutionUtil.createSequentToProveWithNewSuccedent(node, pio, toProof);
            info = SymbolicExecutionSideProofUtil.startSideProof(proof, sideProofEnv, sequent, "METHOD_CONTRACT", "LOOP_INVARIANT", "QUERY_ON", "SPLITTING_DELAYED");
            boolean bl = info.getProof().closed();
            SymbolicExecutionSideProofUtil.disposeOrStore("Breakpoint condition computation on node " + node.serialNr() + ".", info);
            return bl;
        }
        catch (ProofInputException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            SymbolicExecutionSideProofUtil.disposeOrStore("Breakpoint condition computation on node " + node.serialNr() + ".", info);
        }
    }

    @Override
    public boolean isBreakpointHit(SourceElement activeStatement, RuleApp ruleApp, Proof proof, Node node) {
        return (!this.conditionEnabled || this.conditionMet(ruleApp, proof, node)) && super.isBreakpointHit(activeStatement, ruleApp, proof, node);
    }

    protected abstract StatementBlock getStatementBlock(StatementContainer var1);

    protected abstract boolean isInScope(Node var1);

    protected abstract boolean isInScopeForCondition(Node var1);

    private ImmutableList<ProgramVariable> saveAddVariable(LocationVariable x, ImmutableList<ProgramVariable> varsForCondition) {
        boolean contains = false;
        for (ProgramVariable paramVar : varsForCondition) {
            if (!paramVar.toString().equals(x.toString())) continue;
            contains = true;
            break;
        }
        if (!contains && !x.isMember()) {
            varsForCondition = varsForCondition.append((Object)x);
        }
        return varsForCondition;
    }

    public void setConditionEnabled(boolean conditionEnabled) {
        this.conditionEnabled = conditionEnabled;
    }

    public Term getCondition() {
        return this.condition;
    }

    public boolean isConditionEnabled() {
        return this.conditionEnabled;
    }

    public void setCondition(String condition) throws SLTranslationException {
        this.conditionString = condition;
        this.condition = this.conditionEnabled ? this.computeTermForCondition(condition) : this.getProof().getServices().getTermBuilder().tt();
    }

    public String getConditionString() {
        return this.conditionString;
    }

    public Set<LocationVariable> getToKeep() {
        return this.toKeep;
    }

    public Map<SVSubstitute, SVSubstitute> getVariableNamingMap() {
        return this.variableNamingMap;
    }

    public void setVariableNamingMap(Map<SVSubstitute, SVSubstitute> variableNamingMap) {
        this.variableNamingMap = variableNamingMap;
    }

    public ProgramVariable getSelfVar() {
        return this.selfVar;
    }

    public void setSelfVar(ProgramVariable selfVar) {
        this.selfVar = selfVar;
    }

    public ImmutableList<ProgramVariable> getVarsForCondition() {
        return this.varsForCondition;
    }

    public void setVarsForCondition(ImmutableList<ProgramVariable> varsForCondition) {
        this.varsForCondition = varsForCondition;
    }

    public IProgramMethod getPm() {
        return this.pm;
    }

    public void setPm(IProgramMethod pm) {
        this.pm = pm;
    }
}

