/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.strategy.breakpoint;

import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.symbolic_execution.strategy.breakpoint.AbstractBreakpoint;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractHitCountBreakpoint
extends AbstractBreakpoint {
    private int hitCount;
    private int hitted = 0;
    private final Map<Integer, Boolean> hittedNodes = new HashMap<Integer, Boolean>();

    public AbstractHitCountBreakpoint(int hitCount, Proof proof, boolean enabled) {
        super(proof, enabled);
        this.hitCount = hitCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean hitcountExceeded(Node node) {
        if (this.hitCount == -1) return true;
        if (this.hittedNodes.containsKey(node.serialNr())) return this.hittedNodes.get(node.serialNr());
        if (this.hitCount == this.hitted + 1) {
            this.hitted = 0;
            this.hittedNodes.put(node.serialNr(), Boolean.TRUE);
            return true;
        }
        this.hittedNodes.put(node.serialNr(), Boolean.FALSE);
        ++this.hitted;
        return false;
    }

    @Override
    public boolean isBreakpointHit(SourceElement activeStatement, RuleApp ruleApp, Proof proof, Node node) {
        return this.hitcountExceeded(node);
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public void setHitCount(int hitCount) {
        if (this.hitCount != hitCount) {
            this.hitCount = hitCount;
            this.hitted = 0;
            this.hittedNodes.clear();
        }
    }
}

