/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.strategy.breakpoint;

import de.uka.ilkd.key.java.JavaInfo;
import de.uka.ilkd.key.java.ProgramElement;
import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.java.abstraction.KeYJavaType;
import de.uka.ilkd.key.java.statement.Throw;
import de.uka.ilkd.key.logic.op.LocationVariable;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.symbolic_execution.strategy.breakpoint.AbstractHitCountBreakpoint;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import java.util.HashSet;
import java.util.Set;
import org.key_project.util.collection.ImmutableList;

public class ExceptionBreakpoint
extends AbstractHitCountBreakpoint {
    private String exceptionName;
    private Set<Node> exceptionParentNodes;
    private boolean caught;
    private boolean suspendOnSubclasses;
    private boolean uncaught;

    public ExceptionBreakpoint(Proof proof, String exceptionName, boolean caught, boolean uncaught, boolean suspendOnSubclasses, boolean enabled, int hitCount) {
        super(hitCount, proof, enabled);
        this.exceptionName = exceptionName;
        this.exceptionParentNodes = new HashSet<Node>();
        this.caught = caught;
        this.uncaught = uncaught;
        this.suspendOnSubclasses = suspendOnSubclasses;
    }

    public boolean isParentNode(Node node, Node parent) {
        if (node != null) {
            Node parentIter = node.parent();
            boolean result = false;
            while (parentIter != null && !result) {
                if (parentIter.equals(parent)) {
                    result = true;
                    continue;
                }
                parentIter = parentIter.parent();
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean isBreakpointHit(SourceElement activeStatement, RuleApp ruleApp, Proof proof, Node node) {
        Node SETParent = SymbolicExecutionUtil.findParentSetNode(node);
        if (activeStatement != null && activeStatement instanceof Throw && this.isEnabled()) {
            Throw throwStatement = (Throw)activeStatement;
            for (int i = 0; i < throwStatement.getChildCount(); ++i) {
                ProgramElement childElement = throwStatement.getChildAt(i);
                if (!(childElement instanceof LocationVariable)) continue;
                LocationVariable locVar = (LocationVariable)childElement;
                if (locVar.getKeYJavaType().getSort().toString().equals(this.exceptionName) && !this.exceptionParentNodes.contains(SETParent)) {
                    this.exceptionParentNodes.add(SETParent);
                    return true;
                }
                if (!this.suspendOnSubclasses) continue;
                JavaInfo info = proof.getServices().getJavaInfo();
                KeYJavaType kjt = locVar.getKeYJavaType();
                ImmutableList kjts = info.getAllSupertypes(kjt);
                for (KeYJavaType kjtloc : kjts) {
                    if (!kjtloc.getSort().toString().equals(this.exceptionName) || this.exceptionParentNodes.contains(SETParent)) continue;
                    this.exceptionParentNodes.add(SETParent);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isCaught() {
        return this.caught;
    }

    public void setCaught(boolean isCaught) {
        this.caught = isCaught;
    }

    public boolean isUncaught() {
        return this.uncaught;
    }

    public void setUncaught(boolean isUncaught) {
        this.uncaught = isUncaught;
    }

    public boolean isSuspendOnSubclasses() {
        return this.suspendOnSubclasses;
    }

    public void setSuspendOnSubclasses(boolean suspendOnSubclasses) {
        this.suspendOnSubclasses = suspendOnSubclasses;
    }
}

