/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.strategy.breakpoint;

import de.uka.ilkd.key.java.NonTerminalProgramElement;
import de.uka.ilkd.key.java.ProgramElement;
import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.java.abstraction.KeYJavaType;
import de.uka.ilkd.key.java.expression.Assignment;
import de.uka.ilkd.key.java.reference.FieldReference;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.TermBuilder;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.symbolic_execution.strategy.breakpoint.AbstractHitCountBreakpoint;

public class FieldWatchpoint
extends AbstractHitCountBreakpoint {
    private boolean isAccess;
    private boolean isModification;
    private String fullFieldName;

    public FieldWatchpoint(boolean enabled, int hitCount, String fieldName, boolean isAcces, boolean isModification, KeYJavaType containerKJT, Proof proof) {
        super(hitCount, proof, enabled);
        this.isAccess = isAcces;
        this.isModification = isModification;
        this.fullFieldName = containerKJT.getSort().toString() + "::" + fieldName;
    }

    @Override
    public boolean isBreakpointHit(SourceElement activeStatement, RuleApp ruleApp, Proof proof, Node node) {
        if (activeStatement != null && activeStatement instanceof Assignment) {
            Assignment assignment = (Assignment)activeStatement;
            ProgramElement firstElement = assignment.getChildAt(0);
            if (firstElement instanceof FieldReference) {
                PosInOccurrence pio = ruleApp.posInOccurrence();
                Term term = pio.subTerm();
                this.getProof().getServices().getTermBuilder();
                term = TermBuilder.goBelowUpdates((Term)term);
                if (((FieldReference)firstElement).getProgramVariable().name().toString().equals(this.fullFieldName) && this.isModification && this.hitcountExceeded(node)) {
                    return super.isBreakpointHit(activeStatement, ruleApp, proof, node);
                }
            }
            if (this.checkChildrenOfSourceElement((SourceElement)assignment) && this.hitcountExceeded(node)) {
                return super.isBreakpointHit(activeStatement, ruleApp, proof, node);
            }
        } else if (activeStatement != null && this.checkChildrenOfSourceElement(activeStatement) && this.hitcountExceeded(node)) {
            return super.isBreakpointHit(activeStatement, ruleApp, proof, node);
        }
        return false;
    }

    private boolean checkChildrenOfSourceElement(SourceElement sourceElement) {
        boolean found;
        block5: {
            block4: {
                found = false;
                if (!(sourceElement instanceof Assignment)) break block4;
                Assignment assignment = (Assignment)sourceElement;
                for (int i = 1; i < assignment.getChildCount(); ++i) {
                    ProgramElement childElement = assignment.getChildAt(i);
                    if (childElement instanceof FieldReference && ((FieldReference)childElement).getProgramVariable().name().toString().equals(this.fullFieldName)) {
                        FieldReference field = (FieldReference)childElement;
                        ProgramVariable progVar = field.getProgramVariable();
                        if (!this.fullFieldName.equals(progVar.toString())) continue;
                        return this.isAccess;
                    }
                    if (!(childElement instanceof NonTerminalProgramElement)) continue;
                    found = found || this.checkChildrenOfSourceElement((SourceElement)childElement);
                }
                break block5;
            }
            if (!(sourceElement instanceof NonTerminalProgramElement)) break block5;
            NonTerminalProgramElement programElement = (NonTerminalProgramElement)sourceElement;
            for (int i = 0; i < programElement.getChildCount(); ++i) {
                ProgramElement childElement = programElement.getChildAt(i);
                if (childElement instanceof FieldReference && ((FieldReference)childElement).getProgramVariable().name().toString().equals(this.fullFieldName)) {
                    FieldReference field = (FieldReference)childElement;
                    ProgramVariable progVar = field.getProgramVariable();
                    if (!this.fullFieldName.equals(progVar.toString())) continue;
                    return this.isAccess;
                }
                if (!(childElement instanceof NonTerminalProgramElement)) continue;
                found = found || this.checkChildrenOfSourceElement((SourceElement)childElement);
            }
        }
        return found;
    }

    public boolean isAccess() {
        return this.isAccess;
    }

    public void setAccess(boolean isAccess) {
        this.isAccess = isAccess;
    }

    public boolean isModification() {
        return this.isModification;
    }

    public void setModification(boolean isModification) {
        this.isModification = isModification;
    }
}

