/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.strategy.breakpoint;

import de.uka.ilkd.key.java.JavaTools;
import de.uka.ilkd.key.java.Position;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.java.StatementBlock;
import de.uka.ilkd.key.java.StatementContainer;
import de.uka.ilkd.key.java.abstraction.KeYJavaType;
import de.uka.ilkd.key.java.reference.ExecutionContext;
import de.uka.ilkd.key.logic.JavaBlock;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.TermBuilder;
import de.uka.ilkd.key.logic.op.SVSubstitute;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.OpReplacer;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.proof.mgt.ProofEnvironment;
import de.uka.ilkd.key.prover.impl.ApplyStrategyInfo;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.speclang.translation.SLTranslationException;
import de.uka.ilkd.key.symbolic_execution.strategy.breakpoint.AbstractConditionalBreakpoint;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionSideProofUtil;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;

public class KeYWatchpoint
extends AbstractConditionalBreakpoint {
    private boolean suspendOnTrue;

    public KeYWatchpoint(int hitCount, Proof proof, String condition, boolean enabled, boolean conditionEnabled, KeYJavaType containerType, boolean suspendOnTrue) throws SLTranslationException {
        super(hitCount, null, proof, enabled, conditionEnabled, -1, -1, containerType);
        this.setSuspendOnTrue(suspendOnTrue);
        this.setCondition(condition);
    }

    @Override
    protected StatementBlock getStatementBlock(StatementContainer statementContainer) {
        return (StatementBlock)statementContainer;
    }

    @Override
    protected boolean isInScope(Node node) {
        return true;
    }

    @Override
    protected boolean isInScopeForCondition(Node node) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean conditionMet(RuleApp ruleApp, Proof proof, Node node) {
        if (this.suspendOnTrue) {
            return super.conditionMet(ruleApp, proof, node);
        }
        ApplyStrategyInfo info = null;
        try {
            Sequent sequent;
            Term negatedCondition = this.getProof().getServices().getTermBuilder().not(this.getCondition());
            PosInOccurrence pio = ruleApp.posInOccurrence();
            Term term = pio.subTerm();
            term = TermBuilder.goBelowUpdates((Term)term);
            ExecutionContext ec = JavaTools.getInnermostExecutionContext((JavaBlock)term.javaBlock(), (Services)proof.getServices());
            if (ec != null) {
                this.getVariableNamingMap().put((SVSubstitute)this.getSelfVar(), (SVSubstitute)ec.getRuntimeInstance());
            }
            OpReplacer replacer = new OpReplacer(this.getVariableNamingMap(), this.getProof().getServices().getTermFactory());
            Term termForSideProof = replacer.replace(negatedCondition);
            Term toProof = this.getProof().getServices().getTermBuilder().equals(this.getProof().getServices().getTermBuilder().tt(), termForSideProof);
            ProofEnvironment sideProofEnv = SymbolicExecutionSideProofUtil.cloneProofEnvironmentWithOwnOneStepSimplifier(this.getProof(), false);
            info = SymbolicExecutionSideProofUtil.startSideProof(proof, sideProofEnv, sequent = SymbolicExecutionUtil.createSequentToProveWithNewSuccedent(node, pio, toProof), "METHOD_CONTRACT", "LOOP_INVARIANT", "QUERY_ON", "SPLITTING_DELAYED");
            boolean bl = !info.getProof().closed();
            SymbolicExecutionSideProofUtil.disposeOrStore("KeY Watchpoint evaluation on node " + node.serialNr() + ".", info);
            return bl;
        }
        catch (ProofInputException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            SymbolicExecutionSideProofUtil.disposeOrStore("KeY Watchpoint evaluation on node " + node.serialNr() + ".", info);
        }
    }

    public boolean isSuspendOnTrue() {
        return this.suspendOnTrue;
    }

    public void setSuspendOnTrue(boolean suspendOnTrue) {
        this.suspendOnTrue = suspendOnTrue;
    }

    @Override
    public boolean isBreakpointHit(SourceElement activeStatement, RuleApp ruleApp, Proof proof, Node node) {
        if (activeStatement != null && activeStatement.getStartPosition() != Position.UNDEFINED) {
            return super.isBreakpointHit(activeStatement, ruleApp, proof, node);
        }
        return false;
    }
}

