/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.strategy.breakpoint;

import de.uka.ilkd.key.java.Position;
import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.java.StatementBlock;
import de.uka.ilkd.key.java.StatementContainer;
import de.uka.ilkd.key.java.declaration.LocalVariableDeclaration;
import de.uka.ilkd.key.logic.op.IProgramMethod;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.NodeInfo;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.rule.LoopInvariantBuiltInRuleApp;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.speclang.translation.SLTranslationException;
import de.uka.ilkd.key.symbolic_execution.strategy.breakpoint.AbstractConditionalBreakpoint;
import org.key_project.util.ExtList;

public class LineBreakpoint
extends AbstractConditionalBreakpoint {
    private String classPath;
    private int lineNumber;
    protected int methodStart;
    protected int methodEnd;

    public LineBreakpoint(String classPath, int lineNumber, int hitCount, IProgramMethod pm, Proof proof, String condition, boolean enabled, boolean conditionEnabled, int methodStart, int methodEnd) throws SLTranslationException {
        super(hitCount, pm, proof, enabled, conditionEnabled, methodStart, methodEnd, pm.getContainerType());
        this.classPath = classPath;
        this.methodEnd = methodEnd;
        this.methodStart = methodStart;
        this.lineNumber = lineNumber;
        this.setCondition(condition);
    }

    @Override
    protected StatementBlock getStatementBlock(StatementContainer statementContainer) {
        int i;
        ExtList nextResult = new ExtList();
        for (i = 0; i < statementContainer.getStatementCount(); ++i) {
            nextResult.add((Object)statementContainer.getStatementAt(i));
        }
        for (i = 0; i < nextResult.size(); ++i) {
            if (((SourceElement)nextResult.get(i)).getEndPosition().getLine() <= this.lineNumber) continue;
            if (nextResult.get(i) instanceof StatementContainer) {
                nextResult.set(i, (Object)this.getStatementBlock((StatementContainer)nextResult.get(i)));
                continue;
            }
            for (int j = nextResult.size() - 1; j >= i; --j) {
                nextResult.remove((Object)statementContainer.getChildAt(j));
            }
        }
        return new StatementBlock(nextResult);
    }

    protected boolean shouldStopInLine(int line, String path) {
        return this.lineNumber == line && this.getClassPath().equals(path);
    }

    @Override
    public boolean isBreakpointHit(SourceElement activeStatement, RuleApp ruleApp, Proof proof, Node node) {
        if (ruleApp instanceof LoopInvariantBuiltInRuleApp) {
            activeStatement = ((LoopInvariantBuiltInRuleApp)ruleApp).getLoopStatement();
        }
        return this.isInLine(activeStatement) && super.isBreakpointHit(activeStatement, ruleApp, proof, node);
    }

    private boolean isInLine(SourceElement activeStatement) {
        if (activeStatement != null && activeStatement.getStartPosition() != Position.UNDEFINED) {
            String path = activeStatement.getPositionInfo().getParentClass();
            int startLine = activeStatement.getStartPosition().getLine();
            int endLine = activeStatement.getEndPosition().getLine();
            boolean isInLine = endLine > startLine + 1 ? this.shouldStopInLine(startLine, path) : this.shouldStopInLine(endLine, path);
            return isInLine;
        }
        return false;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    protected boolean isInScope(Node node) {
        for (Node checkNode = node; checkNode != null; checkNode = checkNode.parent()) {
            SourceElement activeStatement = NodeInfo.computeActiveStatement((RuleApp)checkNode.getAppliedRuleApp());
            if (activeStatement == null || activeStatement.getStartPosition() == Position.UNDEFINED) continue;
            if (activeStatement.getStartPosition().getLine() < this.methodStart || activeStatement.getEndPosition().getLine() > this.methodEnd) break;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isInScopeForCondition(Node node) {
        for (Node checkNode = node; checkNode != null; checkNode = checkNode.parent()) {
            SourceElement activeStatement = NodeInfo.computeActiveStatement((RuleApp)checkNode.getAppliedRuleApp());
            if (activeStatement == null || activeStatement.getStartPosition() == Position.UNDEFINED) continue;
            if (activeStatement.getStartPosition().getLine() < this.methodStart || activeStatement.getEndPosition().getLine() > this.methodEnd || !(activeStatement instanceof LocalVariableDeclaration)) break;
            return true;
        }
        return false;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }
}

