/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.strategy.breakpoint;

import de.uka.ilkd.key.java.JavaTools;
import de.uka.ilkd.key.java.Position;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.java.StatementBlock;
import de.uka.ilkd.key.java.StatementContainer;
import de.uka.ilkd.key.java.declaration.LocalVariableDeclaration;
import de.uka.ilkd.key.java.statement.MethodBodyStatement;
import de.uka.ilkd.key.java.statement.MethodFrame;
import de.uka.ilkd.key.logic.JavaBlock;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.TermBuilder;
import de.uka.ilkd.key.logic.op.IProgramMethod;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.NodeInfo;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.rule.ContractRuleApp;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.speclang.Contract;
import de.uka.ilkd.key.speclang.FunctionalOperationContract;
import de.uka.ilkd.key.speclang.translation.SLTranslationException;
import de.uka.ilkd.key.symbolic_execution.strategy.breakpoint.AbstractConditionalBreakpoint;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import org.key_project.util.java.ObjectUtil;

public class MethodBreakpoint
extends AbstractConditionalBreakpoint {
    private boolean isEntry;
    private boolean isExit;
    protected int methodStart;
    protected int methodEnd;
    private String classPath;

    public MethodBreakpoint(String classPath, int lineNumber, int hitCount, IProgramMethod pm, Proof proof, String condition, boolean enabled, boolean conditionEnabled, int methodStart, int methodEnd, boolean isEntry, boolean isExit) throws SLTranslationException {
        super(hitCount, pm, proof, enabled, conditionEnabled, methodStart, methodEnd, pm.getContainerType());
        this.isEntry = isEntry;
        this.isExit = isExit;
        this.setClassPath(classPath);
        this.methodEnd = methodEnd;
        this.methodStart = methodStart;
        this.setCondition(condition);
    }

    @Override
    public boolean isBreakpointHit(SourceElement activeStatement, RuleApp ruleApp, Proof proof, Node node) {
        return !proof.isDisposed() && (this.isEntry && this.isMethodCallNode(node, ruleApp) || this.isExit && this.isMethodReturnNode(node, ruleApp)) && (!this.isConditionEnabled() || this.conditionMet(ruleApp, proof, node)) && this.isEnabled() && this.hitcountExceeded(node);
    }

    private boolean isMethodCallNode(Node node, RuleApp ruleApp) {
        FunctionalOperationContract methodContract;
        ContractRuleApp methodRuleApp;
        Contract contract;
        SourceElement statement = NodeInfo.computeActiveStatement((RuleApp)ruleApp);
        Object currentPm = null;
        if (statement instanceof MethodBodyStatement) {
            MethodBodyStatement mbs = (MethodBodyStatement)statement;
            currentPm = mbs.getProgramMethod(this.getProof().getServices());
        }
        if (currentPm != null && currentPm.equals(this.getPm()) && SymbolicExecutionUtil.isMethodCallNode(node, ruleApp, statement)) {
            return true;
        }
        return ruleApp instanceof ContractRuleApp && (contract = (methodRuleApp = (ContractRuleApp)ruleApp).getInstantiation()) instanceof FunctionalOperationContract && (methodContract = (FunctionalOperationContract)contract).getTarget().equals(this.getPm());
    }

    private boolean isMethodReturnNode(Node node, RuleApp ruleApp) {
        FunctionalOperationContract methodContract;
        ContractRuleApp methodRuleApp;
        Contract contract;
        if ((SymbolicExecutionUtil.isMethodReturnNode(node, ruleApp) || SymbolicExecutionUtil.isExceptionalMethodReturnNode(node, ruleApp)) && this.isCorrectMethodReturn(node, ruleApp)) {
            return true;
        }
        return ruleApp instanceof ContractRuleApp && (contract = (methodRuleApp = (ContractRuleApp)ruleApp).getInstantiation()) instanceof FunctionalOperationContract && (methodContract = (FunctionalOperationContract)contract).getTarget().equals(this.getPm());
    }

    private boolean isCorrectMethodReturn(Node node, RuleApp ruleApp) {
        Term term = ruleApp.posInOccurrence().subTerm();
        term = TermBuilder.goBelowUpdates((Term)term);
        MethodFrame mf = JavaTools.getInnermostMethodFrame((JavaBlock)term.javaBlock(), (Services)node.proof().getServices());
        return ObjectUtil.equals((Object)this.getPm(), (Object)mf.getProgramMethod());
    }

    @Override
    protected StatementBlock getStatementBlock(StatementContainer statementContainer) {
        return (StatementBlock)statementContainer;
    }

    public boolean isEntry() {
        return this.isEntry;
    }

    public void setEntry(boolean isEntry) {
        this.isEntry = isEntry;
    }

    public boolean isExit() {
        return this.isExit;
    }

    public void setExit(boolean isExit) {
        this.isExit = isExit;
    }

    @Override
    protected boolean isInScope(Node node) {
        for (Node checkNode = node; checkNode != null; checkNode = checkNode.parent()) {
            SourceElement activeStatement = NodeInfo.computeActiveStatement((RuleApp)checkNode.getAppliedRuleApp());
            if (activeStatement == null || activeStatement.getStartPosition() == Position.UNDEFINED) continue;
            if (activeStatement.getStartPosition().getLine() < this.methodStart || activeStatement.getEndPosition().getLine() > this.methodEnd) break;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isInScopeForCondition(Node node) {
        for (Node checkNode = node; checkNode != null; checkNode = checkNode.parent()) {
            SourceElement activeStatement = NodeInfo.computeActiveStatement((RuleApp)checkNode.getAppliedRuleApp());
            if (activeStatement == null || activeStatement.getStartPosition() == Position.UNDEFINED) continue;
            if (activeStatement.getStartPosition().getLine() < this.methodStart || activeStatement.getEndPosition().getLine() > this.methodEnd || !(activeStatement instanceof LocalVariableDeclaration)) break;
            return true;
        }
        return false;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }
}

