/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.util;

import de.uka.ilkd.key.control.DefaultUserInterfaceControl;
import de.uka.ilkd.key.control.KeYEnvironment;
import de.uka.ilkd.key.control.UserInterfaceControl;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.symbolic_execution.util.event.ISideProofStoreListener;
import de.uka.ilkd.key.symbolic_execution.util.event.SideProofStoreEvent;
import de.uka.ilkd.key.util.ProofUserManager;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.key_project.util.java.CollectionUtil;
import org.key_project.util.java.IFilter;

public final class SideProofStore {
    public static final String PROP_ENABLED = "enabled";
    public static final SideProofStore DEFAULT_INSTANCE = new SideProofStore();
    private final List<Entry> entries = new LinkedList<Entry>();
    private final List<ISideProofStoreListener> listener = new LinkedList<ISideProofStoreListener>();
    private boolean enabled = false;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    private SideProofStore() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldValue = this.isEnabled();
        this.enabled = enabled;
        this.pcs.firePropertyChange(PROP_ENABLED, oldValue, this.isEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProof(String description, Proof proof) {
        List<Entry> list = this.entries;
        synchronized (list) {
            if (!this.containsEntry(proof)) {
                Entry entry = new Entry(description, proof);
                ProofUserManager.getInstance().addUser(entry.getProof(), entry.getEnvironment(), (Object)this);
                this.entries.add(entry);
                this.fireEntriesAdded(new SideProofStoreEvent(this, new Entry[]{entry}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntries(Collection<Entry> entries) {
        Collection<Entry> collection = entries;
        synchronized (collection) {
            if (this.entries.removeAll(entries)) {
                for (Entry entry : entries) {
                    ProofUserManager.getInstance().removeUserAndDispose(entry.getProof(), (Object)this);
                }
                this.fireEntriesRemoved(new SideProofStoreEvent(this, entries.toArray(new Entry[entries.size()])));
            }
        }
    }

    public void clearProofs() {
        this.removeEntries(new LinkedList<Entry>(this.entries));
    }

    public boolean containsEntry(Proof proof) {
        return this.getEntry(proof) != null;
    }

    public Entry getEntry(final Proof proof) {
        return (Entry)CollectionUtil.search(this.entries, (IFilter)new IFilter<Entry>(){

            public boolean select(Entry element) {
                return element != null && element.getProof() == proof;
            }
        });
    }

    public boolean containsEntry(Entry entry) {
        return this.entries.contains(entry);
    }

    public int countEntries() {
        return this.entries.size();
    }

    public Entry getEntryAt(int index) {
        return index >= 0 && index < this.entries.size() ? this.entries.get(index) : null;
    }

    public Entry[] getEntries() {
        return this.entries.toArray(new Entry[this.entries.size()]);
    }

    public void addProofStoreListener(ISideProofStoreListener l) {
        if (l != null) {
            this.listener.add(l);
        }
    }

    public void removeProofStoreListener(ISideProofStoreListener l) {
        if (l != null) {
            this.listener.remove(l);
        }
    }

    public ISideProofStoreListener[] getProofStoreListener() {
        return this.listener.toArray(new ISideProofStoreListener[this.listener.size()]);
    }

    protected void fireEntriesAdded(SideProofStoreEvent e) {
        ISideProofStoreListener[] listener;
        for (ISideProofStoreListener l : listener = this.getProofStoreListener()) {
            l.entriesAdded(e);
        }
    }

    protected void fireEntriesRemoved(SideProofStoreEvent e) {
        ISideProofStoreListener[] listener;
        for (ISideProofStoreListener l : listener = this.getProofStoreListener()) {
            l.entriesRemoved(e);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public static class Entry {
        private final String description;
        private final Proof proof;
        private final KeYEnvironment<DefaultUserInterfaceControl> environment;

        public Entry(String description, Proof proof) {
            this.description = description;
            this.proof = proof;
            DefaultUserInterfaceControl ui = new DefaultUserInterfaceControl();
            this.environment = new KeYEnvironment((UserInterfaceControl)ui, proof.getInitConfig(), proof, null, null);
        }

        public String getDescription() {
            return this.description;
        }

        public Proof getProof() {
            return this.proof;
        }

        public KeYEnvironment<DefaultUserInterfaceControl> getEnvironment() {
            return this.environment;
        }

        public String toString() {
            return this.description;
        }
    }
}

