/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.util;

import de.uka.ilkd.key.control.KeYEnvironment;
import de.uka.ilkd.key.control.UserInterfaceControl;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.prover.GoalChooser;
import de.uka.ilkd.key.prover.StopCondition;
import de.uka.ilkd.key.settings.ProofSettings;
import de.uka.ilkd.key.strategy.StrategyProperties;
import de.uka.ilkd.key.symbolic_execution.SymbolicExecutionTreeBuilder;
import de.uka.ilkd.key.symbolic_execution.strategy.ExecutedSymbolicExecutionTreeNodesStopCondition;
import de.uka.ilkd.key.symbolic_execution.strategy.SymbolicExecutionGoalChooser;
import de.uka.ilkd.key.symbolic_execution.strategy.SymbolicExecutionStrategy;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;

public class SymbolicExecutionEnvironment<U extends UserInterfaceControl>
extends KeYEnvironment<U> {
    private SymbolicExecutionTreeBuilder builder;

    public SymbolicExecutionEnvironment(KeYEnvironment<U> environment, SymbolicExecutionTreeBuilder builder) {
        this(environment.getUi(), environment.getInitConfig(), builder);
    }

    public SymbolicExecutionEnvironment(U ui, InitConfig initConfig, SymbolicExecutionTreeBuilder builder) {
        super(ui, initConfig);
        this.builder = builder;
    }

    public SymbolicExecutionTreeBuilder getBuilder() {
        return this.builder;
    }

    public Proof getProof() {
        return this.getBuilder().getProof();
    }

    public static void configureProofForSymbolicExecution(Proof proof, int maximalNumberOfNodesPerBranch) {
        StrategyProperties sp = ProofSettings.DEFAULT_SETTINGS.getStrategySettings().getActiveStrategyProperties();
        boolean methodTreatmentContract = "METHOD_CONTRACT".equals(sp.get((Object)"METHOD_OPTIONS_KEY"));
        boolean loopTreatmentInvariant = "LOOP_INVARIANT".equals(sp.get((Object)"LOOP_OPTIONS_KEY"));
        boolean blockTreatmentContract = "BLOCK_CONTRACT_INTERNAL".equals(sp.get((Object)"BLOCK_OPTIONS_KEY"));
        boolean aliasChecks = "SYMBOLIC_EXECUTION_ALIAS_CHECK_IMMEDIATELY".equals(sp.get((Object)"SYMBOLIC_EXECUTION_ALIAS_CHECK_OPTIONS_KEY"));
        boolean nonExecutionBranchHidingSideProofs = "SYMBOLIC_EXECUTION_NON_EXECUTION_BRANCH_HIDING_SIDE_PROOF".equals(sp.get((Object)"SYMBOLIC_EXECUTION_NON_EXECUTION_BRANCH_HIDING_OPTIONS_KEY"));
        SymbolicExecutionEnvironment.configureProofForSymbolicExecution(proof, maximalNumberOfNodesPerBranch, methodTreatmentContract, loopTreatmentInvariant, blockTreatmentContract, nonExecutionBranchHidingSideProofs, aliasChecks);
    }

    public static void configureProofForSymbolicExecution(Proof proof, int maximalNumberOfNodesPerBranch, boolean methodTreatmentContract, boolean loopTreatmentInvariant, boolean blockTreatmentContract, boolean nonExecutionBranchHidingSideProofs, boolean aliasChecks) {
        if (proof != null) {
            StrategyProperties strategyProperties = SymbolicExecutionStrategy.getSymbolicExecutionStrategyProperties(true, methodTreatmentContract, loopTreatmentInvariant, blockTreatmentContract, nonExecutionBranchHidingSideProofs, aliasChecks);
            proof.setActiveStrategy(proof.getActiveStrategyFactory().create(proof, strategyProperties));
            proof.getSettings().getStrategySettings().setCustomApplyStrategyGoalChooser((GoalChooser)new SymbolicExecutionGoalChooser());
            proof.getSettings().getStrategySettings().setCustomApplyStrategyStopCondition((StopCondition)new ExecutedSymbolicExecutionTreeNodesStopCondition(maximalNumberOfNodesPerBranch));
            SymbolicExecutionUtil.updateStrategySettings(proof, strategyProperties);
        }
    }

    public void dispose() {
        Proof proof = this.getProof();
        if (this.builder != null) {
            this.builder.dispose();
        }
        if (proof != null && !proof.isDisposed() && proof != this.getLoadedProof()) {
            proof.dispose();
        }
        super.dispose();
    }
}

