/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.util;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.abstraction.KeYJavaType;
import de.uka.ilkd.key.ldt.HeapLDT;
import de.uka.ilkd.key.logic.Choice;
import de.uka.ilkd.key.logic.DefaultVisitor;
import de.uka.ilkd.key.logic.Named;
import de.uka.ilkd.key.logic.Namespace;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.TermBuilder;
import de.uka.ilkd.key.logic.Visitor;
import de.uka.ilkd.key.logic.label.TermLabel;
import de.uka.ilkd.key.logic.label.TermLabelManager;
import de.uka.ilkd.key.logic.op.Function;
import de.uka.ilkd.key.logic.op.IProgramMethod;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.Modality;
import de.uka.ilkd.key.logic.op.Operator;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.proof.init.JavaProfile;
import de.uka.ilkd.key.proof.init.Profile;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.proof.mgt.AxiomJustification;
import de.uka.ilkd.key.proof.mgt.ProofEnvironment;
import de.uka.ilkd.key.proof.mgt.RuleJustification;
import de.uka.ilkd.key.proof.mgt.RuleJustificationInfo;
import de.uka.ilkd.key.prover.impl.ApplyStrategyInfo;
import de.uka.ilkd.key.rule.BuiltInRule;
import de.uka.ilkd.key.rule.OneStepSimplifier;
import de.uka.ilkd.key.rule.Rule;
import de.uka.ilkd.key.rule.Taclet;
import de.uka.ilkd.key.settings.ProofSettings;
import de.uka.ilkd.key.strategy.StrategyProperties;
import de.uka.ilkd.key.symbolic_execution.profile.SimplifyTermProfile;
import de.uka.ilkd.key.symbolic_execution.profile.SymbolicExecutionJavaProfile;
import de.uka.ilkd.key.symbolic_execution.util.SideProofStore;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import de.uka.ilkd.key.util.Pair;
import de.uka.ilkd.key.util.ProofStarter;
import de.uka.ilkd.key.util.SideProofUtil;
import de.uka.ilkd.key.util.Triple;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.key_project.util.collection.ImmutableArray;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSet;
import org.key_project.util.java.CollectionUtil;
import org.key_project.util.java.IFilter;
import org.key_project.util.java.ObjectUtil;

public final class SymbolicExecutionSideProofUtil {
    private SymbolicExecutionSideProofUtil() {
    }

    public static Sequent computeGeneralSequentToProve(Sequent goalSequent, SequentFormula currentSF) {
        Sequent sequentToProve = Sequent.EMPTY_SEQUENT;
        for (SequentFormula sf : goalSequent.antecedent()) {
            if (sf == currentSF || SymbolicExecutionSideProofUtil.containsModalityOrQuery(sf)) continue;
            sequentToProve = sequentToProve.addFormula(sf, true, false).sequent();
        }
        for (SequentFormula sf : goalSequent.succedent()) {
            if (sf == currentSF || SymbolicExecutionSideProofUtil.containsModalityOrQuery(sf)) continue;
            sequentToProve = sequentToProve.addFormula(sf, false, false).sequent();
        }
        return sequentToProve;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Term, Node>> computeResults(Services services, Proof proof, ProofEnvironment sideProofEnvironment, Sequent sequentToProve, TermLabel label, String description, String methodTreatment, String loopTreatment, String queryTreatment, String splittingOption, boolean addNamesToServices) throws ProofInputException {
        ApplyStrategyInfo info = SymbolicExecutionSideProofUtil.startSideProof(proof, sideProofEnvironment, sequentToProve, methodTreatment, loopTreatment, queryTreatment, splittingOption);
        try {
            LinkedList<Pair> conditionsAndResultsMap = new LinkedList<Pair>();
            for (Goal resultGoal : info.getProof().openGoals()) {
                Term result;
                if (SymbolicExecutionUtil.hasApplicableRules(resultGoal)) {
                    throw new IllegalStateException("Not all applicable rules are applied.");
                }
                Sequent sequent = resultGoal.sequent();
                LinkedList<Term> results = new LinkedList<Term>();
                for (SequentFormula sf : sequent.antecedent()) {
                    if (!sf.formula().containsLabel(label)) continue;
                    result = sf.formula();
                    result = services.getTermBuilder().not(result);
                    results.add(result);
                }
                for (SequentFormula sf : sequent.succedent()) {
                    if (!sf.formula().containsLabel(label)) continue;
                    result = sf.formula();
                    results.add(result);
                }
                Term result2 = results.isEmpty() ? services.getTermBuilder().tt() : services.getTermBuilder().or(results);
                conditionsAndResultsMap.add(new Pair((Object)result2, (Object)resultGoal.node()));
            }
            LinkedList<Pair> linkedList = conditionsAndResultsMap;
            return linkedList;
        }
        finally {
            SymbolicExecutionSideProofUtil.disposeOrStore(description, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Triple<Term, Set<Term>, Node>> computeResultsAndConditions(Services services, Proof proof, ProofEnvironment sideProofEnvironment, Sequent sequentToProve, Operator operator, String description, String methodTreatment, String loopTreatment, String queryTreatment, String splittingOption, boolean addNamesToServices) throws ProofInputException {
        ApplyStrategyInfo info = SymbolicExecutionSideProofUtil.startSideProof(proof, sideProofEnvironment, sequentToProve, methodTreatment, loopTreatment, queryTreatment, splittingOption);
        try {
            Set<Operator> relevantThingsInSequentToProve = SymbolicExecutionSideProofUtil.extractRelevantThings(info.getProof().getServices(), sequentToProve);
            LinkedList<Triple> conditionsAndResultsMap = new LinkedList<Triple>();
            for (Goal resultGoal : info.getProof().openGoals()) {
                Term constructedResult;
                if (SymbolicExecutionUtil.hasApplicableRules(resultGoal)) {
                    throw new IllegalStateException("Not all applicable rules are applied.");
                }
                Sequent sequent = resultGoal.sequent();
                boolean newPredicateIsSequentFormula = SymbolicExecutionSideProofUtil.isOperatorASequentFormula(sequent, operator);
                LinkedHashSet<Term> resultConditions = new LinkedHashSet<Term>();
                Term result = null;
                for (SequentFormula sf : sequent.antecedent()) {
                    if (newPredicateIsSequentFormula) {
                        if (sf.formula().op() == operator) {
                            throw new IllegalStateException("Result predicate found in antecedent.");
                        }
                        constructedResult = SymbolicExecutionSideProofUtil.constructResultIfContained(services, sf, operator);
                        if (constructedResult != null) {
                            throw new IllegalStateException("Result predicate found in antecedent.");
                        }
                    }
                    if (SymbolicExecutionSideProofUtil.isIrrelevantCondition(services, sequentToProve, relevantThingsInSequentToProve, sf) || !resultConditions.add(sf.formula()) || !addNamesToServices) continue;
                    SymbolicExecutionSideProofUtil.addNewNamesToNamespace(services, sf.formula());
                }
                for (SequentFormula sf : sequent.succedent()) {
                    if (newPredicateIsSequentFormula) {
                        if (sf.formula().op() == operator) {
                            if (result != null) {
                                throw new IllegalStateException("Result predicate found multiple times in succedent.");
                            }
                            result = sf.formula().sub(0);
                        }
                    } else {
                        constructedResult = SymbolicExecutionSideProofUtil.constructResultIfContained(services, sf, operator);
                        if (constructedResult != null) {
                            if (result != null) {
                                throw new IllegalStateException("Result predicate found multiple times in succedent.");
                            }
                            result = constructedResult;
                        }
                    }
                    if (result != null || SymbolicExecutionSideProofUtil.isIrrelevantCondition(services, sequentToProve, relevantThingsInSequentToProve, sf) || !resultConditions.add(services.getTermBuilder().not(sf.formula())) || !addNamesToServices) continue;
                    SymbolicExecutionSideProofUtil.addNewNamesToNamespace(services, sf.formula());
                }
                if (result == null) {
                    result = services.getTermBuilder().ff();
                }
                conditionsAndResultsMap.add(new Triple((Object)result, resultConditions, (Object)resultGoal.node()));
            }
            LinkedList<Triple> linkedList = conditionsAndResultsMap;
            return linkedList;
        }
        finally {
            SymbolicExecutionSideProofUtil.disposeOrStore(description, info);
        }
    }

    private static Term constructResultIfContained(Services services, SequentFormula sf, Operator operator) {
        return SymbolicExecutionSideProofUtil.constructResultIfContained(services, sf.formula(), operator);
    }

    private static Term constructResultIfContained(Services services, Term term, Operator operator) {
        int i;
        if (term.op() == operator) {
            return term.sub(0);
        }
        Term result = null;
        for (i = 0; result == null && i < term.arity(); ++i) {
            result = SymbolicExecutionSideProofUtil.constructResultIfContained(services, term.sub(i), operator);
        }
        if (result != null) {
            LinkedList<Term> newSubs = new LinkedList<Term>();
            for (int j = 0; j < term.arity(); ++j) {
                if (j == i - 1) {
                    newSubs.add(result);
                    continue;
                }
                newSubs.add(term.sub(j));
            }
            result = services.getTermFactory().createTerm(term.op(), new ImmutableArray(newSubs), term.boundVars(), term.javaBlock(), term.getLabels());
        }
        return result;
    }

    private static boolean isOperatorASequentFormula(Sequent sequent, final Operator operator) {
        return CollectionUtil.search((Iterable)sequent, (IFilter)new IFilter<SequentFormula>(){

            public boolean select(SequentFormula element) {
                return element.formula().op() == operator;
            }
        }) != null;
    }

    public static void addNewNamesToNamespace(Services services, Term term) {
        final Namespace functions = services.getNamespaces().functions();
        final Namespace progVars = services.getNamespaces().programVariables();
        term.execPreOrder((Visitor)new DefaultVisitor(){

            public void visit(Term visited) {
                if (visited.op() instanceof Function) {
                    functions.add((Named)((Function)visited.op()));
                } else if (visited.op() instanceof IProgramVariable) {
                    progVars.add((Named)((IProgramVariable)visited.op()));
                }
            }
        });
    }

    public static boolean containsModalityOrQuery(SequentFormula sf) {
        return SymbolicExecutionSideProofUtil.containsModalityOrQuery(sf.formula());
    }

    public static boolean containsModalityOrQuery(Term term) {
        ContainsModalityOrQueryVisitor visitor = new ContainsModalityOrQueryVisitor();
        term.execPostOrder((Visitor)visitor);
        return visitor.isContainsModalityOrQuery();
    }

    public static Set<Operator> extractRelevantThings(final Services services, Sequent sequentToProve) {
        final HashSet<Operator> result = new HashSet<Operator>();
        for (SequentFormula sf : sequentToProve) {
            sf.formula().execPreOrder((Visitor)new DefaultVisitor(){

                public void visit(Term visited) {
                    if (SymbolicExecutionSideProofUtil.isRelevantThing(services, visited)) {
                        result.add(visited.op());
                    }
                }
            });
        }
        return result;
    }

    protected static boolean isRelevantThing(Services services, Term term) {
        if (term.op() instanceof IProgramVariable) {
            return true;
        }
        if (term.op() instanceof Function) {
            HeapLDT heapLDT = services.getTypeConverter().getHeapLDT();
            if (SymbolicExecutionUtil.isHeap(term.op(), heapLDT)) {
                return true;
            }
            KeYJavaType kjt = services.getJavaInfo().getKeYJavaType(term.sort());
            return kjt != null;
        }
        return false;
    }

    public static boolean isIrrelevantCondition(Services services, Sequent initialSequent, Set<Operator> relevantThingsInSequentToProve, SequentFormula sf) {
        return initialSequent.antecedent().contains(sf) || initialSequent.succedent().contains(sf) || SymbolicExecutionSideProofUtil.containsModalityOrQuery(sf) || SymbolicExecutionSideProofUtil.containsIrrelevantThings(services, sf, relevantThingsInSequentToProve);
    }

    public static boolean containsIrrelevantThings(Services services, SequentFormula sf, Set<Operator> relevantThings) {
        ContainsIrrelevantThingsVisitor visitor = new ContainsIrrelevantThingsVisitor(services, relevantThings);
        sf.formula().execPostOrder((Visitor)visitor);
        return visitor.isContainsIrrelevantThings();
    }

    public static ApplyStrategyInfo startSideProof(Proof proof, ProofEnvironment sideProofEnvironment, Sequent sequentToProve) throws ProofInputException {
        return SymbolicExecutionSideProofUtil.startSideProof(proof, sideProofEnvironment, sequentToProve, "METHOD_NONE", "LOOP_NONE", "QUERY_OFF", "SPLITTING_OFF");
    }

    public static ApplyStrategyInfo startSideProof(Proof proof, ProofEnvironment sideProofEnvironment, Sequent sequentToProve, String methodTreatment, String loopTreatment, String queryTreatment, String splittingOption) throws ProofInputException {
        ProofStarter starter = SymbolicExecutionSideProofUtil.createSideProof(sideProofEnvironment, sequentToProve, null);
        return SymbolicExecutionSideProofUtil.startSideProof(proof, starter, methodTreatment, loopTreatment, queryTreatment, splittingOption);
    }

    public static ProofStarter createSideProof(ProofEnvironment sideProofEnvironment, Sequent sequentToProve, String proofName) throws ProofInputException {
        return SideProofUtil.createSideProof((ProofEnvironment)sideProofEnvironment, (Sequent)sequentToProve, (String)proofName);
    }

    public static ApplyStrategyInfo startSideProof(Proof proof, ProofStarter starter, String methodTreatment, String loopTreatment, String queryTreatment, String splittingOption) {
        assert (starter != null);
        starter.setMaxRuleApplications(10000);
        StrategyProperties sp = proof != null && !proof.isDisposed() ? proof.getSettings().getStrategySettings().getActiveStrategyProperties() : new StrategyProperties();
        StrategyProperties.setDefaultStrategyProperties((StrategyProperties)sp, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (boolean)false, (boolean)false);
        sp.setProperty("METHOD_OPTIONS_KEY", methodTreatment);
        sp.setProperty("LOOP_OPTIONS_KEY", loopTreatment);
        sp.setProperty("QUERY_NEW_OPTIONS_KEY", queryTreatment);
        sp.setProperty("SPLITTING_OPTIONS_KEY", splittingOption);
        sp.setProperty("QUANTIFIERS_OPTIONS_KEY", "QUANTIFIERS_NON_SPLITTING");
        starter.setStrategyProperties(sp);
        return starter.start();
    }

    public static Term extractOperatorValue(Goal goal, Operator operator) {
        assert (goal != null);
        return SymbolicExecutionSideProofUtil.extractOperatorValue(goal.node(), operator);
    }

    public static Term extractOperatorValue(Node node, Operator operator) {
        Term operatorTerm = SymbolicExecutionSideProofUtil.extractOperatorTerm(node, operator);
        return operatorTerm != null ? operatorTerm.sub(0) : null;
    }

    public static Term extractOperatorTerm(ApplyStrategyInfo info, Operator operator) throws ProofInputException {
        assert (info != null);
        if (info.getProof().openGoals().size() != 1) {
            throw new ProofInputException("Assumption that return value extraction has one goal does not hold because " + info.getProof().openGoals().size() + " goals are available.");
        }
        return SymbolicExecutionSideProofUtil.extractOperatorTerm((Goal)info.getProof().openGoals().head(), operator);
    }

    public static Term extractOperatorTerm(Goal goal, Operator operator) {
        assert (goal != null);
        return SymbolicExecutionSideProofUtil.extractOperatorTerm(goal.node(), operator);
    }

    public static Term extractOperatorTerm(Node node, final Operator operator) {
        assert (node != null);
        SequentFormula sf = (SequentFormula)CollectionUtil.search((Iterable)node.sequent(), (IFilter)new IFilter<SequentFormula>(){

            public boolean select(SequentFormula element) {
                Term term = element.formula();
                term = TermBuilder.goBelowUpdates((Term)term);
                return ObjectUtil.equals((Object)term.op(), (Object)operator);
            }
        });
        if (sf != null) {
            Term term = sf.formula();
            term = TermBuilder.goBelowUpdates((Term)term);
            return term;
        }
        return null;
    }

    public static ProofEnvironment cloneProofEnvironmentWithOwnOneStepSimplifier(Proof source, boolean useSimplifyTermProfile) {
        assert (source != null);
        assert (!source.isDisposed());
        return SymbolicExecutionSideProofUtil.cloneProofEnvironmentWithOwnOneStepSimplifier(source.getInitConfig(), useSimplifyTermProfile);
    }

    public static ProofEnvironment cloneProofEnvironmentWithOwnOneStepSimplifier(final InitConfig sourceInitConfig, boolean useSimplifyTermProfile) {
        RuleJustificationInfo sourceJustiInfo = sourceInitConfig.getJustifInfo();
        JavaProfile profile = useSimplifyTermProfile ? new SimplifyTermProfile(){

            @Override
            protected ImmutableList<TermLabelManager.TermLabelConfiguration> computeTermLabelConfiguration() {
                Profile sourceProfile = sourceInitConfig.getProfile();
                if (sourceProfile instanceof SymbolicExecutionJavaProfile) {
                    ImmutableList result = super.computeTermLabelConfiguration();
                    result = result.prepend(SymbolicExecutionJavaProfile.getSymbolicExecutionTermLabelConfigurations(SymbolicExecutionJavaProfile.isTruthValueEvaluationEnabled(sourceInitConfig)));
                    return result;
                }
                return super.computeTermLabelConfiguration();
            }
        } : new JavaProfile(){

            protected ImmutableList<TermLabelManager.TermLabelConfiguration> computeTermLabelConfiguration() {
                Profile sourceProfile = sourceInitConfig.getProfile();
                if (sourceProfile instanceof SymbolicExecutionJavaProfile) {
                    ImmutableList result = super.computeTermLabelConfiguration();
                    result = result.prepend(SymbolicExecutionJavaProfile.getSymbolicExecutionTermLabelConfigurations(SymbolicExecutionJavaProfile.isTruthValueEvaluationEnabled(sourceInitConfig)));
                    return result;
                }
                return super.computeTermLabelConfiguration();
            }
        };
        InitConfig initConfig = new InitConfig(sourceInitConfig.getServices().copy((Profile)profile, false));
        Choice runtimeExceptionTreatment = new Choice("ban", "runtimeExceptions");
        ImmutableSet choices = SideProofUtil.activateChoice((ImmutableSet)sourceInitConfig.getActivatedChoices(), (Choice)runtimeExceptionTreatment);
        initConfig.setActivatedChoices(choices);
        ProofSettings clonedSettings = sourceInitConfig.getSettings() != null ? new ProofSettings(sourceInitConfig.getSettings()) : null;
        initConfig.setSettings(clonedSettings);
        initConfig.setTaclet2Builder((HashMap)sourceInitConfig.getTaclet2Builder().clone());
        initConfig.setTaclets(sourceInitConfig.getTaclets());
        ProofEnvironment env = new ProofEnvironment(initConfig);
        for (Taclet taclet : initConfig.activatedTaclets()) {
            initConfig.getJustifInfo().addJustification((Rule)taclet, sourceJustiInfo.getJustification((Rule)taclet));
        }
        for (BuiltInRule rule : initConfig.builtInRules()) {
            RuleJustification origJusti = sourceJustiInfo.getJustification((Rule)rule);
            if (origJusti == null) {
                assert (rule instanceof OneStepSimplifier);
                origJusti = AxiomJustification.INSTANCE;
            }
            initConfig.getJustifInfo().addJustification((Rule)rule, origJusti);
        }
        return env;
    }

    public static void disposeOrStore(String description, ApplyStrategyInfo info) {
        if (info != null) {
            if (SideProofStore.DEFAULT_INSTANCE.isEnabled()) {
                SideProofStore.DEFAULT_INSTANCE.addProof(description, info.getProof());
            } else {
                info.getProof().dispose();
            }
        }
    }

    protected static class ContainsIrrelevantThingsVisitor
    extends DefaultVisitor {
        private Services services;
        private Set<Operator> relevantThings;
        boolean containsIrrelevantThings = false;

        public ContainsIrrelevantThingsVisitor(Services services, Set<Operator> relevantThings) {
            this.services = services;
            this.relevantThings = relevantThings;
        }

        public void visit(Term visited) {
            if (!(!SymbolicExecutionSideProofUtil.isRelevantThing(this.services, visited) || SymbolicExecutionUtil.isSelect(this.services, visited) || SymbolicExecutionUtil.isBoolean(this.services, visited.op()) || SymbolicExecutionUtil.isNumber(visited.op()) || this.relevantThings.contains(visited.op()))) {
                this.containsIrrelevantThings = true;
            }
        }

        public boolean isContainsIrrelevantThings() {
            return this.containsIrrelevantThings;
        }
    }

    protected static class ContainsModalityOrQueryVisitor
    extends DefaultVisitor {
        boolean containsModalityOrQuery = false;

        protected ContainsModalityOrQueryVisitor() {
        }

        public void visit(Term visited) {
            if (visited.op() instanceof Modality) {
                this.containsModalityOrQuery = true;
            } else if (visited.op() instanceof IProgramMethod) {
                this.containsModalityOrQuery = true;
            }
        }

        public boolean isContainsModalityOrQuery() {
            return this.containsModalityOrQuery;
        }
    }
}

