/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.util;

import de.uka.ilkd.key.java.Expression;
import de.uka.ilkd.key.java.JavaProgramElement;
import de.uka.ilkd.key.java.JavaTools;
import de.uka.ilkd.key.java.Position;
import de.uka.ilkd.key.java.PositionInfo;
import de.uka.ilkd.key.java.ProgramElement;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.java.Statement;
import de.uka.ilkd.key.java.StatementBlock;
import de.uka.ilkd.key.java.TypeConverter;
import de.uka.ilkd.key.java.abstraction.KeYJavaType;
import de.uka.ilkd.key.java.abstraction.Type;
import de.uka.ilkd.key.java.declaration.FieldDeclaration;
import de.uka.ilkd.key.java.declaration.FieldSpecification;
import de.uka.ilkd.key.java.declaration.TypeDeclaration;
import de.uka.ilkd.key.java.expression.Assignment;
import de.uka.ilkd.key.java.reference.ExecutionContext;
import de.uka.ilkd.key.java.reference.IExecutionContext;
import de.uka.ilkd.key.java.reference.ReferencePrefix;
import de.uka.ilkd.key.java.reference.TypeReference;
import de.uka.ilkd.key.java.statement.BranchStatement;
import de.uka.ilkd.key.java.statement.Catch;
import de.uka.ilkd.key.java.statement.Do;
import de.uka.ilkd.key.java.statement.EmptyStatement;
import de.uka.ilkd.key.java.statement.EnhancedFor;
import de.uka.ilkd.key.java.statement.For;
import de.uka.ilkd.key.java.statement.LoopStatement;
import de.uka.ilkd.key.java.statement.MethodBodyStatement;
import de.uka.ilkd.key.java.statement.MethodFrame;
import de.uka.ilkd.key.java.statement.Try;
import de.uka.ilkd.key.java.statement.While;
import de.uka.ilkd.key.java.visitor.ContainsStatementVisitor;
import de.uka.ilkd.key.ldt.BooleanLDT;
import de.uka.ilkd.key.ldt.HeapLDT;
import de.uka.ilkd.key.ldt.IntegerLDT;
import de.uka.ilkd.key.logic.DefaultVisitor;
import de.uka.ilkd.key.logic.IntIterator;
import de.uka.ilkd.key.logic.JavaBlock;
import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.logic.Named;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.PosInTerm;
import de.uka.ilkd.key.logic.ProgramElementName;
import de.uka.ilkd.key.logic.ProgramPrefix;
import de.uka.ilkd.key.logic.Semisequent;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.TermBuilder;
import de.uka.ilkd.key.logic.TermFactory;
import de.uka.ilkd.key.logic.TermServices;
import de.uka.ilkd.key.logic.Visitor;
import de.uka.ilkd.key.logic.label.BlockContractValidityTermLabel;
import de.uka.ilkd.key.logic.label.ParameterlessTermLabel;
import de.uka.ilkd.key.logic.label.SymbolicExecutionTermLabel;
import de.uka.ilkd.key.logic.label.TermLabel;
import de.uka.ilkd.key.logic.label.TermLabelState;
import de.uka.ilkd.key.logic.op.ElementaryUpdate;
import de.uka.ilkd.key.logic.op.Equality;
import de.uka.ilkd.key.logic.op.Function;
import de.uka.ilkd.key.logic.op.IProgramMethod;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.Junctor;
import de.uka.ilkd.key.logic.op.LocationVariable;
import de.uka.ilkd.key.logic.op.Modality;
import de.uka.ilkd.key.logic.op.Operator;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.logic.op.SortDependingFunction;
import de.uka.ilkd.key.logic.op.SortedOperator;
import de.uka.ilkd.key.logic.op.UpdateApplication;
import de.uka.ilkd.key.logic.op.UpdateJunctor;
import de.uka.ilkd.key.logic.sort.NullSort;
import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.pp.LogicPrinter;
import de.uka.ilkd.key.pp.NotationInfo;
import de.uka.ilkd.key.pp.ProgramPrinter;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.NodeInfo;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.init.AbstractOperationPO;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.proof.io.ProofSaver;
import de.uka.ilkd.key.proof.mgt.ProofEnvironment;
import de.uka.ilkd.key.prover.impl.ApplyStrategyInfo;
import de.uka.ilkd.key.rule.AbstractAuxiliaryContractBuiltInRuleApp;
import de.uka.ilkd.key.rule.AbstractBlockContractBuiltInRuleApp;
import de.uka.ilkd.key.rule.AbstractContractRuleApp;
import de.uka.ilkd.key.rule.BlockContractExternalBuiltInRuleApp;
import de.uka.ilkd.key.rule.BlockContractInternalBuiltInRuleApp;
import de.uka.ilkd.key.rule.ContractRuleApp;
import de.uka.ilkd.key.rule.LoopInvariantBuiltInRuleApp;
import de.uka.ilkd.key.rule.OneStepSimplifierRuleApp;
import de.uka.ilkd.key.rule.PosTacletApp;
import de.uka.ilkd.key.rule.Rule;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.rule.SyntacticalReplaceVisitor;
import de.uka.ilkd.key.rule.Taclet;
import de.uka.ilkd.key.rule.TacletApp;
import de.uka.ilkd.key.rule.merge.CloseAfterMergeRuleBuiltInRuleApp;
import de.uka.ilkd.key.rule.merge.MergeRuleBuiltInRuleApp;
import de.uka.ilkd.key.rule.tacletbuilder.TacletGoalTemplate;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.ProofSettings;
import de.uka.ilkd.key.speclang.Contract;
import de.uka.ilkd.key.speclang.OperationContract;
import de.uka.ilkd.key.strategy.JavaCardDLStrategyFactory;
import de.uka.ilkd.key.strategy.StrategyProperties;
import de.uka.ilkd.key.symbolic_execution.ExecutionVariableExtractor;
import de.uka.ilkd.key.symbolic_execution.SymbolicExecutionTreeBuilder;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionConstraint;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionElement;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionNode;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionVariable;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionConstraint;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionVariable;
import de.uka.ilkd.key.symbolic_execution.strategy.SymbolicExecutionStrategy;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionSideProofUtil;
import de.uka.ilkd.key.util.KeYTypeUtil;
import de.uka.ilkd.key.util.MiscTools;
import de.uka.ilkd.key.util.Pair;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.key_project.util.collection.ImmutableArray;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;
import org.key_project.util.java.CollectionUtil;
import org.key_project.util.java.IFilter;
import org.key_project.util.java.ObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SymbolicExecutionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SymbolicExecutionUtil.class);
    public static final String CHOICE_SETTING_RUNTIME_EXCEPTIONS = "runtimeExceptions";
    public static final String CHOICE_SETTING_RUNTIME_EXCEPTIONS_VALUE_BAN = "runtimeExceptions:ban";
    public static final String CHOICE_SETTING_RUNTIME_EXCEPTIONS_VALUE_ALLOW = "runtimeExceptions:allow";
    public static final Name RESULT_LABEL_NAME = new Name("RES");
    public static final TermLabel RESULT_LABEL = new ParameterlessTermLabel(RESULT_LABEL_NAME);
    public static final Name LOOP_BODY_LABEL_NAME = new Name("LoopBody");
    public static final TermLabel LOOP_BODY_LABEL = new ParameterlessTermLabel(LOOP_BODY_LABEL_NAME);
    public static final Name LOOP_INVARIANT_NORMAL_BEHAVIOR_LABEL_NAME = new Name("LoopInvariantNormalBehavior");
    public static final TermLabel LOOP_INVARIANT_NORMAL_BEHAVIOR_LABEL = new ParameterlessTermLabel(LOOP_INVARIANT_NORMAL_BEHAVIOR_LABEL_NAME);

    private SymbolicExecutionUtil() {
    }

    public static Term simplify(InitConfig initConfig, Term term) throws ProofInputException {
        return SymbolicExecutionUtil.simplify(initConfig, null, term);
    }

    public static Term simplify(Proof parentProof, Term term) throws ProofInputException {
        assert (!parentProof.isDisposed());
        return SymbolicExecutionUtil.simplify(parentProof.getInitConfig(), parentProof, term);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Term simplify(InitConfig initConfig, Proof parentProof, Term term) throws ProofInputException {
        Services services = initConfig.getServices();
        ProofEnvironment sideProofEnv = SymbolicExecutionSideProofUtil.cloneProofEnvironmentWithOwnOneStepSimplifier(initConfig, true);
        Sequent sequentToProve = Sequent.EMPTY_SEQUENT.addFormula(new SequentFormula(term), false, true).sequent();
        ApplyStrategyInfo info = SymbolicExecutionSideProofUtil.startSideProof(parentProof, sideProofEnv, sequentToProve);
        try {
            ImmutableList openGoals = info.getProof().openEnabledGoals();
            TermBuilder tb = services.getTermBuilder();
            if (openGoals.isEmpty()) {
                Term term2 = tb.tt();
                return term2;
            }
            ImmutableSLList goalImplications = ImmutableSLList.nil();
            for (Goal goal : openGoals) {
                Term goalImplication = SymbolicExecutionUtil.sequentToImplication(goal.sequent(), goal.proof().getServices());
                goalImplication = tb.not(goalImplication);
                goalImplications = goalImplications.append((Object)goalImplication);
            }
            Iterator iterator = tb.not(tb.or((Iterable)goalImplications));
            return iterator;
        }
        finally {
            SymbolicExecutionSideProofUtil.disposeOrStore("Simplification of " + ProofSaver.printAnything((Object)term, (Services)services), info);
        }
    }

    public static Term sequentToImplication(Sequent sequent, Services services) {
        if (sequent != null) {
            ImmutableList<Term> antecedents = SymbolicExecutionUtil.listSemisequentTerms(sequent.antecedent());
            ImmutableList<Term> succedents = SymbolicExecutionUtil.listSemisequentTerms(sequent.succedent());
            Term left = services.getTermBuilder().and(antecedents);
            Term right = services.getTermBuilder().or(succedents);
            return services.getTermBuilder().imp(left, right);
        }
        return services.getTermBuilder().tt();
    }

    public static ImmutableList<Term> listSemisequentTerms(Semisequent semisequent) {
        ImmutableSLList terms = ImmutableSLList.nil();
        if (semisequent != null) {
            for (SequentFormula sf : semisequent) {
                terms = terms.append((Object)sf.formula());
            }
        }
        return terms;
    }

    public static Term improveReadability(Term term, Services services) {
        if (term != null && services != null) {
            IntegerLDT integerLDT = services.getTypeConverter().getIntegerLDT();
            term = SymbolicExecutionUtil.improveReadabilityRecursive(term, services, integerLDT);
        }
        return term;
    }

    private static Term improveReadabilityRecursive(Term term, Services services, IntegerLDT integerLDT) {
        Term subOne;
        boolean subChanged = false;
        LinkedList<Term> newSubs = new LinkedList<Term>();
        for (Term sub : term.subs()) {
            Term newSub = SymbolicExecutionUtil.improveReadabilityRecursive(sub, services, integerLDT);
            if (newSub != sub) {
                newSubs.add(newSub);
                subChanged = true;
                continue;
            }
            newSubs.add(sub);
        }
        if (subChanged) {
            term = services.getTermFactory().createTerm(term.op(), new ImmutableArray(newSubs), term.boundVars(), term.javaBlock(), term.getLabels());
        }
        TermBuilder tb = services.getTermBuilder();
        if (term.op() == integerLDT.getLessThan()) {
            subOne = term.sub(1);
            if (subOne.op() == integerLDT.getAdd()) {
                if (SymbolicExecutionUtil.isOne(subOne.sub(0), integerLDT)) {
                    term = tb.leq(term.sub(0), subOne.sub(1));
                } else if (SymbolicExecutionUtil.isOne(subOne.sub(1), integerLDT)) {
                    term = tb.leq(term.sub(0), subOne.sub(0));
                }
            }
        } else if (term.op() == integerLDT.getGreaterOrEquals()) {
            subOne = term.sub(1);
            if (subOne.op() == integerLDT.getAdd()) {
                if (SymbolicExecutionUtil.isOne(subOne.sub(0), integerLDT)) {
                    term = tb.gt(term.sub(0), subOne.sub(1));
                } else if (SymbolicExecutionUtil.isOne(subOne.sub(1), integerLDT)) {
                    term = tb.gt(term.sub(0), subOne.sub(0));
                }
            }
        } else if (term.op() == integerLDT.getLessOrEquals()) {
            subOne = term.sub(1);
            if (subOne.op() == integerLDT.getAdd()) {
                if (SymbolicExecutionUtil.isMinusOne(subOne.sub(0), integerLDT)) {
                    term = tb.lt(term.sub(0), subOne.sub(1));
                } else if (SymbolicExecutionUtil.isMinusOne(subOne.sub(1), integerLDT)) {
                    term = tb.lt(term.sub(0), subOne.sub(0));
                }
            } else if (subOne.op() == integerLDT.getSub() && SymbolicExecutionUtil.isOne(subOne.sub(1), integerLDT)) {
                term = tb.lt(term.sub(0), subOne.sub(0));
            }
        } else if (term.op() == integerLDT.getGreaterThan()) {
            subOne = term.sub(1);
            if (subOne.op() == integerLDT.getAdd()) {
                if (SymbolicExecutionUtil.isMinusOne(subOne.sub(0), integerLDT)) {
                    term = tb.geq(term.sub(0), subOne.sub(1));
                } else if (SymbolicExecutionUtil.isMinusOne(subOne.sub(1), integerLDT)) {
                    term = tb.geq(term.sub(0), subOne.sub(0));
                }
            } else if (subOne.op() == integerLDT.getSub() && SymbolicExecutionUtil.isOne(subOne.sub(1), integerLDT)) {
                term = tb.geq(term.sub(0), subOne.sub(0));
            }
        } else if (term.op() == Junctor.NOT) {
            Term sub;
            sub = term.sub(0);
            if (sub.op() == integerLDT.getLessOrEquals()) {
                term = tb.gt(sub.sub(0), sub.sub(1));
            } else if (sub.op() == integerLDT.getLessThan()) {
                term = tb.geq(sub.sub(0), sub.sub(1));
            } else if (sub.op() == integerLDT.getGreaterOrEquals()) {
                term = tb.lt(sub.sub(0), sub.sub(1));
            } else if (sub.op() == integerLDT.getGreaterThan()) {
                term = tb.leq(sub.sub(0), sub.sub(1));
            }
        }
        return term;
    }

    private static boolean isOne(Term subOne, IntegerLDT integerLDT) {
        return subOne.equalsModIrrelevantTermLabels((Object)integerLDT.one());
    }

    private static boolean isMinusOne(Term term, IntegerLDT integerLDT) {
        return term.op() == integerLDT.getNumberSymbol() && (term = term.sub(0)).op() == integerLDT.getNegativeNumberSign() && (term = term.sub(0)).op() == integerLDT.getNumberLiteralFor(1) && (term = term.sub(0)).op() == integerLDT.getNumberTerminator();
    }

    public static SiteProofVariableValueInput createExtractReturnVariableValueSequent(Services services, TypeReference contextObjectType, IProgramMethod contextMethod, ReferencePrefix contextObject, Node methodReturnNode, Node methodCallEmptyNode, IProgramVariable variable) {
        ExecutionContext context = new ExecutionContext(contextObjectType, contextMethod, contextObject);
        return SymbolicExecutionUtil.createExtractReturnVariableValueSequent(services, (IExecutionContext)context, methodReturnNode, methodCallEmptyNode, variable);
    }

    public static SiteProofVariableValueInput createExtractReturnVariableValueSequent(Services services, IExecutionContext context, Node methodReturnNode, Node methodCallEmptyNode, IProgramVariable variable) {
        assert (context != null);
        assert (methodReturnNode != null);
        assert (methodCallEmptyNode != null);
        assert (variable instanceof ProgramVariable);
        Statement originalReturnStatement = (Statement)methodReturnNode.getNodeInfo().getActiveStatement();
        MethodFrame newMethodFrame = new MethodFrame(variable, context, new StatementBlock(originalReturnStatement));
        JavaBlock newJavaBlock = JavaBlock.createJavaBlock((StatementBlock)new StatementBlock((Statement)newMethodFrame));
        Function newPredicate = new Function(new Name(services.getTermBuilder().newName("ResultPredicate")), Sort.FORMULA, new Sort[]{variable.sort()});
        Term newTerm = services.getTermBuilder().func(newPredicate, services.getTermBuilder().var((ProgramVariable)variable));
        Term modalityTerm = services.getTermBuilder().dia(newJavaBlock, newTerm);
        Term originalModifiedFormula = methodReturnNode.getAppliedRuleApp().posInOccurrence().sequentFormula().formula();
        ImmutableList originalUpdates = (ImmutableList)TermBuilder.goBelowUpdates2((Term)originalModifiedFormula).first;
        Sequent sequentToProve = SymbolicExecutionUtil.createSequentToProveWithNewSuccedent(methodCallEmptyNode, null, modalityTerm, (ImmutableList<Term>)originalUpdates, false);
        return new SiteProofVariableValueInput(sequentToProve, (Operator)newPredicate);
    }

    public static SiteProofVariableValueInput createExtractVariableValueSequent(Services services, Node node, PosInOccurrence pio, Term additionalConditions, IProgramVariable variable) {
        assert (node != null);
        assert (variable instanceof ProgramVariable);
        Function newPredicate = new Function(new Name(services.getTermBuilder().newName("ResultPredicate")), Sort.FORMULA, new Sort[]{variable.sort()});
        Term newTerm = services.getTermBuilder().func(newPredicate, services.getTermBuilder().var((ProgramVariable)variable));
        Sequent sequentToProve = SymbolicExecutionUtil.createSequentToProveWithNewSuccedent(node, pio, additionalConditions, newTerm, false);
        return new SiteProofVariableValueInput(sequentToProve, (Operator)newPredicate);
    }

    public static SiteProofVariableValueInput createExtractTermSequent(Services sideProofServices, Node node, PosInOccurrence pio, Term additionalConditions, Term term, boolean keepUpdates) {
        assert (node != null);
        assert (term != null);
        Function newPredicate = new Function(new Name(sideProofServices.getTermBuilder().newName("ResultPredicate")), Sort.FORMULA, new Sort[]{term.sort()});
        Term newTerm = sideProofServices.getTermBuilder().func(newPredicate, term);
        Sequent sequentToProve = keepUpdates ? SymbolicExecutionUtil.createSequentToProveWithNewSuccedent(node, pio, additionalConditions, newTerm, false) : SymbolicExecutionUtil.createSequentToProveWithNewSuccedent(node, pio, additionalConditions, newTerm, null, false);
        return new SiteProofVariableValueInput(sequentToProve, (Operator)newPredicate);
    }

    public static boolean isHeapUpdate(Services services, Term term) {
        Term sub;
        ImmutableArray subs;
        boolean heapUpdate = false;
        if (term != null && (subs = term.subs()).size() == 1 && ((sub = (Term)subs.get(0)).op() == services.getTypeConverter().getHeapLDT().getStore() || sub.op() == services.getTypeConverter().getHeapLDT().getCreate())) {
            heapUpdate = true;
        }
        return heapUpdate;
    }

    public static boolean canComputeVariables(IExecutionNode<?> node, Services services) throws ProofInputException {
        return node != null && !node.isDisposed() && !services.getTermBuilder().ff().equals(node.getPathCondition());
    }

    public static IExecutionConstraint[] createExecutionConstraints(IExecutionNode<?> node) {
        if (node != null && !node.isDisposed()) {
            TermBuilder tb = node.getServices().getTermBuilder();
            LinkedList<ExecutionConstraint> constraints = new LinkedList<ExecutionConstraint>();
            Node proofNode = node.getProofNode();
            Sequent sequent = proofNode.sequent();
            for (SequentFormula sf : sequent.antecedent()) {
                if (SymbolicExecutionUtil.containsSymbolicExecutionLabel(sf.formula())) continue;
                constraints.add(new ExecutionConstraint(node.getSettings(), proofNode, node.getModalityPIO(), sf.formula()));
            }
            for (SequentFormula sf : sequent.succedent()) {
                if (SymbolicExecutionUtil.containsSymbolicExecutionLabel(sf.formula())) continue;
                constraints.add(new ExecutionConstraint(node.getSettings(), proofNode, node.getModalityPIO(), tb.not(sf.formula())));
            }
            return constraints.toArray(new IExecutionConstraint[constraints.size()]);
        }
        return new IExecutionConstraint[0];
    }

    public static boolean containsSymbolicExecutionLabel(Term term) {
        boolean hasModality = false;
        if ((term = TermBuilder.goBelowUpdates((Term)term)).op() instanceof Modality) {
            hasModality = SymbolicExecutionUtil.hasSymbolicExecutionLabel(term);
        }
        if (!hasModality) {
            for (int i = 0; !hasModality && i < term.arity(); ++i) {
                hasModality = SymbolicExecutionUtil.containsSymbolicExecutionLabel(term.sub(i));
            }
        }
        return hasModality;
    }

    public static IExecutionVariable[] createExecutionVariables(IExecutionNode<?> node) throws ProofInputException {
        return SymbolicExecutionUtil.createExecutionVariables(node, null);
    }

    public static IExecutionVariable[] createExecutionVariables(IExecutionNode<?> node, Term condition) throws ProofInputException {
        if (node != null) {
            return SymbolicExecutionUtil.createExecutionVariables(node, node.getProofNode(), node.getModalityPIO(), condition);
        }
        return new IExecutionVariable[0];
    }

    public static IExecutionVariable[] createExecutionVariables(IExecutionNode<?> node, Node proofNode, PosInOccurrence modalityPIO, Term condition) throws ProofInputException {
        if (node.getSettings().isVariablesAreOnlyComputedFromUpdates()) {
            ExecutionVariableExtractor extractor = new ExecutionVariableExtractor(proofNode, modalityPIO, node, condition, node.getSettings().isSimplifyConditions());
            return extractor.analyse();
        }
        return SymbolicExecutionUtil.createAllExecutionVariables(node, proofNode, modalityPIO, condition);
    }

    public static IExecutionVariable[] createAllExecutionVariables(IExecutionNode<?> node, Node proofNode, PosInOccurrence modalityPIO, Term condition) {
        if (proofNode != null) {
            Node callNode;
            LinkedList<IProgramVariable> variables = new LinkedList<IProgramVariable>();
            IProgramVariable selfVar = SymbolicExecutionUtil.findSelfTerm(proofNode, modalityPIO);
            if (selfVar != null) {
                variables.add(selfVar);
            }
            if ((callNode = SymbolicExecutionUtil.findMethodCallNode(proofNode, modalityPIO)) != null && callNode.getNodeInfo().getActiveStatement() instanceof MethodBodyStatement) {
                MethodBodyStatement mbs = (MethodBodyStatement)callNode.getNodeInfo().getActiveStatement();
                for (Expression e : mbs.getArguments()) {
                    if (!(e instanceof IProgramVariable)) continue;
                    variables.add((IProgramVariable)e);
                }
            }
            List<IProgramVariable> variablesFromUpdates = SymbolicExecutionUtil.collectAllElementaryUpdateTerms(proofNode);
            for (IProgramVariable variable : variablesFromUpdates) {
                if (variables.contains(variable)) continue;
                variables.add(variable);
            }
            IExecutionVariable[] result = new IExecutionVariable[variables.size()];
            int i = 0;
            for (IProgramVariable var : variables) {
                result[i] = new ExecutionVariable(node, proofNode, modalityPIO, var, condition);
                ++i;
            }
            return result;
        }
        return new IExecutionVariable[0];
    }

    public static List<IProgramVariable> collectAllElementaryUpdateTerms(Node node) {
        if (node != null) {
            Services services = node.proof().getServices();
            LinkedList<IProgramVariable> result = new LinkedList<IProgramVariable>();
            for (SequentFormula sf : node.sequent().antecedent()) {
                SymbolicExecutionUtil.internalCollectAllElementaryUpdateTerms(services, result, sf.formula());
            }
            for (SequentFormula sf : node.sequent().succedent()) {
                SymbolicExecutionUtil.internalCollectAllElementaryUpdateTerms(services, result, sf.formula());
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static void internalCollectAllElementaryUpdateTerms(Services services, List<IProgramVariable> result, Term term) {
        block1: {
            block2: {
                block3: {
                    if (term == null) break block1;
                    if (!(term.op() instanceof ElementaryUpdate)) break block2;
                    if (!SymbolicExecutionUtil.isHeapUpdate(services, term)) break block3;
                    LinkedHashSet<IProgramVariable> staticAttributes = new LinkedHashSet<IProgramVariable>();
                    SymbolicExecutionUtil.internalCollectStaticProgramVariablesOnHeap(services, staticAttributes, term);
                    result.addAll(staticAttributes);
                    break block1;
                }
                ElementaryUpdate eu = (ElementaryUpdate)term.op();
                if (!(eu.lhs() instanceof IProgramVariable)) break block1;
                result.add((IProgramVariable)eu.lhs());
                break block1;
            }
            for (Term sub : term.subs()) {
                SymbolicExecutionUtil.internalCollectAllElementaryUpdateTerms(services, result, sub);
            }
        }
    }

    private static void internalCollectStaticProgramVariablesOnHeap(Services services, Set<IProgramVariable> result, Term term) {
        HeapLDT heapLDT = services.getTypeConverter().getHeapLDT();
        try {
            if (term.op() == heapLDT.getStore()) {
                Term innerMostSelect;
                Term locationTerm;
                ProgramVariable attribute;
                ImmutableArray subs = term.subs();
                if (term.arity() == 4 && (attribute = SymbolicExecutionUtil.getProgramVariable(services, heapLDT, locationTerm = (innerMostSelect = SymbolicExecutionUtil.findInnerMostSelect((Term)subs.get(1), services)) != null ? innerMostSelect.sub(2) : (Term)subs.get(2))) != null && attribute.isStatic()) {
                    result.add((IProgramVariable)attribute);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Term sub : term.subs()) {
            SymbolicExecutionUtil.internalCollectStaticProgramVariablesOnHeap(services, result, sub);
        }
    }

    private static Term findInnerMostSelect(Term term, Services services) {
        if (SymbolicExecutionUtil.isSelect(services, term)) {
            while (SymbolicExecutionUtil.isSelect(services, term.sub(1))) {
                term = term.sub(1);
            }
            return term;
        }
        return null;
    }

    public static ProgramVariable getProgramVariable(Services services, HeapLDT heapLDT, Term locationTerm) {
        ProgramVariable result = null;
        if (locationTerm.op() instanceof Function) {
            Function function = (Function)locationTerm.op();
            if (heapLDT.getArr() != function) {
                String typeName = HeapLDT.getClassName((Function)function);
                KeYJavaType type = services.getJavaInfo().getKeYJavaType(typeName);
                if (type != null) {
                    String fieldName = HeapLDT.getPrettyFieldName((Named)function);
                    result = services.getJavaInfo().getAttribute(fieldName, type);
                }
            }
        }
        return result;
    }

    public static Term getArrayIndex(Services services, HeapLDT heapLDT, Term arrayIndexTerm) {
        if (arrayIndexTerm.op() == heapLDT.getArr() && arrayIndexTerm.arity() == 1) {
            return arrayIndexTerm.sub(0);
        }
        return null;
    }

    public static IProgramVariable findSelfTerm(Node node, PosInOccurrence pio) {
        if (pio != null) {
            Services services;
            Term term = pio.subTerm();
            JavaBlock jb = (term = TermBuilder.goBelowUpdates((Term)term)).javaBlock();
            ExecutionContext context = JavaTools.getInnermostExecutionContext((JavaBlock)jb, (Services)(services = node.proof().getServices()));
            if (context instanceof ExecutionContext) {
                ReferencePrefix prefix = context.getRuntimeInstance();
                return prefix instanceof IProgramVariable ? (IProgramVariable)prefix : null;
            }
            return null;
        }
        return null;
    }

    public static boolean isMethodCallNode(Node node, RuleApp ruleApp, SourceElement statement) {
        return SymbolicExecutionUtil.isMethodCallNode(node, ruleApp, statement, false);
    }

    public static boolean isMethodCallNode(Node node, RuleApp ruleApp, SourceElement statement, boolean allowImpliciteMethods) {
        if (ruleApp != null) {
            if (statement instanceof MethodBodyStatement) {
                if (allowImpliciteMethods) {
                    return true;
                }
                MethodBodyStatement mbs = (MethodBodyStatement)statement;
                IProgramMethod pm = mbs.getProgramMethod(node.proof().getServices());
                return SymbolicExecutionUtil.isNotImplicit(node.proof().getServices(), pm);
            }
            return false;
        }
        return false;
    }

    public static boolean isNotImplicit(Services services, IProgramMethod pm) {
        if (pm != null) {
            if (KeYTypeUtil.isImplicitConstructor((IProgramMethod)pm)) {
                IProgramMethod explicitConstructor = KeYTypeUtil.findExplicitConstructor((Services)services, (IProgramMethod)pm);
                return explicitConstructor != null && !KeYTypeUtil.isLibraryClass((KeYJavaType)explicitConstructor.getContainerType());
            }
            return !pm.isImplicit() && !KeYTypeUtil.isLibraryClass((KeYJavaType)pm.getContainerType());
        }
        return true;
    }

    public static boolean isBranchStatement(Node node, RuleApp ruleApp, SourceElement statement, PositionInfo posInfo) {
        return SymbolicExecutionUtil.isStatementNode(node, ruleApp, statement, posInfo) && statement instanceof BranchStatement;
    }

    public static boolean isLoopStatement(Node node, RuleApp ruleApp, SourceElement statement, PositionInfo posInfo) {
        return SymbolicExecutionUtil.isStatementNode(node, ruleApp, statement, posInfo) && statement instanceof LoopStatement;
    }

    public static boolean isStatementNode(Node node, RuleApp ruleApp, SourceElement statement, PositionInfo posInfo) {
        return ruleApp != null && posInfo != null && posInfo.getEndPosition() != Position.UNDEFINED && posInfo.getEndPosition().getLine() >= 0 && !(statement instanceof EmptyStatement) && (!(statement instanceof StatementBlock) || !((StatementBlock)statement).isEmpty());
    }

    public static boolean isTerminationNode(Node node, RuleApp ruleApp) {
        return "emptyModality".equals(MiscTools.getRuleDisplayName((RuleApp)ruleApp));
    }

    public static boolean isOperationContract(Node node, RuleApp ruleApp) {
        if (ruleApp instanceof AbstractContractRuleApp) {
            Contract contract = ((AbstractContractRuleApp)ruleApp).getInstantiation();
            if (contract instanceof OperationContract) {
                IProgramMethod target = ((OperationContract)contract).getTarget();
                return SymbolicExecutionUtil.isNotImplicit(node.proof().getServices(), target);
            }
            return false;
        }
        return false;
    }

    public static boolean isBlockSpecificationElement(Node node, RuleApp ruleApp) {
        return ruleApp instanceof AbstractAuxiliaryContractBuiltInRuleApp;
    }

    public static boolean isLoopInvariant(Node node, RuleApp ruleApp) {
        return "Loop Invariant".equals(MiscTools.getRuleDisplayName((RuleApp)ruleApp));
    }

    public static boolean isMethodReturnNode(Node node, RuleApp ruleApp) {
        String displayName = MiscTools.getRuleDisplayName((RuleApp)ruleApp);
        String ruleName = MiscTools.getRuleName((RuleApp)ruleApp);
        return "methodCallEmpty".equals(displayName) || "methodCallEmptyReturn".equals(ruleName) || "methodCallReturnIgnoreResult".equals(ruleName);
    }

    public static boolean isExceptionalMethodReturnNode(Node node, RuleApp ruleApp) {
        String ruleName = MiscTools.getRuleName((RuleApp)ruleApp);
        return "methodCallParamThrow".equals(ruleName) || "methodCallThrow".equals(ruleName);
    }

    public static boolean hasLoopCondition(Node node, RuleApp ruleApp, SourceElement statement) {
        return ruleApp != null && statement instanceof LoopStatement && !(statement instanceof EnhancedFor);
    }

    public static boolean hasLoopBodyLabel(RuleApp ruleApp) {
        if (ruleApp != null && ruleApp.posInOccurrence() != null) {
            Term term = ruleApp.posInOccurrence().subTerm();
            if (term != null) {
                term = TermBuilder.goBelowUpdates((Term)term);
                return term.containsLabel(LOOP_BODY_LABEL);
            }
            return false;
        }
        return false;
    }

    public static boolean hasLoopBodyTerminationLabel(RuleApp ruleApp) {
        if (ruleApp != null && ruleApp.posInOccurrence() != null) {
            Term term = ruleApp.posInOccurrence().subTerm();
            return term.containsLabel(LOOP_INVARIANT_NORMAL_BEHAVIOR_LABEL);
        }
        return false;
    }

    public static boolean hasSymbolicExecutionLabel(RuleApp ruleApp) {
        return SymbolicExecutionUtil.getSymbolicExecutionLabel(ruleApp) != null;
    }

    public static SymbolicExecutionTermLabel getSymbolicExecutionLabel(RuleApp ruleApp) {
        if (ruleApp != null && ruleApp.posInOccurrence() != null) {
            return SymbolicExecutionUtil.getSymbolicExecutionLabel(ruleApp.posInOccurrence().subTerm());
        }
        return null;
    }

    public static boolean hasSymbolicExecutionLabel(Term term) {
        return SymbolicExecutionUtil.getSymbolicExecutionLabel(term) != null;
    }

    public static SymbolicExecutionTermLabel getSymbolicExecutionLabel(Term term) {
        if (term != null) {
            term = TermBuilder.goBelowUpdates((Term)term);
            return (SymbolicExecutionTermLabel)CollectionUtil.search((Iterable)term.getLabels(), (IFilter)new IFilter<TermLabel>(){

                public boolean select(TermLabel element) {
                    return element instanceof SymbolicExecutionTermLabel;
                }
            });
        }
        return null;
    }

    public static PosInOccurrence findModalityWithMaxSymbolicExecutionLabelId(Sequent sequent) {
        if (sequent != null) {
            PosInOccurrence nextAntecedent = SymbolicExecutionUtil.findModalityWithMaxSymbolicExecutionLabelId(sequent.antecedent(), true);
            PosInOccurrence nextSuccedent = SymbolicExecutionUtil.findModalityWithMaxSymbolicExecutionLabelId(sequent.succedent(), false);
            if (nextAntecedent != null) {
                if (nextSuccedent != null) {
                    SymbolicExecutionTermLabel antecedentLabel = SymbolicExecutionUtil.getSymbolicExecutionLabel(nextAntecedent.subTerm());
                    SymbolicExecutionTermLabel succedentLabel = SymbolicExecutionUtil.getSymbolicExecutionLabel(nextSuccedent.subTerm());
                    return antecedentLabel.getId() > succedentLabel.getId() ? nextAntecedent : nextSuccedent;
                }
                return nextAntecedent;
            }
            return nextSuccedent;
        }
        return null;
    }

    public static PosInOccurrence findModalityWithMaxSymbolicExecutionLabelId(Semisequent semisequent, boolean inAntec) {
        if (semisequent != null) {
            int maxId = Integer.MIN_VALUE;
            PosInOccurrence maxPio = null;
            for (SequentFormula sf : semisequent) {
                PosInTerm current = SymbolicExecutionUtil.findModalityWithMaxSymbolicExecutionLabelId(sf.formula());
                if (current == null) continue;
                PosInOccurrence pio = new PosInOccurrence(sf, current, inAntec);
                SymbolicExecutionTermLabel label = SymbolicExecutionUtil.getSymbolicExecutionLabel(pio.subTerm());
                if (maxPio != null && label.getId() <= maxId) continue;
                maxPio = pio;
                maxId = label.getId();
            }
            return maxPio;
        }
        return null;
    }

    public static PosInTerm findModalityWithMaxSymbolicExecutionLabelId(Term term) {
        if (term != null) {
            FindModalityWithSymbolicExecutionLabelId visitor = new FindModalityWithSymbolicExecutionLabelId(true);
            term.execPreOrder((Visitor)visitor);
            return visitor.getPosInTerm();
        }
        return null;
    }

    public static PosInOccurrence findModalityWithMinSymbolicExecutionLabelId(Sequent sequent) {
        if (sequent != null) {
            PosInOccurrence nextAntecedent = SymbolicExecutionUtil.findModalityWithMinSymbolicExecutionLabelId(sequent.antecedent(), true);
            PosInOccurrence nextSuccedent = SymbolicExecutionUtil.findModalityWithMinSymbolicExecutionLabelId(sequent.succedent(), false);
            if (nextAntecedent != null) {
                if (nextSuccedent != null) {
                    SymbolicExecutionTermLabel antecedentLabel = SymbolicExecutionUtil.getSymbolicExecutionLabel(nextAntecedent.subTerm());
                    SymbolicExecutionTermLabel succedentLabel = SymbolicExecutionUtil.getSymbolicExecutionLabel(nextSuccedent.subTerm());
                    return antecedentLabel.getId() < succedentLabel.getId() ? nextAntecedent : nextSuccedent;
                }
                return nextAntecedent;
            }
            return nextSuccedent;
        }
        return null;
    }

    public static PosInOccurrence findModalityWithMinSymbolicExecutionLabelId(Semisequent semisequent, boolean inAntec) {
        if (semisequent != null) {
            int maxId = Integer.MIN_VALUE;
            PosInOccurrence minPio = null;
            for (SequentFormula sf : semisequent) {
                PosInTerm current = SymbolicExecutionUtil.findModalityWithMinSymbolicExecutionLabelId(sf.formula());
                if (current == null) continue;
                PosInOccurrence pio = new PosInOccurrence(sf, current, inAntec);
                SymbolicExecutionTermLabel label = SymbolicExecutionUtil.getSymbolicExecutionLabel(pio.subTerm());
                if (minPio != null && label.getId() >= maxId) continue;
                minPio = pio;
                maxId = label.getId();
            }
            return minPio;
        }
        return null;
    }

    public static PosInTerm findModalityWithMinSymbolicExecutionLabelId(Term term) {
        if (term != null) {
            FindModalityWithSymbolicExecutionLabelId visitor = new FindModalityWithSymbolicExecutionLabelId(false);
            term.execPreOrder((Visitor)visitor);
            return visitor.getPosInTerm();
        }
        return null;
    }

    public static boolean isSymbolicExecutionTreeNode(Node node, RuleApp ruleApp) {
        if (node != null && !SymbolicExecutionUtil.isRuleAppToIgnore(ruleApp) && SymbolicExecutionUtil.hasSymbolicExecutionLabel(ruleApp)) {
            PositionInfo posInfo;
            SourceElement statement = NodeInfo.computeActiveStatement((RuleApp)ruleApp);
            PositionInfo positionInfo = posInfo = statement != null ? statement.getPositionInfo() : null;
            if (SymbolicExecutionUtil.isMethodReturnNode(node, ruleApp)) {
                return !SymbolicExecutionUtil.isInImplicitMethod(node, ruleApp);
            }
            if (SymbolicExecutionUtil.isExceptionalMethodReturnNode(node, ruleApp)) {
                return !SymbolicExecutionUtil.isInImplicitMethod(node, ruleApp);
            }
            if (SymbolicExecutionUtil.isLoopStatement(node, ruleApp, statement, posInfo)) {
                return true;
            }
            if (SymbolicExecutionUtil.isBranchStatement(node, ruleApp, statement, posInfo) || SymbolicExecutionUtil.isMethodCallNode(node, ruleApp, statement) || SymbolicExecutionUtil.isStatementNode(node, ruleApp, statement, posInfo) || SymbolicExecutionUtil.isTerminationNode(node, ruleApp)) {
                return true;
            }
            if (SymbolicExecutionUtil.hasLoopCondition(node, ruleApp, statement)) {
                return ((LoopStatement)statement).getGuardExpression().getPositionInfo() != PositionInfo.UNDEFINED && !SymbolicExecutionUtil.isDoWhileLoopCondition(node, statement) && !SymbolicExecutionUtil.isForLoopCondition(node, statement);
            }
            if (SymbolicExecutionUtil.isOperationContract(node, ruleApp)) {
                return true;
            }
            if (SymbolicExecutionUtil.isLoopInvariant(node, ruleApp)) {
                return true;
            }
            return SymbolicExecutionUtil.isBlockSpecificationElement(node, ruleApp);
        }
        return SymbolicExecutionUtil.isLoopBodyTermination(node, ruleApp);
    }

    public static boolean isRuleAppToIgnore(RuleApp ruleApp) {
        return "unusedLabel".equals(MiscTools.getRuleDisplayName((RuleApp)ruleApp)) || "elim_double_block".equals(MiscTools.getRuleDisplayName((RuleApp)ruleApp));
    }

    public static boolean isInImplicitMethod(Node node, RuleApp ruleApp) {
        Term term = ruleApp.posInOccurrence().subTerm();
        JavaBlock block = (term = TermBuilder.goBelowUpdates((Term)term)).javaBlock();
        ExecutionContext context = JavaTools.getInnermostExecutionContext((JavaBlock)block, (Services)node.proof().getServices());
        return context != null && context.getMethodContext() != null && context.getMethodContext().isImplicit();
    }

    public static int computeStackSize(RuleApp ruleApp) {
        JavaProgramElement element;
        JavaBlock block;
        Term modality;
        Term subTerm;
        PosInOccurrence posInOc;
        int result = 0;
        if (ruleApp != null && (posInOc = ruleApp.posInOccurrence()) != null && (subTerm = posInOc.subTerm()) != null && (modality = TermBuilder.goBelowUpdates((Term)subTerm)) != null && (block = modality.javaBlock()) != null && (element = block.program()) instanceof StatementBlock) {
            StatementBlock b = (StatementBlock)block.program();
            ImmutableArray prefix = b.getPrefixElements();
            result = CollectionUtil.count((Iterable)prefix, (IFilter)new IFilter<ProgramPrefix>(){

                public boolean select(ProgramPrefix element) {
                    return element instanceof MethodFrame;
                }
            });
        }
        return result;
    }

    public static boolean isDoWhileLoopCondition(Node node, SourceElement statement) {
        return statement instanceof Do;
    }

    public static boolean isForLoopCondition(Node node, SourceElement statement) {
        return statement instanceof For;
    }

    public static ImmutableList<Goal> collectGoalsInSubtree(IExecutionElement executionElement) {
        if (executionElement != null) {
            return SymbolicExecutionUtil.collectGoalsInSubtree(executionElement.getProofNode());
        }
        return ImmutableSLList.nil();
    }

    public static ImmutableList<Goal> collectGoalsInSubtree(Node node) {
        Proof proof = node.proof();
        return proof.getSubtreeEnabledGoals(node);
    }

    public static Node findMethodCallNode(Node node, PosInOccurrence pio) {
        if (node != null && pio != null) {
            Term term = pio.subTerm();
            term = TermBuilder.goBelowUpdates((Term)term);
            Services services = node.proof().getServices();
            MethodFrame mf = JavaTools.getInnermostMethodFrame((JavaBlock)term.javaBlock(), (Services)services);
            if (mf != null) {
                Node parent = node.parent();
                Node result = null;
                while (parent != null && result == null) {
                    SourceElement activeStatement = parent.getNodeInfo().getActiveStatement();
                    if (activeStatement instanceof MethodBodyStatement && ((MethodBodyStatement)activeStatement).getProgramMethod(services) == mf.getProgramMethod()) {
                        result = parent;
                        continue;
                    }
                    parent = parent.parent();
                }
                return result;
            }
            return null;
        }
        return null;
    }

    public static Node findParentSetNode(Node node) {
        if (node != null) {
            Node parent = node.parent();
            Node result = null;
            while (parent != null && result == null) {
                if (SymbolicExecutionUtil.isSymbolicExecutionTreeNode(parent, parent.getAppliedRuleApp())) {
                    result = parent;
                    continue;
                }
                parent = parent.parent();
            }
            return result;
        }
        return null;
    }

    public static Term computeBranchCondition(Node node, boolean simplify, boolean improveReadability) throws ProofInputException {
        Node parent = node.parent();
        if (parent.getAppliedRuleApp() instanceof TacletApp) {
            return SymbolicExecutionUtil.computeTacletAppBranchCondition(parent, node, simplify, improveReadability);
        }
        if (parent.getAppliedRuleApp() instanceof ContractRuleApp) {
            return SymbolicExecutionUtil.computeContractRuleAppBranchCondition(parent, node, simplify, improveReadability);
        }
        if (parent.getAppliedRuleApp() instanceof LoopInvariantBuiltInRuleApp) {
            return SymbolicExecutionUtil.computeLoopInvariantBuiltInRuleAppBranchCondition(parent, node, simplify, improveReadability);
        }
        if (parent.getAppliedRuleApp() instanceof AbstractBlockContractBuiltInRuleApp) {
            return SymbolicExecutionUtil.computeBlockContractBuiltInRuleAppBranchCondition(parent, node, simplify, improveReadability);
        }
        throw new ProofInputException("Unsupported RuleApp in branch computation \"" + parent.getAppliedRuleApp() + "\".");
    }

    private static Term computeContractRuleAppBranchCondition(Node parent, Node node, boolean simplify, boolean improveReadability) throws ProofInputException {
        Term condition;
        Services services = node.proof().getServices();
        if (!(parent.getAppliedRuleApp() instanceof ContractRuleApp)) {
            throw new ProofInputException("Only ContractRuleApp is allowed in branch computation but rule \"" + parent.getAppliedRuleApp() + "\" was found.");
        }
        int childIndex = CollectionUtil.indexOf((Iterator)parent.childrenIterator(), (Object)node);
        if (childIndex >= 3) {
            throw new ProofInputException("Branch condition of null pointer check is not supported.");
        }
        if (childIndex == 2) {
            PosInOccurrence pio = parent.getAppliedRuleApp().posInOccurrence();
            Term workingTerm = SymbolicExecutionUtil.posInOccurrenceInOtherNode(parent, pio, node);
            if (workingTerm == null) {
                throw new ProofInputException("Term not find in precondition branch, implementation of UseOperationContractRule might have changed!");
            }
            if ((workingTerm = TermBuilder.goBelowUpdates((Term)workingTerm)).op() != Junctor.AND) {
                throw new ProofInputException("And operation expected, implementation of UseOperationContractRule might have changed!");
            }
            Term preconditions = workingTerm.sub(0);
            return services.getTermBuilder().not(preconditions);
        }
        ContractPostOrExcPostExceptionVariableResult search = SymbolicExecutionUtil.searchContractPostOrExcPostExceptionVariable(node, node.proof().getServices());
        LinkedList<Term> normalConditions = new LinkedList<Term>();
        LinkedList<Term> exceptinalConditions = new LinkedList<Term>();
        SymbolicExecutionUtil.collectContractPreconditions(services, search, normalConditions, exceptinalConditions);
        LinkedList<Term> relevantConditions = childIndex == 1 ? exceptinalConditions : normalConditions;
        Term result = relevantConditions.isEmpty() ? services.getTermBuilder().tt() : services.getTermBuilder().or(relevantConditions);
        Term excEquality = search.getExceptionEquality();
        if (childIndex == 1) {
            excEquality = services.getTermBuilder().not(excEquality);
        }
        result = services.getTermBuilder().and(excEquality, result);
        if (parent.childrenCount() == 4) {
            Term callerNotNullTerm = SymbolicExecutionUtil.posInOccurrenceInOtherNode(parent, parent.getAppliedRuleApp().posInOccurrence(), parent.child(3));
            if ((callerNotNullTerm = TermBuilder.goBelowUpdates((Term)callerNotNullTerm)).op() != Junctor.NOT) {
                throw new ProofInputException("Not operation expected, implementation of UseOperationContractRule might have changed!");
            }
            if (callerNotNullTerm.sub(0).op() != Equality.EQUALS) {
                throw new ProofInputException("Equals operation expected, implementation of UseOperationContractRule might have changed!");
            }
            if (!(callerNotNullTerm.sub(0).sub(0).op() instanceof ProgramVariable)) {
                throw new ProofInputException("ProgramVariable expected, implementation of UseOperationContractRule might have changed!");
            }
            if (!SymbolicExecutionUtil.isNullSort(callerNotNullTerm.sub(0).sub(1).sort(), parent.proof().getServices())) {
                throw new ProofInputException("Null expected, implementation of UseOperationContractRule might have changed!");
            }
            result = services.getTermBuilder().and(callerNotNullTerm, result);
        }
        if (simplify) {
            ProofEnvironment sideProofEnv = SymbolicExecutionSideProofUtil.cloneProofEnvironmentWithOwnOneStepSimplifier(parent.proof(), true);
            Sequent newSequent = SymbolicExecutionUtil.createSequentToProveWithNewSuccedent(parent, null, result, true);
            condition = SymbolicExecutionUtil.evaluateInSideProof(services, parent.proof(), sideProofEnv, newSequent, RESULT_LABEL, "Operation contract branch condition computation on node " + parent.serialNr() + " for branch " + node.serialNr() + ".", "SPLITTING_OFF");
        } else {
            condition = services.getTermBuilder().applyParallel((ImmutableList)search.getUpdatesAndTerm().first, result);
        }
        if (improveReadability) {
            condition = SymbolicExecutionUtil.improveReadability(condition, services);
        }
        return condition;
    }

    private static void collectContractPreconditions(Services services, ContractPostOrExcPostExceptionVariableResult search, List<Term> normalConditions, List<Term> exceptinalConditions) throws ProofInputException {
        Term normalExcDefinition;
        Term exceptionalExcDefinition;
        if (search.getWorkingTerm().op() != Junctor.AND) {
            throw new ProofInputException("And operation expected, implementation of UseOperationContractRule might have changed!");
        }
        Term specificationCasesTerm = search.getWorkingTerm().sub(1);
        Term excDefinition = search.getExceptionDefinition();
        if (excDefinition.op() == Junctor.NOT) {
            exceptionalExcDefinition = excDefinition;
            normalExcDefinition = search.getExceptionEquality();
        } else {
            normalExcDefinition = excDefinition;
            exceptionalExcDefinition = services.getTermBuilder().not(excDefinition);
        }
        SymbolicExecutionUtil.collectSpecifcationCasesPreconditions(normalExcDefinition, exceptionalExcDefinition, specificationCasesTerm, normalConditions, exceptinalConditions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void collectSpecifcationCasesPreconditions(Term normalExcDefinition, Term exceptionalExcDefinition, Term term, List<Term> normalConditions, List<Term> exceptinalConditions) throws ProofInputException {
        if (term.op() == Junctor.AND) {
            Term firstChild;
            Term lastChild = term.sub(term.arity() - 1);
            if (lastChild.equalsModIrrelevantTermLabels((Object)normalExcDefinition) || lastChild.equalsModIrrelevantTermLabels((Object)exceptionalExcDefinition) || (firstChild = term.sub(0)).equalsModIrrelevantTermLabels((Object)normalExcDefinition) || firstChild.equalsModIrrelevantTermLabels((Object)exceptionalExcDefinition)) return;
            for (int i = 0; i < term.arity(); ++i) {
                SymbolicExecutionUtil.collectSpecifcationCasesPreconditions(normalExcDefinition, exceptionalExcDefinition, term.sub(i), normalConditions, exceptinalConditions);
            }
            return;
        } else {
            Term leftTerm;
            if (term.op() != Junctor.IMP || (leftTerm = term.sub(0)).equalsModIrrelevantTermLabels((Object)normalExcDefinition) || leftTerm.equalsModIrrelevantTermLabels((Object)exceptionalExcDefinition)) return;
            Term rightTerm = term.sub(1);
            if (rightTerm.op() == Junctor.AND && rightTerm.sub(0).op() == Junctor.IMP && rightTerm.sub(0).sub(0).equalsModIrrelevantTermLabels((Object)normalExcDefinition)) {
                normalConditions.add(leftTerm);
                return;
            } else if (rightTerm.op() == Junctor.AND && rightTerm.sub(1).op() == Junctor.IMP && rightTerm.sub(1).sub(0).equalsModIrrelevantTermLabels((Object)exceptionalExcDefinition)) {
                exceptinalConditions.add(leftTerm);
                return;
            } else if (rightTerm.op() == Junctor.IMP && rightTerm.sub(0).equalsModIrrelevantTermLabels((Object)normalExcDefinition)) {
                normalConditions.add(leftTerm);
                return;
            } else if (rightTerm.op() == Junctor.IMP && rightTerm.sub(0).equalsModIrrelevantTermLabels((Object)exceptionalExcDefinition)) {
                exceptinalConditions.add(leftTerm);
                return;
            } else {
                Term excCondition = rightTerm;
                if (excCondition.op() == Junctor.AND) {
                    excCondition = excCondition.sub(excCondition.arity() - 1);
                }
                if (excCondition.equalsModIrrelevantTermLabels((Object)normalExcDefinition)) {
                    normalConditions.add(leftTerm);
                    return;
                } else if (excCondition.equalsModIrrelevantTermLabels((Object)exceptionalExcDefinition)) {
                    exceptinalConditions.add(leftTerm);
                    return;
                } else {
                    if (rightTerm.op() != Junctor.AND) throw new ProofInputException("Exeptional condition expected, implementation of UseOperationContractRule might have changed!");
                    excCondition = rightTerm.sub(0);
                    if (excCondition.equalsModIrrelevantTermLabels((Object)normalExcDefinition)) {
                        normalConditions.add(leftTerm);
                        return;
                    } else {
                        if (!excCondition.equalsModIrrelevantTermLabels((Object)exceptionalExcDefinition)) throw new ProofInputException("Exeptional condition expected, implementation of UseOperationContractRule might have changed!");
                        exceptinalConditions.add(leftTerm);
                    }
                }
            }
        }
    }

    public static ContractPostOrExcPostExceptionVariableResult searchContractPostOrExcPostExceptionVariable(Node node, Services services) throws ProofInputException {
        Semisequent antecedent = node.sequent().antecedent();
        SequentFormula sf = antecedent.get(antecedent.size() - 1);
        Term workingTerm = sf.formula();
        Pair updatesAndTerm = TermBuilder.goBelowUpdates2((Term)workingTerm);
        workingTerm = (Term)updatesAndTerm.second;
        if (workingTerm.op() != Junctor.AND) {
            throw new ProofInputException("And operation expected, implementation of UseOperationContractRule might have changed!");
        }
        workingTerm = workingTerm.sub(1);
        Term exceptionDefinition = SymbolicExecutionUtil.searchExceptionDefinition(workingTerm = TermBuilder.goBelowUpdates((Term)workingTerm), services);
        if (exceptionDefinition == null) {
            throw new ProofInputException("Exception definition not found, implementation of UseOperationContractRule might have changed!");
        }
        Term exceptionEquality = exceptionDefinition.op() == Junctor.NOT ? exceptionDefinition.sub(0) : exceptionDefinition;
        return new ContractPostOrExcPostExceptionVariableResult(workingTerm, (Pair<ImmutableList<Term>, Term>)updatesAndTerm, exceptionDefinition, exceptionEquality);
    }

    private static Term searchExceptionDefinition(Term term, Services services) {
        if (term.op() == Equality.EQUALS && term.sub(0).op() instanceof LocationVariable && term.sub(0).toString().startsWith("exc_") && SymbolicExecutionUtil.isNullSort(term.sub(1).sort(), services) && services.getJavaInfo().isSubtype(services.getJavaInfo().getKeYJavaType(term.sub(0).sort()), services.getJavaInfo().getKeYJavaType("java.lang.Throwable"))) {
            return term;
        }
        Term result = null;
        for (int i = term.arity() - 1; result == null && i >= 0; --i) {
            result = SymbolicExecutionUtil.searchExceptionDefinition(term.sub(i), services);
        }
        return result;
    }

    private static Term computeLoopInvariantBuiltInRuleAppBranchCondition(Node parent, Node node, boolean simplify, boolean improveReadability) throws ProofInputException {
        if (!(parent.getAppliedRuleApp() instanceof LoopInvariantBuiltInRuleApp)) {
            throw new ProofInputException("Only LoopInvariantBuiltInRuleApp is allowed in branch computation but rule \"" + parent.getAppliedRuleApp() + "\" was found.");
        }
        int childIndex = CollectionUtil.indexOf((Iterator)parent.childrenIterator(), (Object)node);
        if (childIndex == 1 || childIndex == 2) {
            Term condition;
            Term modalityTerm;
            Term loopCondAndInv;
            LoopInvariantBuiltInRuleApp app = (LoopInvariantBuiltInRuleApp)parent.getAppliedRuleApp();
            Services services = parent.proof().getServices();
            Node useNode = parent.child(2);
            Semisequent antecedent = useNode.sequent().antecedent();
            Term invTerm = antecedent.get(antecedent.size() - 1).formula();
            Term loopConditionModalityTerm = SymbolicExecutionUtil.posInOccurrenceInOtherNode(parent, app.posInOccurrence(), node);
            Pair pair = TermBuilder.goBelowUpdates2((Term)loopConditionModalityTerm);
            loopConditionModalityTerm = (Term)pair.second;
            if (childIndex == 1) {
                if (loopConditionModalityTerm.op() != Junctor.IMP) {
                    throw new ProofInputException("Implementation of WhileInvariantRule has changed.");
                }
                loopConditionModalityTerm = loopConditionModalityTerm.sub(0);
            } else {
                if (loopConditionModalityTerm.op() != Modality.BOX) {
                    throw new ProofInputException("Implementation of WhileInvariantRule has changed.");
                }
                Term sub = loopConditionModalityTerm.sub(0);
                if (sub.op() != Junctor.IMP) {
                    throw new ProofInputException("Implementation of WhileInvariantRule has changed.");
                }
                loopConditionModalityTerm = services.getTermBuilder().box(loopConditionModalityTerm.javaBlock(), sub.sub(0));
            }
            if (loopConditionModalityTerm.op() != Modality.BOX || loopConditionModalityTerm.sub(0).op() != Equality.EQUALS || !(loopConditionModalityTerm.sub(0).sub(0).op() instanceof LocationVariable) || loopConditionModalityTerm.sub(0).sub(1).op() != (childIndex == 1 ? services.getTermBuilder().TRUE().op() : services.getTermBuilder().FALSE().op())) {
                throw new ProofInputException("Implementation of WhileInvariantRule has changed.");
            }
            invTerm = TermBuilder.goBelowUpdates((Term)invTerm);
            Term newTerm = loopCondAndInv = services.getTermBuilder().and(loopConditionModalityTerm.sub(0), invTerm);
            Term term = modalityTerm = childIndex == 1 ? services.getTermBuilder().box(loopConditionModalityTerm.javaBlock(), newTerm) : services.getTermBuilder().dia(loopConditionModalityTerm.javaBlock(), newTerm);
            if (simplify) {
                ProofEnvironment sideProofEnv = SymbolicExecutionSideProofUtil.cloneProofEnvironmentWithOwnOneStepSimplifier(parent.proof(), true);
                Sequent newSequent = SymbolicExecutionUtil.createSequentToProveWithNewSuccedent(parent, (Term)null, modalityTerm, (ImmutableList<Term>)((ImmutableList)pair.first), true);
                condition = SymbolicExecutionUtil.evaluateInSideProof(services, parent.proof(), sideProofEnv, newSequent, RESULT_LABEL, "Loop invariant branch condition computation on node " + parent.serialNr() + " for branch " + node.serialNr() + ".", "SPLITTING_OFF");
            } else {
                condition = services.getTermBuilder().applySequential((ImmutableList)pair.first, modalityTerm);
            }
            if (improveReadability) {
                condition = SymbolicExecutionUtil.improveReadability(condition, services);
            }
            return condition;
        }
        throw new ProofInputException("Branch condition of initially valid check is not supported.");
    }

    private static Term computeBlockContractBuiltInRuleAppBranchCondition(Node parent, Node node, boolean simplify, boolean improveReadability) throws ProofInputException {
        if (!(parent.getAppliedRuleApp() instanceof AbstractBlockContractBuiltInRuleApp)) {
            throw new ProofInputException("Only AbstractBlockContractBuiltInRuleApp is allowed in branch computation but rule \"" + parent.getAppliedRuleApp() + "\" was found.");
        }
        RuleApp app = parent.getAppliedRuleApp();
        int childIndex = CollectionUtil.indexOf((Iterator)parent.childrenIterator(), (Object)node);
        if (app instanceof BlockContractInternalBuiltInRuleApp && childIndex == 0) {
            return parent.proof().getServices().getTermBuilder().tt();
        }
        if (app instanceof BlockContractInternalBuiltInRuleApp && childIndex == 2 || app instanceof BlockContractExternalBuiltInRuleApp && childIndex == 1) {
            Services services = parent.proof().getServices();
            Semisequent antecedent = node.sequent().antecedent();
            Term condition = antecedent.get(antecedent.size() - 1).formula();
            if (simplify) {
                ProofEnvironment sideProofEnv = SymbolicExecutionSideProofUtil.cloneProofEnvironmentWithOwnOneStepSimplifier(parent.proof(), true);
                Sequent newSequent = SymbolicExecutionUtil.createSequentToProveWithNewSuccedent(parent, (Term)null, condition, null, true);
                condition = SymbolicExecutionUtil.evaluateInSideProof(services, parent.proof(), sideProofEnv, newSequent, RESULT_LABEL, "Block contract branch condition computation on node " + parent.serialNr() + " for branch " + node.serialNr() + ".", "SPLITTING_OFF");
            }
            if (improveReadability) {
                condition = SymbolicExecutionUtil.improveReadability(condition, services);
            }
            return condition;
        }
        throw new ProofInputException("Branch condition of precondition check is not supported.");
    }

    public static Term posInOccurrenceInOtherNode(Node original, PosInOccurrence pio, Node toApplyOn) {
        PosInOccurrence appliedPIO = SymbolicExecutionUtil.posInOccurrenceToOtherSequent(original, pio, toApplyOn);
        if (appliedPIO != null) {
            return appliedPIO.subTerm();
        }
        return null;
    }

    public static Term posInOccurrenceInOtherNode(Sequent original, PosInOccurrence pio, Sequent toApplyOn) {
        PosInOccurrence appliedPIO = SymbolicExecutionUtil.posInOccurrenceToOtherSequent(original, pio, toApplyOn);
        if (appliedPIO != null) {
            return appliedPIO.subTerm();
        }
        return null;
    }

    public static PosInOccurrence posInOccurrenceToOtherSequent(Node original, PosInOccurrence pio, Node toApplyTo) {
        if (original != null && toApplyTo != null) {
            return SymbolicExecutionUtil.posInOccurrenceToOtherSequent(original.sequent(), pio, toApplyTo.sequent());
        }
        return null;
    }

    public static PosInOccurrence posInOccurrenceToOtherSequent(Sequent original, PosInOccurrence pio, Sequent toApplyTo) {
        if (original != null && pio != null && toApplyTo != null) {
            SequentFormula originalSF = pio.sequentFormula();
            boolean antecendet = pio.isInAntec();
            int index = antecendet ? original.antecedent().indexOf(originalSF) : original.succedent().indexOf(originalSF);
            if (index >= 0) {
                SequentFormula toApplyToSF = (antecendet ? toApplyTo.antecedent() : toApplyTo.succedent()).get(index);
                return new PosInOccurrence(toApplyToSF, pio.posInTerm(), antecendet);
            }
            return null;
        }
        return null;
    }

    private static Term computeTacletAppBranchCondition(Node parent, Node node, boolean simplify, boolean improveReadability) throws ProofInputException {
        Term condition;
        if (!(parent.getAppliedRuleApp() instanceof TacletApp)) {
            throw new ProofInputException("Only TacletApp is allowed in branch computation but rule \"" + parent.getAppliedRuleApp() + "\" was found.");
        }
        TacletApp app = (TacletApp)parent.getAppliedRuleApp();
        Services services = node.proof().getServices();
        ImmutableList newAntecedents = SymbolicExecutionUtil.listNewSemisequentTerms(parent.sequent().antecedent(), node.sequent().antecedent());
        ImmutableList newSuccedents = SymbolicExecutionUtil.listNewSemisequentTerms(parent.sequent().succedent(), node.sequent().succedent());
        int childIndex = CollectionUtil.indexOf((Iterator)parent.childrenIterator(), (Object)node);
        TacletGoalTemplate goalTemplate = app.taclet().goalTemplates().size() + 1 == parent.childrenCount() ? (childIndex == 0 ? null : (TacletGoalTemplate)app.taclet().goalTemplates().take(app.taclet().goalTemplates().size() - childIndex).head()) : (TacletGoalTemplate)app.taclet().goalTemplates().take(app.taclet().goalTemplates().size() - 1 - childIndex).head();
        if (goalTemplate != null) {
            if (goalTemplate.replaceWithExpressionAsObject() instanceof Sequent) {
                if (NodeInfo.isSymbolicExecution((Taclet)app.taclet())) {
                    Object originalTerm;
                    Term replaceTerm;
                    Sequent sequent = (Sequent)goalTemplate.replaceWithExpressionAsObject();
                    for (SequentFormula sf : sequent.antecedent()) {
                        replaceTerm = SymbolicExecutionUtil.instantiateTerm(node, sf.formula(), app, services);
                        replaceTerm = services.getTermBuilder().applyUpdatePairsSequential(app.instantiations().getUpdateContext(), replaceTerm);
                        originalTerm = SymbolicExecutionUtil.findReplacement(node.sequent().antecedent(), app.posInOccurrence(), replaceTerm);
                        assert (originalTerm != null);
                        newAntecedents = newAntecedents.removeFirst(originalTerm);
                    }
                    for (SequentFormula sf : sequent.succedent()) {
                        replaceTerm = SymbolicExecutionUtil.instantiateTerm(node, sf.formula(), app, services);
                        replaceTerm = services.getTermBuilder().applyUpdatePairsSequential(app.instantiations().getUpdateContext(), replaceTerm);
                        originalTerm = SymbolicExecutionUtil.findReplacement(node.sequent().succedent(), app.posInOccurrence(), replaceTerm);
                        assert (originalTerm != null);
                        newSuccedents = newSuccedents.removeFirst(originalTerm);
                    }
                }
            } else if (goalTemplate.replaceWithExpressionAsObject() instanceof Term) {
                Term replaceTerm = (Term)goalTemplate.replaceWithExpressionAsObject();
                replaceTerm = SymbolicExecutionUtil.instantiateTerm(node, replaceTerm, app, services);
                Term originalTerm = SymbolicExecutionUtil.findReplacement(app.posInOccurrence().isInAntec() ? node.sequent().antecedent() : node.sequent().succedent(), app.posInOccurrence(), replaceTerm);
                assert (originalTerm != null);
                if (app.posInOccurrence().isInAntec()) {
                    newAntecedents = newAntecedents.removeFirst((Object)originalTerm);
                } else {
                    newSuccedents = newSuccedents.removeFirst((Object)originalTerm);
                }
                if (!NodeInfo.isSymbolicExecution((Taclet)app.taclet())) {
                    if (!(app instanceof PosTacletApp)) {
                        throw new ProofInputException("Only PosTacletApp are allowed with a replace term in branch computation but rule \"" + app + "\" was found.");
                    }
                    ImmutableSLList tempAntecedents = ImmutableSLList.nil();
                    ImmutableSLList tempSuccedents = ImmutableSLList.nil();
                    for (Term a : newAntecedents) {
                        tempAntecedents = tempAntecedents.append((Object)services.getTermBuilder().applyUpdatePairsSequential(app.instantiations().getUpdateContext(), a));
                    }
                    for (Term suc : newSuccedents) {
                        tempSuccedents = tempSuccedents.append((Object)services.getTermBuilder().applyUpdatePairsSequential(app.instantiations().getUpdateContext(), suc));
                    }
                    replaceTerm = SymbolicExecutionUtil.followPosInOccurrence(app.posInOccurrence(), originalTerm);
                    replaceTerm = services.getTermBuilder().equals(replaceTerm, app.posInOccurrence().subTerm());
                    replaceTerm = services.getTermBuilder().applyUpdatePairsSequential(app.instantiations().getUpdateContext(), replaceTerm);
                    if (!tempAntecedents.contains((Object)replaceTerm)) {
                        tempAntecedents = tempAntecedents.append((Object)replaceTerm);
                    }
                    newAntecedents = tempAntecedents;
                    newSuccedents = tempSuccedents;
                }
            } else if (goalTemplate.replaceWithExpressionAsObject() != null) {
                throw new ProofInputException("Expected replacement as Sequent or Term during branch condition computation but is \"" + goalTemplate.replaceWithExpressionAsObject() + "\".");
            }
        }
        Term newLeft = services.getTermBuilder().and(newAntecedents);
        Term newRight = services.getTermBuilder().or(newSuccedents);
        Term newLeftAndRight = services.getTermBuilder().and(newLeft, services.getTermBuilder().not(newRight));
        if (simplify) {
            ProofEnvironment sideProofEnv = SymbolicExecutionSideProofUtil.cloneProofEnvironmentWithOwnOneStepSimplifier(parent.proof(), true);
            Sequent newSequent = SymbolicExecutionUtil.createSequentToProveWithNewSuccedent(parent, null, (Term)null, newLeftAndRight, true);
            condition = SymbolicExecutionUtil.evaluateInSideProof(services, parent.proof(), sideProofEnv, newSequent, RESULT_LABEL, "Taclet branch condition computation on node " + parent.serialNr() + " for branch " + node.serialNr() + ".", "SPLITTING_OFF");
        } else {
            condition = newLeftAndRight;
        }
        if (improveReadability) {
            condition = SymbolicExecutionUtil.improveReadability(condition, services);
        }
        return condition;
    }

    private static ImmutableList<Term> listNewSemisequentTerms(Semisequent parent, Semisequent child) {
        HashSet<SequentFormula> parentSFs = new HashSet<SequentFormula>();
        for (SequentFormula sf : parent) {
            parentSFs.add(sf);
        }
        ImmutableSLList result = ImmutableSLList.nil();
        for (SequentFormula sf : child) {
            if (parentSFs.contains(sf)) continue;
            result = result.append((Object)sf.formula());
        }
        return result;
    }

    private static Term findReplacement(Semisequent semisequent, final PosInOccurrence posInOccurrence, final Term replaceTerm) {
        SequentFormula sf = (SequentFormula)CollectionUtil.search((Iterable)semisequent, (IFilter)new IFilter<SequentFormula>(){

            public boolean select(SequentFormula element) {
                return SymbolicExecutionUtil.checkReplaceTerm(element.formula(), posInOccurrence, replaceTerm);
            }
        });
        return sf != null ? sf.formula() : null;
    }

    private static boolean checkReplaceTerm(Term toCheck, PosInOccurrence posInOccurrence, Term replaceTerm) {
        Term termAtPio = SymbolicExecutionUtil.followPosInOccurrence(posInOccurrence, toCheck);
        if (termAtPio != null) {
            return termAtPio.equalsModRenaming(replaceTerm);
        }
        return false;
    }

    public static Term followPosInOccurrence(PosInOccurrence posInOccurrence, Term term) {
        boolean matches = true;
        IntIterator iter = posInOccurrence.posInTerm().iterator();
        while (matches && iter.hasNext()) {
            int index = iter.next();
            if (index < term.arity()) {
                term = term.sub(index);
                continue;
            }
            matches = false;
        }
        return matches ? term : null;
    }

    public static Term instantiateTerm(Node node, Term term, TacletApp tacletApp, Services services) {
        if (term != null) {
            SyntacticalReplaceVisitor visitor = new SyntacticalReplaceVisitor(new TermLabelState(), null, tacletApp.posInOccurrence(), tacletApp.instantiations(), null, (Rule)tacletApp.taclet(), (RuleApp)tacletApp, services);
            term.execPostOrder((Visitor)visitor);
            return visitor.getTerm();
        }
        return null;
    }

    private static Term evaluateInSideProof(Services services, Proof proof, ProofEnvironment sideProofEnvironment, Sequent sequentToProve, TermLabel label, String description, String splittingOption) throws ProofInputException {
        List<Pair<Term, Node>> resultValuesAndConditions = SymbolicExecutionSideProofUtil.computeResults(services, proof, sideProofEnvironment, sequentToProve, label, description, "METHOD_NONE", "LOOP_NONE", "QUERY_OFF", splittingOption, false);
        ImmutableSLList goalCondtions = ImmutableSLList.nil();
        for (Pair<Term, Node> pair : resultValuesAndConditions) {
            Term goalCondition = (Term)pair.first;
            goalCondition = SymbolicExecutionUtil.replaceSkolemConstants(((Node)pair.second).sequent(), goalCondition, services);
            goalCondition = SymbolicExecutionUtil.removeLabelRecursive(services.getTermFactory(), goalCondition, label);
            goalCondtions = goalCondtions.append((Object)goalCondition);
        }
        return services.getTermBuilder().and((Iterable)goalCondtions);
    }

    public static String getChoiceSetting(String key) {
        HashMap settings = ProofSettings.DEFAULT_SETTINGS.getChoiceSettings().getDefaultChoices();
        return (String)settings.get(key);
    }

    public static void setChoiceSetting(String key, String value) {
        HashMap settings = ProofSettings.DEFAULT_SETTINGS.getChoiceSettings().getDefaultChoices();
        LinkedHashMap<String, String> clone = new LinkedHashMap<String, String>();
        clone.putAll(settings);
        clone.put(key, value);
        ProofSettings.DEFAULT_SETTINGS.getChoiceSettings().setDefaultChoices(clone);
    }

    public static boolean isNull(Node node, Term additionalAntecedent, Term newSuccedent) throws ProofInputException {
        return SymbolicExecutionUtil.checkNull(node, additionalAntecedent, newSuccedent, true);
    }

    public static boolean isNotNull(Node node, Term additionalAntecedent, Term newSuccedent) throws ProofInputException {
        return SymbolicExecutionUtil.checkNull(node, additionalAntecedent, newSuccedent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkNull(Node node, Term additionalAntecedent, Term newSuccedent, boolean nullExpected) throws ProofInputException {
        assert (node != null);
        assert (newSuccedent != null);
        ProofEnvironment sideProofEnv = SymbolicExecutionSideProofUtil.cloneProofEnvironmentWithOwnOneStepSimplifier(node.proof(), true);
        TermBuilder tb = sideProofEnv.getServicesForEnvironment().getTermBuilder();
        Term isNull = tb.equals(newSuccedent, tb.NULL());
        Term isNotNull = tb.not(isNull);
        Sequent sequentToProve = SymbolicExecutionUtil.createSequentToProveWithNewSuccedent(node, additionalAntecedent, nullExpected ? isNull : isNotNull, false);
        ApplyStrategyInfo info = SymbolicExecutionSideProofUtil.startSideProof(node.proof(), sideProofEnv, sequentToProve, "METHOD_CONTRACT", "LOOP_INVARIANT", "QUERY_ON", "SPLITTING_NORMAL");
        try {
            boolean bl = !info.getProof().openEnabledGoals().isEmpty();
            return bl;
        }
        finally {
            SymbolicExecutionSideProofUtil.disposeOrStore("Null check on node " + node.serialNr() + ".", info);
        }
    }

    public static Sequent createSequentToProveWithNewSuccedent(Node node, PosInOccurrence pio, Term newSuccedent) {
        return SymbolicExecutionUtil.createSequentToProveWithNewSuccedent(node, pio, null, newSuccedent, false);
    }

    public static Sequent createSequentToProveWithNewSuccedent(Node node, Term additionalAntecedent, Term newSuccedent, boolean addResultLabel) {
        return SymbolicExecutionUtil.createSequentToProveWithNewSuccedent(node, node.getAppliedRuleApp() != null ? node.getAppliedRuleApp().posInOccurrence() : null, additionalAntecedent, newSuccedent, addResultLabel);
    }

    public static Sequent createSequentToProveWithNewSuccedent(Node node, PosInOccurrence pio, Term additionalAntecedent, Term newSuccedent, boolean addResultLabel) {
        if (pio != null) {
            ImmutableList originalUpdates;
            if (node.proof().root() == node) {
                originalUpdates = SymbolicExecutionUtil.computeRootElementaryUpdates(node);
            } else {
                Term originalModifiedFormula = pio.sequentFormula().formula();
                originalUpdates = (ImmutableList)TermBuilder.goBelowUpdates2((Term)originalModifiedFormula).first;
            }
            return SymbolicExecutionUtil.createSequentToProveWithNewSuccedent(node, pio, additionalAntecedent, newSuccedent, (ImmutableList<Term>)originalUpdates, addResultLabel);
        }
        return SymbolicExecutionUtil.createSequentToProveWithNewSuccedent(node, pio, additionalAntecedent, newSuccedent, null, addResultLabel);
    }

    public static ImmutableList<Term> computeRootElementaryUpdates(Node root) {
        ImmutableSLList result = ImmutableSLList.nil();
        Sequent sequent = root.sequent();
        for (SequentFormula sf : sequent.succedent()) {
            Term term = sf.formula();
            if (!Junctor.IMP.equals(term.op())) continue;
            result = result.prepend(SymbolicExecutionUtil.collectElementaryUpdates(term.sub(1)));
        }
        return result;
    }

    public static ImmutableList<Term> collectElementaryUpdates(Term term) {
        if (term.op() instanceof UpdateApplication) {
            Term updateTerm = UpdateApplication.getUpdate((Term)term);
            return SymbolicExecutionUtil.collectElementaryUpdates(updateTerm);
        }
        if (term.op() == UpdateJunctor.PARALLEL_UPDATE) {
            ImmutableSLList result = ImmutableSLList.nil();
            for (int i = 0; i < term.arity(); ++i) {
                result = result.prepend(SymbolicExecutionUtil.collectElementaryUpdates(term.sub(i)));
            }
            return result;
        }
        if (term.op() instanceof ElementaryUpdate) {
            return ImmutableSLList.nil().prepend((Object)term);
        }
        return ImmutableSLList.nil();
    }

    public static Sequent createSequentToProveWithNewSuccedent(Node node, Term additionalAntecedent, Term newSuccedent, ImmutableList<Term> updates, boolean addResultLabel) {
        return SymbolicExecutionUtil.createSequentToProveWithNewSuccedent(node, node.getAppliedRuleApp().posInOccurrence(), additionalAntecedent, newSuccedent, updates, addResultLabel);
    }

    public static Sequent createSequentToProveWithNewSuccedent(Node node, PosInOccurrence pio, Term additionalAntecedent, Term newSuccedent, ImmutableList<Term> updates, boolean addResultLabel) {
        Sequent sequentToProve;
        TermBuilder tb = node.proof().getServices().getTermBuilder();
        Term newSuccedentToProve = updates != null ? (newSuccedent != null ? tb.applySequential(updates, newSuccedent) : newSuccedent) : newSuccedent;
        Sequent originalSequentWithoutMethodFrame = SymbolicExecutionSideProofUtil.computeGeneralSequentToProve(node.sequent(), pio != null ? pio.sequentFormula() : null);
        Set<Term> skolemTerms = newSuccedentToProve != null ? SymbolicExecutionUtil.collectSkolemConstants(originalSequentWithoutMethodFrame, newSuccedentToProve) : SymbolicExecutionUtil.collectSkolemConstants(originalSequentWithoutMethodFrame, tb.parallel(updates));
        originalSequentWithoutMethodFrame = SymbolicExecutionUtil.removeAllUnusedSkolemEqualities(originalSequentWithoutMethodFrame, skolemTerms);
        if (addResultLabel) {
            TermFactory factory = node.proof().getServices().getTermFactory();
            Set<Term> skolemInNewTerm = SymbolicExecutionUtil.collectSkolemConstantsNonRecursive(newSuccedentToProve);
            originalSequentWithoutMethodFrame = SymbolicExecutionUtil.labelSkolemConstants(originalSequentWithoutMethodFrame, skolemInNewTerm, factory);
            newSuccedentToProve = SymbolicExecutionUtil.addLabelRecursiveToNonSkolem(factory, newSuccedentToProve, RESULT_LABEL);
        }
        Sequent sequent = sequentToProve = newSuccedentToProve != null ? originalSequentWithoutMethodFrame.addFormula(new SequentFormula(newSuccedentToProve), false, true).sequent() : originalSequentWithoutMethodFrame;
        if (additionalAntecedent != null) {
            sequentToProve = sequentToProve.addFormula(new SequentFormula(additionalAntecedent), true, false).sequent();
        }
        return sequentToProve;
    }

    protected static Sequent labelSkolemConstants(Sequent sequent, Set<Term> constantsToLabel, TermFactory factory) {
        for (SequentFormula sf : sequent.antecedent()) {
            Term newEquality;
            LinkedList<Term> newSubs;
            Term skolem;
            Term definition;
            Term equality;
            int skolemEquality = SymbolicExecutionUtil.checkSkolemEquality(sf);
            if (skolemEquality == -1) {
                equality = sf.formula();
                if (!constantsToLabel.contains(equality.sub(0))) continue;
                definition = SymbolicExecutionUtil.addLabelRecursiveToNonSkolem(factory, equality.sub(1), RESULT_LABEL);
                skolem = SymbolicExecutionUtil.addLabelRecursiveToNonSkolem(factory, equality.sub(0), RESULT_LABEL);
                newSubs = new LinkedList<Term>();
                newSubs.add(definition);
                newSubs.add(skolem);
                newEquality = factory.createTerm(equality.op(), new ImmutableArray(newSubs), equality.boundVars(), equality.javaBlock(), equality.getLabels());
                sequent = sequent.changeFormula(new SequentFormula(newEquality), new PosInOccurrence(sf, PosInTerm.getTopLevel(), true)).sequent();
                continue;
            }
            if (skolemEquality != 1 || !constantsToLabel.contains((equality = sf.formula()).sub(1))) continue;
            definition = SymbolicExecutionUtil.addLabelRecursiveToNonSkolem(factory, equality.sub(0), RESULT_LABEL);
            skolem = SymbolicExecutionUtil.addLabelRecursiveToNonSkolem(factory, equality.sub(1), RESULT_LABEL);
            newSubs = new LinkedList();
            newSubs.add(definition);
            newSubs.add(skolem);
            newEquality = factory.createTerm(equality.op(), new ImmutableArray(newSubs), equality.boundVars(), equality.javaBlock(), equality.getLabels());
            sequent = sequent.changeFormula(new SequentFormula(newEquality), new PosInOccurrence(sf, PosInTerm.getTopLevel(), true)).sequent();
        }
        return sequent;
    }

    private static Term addLabelRecursiveToNonSkolem(TermFactory tf, Term term, TermLabel label) {
        LinkedList<Term> newSubs = new LinkedList<Term>();
        for (Term oldSub : term.subs()) {
            newSubs.add(SymbolicExecutionUtil.addLabelRecursiveToNonSkolem(tf, oldSub, label));
        }
        if (SymbolicExecutionUtil.checkSkolemEquality(term) != 0 || SymbolicExecutionUtil.isSkolemConstant(term)) {
            return tf.createTerm(term.op(), new ImmutableArray(newSubs), term.boundVars(), term.javaBlock(), term.getLabels());
        }
        LinkedList<TermLabel> newLabels = new LinkedList<TermLabel>();
        for (TermLabel oldLabel : term.getLabels()) {
            newLabels.add(oldLabel);
        }
        newLabels.add(label);
        return tf.createTerm(term.op(), new ImmutableArray(newSubs), term.boundVars(), term.javaBlock(), new ImmutableArray(newLabels));
    }

    public static Term removeLabelRecursive(TermFactory tf, Term term, TermLabel label) {
        LinkedList<Term> newSubs = new LinkedList<Term>();
        ImmutableArray oldSubs = term.subs();
        for (Term oldSub : oldSubs) {
            newSubs.add(SymbolicExecutionUtil.removeLabelRecursive(tf, oldSub, label));
        }
        LinkedList<TermLabel> newLabels = new LinkedList<TermLabel>();
        ImmutableArray oldLabels = term.getLabels();
        for (TermLabel oldLabel : oldLabels) {
            if (oldLabel == label) continue;
            newLabels.add(oldLabel);
        }
        return tf.createTerm(term.op(), new ImmutableArray(newSubs), term.boundVars(), term.javaBlock(), new ImmutableArray(newLabels));
    }

    private static Set<Term> collectSkolemConstants(Sequent sequent, Term term) {
        if (term != null) {
            Set<Term> result = SymbolicExecutionUtil.collectSkolemConstantsNonRecursive(term);
            LinkedList<Term> toCheck = new LinkedList<Term>(result);
            while (!toCheck.isEmpty()) {
                Term skolemConstant = (Term)toCheck.remove(0);
                List<Term> replacements = SymbolicExecutionUtil.findSkolemReplacements(sequent, skolemConstant, null);
                for (Term replacement : replacements) {
                    Set<Term> checkResult = SymbolicExecutionUtil.collectSkolemConstantsNonRecursive(replacement);
                    for (Term checkConstant : checkResult) {
                        if (!result.add(checkConstant)) continue;
                        toCheck.add(checkConstant);
                    }
                }
            }
            return result;
        }
        return new HashSet<Term>();
    }

    private static Set<Term> collectSkolemConstantsNonRecursive(Term term) {
        final HashSet<Term> result = new HashSet<Term>();
        term.execPreOrder((Visitor)new DefaultVisitor(){

            public void visit(Term visited) {
                if (SymbolicExecutionUtil.isSkolemConstant(visited)) {
                    result.add(visited);
                }
            }
        });
        return result;
    }

    public static boolean isSkolemConstant(Term term) {
        return term.containsLabel(ParameterlessTermLabel.SELECT_SKOLEM_LABEL);
    }

    private static Sequent removeAllUnusedSkolemEqualities(Sequent sequent, Collection<Term> skolemConstants) {
        Sequent result = sequent;
        for (SequentFormula sf : sequent.antecedent()) {
            result = SymbolicExecutionUtil.removeAllUnusedSkolemEqualities(result, sf, true, skolemConstants);
        }
        for (SequentFormula sf : sequent.succedent()) {
            result = SymbolicExecutionUtil.removeAllUnusedSkolemEqualities(result, sf, false, skolemConstants);
        }
        return result;
    }

    private static Sequent removeAllUnusedSkolemEqualities(Sequent sequent, SequentFormula sf, boolean antecedent, Collection<Term> skolemConstants) {
        Term term = sf.formula();
        boolean remove = false;
        if (term.op() == Equality.EQUALS) {
            if (SymbolicExecutionUtil.isSkolemConstant(term.sub(0))) {
                boolean bl = remove = !skolemConstants.contains(term.sub(0));
            }
            if (!remove && SymbolicExecutionUtil.isSkolemConstant(term.sub(1))) {
                boolean bl = remove = !skolemConstants.contains(term.sub(1));
            }
        }
        if (remove) {
            return sequent.removeFormula(new PosInOccurrence(sf, PosInTerm.getTopLevel(), antecedent)).sequent();
        }
        return sequent;
    }

    public static int checkSkolemEquality(SequentFormula sf) {
        return SymbolicExecutionUtil.checkSkolemEquality(sf.formula());
    }

    public static int checkSkolemEquality(Term term) {
        if (term.op() == Equality.EQUALS) {
            if (SymbolicExecutionUtil.isSkolemConstant(term.sub(0))) {
                return -1;
            }
            if (SymbolicExecutionUtil.isSkolemConstant(term.sub(1))) {
                return 1;
            }
        }
        return 0;
    }

    public static Term replaceSkolemConstants(Sequent sequent, Term term, Services services) {
        int skolemCheck = SymbolicExecutionUtil.checkSkolemEquality(term);
        if (skolemCheck == -1) {
            TermBuilder tb = services.getTermBuilder();
            List<Term> replacements = SymbolicExecutionUtil.findSkolemReplacements(sequent, term.sub(0), term);
            if (!replacements.isEmpty()) {
                Term other = term.sub(1);
                LinkedList<Term> newTerms = new LinkedList<Term>();
                for (Term replacement : replacements) {
                    newTerms.add(tb.equals(replacement, other));
                }
                term = tb.and(newTerms);
                return SymbolicExecutionUtil.replaceSkolemConstants(sequent, term, services);
            }
            return services.getTermBuilder().tt();
        }
        if (skolemCheck == 1) {
            TermBuilder tb = services.getTermBuilder();
            List<Term> replacements = SymbolicExecutionUtil.findSkolemReplacements(sequent, term.sub(1), term);
            if (!replacements.isEmpty()) {
                Term other = term.sub(0);
                LinkedList<Term> newTerms = new LinkedList<Term>();
                for (Term replacement : replacements) {
                    newTerms.add(tb.equals(other, replacement));
                }
                term = tb.and(newTerms);
                return SymbolicExecutionUtil.replaceSkolemConstants(sequent, term, services);
            }
            return services.getTermBuilder().tt();
        }
        if (SymbolicExecutionUtil.isSkolemConstant(term)) {
            List<Term> replacements = SymbolicExecutionUtil.findSkolemReplacements(sequent, term, null);
            return !replacements.isEmpty() ? replacements.get(0) : term;
        }
        LinkedList<Term> newChildren = new LinkedList<Term>();
        boolean changed = false;
        for (int i = 0; i < term.arity(); ++i) {
            Term oldChild = term.sub(i);
            Term newChild = SymbolicExecutionUtil.replaceSkolemConstants(sequent, oldChild, services);
            if (newChild != oldChild) {
                changed = true;
            }
            newChildren.add(newChild);
        }
        if (changed) {
            if (term.op() == Junctor.NOT) {
                assert (newChildren.size() == 1);
                assert (term.boundVars().isEmpty());
                assert (term.javaBlock() == JavaBlock.EMPTY_JAVABLOCK);
                Term result = services.getTermBuilder().not((Term)newChildren.get(0));
                if (term.hasLabels()) {
                    result = services.getTermBuilder().label(result, term.getLabels());
                }
                return result;
            }
            if (term.op() == Junctor.OR) {
                assert (term.boundVars().isEmpty());
                assert (term.javaBlock() == JavaBlock.EMPTY_JAVABLOCK);
                Term result = services.getTermBuilder().or(newChildren);
                if (term.hasLabels()) {
                    result = services.getTermBuilder().label(result, term.getLabels());
                }
                return result;
            }
            if (term.op() == Junctor.AND) {
                assert (term.boundVars().isEmpty());
                assert (term.javaBlock() == JavaBlock.EMPTY_JAVABLOCK);
                Term result = services.getTermBuilder().and(newChildren);
                if (term.hasLabels()) {
                    result = services.getTermBuilder().label(result, term.getLabels());
                }
                return result;
            }
            if (term.op() == Junctor.IMP) {
                assert (newChildren.size() == 2);
                assert (term.boundVars().isEmpty());
                assert (term.javaBlock() == JavaBlock.EMPTY_JAVABLOCK);
                return services.getTermBuilder().imp((Term)newChildren.get(0), (Term)newChildren.get(1), term.getLabels());
            }
            return services.getTermFactory().createTerm(term.op(), new ImmutableArray(newChildren), term.boundVars(), term.javaBlock(), term.getLabels());
        }
        return term;
    }

    private static List<Term> findSkolemReplacements(Sequent sequent, Term skolemConstant, Term skolemEquality) {
        LinkedList<Term> result = new LinkedList<Term>();
        for (SequentFormula sf : sequent) {
            Term term = sf.formula();
            if (term == skolemEquality) continue;
            int skolemCheck = SymbolicExecutionUtil.checkSkolemEquality(term);
            if (skolemCheck == -1) {
                if (!term.sub(0).equalsModIrrelevantTermLabels((Object)skolemConstant)) continue;
                result.add(term.sub(1));
                continue;
            }
            if (skolemCheck != 1 || !term.sub(1).equalsModIrrelevantTermLabels((Object)skolemConstant)) continue;
            result.add(term.sub(0));
        }
        return result;
    }

    public static boolean isNullSort(Sort sort, Services services) {
        return sort instanceof NullSort;
    }

    public static boolean isStaticVariable(IProgramVariable programVariable) {
        return programVariable instanceof ProgramVariable && ((ProgramVariable)programVariable).isStatic();
    }

    public static Set<IProgramVariable> getProgramVariables(FieldDeclaration fd) {
        LinkedHashSet<IProgramVariable> result = new LinkedHashSet<IProgramVariable>();
        if (fd != null) {
            ImmutableArray specifications = fd.getFieldSpecifications();
            for (FieldSpecification spec : specifications) {
                result.add(spec.getProgramVariable());
            }
        }
        return result;
    }

    public static Term computePathCondition(Node node, boolean simplify, boolean improveReadability) throws ProofInputException {
        return SymbolicExecutionUtil.computePathCondition(null, node, simplify, improveReadability);
    }

    public static Term computePathCondition(Node parentNode, Node childNode, boolean simplify, boolean improveReadability) throws ProofInputException {
        if (childNode != null) {
            Services services = childNode.proof().getServices();
            Term pathCondition = services.getTermBuilder().tt();
            while (childNode != null && childNode != parentNode) {
                Node parent = childNode.parent();
                if (parent != null && parent.childrenCount() >= 2) {
                    Term branchCondition = SymbolicExecutionUtil.computeBranchCondition(childNode, simplify, improveReadability);
                    pathCondition = services.getTermBuilder().and(branchCondition, pathCondition);
                }
                childNode = parent;
            }
            if (services.getTermBuilder().ff().equalsModIrrelevantTermLabels((Object)pathCondition)) {
                throw new ProofInputException("Path condition computation failed because the result is false.");
            }
            return pathCondition;
        }
        return null;
    }

    public static boolean hasReferenceSort(Services services, Term term) {
        if (services != null && term != null) {
            return SymbolicExecutionUtil.hasReferenceSort(services, term.sort());
        }
        return false;
    }

    public static boolean hasReferenceSort(Services services, IProgramVariable var) {
        if (services != null && var != null) {
            return SymbolicExecutionUtil.hasReferenceSort(services, var.sort());
        }
        return false;
    }

    public static boolean hasReferenceSort(Services services, Sort sort) {
        KeYJavaType kjt;
        boolean referenceSort = false;
        if (services != null && sort != null && (kjt = services.getJavaInfo().getKeYJavaType(sort)) != null) {
            TypeConverter typeConverter = services.getTypeConverter();
            referenceSort = typeConverter.isReferenceType((Type)kjt) && (!(kjt.getJavaType() instanceof TypeDeclaration) || !((TypeDeclaration)kjt.getJavaType()).isLibraryClass());
        }
        return referenceSort;
    }

    public static String getDisplayString(IProgramVariable pv) {
        if (pv != null) {
            if (pv.name() instanceof ProgramElementName) {
                ProgramElementName name = (ProgramElementName)pv.name();
                if (SymbolicExecutionUtil.isStaticVariable(pv)) {
                    return name.toString();
                }
                return name.getProgramName();
            }
            return pv.name().toString();
        }
        return null;
    }

    public static IExecutionNode<?> getRoot(IExecutionNode<?> executionNode) {
        if (executionNode != null) {
            while (executionNode.getParent() != null) {
                executionNode = executionNode.getParent();
            }
            return executionNode;
        }
        return null;
    }

    public static IProgramVariable extractExceptionVariable(Proof proof) {
        JavaProgramElement updateContent;
        Term modalityTerm;
        Node root = proof.root();
        PosInOccurrence modalityTermPIO = SymbolicExecutionUtil.findModalityWithMinSymbolicExecutionLabelId(root.sequent());
        Term term = modalityTerm = modalityTermPIO != null ? modalityTermPIO.subTerm() : null;
        if (modalityTerm != null && (updateContent = (modalityTerm = TermBuilder.goBelowUpdates((Term)modalityTerm)).javaBlock().program()) instanceof StatementBlock) {
            Assignment assignment;
            StatementBlock catchBlock;
            Catch catchStatement;
            ImmutableArray updateContentBody = ((StatementBlock)updateContent).getBody();
            Try tryStatement = null;
            Iterator iter = updateContentBody.iterator();
            while (tryStatement == null && iter.hasNext()) {
                Statement next = (Statement)iter.next();
                if (!(next instanceof Try)) continue;
                tryStatement = (Try)next;
            }
            if (tryStatement != null && tryStatement.getBranchCount() == 1 && tryStatement.getBranchList().get(0) instanceof Catch && (catchStatement = (Catch)tryStatement.getBranchList().get(0)).getBody() instanceof StatementBlock && (catchBlock = (StatementBlock)catchStatement.getBody()).getBody().size() == 1 && catchBlock.getBody().get(0) instanceof Assignment && (assignment = (Assignment)catchBlock.getBody().get(0)).getFirstElement() instanceof IProgramVariable) {
                IProgramVariable var = (IProgramVariable)assignment.getFirstElement();
                return var;
            }
        }
        throw new IllegalStateException("Can't extract exception variable from proof.");
    }

    public static void updateStrategySettings(Proof proof, boolean useOperationContracts, boolean useLoopInvariants, boolean nonExecutionBranchHidingSideProofs, boolean aliasChecksImmediately) {
        if (proof != null && !proof.isDisposed()) {
            String methodTreatmentValue = useOperationContracts ? "METHOD_CONTRACT" : "METHOD_EXPAND";
            String loopTreatmentValue = useLoopInvariants ? "LOOP_INVARIANT" : "LOOP_EXPAND";
            String nonExecutionBranchHidingValue = nonExecutionBranchHidingSideProofs ? "SYMBOLIC_EXECUTION_NON_EXECUTION_BRANCH_HIDING_SIDE_PROOF" : "SYMBOLIC_EXECUTION_NON_EXECUTION_BRANCH_HIDING_OFF";
            String aliasChecksValue = aliasChecksImmediately ? "SYMBOLIC_EXECUTION_ALIAS_CHECK_IMMEDIATELY" : "SYMBOLIC_EXECUTION_ALIAS_CHECK_NEVER";
            StrategyProperties sp = proof.getSettings().getStrategySettings().getActiveStrategyProperties();
            sp.setProperty("METHOD_OPTIONS_KEY", methodTreatmentValue);
            sp.setProperty("LOOP_OPTIONS_KEY", loopTreatmentValue);
            sp.setProperty("SYMBOLIC_EXECUTION_NON_EXECUTION_BRANCH_HIDING_OPTIONS_KEY", nonExecutionBranchHidingValue);
            sp.setProperty("SYMBOLIC_EXECUTION_ALIAS_CHECK_OPTIONS_KEY", aliasChecksValue);
            SymbolicExecutionUtil.updateStrategySettings(proof, sp);
        }
    }

    public static void updateStrategySettings(Proof proof, StrategyProperties sp) {
        if (proof != null && !proof.isDisposed()) {
            assert (sp != null);
            ProofSettings.DEFAULT_SETTINGS.getStrategySettings().setActiveStrategyProperties(sp);
            proof.getSettings().getStrategySettings().setActiveStrategyProperties(sp);
        }
    }

    public static boolean isChoiceSettingInitialised() {
        return ProofSettings.isChoiceSettingInitialised();
    }

    public static boolean isLoopBodyTermination(final Node node, RuleApp ruleApp) {
        boolean result = false;
        if (ruleApp instanceof OneStepSimplifierRuleApp) {
            OneStepSimplifierRuleApp simplifierApp = (OneStepSimplifierRuleApp)ruleApp;
            if (simplifierApp.getProtocol() != null) {
                RuleApp terminationApp = (RuleApp)CollectionUtil.search((Iterable)simplifierApp.getProtocol(), (IFilter)new IFilter<RuleApp>(){

                    public boolean select(RuleApp element) {
                        return SymbolicExecutionUtil.isLoopBodyTermination(node, element);
                    }
                });
                result = terminationApp != null;
            }
        } else if (SymbolicExecutionUtil.hasLoopBodyTerminationLabel(ruleApp)) {
            if ("impRight".equals(MiscTools.getRuleDisplayName((RuleApp)ruleApp))) {
                result = true;
            } else {
                Term term = ruleApp.posInOccurrence().subTerm();
                if (term.op() == Junctor.IMP && term.sub(0).op() == Junctor.TRUE) {
                    result = true;
                }
            }
        }
        return result;
    }

    public static boolean isHeap(Operator op, HeapLDT heapLDT) {
        if (op instanceof SortedOperator) {
            final Sort opSort = ((SortedOperator)op).sort();
            return CollectionUtil.search((Iterable)heapLDT.getAllHeaps(), (IFilter)new IFilter<LocationVariable>(){

                public boolean select(LocationVariable element) {
                    return opSort == element.sort();
                }
            }) != null;
        }
        return false;
    }

    public static boolean isBaseHeap(Operator op, HeapLDT heapLDT) {
        return op == heapLDT.getHeapForName(HeapLDT.BASE_HEAP_NAME);
    }

    public static String getSourcePath(PositionInfo posInfo) {
        return MiscTools.getSourcePath((PositionInfo)posInfo);
    }

    public static boolean isSelect(Services services, Term term) {
        if (!SymbolicExecutionUtil.isNullSort(term.sort(), services)) {
            SortDependingFunction select = services.getTypeConverter().getHeapLDT().getSelect(term.sort(), (TermServices)services);
            return select == term.op();
        }
        return false;
    }

    public static boolean isNumber(Operator op) {
        if (op instanceof Function) {
            Object[] numbers = new String[]{"#", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "Z", "neglit"};
            Arrays.sort(numbers);
            int index = Arrays.binarySearch(numbers, op.name().toString());
            return index >= 0;
        }
        return false;
    }

    public static boolean isBoolean(Services services, Operator op) {
        BooleanLDT booleanLDT = services.getTypeConverter().getBooleanLDT();
        return booleanLDT.getFalseConst() == op || booleanLDT.getTrueConst() == op;
    }

    public static HashMap<String, String> getDefaultTacletOptions() {
        return MiscTools.getDefaultTacletOptions();
    }

    public static String formatTerm(Term term, Services services, boolean useUnicode, boolean usePrettyPrinting) {
        if ((useUnicode || usePrettyPrinting) && services != null) {
            NotationInfo ni = new NotationInfo();
            LogicPrinter logicPrinter = new LogicPrinter(new ProgramPrinter(null), ni, services, true);
            logicPrinter.getNotationInfo().refresh(services, usePrettyPrinting, useUnicode);
            try {
                logicPrinter.printTerm(term);
            }
            catch (IOException ioe) {
                LOGGER.debug("", (Throwable)ioe);
            }
            StringBuffer result = logicPrinter.result();
            if (result.charAt(result.length() - 1) == '\n') {
                result.deleteCharAt(result.length() - 1);
            }
            return result.toString();
        }
        return term != null ? TermLabel.removeIrrelevantLabels((Term)term, (Services)services).toString() : null;
    }

    public static boolean isUsePrettyPrinting() {
        return ProofIndependentSettings.isUsePrettyPrinting();
    }

    public static void setUsePrettyPrinting(boolean usePrettyPrinting) {
        ProofIndependentSettings.setUsePrettyPrinting((boolean)usePrettyPrinting);
    }

    public static boolean hasApplicableRules(Goal goal) {
        return Goal.hasApplicableRules((Goal)goal);
    }

    public static Pair<Integer, SourceElement> computeSecondStatement(RuleApp ruleApp) {
        if (ruleApp != null) {
            SourceElement firstStatement = NodeInfo.computeFirstStatement((RuleApp)ruleApp);
            LinkedList<StatementBlock> blocks = new LinkedList<StatementBlock>();
            int methodFrameCount = 0;
            if (firstStatement != null) {
                if (firstStatement instanceof StatementBlock) {
                    blocks.addFirst((StatementBlock)firstStatement);
                }
                SourceElement lastStatement = null;
                while (firstStatement instanceof ProgramPrefix && lastStatement != firstStatement) {
                    lastStatement = firstStatement;
                    firstStatement = firstStatement.getFirstElementIncludingBlocks();
                    if (lastStatement instanceof MethodFrame) {
                        blocks.clear();
                        ++methodFrameCount;
                    }
                    if (!(firstStatement instanceof StatementBlock)) continue;
                    blocks.addFirst((StatementBlock)firstStatement);
                }
            }
            StatementBlock block = null;
            while (!(blocks.isEmpty() || block != null && block.getChildCount() >= 2)) {
                block = (StatementBlock)blocks.removeFirst();
            }
            if (block != null && block.getChildCount() >= 2) {
                return new Pair((Object)methodFrameCount, (Object)block.getChildAt(1));
            }
            return new Pair((Object)methodFrameCount, null);
        }
        return null;
    }

    public static boolean equalsWithPosition(SourceElement first, SourceElement second) {
        if (first != null && second != null) {
            if (first instanceof While) {
                if (second instanceof While) {
                    return first.equals(second) && SymbolicExecutionUtil.equalsWithPosition((SourceElement)((While)first).getGuard(), (SourceElement)((While)second).getGuard());
                }
                return false;
            }
            return first.equals(second) && ObjectUtil.equals((Object)first.getPositionInfo(), (Object)second.getPositionInfo());
        }
        return first == null && second == null;
    }

    public static boolean containsStatement(ProgramElement toSearchIn, SourceElement toSearch, Services services) {
        if (toSearchIn != null) {
            ContainsStatementVisitor visitor = new ContainsStatementVisitor(toSearchIn, toSearch, services);
            visitor.start();
            return visitor.isContained();
        }
        return false;
    }

    public static Term createSelectTerm(IExecutionVariable variable) {
        Services services = variable.getServices();
        if (SymbolicExecutionUtil.isStaticVariable(variable.getProgramVariable())) {
            Function function = services.getTypeConverter().getHeapLDT().getFieldSymbolForPV((LocationVariable)variable.getProgramVariable(), services);
            return services.getTermBuilder().staticDot(variable.getProgramVariable().sort(), function);
        }
        if (variable.getParentValue() == null) {
            return services.getTermBuilder().var((ProgramVariable)variable.getProgramVariable());
        }
        Term parentTerm = variable.getParentValue().getVariable().createSelectTerm();
        if (variable.getProgramVariable() != null) {
            if (services.getJavaInfo().getArrayLength() == variable.getProgramVariable()) {
                Function function = services.getTypeConverter().getHeapLDT().getLength();
                return services.getTermBuilder().func(function, parentTerm);
            }
            Function function = services.getTypeConverter().getHeapLDT().getFieldSymbolForPV((LocationVariable)variable.getProgramVariable(), services);
            return services.getTermBuilder().dot(variable.getProgramVariable().sort(), parentTerm, function);
        }
        return services.getTermBuilder().dotArr(parentTerm, variable.getArrayIndex());
    }

    public static NotationInfo createNotationInfo(IExecutionElement element) {
        Proof proof = element != null ? element.getProof() : null;
        return SymbolicExecutionUtil.createNotationInfo(proof);
    }

    public static NotationInfo createNotationInfo(Node node) {
        Proof proof = node != null ? node.proof() : null;
        return SymbolicExecutionUtil.createNotationInfo(proof);
    }

    public static NotationInfo createNotationInfo(Proof proof) {
        NotationInfo notationInfo = new NotationInfo();
        if (proof != null && !proof.isDisposed()) {
            notationInfo.setAbbrevMap(proof.abbreviations());
        }
        return notationInfo;
    }

    public static boolean lazyComputeIsMainBranchVerified(Node node) {
        if (!node.proof().isDisposed()) {
            Term predicate = AbstractOperationPO.getUninterpretedPredicate((Proof)node.proof());
            if (predicate != null) {
                boolean verified = true;
                Iterator leafsIter = node.leavesIterator();
                while (verified && leafsIter.hasNext()) {
                    Node leaf = (Node)leafsIter.next();
                    if (leaf.isClosed()) continue;
                    final Term toSearch = predicate;
                    SequentFormula topLevelPredicate = (SequentFormula)CollectionUtil.search((Iterable)leaf.sequent().succedent(), (IFilter)new IFilter<SequentFormula>(){

                        public boolean select(SequentFormula element) {
                            return toSearch.op() == element.formula().op();
                        }
                    });
                    if (topLevelPredicate != null) continue;
                    verified = false;
                }
                return verified;
            }
            return node.isClosed();
        }
        return false;
    }

    public static boolean lazyComputeIsAdditionalBranchVerified(Node node) {
        if (!node.proof().isDisposed()) {
            Set additinalPredicates = AbstractOperationPO.getAdditionalUninterpretedPredicates((Proof)node.proof());
            if (!CollectionUtil.isEmpty((Collection)additinalPredicates)) {
                boolean verified = true;
                Iterator leafsIter = node.leavesIterator();
                while (verified && leafsIter.hasNext()) {
                    Node leaf = (Node)leafsIter.next();
                    if (leaf.isClosed()) continue;
                    final HashSet<Operator> additinalOperatos = new HashSet<Operator>();
                    for (Term term : additinalPredicates) {
                        additinalOperatos.add(term.op());
                    }
                    SequentFormula topLevelPredicate = (SequentFormula)CollectionUtil.search((Iterable)leaf.sequent().succedent(), (IFilter)new IFilter<SequentFormula>(){

                        public boolean select(SequentFormula element) {
                            return additinalOperatos.contains(element.formula().op());
                        }
                    });
                    if (topLevelPredicate != null) continue;
                    verified = false;
                }
                return verified;
            }
            return node.isClosed();
        }
        return false;
    }

    public static boolean lazyComputeIsExceptionalTermination(Node node, IProgramVariable exceptionVariable) {
        Sort result = SymbolicExecutionUtil.lazyComputeExceptionSort(node, exceptionVariable);
        return result != null && !(result instanceof NullSort);
    }

    public static Sort lazyComputeExceptionSort(Node node, IProgramVariable exceptionVariable) {
        Sort result = null;
        if (exceptionVariable != null) {
            ImmutableArray<Term> value = null;
            for (SequentFormula f : node.sequent().succedent()) {
                Pair updates = TermBuilder.goBelowUpdates2((Term)f.formula());
                Iterator iter = ((ImmutableList)updates.first).iterator();
                while (value == null && iter.hasNext()) {
                    value = SymbolicExecutionUtil.extractValueFromUpdate((Term)iter.next(), exceptionVariable);
                }
            }
            if (value != null && value.size() == 1) {
                result = ((Term)value.get(0)).sort();
            }
        }
        return result;
    }

    protected static ImmutableArray<Term> extractValueFromUpdate(Term term, IProgramVariable variable) {
        ImmutableArray<Term> result = null;
        if (term.op() instanceof ElementaryUpdate) {
            ElementaryUpdate update = (ElementaryUpdate)term.op();
            if (ObjectUtil.equals((Object)variable, (Object)update.lhs())) {
                result = term.subs();
            }
        } else if (term.op() instanceof UpdateJunctor) {
            Iterator iter = term.subs().iterator();
            while (result == null && iter.hasNext()) {
                result = SymbolicExecutionUtil.extractValueFromUpdate((Term)iter.next(), variable);
            }
        }
        return result;
    }

    public static void initializeStrategy(SymbolicExecutionTreeBuilder builder) {
        Proof proof = builder.getProof();
        StrategyProperties strategyProperties = proof.getSettings().getStrategySettings().getActiveStrategyProperties();
        if (builder.isUninterpretedPredicateUsed()) {
            proof.setActiveStrategy(new SymbolicExecutionStrategy.Factory().create(proof, strategyProperties));
        } else {
            proof.setActiveStrategy(new JavaCardDLStrategyFactory().create(proof, strategyProperties));
        }
    }

    public static boolean isBlockContractValidityBranch(RuleApp appliedRuleApp) {
        return appliedRuleApp != null && SymbolicExecutionUtil.isBlockContractValidityBranch(appliedRuleApp.posInOccurrence());
    }

    public static boolean isBlockContractValidityBranch(PosInOccurrence pio) {
        if (pio != null) {
            Term applicationTerm = TermBuilder.goBelowUpdates((Term)pio.subTerm());
            return applicationTerm.getLabel(BlockContractValidityTermLabel.NAME) != null;
        }
        return false;
    }

    public static boolean isJoin(RuleApp ruleApp) {
        return ruleApp instanceof MergeRuleBuiltInRuleApp && !((MergeRuleBuiltInRuleApp)ruleApp).getMergePartners().isEmpty();
    }

    public static boolean isCloseAfterJoin(RuleApp ruleApp) {
        return ruleApp instanceof CloseAfterMergeRuleBuiltInRuleApp;
    }

    public static boolean isWeakeningGoalEnabled(Proof proof) {
        if (proof != null && !proof.isDisposed()) {
            String value = (String)proof.getSettings().getChoiceSettings().getDefaultChoices().get("mergeGenerateIsWeakeningGoal");
            return "mergeGenerateIsWeakeningGoal:on".equals(value);
        }
        return false;
    }

    public static class ContractPostOrExcPostExceptionVariableResult {
        private Term workingTerm;
        private Pair<ImmutableList<Term>, Term> updatesAndTerm;
        private Term exceptionDefinition;
        private Term exceptionEquality;

        public ContractPostOrExcPostExceptionVariableResult(Term workingTerm, Pair<ImmutableList<Term>, Term> updatesAndTerm, Term exceptionDefinition, Term exceptionEquality) {
            this.workingTerm = workingTerm;
            this.updatesAndTerm = updatesAndTerm;
            this.exceptionDefinition = exceptionDefinition;
            this.exceptionEquality = exceptionEquality;
        }

        public Term getWorkingTerm() {
            return this.workingTerm;
        }

        public Pair<ImmutableList<Term>, Term> getUpdatesAndTerm() {
            return this.updatesAndTerm;
        }

        public Term getExceptionDefinition() {
            return this.exceptionDefinition;
        }

        public Term getExceptionEquality() {
            return this.exceptionEquality;
        }
    }

    private static final class FindModalityWithSymbolicExecutionLabelId
    extends DefaultVisitor {
        private PosInTerm posInTerm;
        private int maxId;
        private boolean maximum;
        private PosInTerm currentPosInTerm = null;
        private Deque<Integer> indexStack = new LinkedList<Integer>();

        public FindModalityWithSymbolicExecutionLabelId(boolean maximum) {
            this.maximum = maximum;
        }

        public void visit(Term visited) {
            SymbolicExecutionTermLabel label = SymbolicExecutionUtil.getSymbolicExecutionLabel(visited);
            if (label != null && (this.posInTerm == null || (this.maximum ? label.getId() > this.maxId : label.getId() < this.maxId))) {
                this.posInTerm = this.currentPosInTerm;
                this.maxId = label.getId();
            }
        }

        public void subtreeEntered(Term subtreeRoot) {
            if (this.currentPosInTerm == null) {
                this.currentPosInTerm = PosInTerm.getTopLevel();
            } else {
                int index = this.indexStack.getFirst();
                this.currentPosInTerm = this.currentPosInTerm.down(index);
            }
            this.indexStack.addFirst(0);
        }

        public void subtreeLeft(Term subtreeRoot) {
            this.currentPosInTerm = this.currentPosInTerm.up();
            this.indexStack.removeFirst();
            if (!this.indexStack.isEmpty()) {
                Integer nextIndex = this.indexStack.removeFirst();
                this.indexStack.addFirst(nextIndex + 1);
            }
        }

        public PosInTerm getPosInTerm() {
            return this.posInTerm;
        }
    }

    public static class SiteProofVariableValueInput {
        private Sequent sequentToProve;
        private Operator operator;

        public SiteProofVariableValueInput(Sequent sequentToProve, Operator operator) {
            this.sequentToProve = sequentToProve;
            this.operator = operator;
        }

        public Sequent getSequentToProve() {
            return this.sequentToProve;
        }

        public Operator getOperator() {
            return this.operator;
        }
    }
}

