/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.proof_references;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofVisitor;
import de.uka.ilkd.key.proof_references.analyst.ClassAxiomAndInvariantProofReferencesAnalyst;
import de.uka.ilkd.key.proof_references.analyst.ContractProofReferencesAnalyst;
import de.uka.ilkd.key.proof_references.analyst.IProofReferencesAnalyst;
import de.uka.ilkd.key.proof_references.analyst.MethodBodyExpandProofReferencesAnalyst;
import de.uka.ilkd.key.proof_references.analyst.MethodCallProofReferencesAnalyst;
import de.uka.ilkd.key.proof_references.analyst.ProgramVariableReferencesAnalyst;
import de.uka.ilkd.key.proof_references.reference.IProofReference;
import java.util.LinkedHashSet;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;
import org.key_project.util.java.CollectionUtil;
import org.key_project.util.java.IFilter;

public final class ProofReferenceUtil {
    public static final ImmutableList<IProofReferencesAnalyst> DEFAULT_ANALYSTS = ImmutableSLList.nil().append((Object[])new IProofReferencesAnalyst[]{new MethodBodyExpandProofReferencesAnalyst(), new MethodCallProofReferencesAnalyst(), new ContractProofReferencesAnalyst(), new ProgramVariableReferencesAnalyst(), new ClassAxiomAndInvariantProofReferencesAnalyst()});

    private ProofReferenceUtil() {
    }

    public static LinkedHashSet<IProofReference<?>> computeProofReferences(Proof proof) {
        return ProofReferenceUtil.computeProofReferences(proof, DEFAULT_ANALYSTS);
    }

    public static LinkedHashSet<IProofReference<?>> computeProofReferences(Proof proof, ImmutableList<IProofReferencesAnalyst> analysts) {
        if (proof != null) {
            Services services = proof.getServices();
            ReferenceAnalaystProofVisitor visitor = new ReferenceAnalaystProofVisitor(services, analysts);
            proof.breadthFirstSearch(proof.root(), (ProofVisitor)visitor);
            return visitor.getResult();
        }
        return new LinkedHashSet();
    }

    public static LinkedHashSet<IProofReference<?>> computeProofReferences(Node node, Services services) {
        return ProofReferenceUtil.computeProofReferences(node, services, DEFAULT_ANALYSTS);
    }

    public static LinkedHashSet<IProofReference<?>> computeProofReferences(Node node, Services services, ImmutableList<IProofReferencesAnalyst> analysts) {
        LinkedHashSet result = new LinkedHashSet();
        if (node != null && analysts != null) {
            for (IProofReferencesAnalyst analyst : analysts) {
                LinkedHashSet<IProofReference<?>> analystResult = analyst.computeReferences(node, services);
                if (analystResult == null) continue;
                ProofReferenceUtil.merge(result, analystResult);
            }
        }
        return result;
    }

    public static void merge(LinkedHashSet<IProofReference<?>> target, LinkedHashSet<IProofReference<?>> toAdd) {
        for (IProofReference iProofReference : toAdd) {
            ProofReferenceUtil.merge(target, iProofReference);
        }
    }

    public static void merge(LinkedHashSet<IProofReference<?>> target, final IProofReference<?> reference) {
        if (!target.add(reference)) {
            IProofReference existingFirst = (IProofReference)CollectionUtil.search(target, (IFilter)new IFilter<IProofReference<?>>(){

                public boolean select(IProofReference<?> element) {
                    return element.equals(reference);
                }
            });
            existingFirst.addNodes(reference.getNodes());
        }
    }

    private static class ReferenceAnalaystProofVisitor
    implements ProofVisitor {
        private Services services;
        private ImmutableList<IProofReferencesAnalyst> analysts;
        private LinkedHashSet<IProofReference<?>> result = new LinkedHashSet();

        public ReferenceAnalaystProofVisitor(Services services, ImmutableList<IProofReferencesAnalyst> analysts) {
            this.services = services;
            this.analysts = analysts;
        }

        public void visit(Proof proof, Node visitedNode) {
            ProofReferenceUtil.merge(this.result, ProofReferenceUtil.computeProofReferences(visitedNode, this.services, this.analysts));
        }

        public LinkedHashSet<IProofReference<?>> getResult() {
            return this.result;
        }
    }
}

