/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.proof_references.analyst;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.abstraction.KeYJavaType;
import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.init.ProofOblInput;
import de.uka.ilkd.key.proof_references.analyst.IProofReferencesAnalyst;
import de.uka.ilkd.key.proof_references.reference.DefaultProofReference;
import de.uka.ilkd.key.proof_references.reference.IProofReference;
import de.uka.ilkd.key.rule.PosTacletApp;
import de.uka.ilkd.key.rule.Taclet;
import de.uka.ilkd.key.speclang.ClassAxiom;
import de.uka.ilkd.key.speclang.ClassInvariant;
import de.uka.ilkd.key.speclang.PartialInvAxiom;
import de.uka.ilkd.key.util.MiscTools;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.key_project.util.collection.DefaultImmutableSet;
import org.key_project.util.collection.ImmutableSet;

public class ClassAxiomAndInvariantProofReferencesAnalyst
implements IProofReferencesAnalyst {
    @Override
    public LinkedHashSet<IProofReference<?>> computeReferences(Node node, Services services) {
        String name = MiscTools.getRuleName((Node)node);
        if (name != null && (name.toLowerCase().contains("axiom_for") || name.toLowerCase().contains("represents_clause_for")) && node.getAppliedRuleApp() instanceof PosTacletApp) {
            KeYJavaType proofKjt = this.findProofsKeYJavaType(services);
            if (proofKjt != null) {
                Name tacletName = ((PosTacletApp)node.getAppliedRuleApp()).taclet().name();
                ImmutableSet axioms = services.getSpecificationRepository().getClassAxioms(proofKjt);
                ClassAxiom found = null;
                Iterator axiomsIterator = axioms.iterator();
                while (found == null && axiomsIterator.hasNext()) {
                    ClassAxiom ca = (ClassAxiom)axiomsIterator.next();
                    DefaultImmutableSet toLimit = DefaultImmutableSet.nil();
                    ImmutableSet taclets = ca.getTaclets((ImmutableSet)toLimit, services);
                    Iterator tacletIterator = taclets.iterator();
                    while (found == null && tacletIterator.hasNext()) {
                        Taclet t = (Taclet)tacletIterator.next();
                        if (!t.name().equals((Object)tacletName)) continue;
                        found = ca;
                    }
                }
                if (found instanceof PartialInvAxiom) {
                    PartialInvAxiom axiom = (PartialInvAxiom)found;
                    DefaultProofReference<ClassInvariant> reference = new DefaultProofReference<ClassInvariant>("Use Invariant", node, axiom.getInv());
                    LinkedHashSet result = new LinkedHashSet();
                    result.add(reference);
                    return result;
                }
                if (found != null) {
                    DefaultProofReference<Object> reference = new DefaultProofReference<Object>("Use Axiom", node, found);
                    LinkedHashSet result = new LinkedHashSet();
                    result.add(reference);
                    return result;
                }
                throw new IllegalStateException("ClassAxiom for taclet \"" + name + "\" was not found applied in node \"" + node.serialNr() + "\".");
            }
            return null;
        }
        return null;
    }

    protected KeYJavaType findProofsKeYJavaType(Services services) {
        ProofOblInput problem = services.getSpecificationRepository().getProofOblInput(services.getProof());
        if (problem != null) {
            KeYJavaType type = problem.getContainerType();
            if (type == null) {
                throw new IllegalStateException("Problem \"" + problem + "\" is not supported.");
            }
            return type;
        }
        return null;
    }
}

