/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.proof_references.analyst;

import de.uka.ilkd.key.java.JavaTools;
import de.uka.ilkd.key.java.ProgramElement;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.abstraction.KeYJavaType;
import de.uka.ilkd.key.java.expression.Assignment;
import de.uka.ilkd.key.java.reference.ExecutionContext;
import de.uka.ilkd.key.java.reference.MethodReference;
import de.uka.ilkd.key.java.reference.TypeRef;
import de.uka.ilkd.key.logic.JavaBlock;
import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.ProgramElementName;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.TermBuilder;
import de.uka.ilkd.key.logic.op.IProgramMethod;
import de.uka.ilkd.key.logic.op.SchemaVariable;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.NodeInfo;
import de.uka.ilkd.key.proof_references.ProofReferenceUtil;
import de.uka.ilkd.key.proof_references.analyst.IProofReferencesAnalyst;
import de.uka.ilkd.key.proof_references.reference.DefaultProofReference;
import de.uka.ilkd.key.proof_references.reference.IProofReference;
import de.uka.ilkd.key.rule.PosTacletApp;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.util.MiscTools;
import java.util.LinkedHashSet;
import org.key_project.util.collection.ImmutableArray;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;

public class MethodCallProofReferencesAnalyst
implements IProofReferencesAnalyst {
    @Override
    public LinkedHashSet<IProofReference<?>> computeReferences(Node node, Services services) {
        String name = MiscTools.getRuleName((Node)node);
        if (name != null && name.toLowerCase().contains("methodcall")) {
            NodeInfo info = node.getNodeInfo();
            if (info != null) {
                if (info.getActiveStatement() instanceof MethodReference) {
                    ExecutionContext context = this.extractContext(node, services);
                    IProofReference<IProgramMethod> reference = this.createReference(node, services, context, (MethodReference)info.getActiveStatement());
                    LinkedHashSet result = new LinkedHashSet();
                    result.add(reference);
                    return result;
                }
                if (info.getActiveStatement() instanceof Assignment) {
                    Assignment assignment = (Assignment)info.getActiveStatement();
                    ExecutionContext context = this.extractContext(node, services);
                    LinkedHashSet result = new LinkedHashSet();
                    for (int i = 0; i < assignment.getChildCount(); ++i) {
                        ProgramElement child = assignment.getChildAt(i);
                        if (!(child instanceof MethodReference)) continue;
                        IProofReference<IProgramMethod> reference = this.createReference(node, services, context, (MethodReference)child);
                        ProofReferenceUtil.merge(result, reference);
                    }
                    return result;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    protected ExecutionContext extractContext(Node node, Services services) {
        RuleApp app = node.getAppliedRuleApp();
        PosInOccurrence pio = app.posInOccurrence();
        JavaBlock jb = TermBuilder.goBelowUpdates((Term)pio.subTerm()).javaBlock();
        return JavaTools.getInnermostExecutionContext((JavaBlock)jb, (Services)services);
    }

    protected IProofReference<IProgramMethod> createReference(Node node, Services services, ExecutionContext context, MethodReference mr) {
        if (context != null) {
            KeYJavaType refPrefixType = mr.determineStaticPrefixType(services, context);
            IProgramMethod pm = mr.method(services, refPrefixType, context);
            return new DefaultProofReference<IProgramMethod>("Call Method", node, pm);
        }
        if (!(node.getAppliedRuleApp() instanceof PosTacletApp)) {
            throw new IllegalArgumentException("PosTacletApp expected.");
        }
        if (!"staticMethodCallStaticWithAssignmentViaTypereference".equals(MiscTools.getRuleName((Node)node))) {
            throw new IllegalArgumentException("Rule \"staticMethodCallStaticWithAssignmentViaTypereference\" expected, but is \"" + MiscTools.getRuleName((Node)node) + "\".");
        }
        PosTacletApp app = (PosTacletApp)node.getAppliedRuleApp();
        SchemaVariable methodSV = app.instantiations().lookupVar(new Name("#mn"));
        SchemaVariable typeSV = app.instantiations().lookupVar(new Name("#t"));
        SchemaVariable argsSV = app.instantiations().lookupVar(new Name("#elist"));
        ProgramElementName method = (ProgramElementName)app.instantiations().getInstantiation(methodSV);
        TypeRef type = (TypeRef)app.instantiations().getInstantiation(typeSV);
        ImmutableArray args = (ImmutableArray)app.instantiations().getInstantiation(argsSV);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Empty argument list expected.");
        }
        IProgramMethod pm = services.getJavaInfo().getProgramMethod(type.getKeYJavaType(), method.toString(), (ImmutableList)ImmutableSLList.nil(), type.getKeYJavaType());
        return new DefaultProofReference<IProgramMethod>("Call Method", node, pm);
    }
}

