/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.proof_references.analyst;

import de.uka.ilkd.key.java.ExpressionContainer;
import de.uka.ilkd.key.java.ProgramElement;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.java.expression.operator.CopyAssignment;
import de.uka.ilkd.key.java.reference.FieldReference;
import de.uka.ilkd.key.java.reference.ReferencePrefix;
import de.uka.ilkd.key.java.statement.If;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof_references.ProofReferenceUtil;
import de.uka.ilkd.key.proof_references.analyst.IProofReferencesAnalyst;
import de.uka.ilkd.key.proof_references.reference.DefaultProofReference;
import de.uka.ilkd.key.proof_references.reference.IProofReference;
import java.util.LinkedHashSet;

public class ProgramVariableReferencesAnalyst
implements IProofReferencesAnalyst {
    @Override
    public LinkedHashSet<IProofReference<?>> computeReferences(Node node, Services services) {
        if (node.getAppliedRuleApp() != null && node.getNodeInfo() != null) {
            SourceElement statement = node.getNodeInfo().getActiveStatement();
            if (statement instanceof CopyAssignment) {
                LinkedHashSet result = new LinkedHashSet();
                this.listReferences(node, (ProgramElement)((CopyAssignment)statement), services.getJavaInfo().getArrayLength(), result, true);
                return result;
            }
            if (statement instanceof If) {
                LinkedHashSet result = new LinkedHashSet();
                this.listReferences(node, (ProgramElement)((If)statement).getExpression(), services.getJavaInfo().getArrayLength(), result, false);
                return result;
            }
            return null;
        }
        return null;
    }

    protected void listReferences(Node node, ProgramElement pe, ProgramVariable arrayLength, LinkedHashSet<IProofReference<?>> toFill, boolean includeExpressionContainer) {
        if (pe instanceof ProgramVariable) {
            ProgramVariable pv = (ProgramVariable)pe;
            if (pv.isMember()) {
                DefaultProofReference<ProgramVariable> reference = new DefaultProofReference<ProgramVariable>("Access", node, (ProgramVariable)pe);
                ProofReferenceUtil.merge(toFill, reference);
            }
        } else if (pe instanceof FieldReference) {
            ProgramVariable pv;
            FieldReference fr = (FieldReference)pe;
            ReferencePrefix ref = fr.getReferencePrefix();
            if (ref != null) {
                this.listReferences(node, (ProgramElement)ref, arrayLength, toFill, includeExpressionContainer);
            }
            if ((pv = fr.getProgramVariable()) != arrayLength) {
                DefaultProofReference<ProgramVariable> reference = new DefaultProofReference<ProgramVariable>("Access", node, pv);
                ProofReferenceUtil.merge(toFill, reference);
            }
        } else if (includeExpressionContainer && pe instanceof ExpressionContainer) {
            ExpressionContainer ec = (ExpressionContainer)pe;
            for (int i = ec.getChildCount() - 1; i >= 0; --i) {
                ProgramElement element = ec.getChildAt(i);
                this.listReferences(node, element, arrayLength, toFill, includeExpressionContainer);
            }
        }
    }
}

