/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.proof_references.reference;

import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof_references.reference.IProofReference;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.key_project.util.java.ObjectUtil;

public class DefaultProofReference<T>
implements IProofReference<T> {
    private String kind;
    private Proof source;
    private T target;
    private LinkedHashSet<Node> nodes = new LinkedHashSet();

    public DefaultProofReference(String kind, Node node, T target) {
        this.kind = kind;
        this.source = node != null ? node.proof() : null;
        this.target = target;
        this.nodes.add(node);
    }

    @Override
    public T getTarget() {
        return this.target;
    }

    @Override
    public LinkedHashSet<Node> getNodes() {
        return this.nodes;
    }

    @Override
    public void addNodes(Collection<Node> nodes) {
        this.nodes.addAll(nodes);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public Proof getSource() {
        return this.source;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IProofReference) {
            IProofReference other = (IProofReference)obj;
            return ObjectUtil.equals((Object)this.getKind(), (Object)other.getKind()) && ObjectUtil.equals((Object)this.getSource(), (Object)other.getSource()) && ObjectUtil.equals(this.getTarget(), other.getTarget());
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.getKind() != null ? this.getKind().hashCode() : 0);
        result = 31 * result + (this.getSource() != null ? this.getSource().hashCode() : 0);
        result = 31 * result + (this.getTarget() != null ? this.getTarget().hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getKind());
        sb.append(" Proof Reference to \"");
        sb.append(this.getTarget());
        sb.append("\"");
        if (!this.getNodes().isEmpty()) {
            sb.append(" at node(s) ");
            boolean afterFirst = false;
            for (Node node : this.getNodes()) {
                if (afterFirst) {
                    sb.append(", ");
                } else {
                    afterFirst = true;
                }
                sb.append(node.serialNr());
            }
        }
        if (this.getSource() != null) {
            sb.append(" of proof \"");
            sb.append(this.getSource());
            sb.append("\"");
        }
        return sb.toString();
    }
}

