/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.core;

import de.uka.ilkd.key.control.AutoModeListener;
import de.uka.ilkd.key.core.InterruptListener;
import de.uka.ilkd.key.core.KeYSelectionEvent;
import de.uka.ilkd.key.core.KeYSelectionListener;
import de.uka.ilkd.key.core.KeYSelectionModel;
import de.uka.ilkd.key.gui.GUIListener;
import de.uka.ilkd.key.gui.InspectorForDecisionPredicates;
import de.uka.ilkd.key.gui.notification.events.ExceptionFailureEvent;
import de.uka.ilkd.key.gui.notification.events.NotificationEvent;
import de.uka.ilkd.key.gui.notification.events.ProofClosedNotificationEvent;
import de.uka.ilkd.key.gui.utilities.CheckedUserInput;
import de.uka.ilkd.key.java.JavaInfo;
import de.uka.ilkd.key.java.ServiceCaches;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Choice;
import de.uka.ilkd.key.logic.Namespace;
import de.uka.ilkd.key.logic.NamespaceSet;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.Function;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.QuantifiableVariable;
import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.pp.NotationInfo;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofEvent;
import de.uka.ilkd.key.proof.ProofTreeAdapter;
import de.uka.ilkd.key.proof.ProofTreeEvent;
import de.uka.ilkd.key.proof.ProofTreeListener;
import de.uka.ilkd.key.proof.RuleAppListener;
import de.uka.ilkd.key.proof.delayedcut.DelayedCut;
import de.uka.ilkd.key.proof.delayedcut.DelayedCutListener;
import de.uka.ilkd.key.proof.delayedcut.DelayedCutProcessor;
import de.uka.ilkd.key.proof.init.AbstractProfile;
import de.uka.ilkd.key.proof.init.Profile;
import de.uka.ilkd.key.proof.io.AutoSaver;
import de.uka.ilkd.key.proof.join.JoinProcessor;
import de.uka.ilkd.key.proof.rulefilter.TacletFilter;
import de.uka.ilkd.key.prover.TaskFinishedInfo;
import de.uka.ilkd.key.prover.TaskStartedInfo;
import de.uka.ilkd.key.prover.impl.DefaultTaskFinishedInfo;
import de.uka.ilkd.key.prover.impl.DefaultTaskStartedInfo;
import de.uka.ilkd.key.rule.OneStepSimplifier;
import de.uka.ilkd.key.rule.RuleSet;
import de.uka.ilkd.key.rule.Taclet;
import de.uka.ilkd.key.settings.ProofSettings;
import de.uka.ilkd.key.ui.AbstractMediatorUserInterfaceControl;
import de.uka.ilkd.key.util.ThreadUtilities;
import java.util.EventObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.lookup.Lookup;

public class KeYMediator {
    private AbstractMediatorUserInterfaceControl ui;
    private final NotationInfo notationInfo;
    private EventListenerList listenerList = new EventListenerList();
    private KeYMediatorProofListener proofListener;
    private KeYMediatorProofTreeListener proofTreeListener;
    private KeYSelectionModel keySelectionModel;
    private TacletFilter filterForInteractiveProving;
    private AutoSaver autoSaver = AutoSaver.getDefaultInstance();
    private final DefaultListModel<Proof> currentlyOpenedProofs = new DefaultListModel();
    private boolean inAutoMode = false;
    private int goalsClosedByAutoMode = 0;
    @Nullable
    private Lookup userData;

    public KeYMediator(AbstractMediatorUserInterfaceControl ui) {
        this.ui = ui;
        this.notationInfo = new NotationInfo();
        this.proofListener = new KeYMediatorProofListener();
        this.proofTreeListener = new KeYMediatorProofTreeListener();
        this.keySelectionModel = new KeYSelectionModel();
        ui.getProofControl().addAutoModeListener(this.proofListener);
    }

    public NotationInfo getNotationInfo() {
        return this.notationInfo;
    }

    public Namespace<QuantifiableVariable> var_ns() {
        NamespaceSet namespaces = this.namespaces();
        return namespaces != null ? namespaces.variables() : null;
    }

    public Namespace<IProgramVariable> progVar_ns() {
        NamespaceSet namespaces = this.namespaces();
        return namespaces != null ? namespaces.programVariables() : null;
    }

    public Namespace<Function> func_ns() {
        NamespaceSet namespaces = this.namespaces();
        return namespaces != null ? namespaces.functions() : null;
    }

    public Namespace<Sort> sort_ns() {
        NamespaceSet namespaces = this.namespaces();
        return namespaces != null ? namespaces.sorts() : null;
    }

    public Namespace<RuleSet> heur_ns() {
        NamespaceSet namespaces = this.namespaces();
        return namespaces != null ? namespaces.ruleSets() : null;
    }

    public Namespace<Choice> choice_ns() {
        NamespaceSet namespaces = this.namespaces();
        return namespaces != null ? namespaces.choices() : null;
    }

    public NamespaceSet namespaces() {
        Proof selectedProof = this.getSelectedProof();
        return selectedProof != null ? selectedProof.getNamespaces() : null;
    }

    public JavaInfo getJavaInfo() {
        Proof selectedProof = this.getSelectedProof();
        return selectedProof != null ? selectedProof.getJavaInfo() : null;
    }

    public Services getServices() {
        Proof selectedProof = this.getSelectedProof();
        return selectedProof != null ? selectedProof.getServices() : null;
    }

    public void setAutoSave(int interval) {
        this.autoSaver = interval > 0 ? new AutoSaver(interval, true) : null;
    }

    public boolean ensureProofLoaded() {
        return this.getSelectedProof() != null;
    }

    public TacletFilter getFilterForInteractiveProving() {
        if (this.filterForInteractiveProving == null) {
            this.filterForInteractiveProving = new TacletFilter(){

                protected boolean filter(Taclet taclet) {
                    for (String name : JoinProcessor.SIMPLIFY_UPDATE) {
                        if (!name.equals(taclet.name().toString())) continue;
                        return false;
                    }
                    return true;
                }
            };
        }
        return this.filterForInteractiveProving;
    }

    public void setBack(Node node) {
        this.getUI().getProofControl().pruneTo(node);
        this.finishSetBack(node.proof());
    }

    public void setBack(Goal goal) {
        if (this.getSelectedProof() != null) {
            this.getUI().getProofControl().pruneTo(goal);
            this.finishSetBack(goal.proof());
        }
    }

    private void finishSetBack(final Proof proof) {
        DefaultTaskFinishedInfo info = new DefaultTaskFinishedInfo(this, null, proof, 0L, 0, this.getNrGoalsClosedByAutoMode()){

            public String toString() {
                return "Proof has been pruned: " + (String)(proof.openGoals().size() == 1 ? "one open goal remains." : proof.openGoals().size() + " open goals remain.");
            }
        };
        this.ui.taskFinished((TaskFinishedInfo)info);
        if (!proof.isDisposed()) {
            ServiceCaches caches = proof.getServices().getCaches();
            caches.getTermTacletAppIndexCache().clear();
            caches.getBetaCandidates().clear();
            caches.getIfThenElseMalusCache().clear();
        }
    }

    public void setProof(Proof p) {
        final Proof pp = p;
        if (SwingUtilities.isEventDispatchThread()) {
            this.setProofHelper(pp);
        } else {
            Runnable swingProzac = new Runnable(){

                @Override
                public void run() {
                    KeYMediator.this.setProofHelper(pp);
                }
            };
            ThreadUtilities.invokeAndWait(swingProzac);
        }
    }

    private void setProofHelper(Proof newProof) {
        Proof oldProof = this.getSelectedProof();
        if (oldProof != null) {
            oldProof.removeProofTreeListener((ProofTreeListener)this.proofTreeListener);
            oldProof.removeRuleAppListener((RuleAppListener)this.proofListener);
        }
        if (newProof != null) {
            this.notationInfo.setAbbrevMap(newProof.abbreviations());
        }
        if (newProof != null) {
            newProof.addProofTreeListener((ProofTreeListener)this.proofTreeListener);
            newProof.addRuleAppListener((RuleAppListener)this.proofListener);
        }
        if (this.getAutoSaver() != null) {
            this.getAutoSaver().setProof(newProof);
        }
        OneStepSimplifier.refreshOSS((Proof)newProof);
        this.keySelectionModel.setSelectedProof(newProof);
    }

    public void setMaxAutomaticSteps(int steps) {
        if (this.getSelectedProof() != null) {
            this.getSelectedProof().getSettings().getStrategySettings().setMaxSteps(steps);
        }
        ProofSettings.DEFAULT_SETTINGS.getStrategySettings().setMaxSteps(steps);
    }

    public int getMaxAutomaticSteps() {
        if (this.getSelectedProof() != null) {
            return this.getSelectedProof().getSettings().getStrategySettings().getMaxSteps();
        }
        return ProofSettings.DEFAULT_SETTINGS.getStrategySettings().getMaxSteps();
    }

    public void addKeYSelectionListener(KeYSelectionListener listener) {
        this.keySelectionModel.addKeYSelectionListener(listener);
    }

    public void addKeYSelectionListenerChecked(KeYSelectionListener listener) {
        this.keySelectionModel.addKeYSelectionListenerChecked(listener);
    }

    public void removeKeYSelectionListener(KeYSelectionListener listener) {
        this.keySelectionModel.removeKeYSelectionListener(listener);
    }

    public void addGUIListener(GUIListener listener) {
        this.listenerList.add(GUIListener.class, listener);
    }

    public void removeGUIListener(GUIListener listener) {
        this.listenerList.remove(GUIListener.class, listener);
    }

    public void addInterruptedListener(InterruptListener listener) {
        this.listenerList.add(InterruptListener.class, listener);
    }

    public void removeInterruptedListener(InterruptListener listener) {
        this.listenerList.remove(InterruptListener.class, listener);
    }

    public void goalChosen(Goal goal) {
        this.keySelectionModel.setSelectedGoal(goal);
    }

    public AbstractMediatorUserInterfaceControl getUI() {
        return this.ui;
    }

    public void nonGoalNodeChosen(Node node) {
        this.keySelectionModel.setSelectedNode(node);
    }

    public synchronized void requestModalAccess(Object src) {
        this.fireModalDialogOpened(new EventObject(src));
    }

    public synchronized void freeModalAccess(Object src) {
        this.fireModalDialogClosed(new EventObject(src));
    }

    public synchronized void fireModalDialogOpened(EventObject e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GUIListener.class) continue;
            ((GUIListener)listeners[i + 1]).modalDialogOpened(e);
        }
    }

    public synchronized void fireModalDialogClosed(EventObject e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GUIListener.class) continue;
            ((GUIListener)listeners[i + 1]).modalDialogClosed(e);
        }
    }

    public synchronized void fireShutDown(EventObject e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GUIListener.class) continue;
            ((GUIListener)listeners[i + 1]).shutDown(e);
        }
    }

    public Proof getSelectedProof() {
        return this.keySelectionModel.getSelectedProof();
    }

    public Goal getSelectedGoal() {
        return this.keySelectionModel.getSelectedGoal();
    }

    public KeYSelectionModel getSelectionModel() {
        return this.keySelectionModel;
    }

    public Node getSelectedNode() {
        return this.keySelectionModel.getSelectedNode();
    }

    public void interrupt() {
        for (InterruptListener listener : (InterruptListener[])this.listenerList.getListeners(InterruptListener.class)) {
            listener.interruptionPerformed();
        }
    }

    public void setInteractive(boolean b) {
        if (this.getSelectedProof() != null) {
            if (b) {
                this.getSelectedProof().setRuleAppIndexToInteractiveMode();
            } else {
                this.getSelectedProof().setRuleAppIndexToAutoMode();
            }
        }
    }

    public void closedAGoal() {
        ++this.goalsClosedByAutoMode;
    }

    public int getNrGoalsClosedByAutoMode() {
        return this.goalsClosedByAutoMode;
    }

    public void resetNrGoalsClosedByHeuristics() {
        this.goalsClosedByAutoMode = 0;
    }

    public void stopInterface(boolean fullStop) {
        final boolean b = fullStop;
        Runnable interfaceSignaller = new Runnable(){

            @Override
            public void run() {
                KeYMediator.this.ui.notifyAutoModeBeingStarted();
                if (b) {
                    KeYMediator.this.inAutoMode = true;
                    KeYMediator.this.getUI().getProofControl().fireAutoModeStarted(new ProofEvent(KeYMediator.this.getSelectedProof()));
                }
            }
        };
        ThreadUtilities.invokeAndWait(interfaceSignaller);
    }

    public void startInterface(boolean fullStop) {
        final boolean b = fullStop;
        Runnable interfaceSignaller = new Runnable(){

            @Override
            public void run() {
                if (b) {
                    KeYMediator.this.inAutoMode = false;
                    KeYMediator.this.getUI().getProofControl().fireAutoModeStopped(new ProofEvent(KeYMediator.this.getSelectedProof()));
                }
                KeYMediator.this.ui.notifyAutomodeStopped();
                if (KeYMediator.this.getSelectedProof() != null) {
                    KeYMediator.this.keySelectionModel.fireSelectedProofChanged();
                }
            }
        };
        ThreadUtilities.invokeOnEventQueue(interfaceSignaller);
    }

    public boolean isInAutoMode() {
        return this.inAutoMode;
    }

    public <T> T lookup(Class<T> service) {
        try {
            if (this.userData == null) {
                return null;
            }
            return (T)this.userData.get(service);
        }
        catch (IllegalStateException ignored) {
            return null;
        }
    }

    public <T> void register(T obj, Class<T> service) {
        this.getUserData().register(obj, service);
    }

    public <T> void deregister(T obj, Class<T> service) {
        if (this.userData != null) {
            this.userData.deregister(obj, service);
        }
    }

    @Nonnull
    public Lookup getUserData() {
        if (this.userData == null) {
            this.userData = new Lookup();
        }
        return this.userData;
    }

    public void enableWhenProofLoaded(final Action a) {
        a.setEnabled(this.getSelectedProof() != null);
        this.addKeYSelectionListener(new KeYSelectionListener(){

            @Override
            public void selectedNodeChanged(KeYSelectionEvent e) {
            }

            @Override
            public void selectedProofChanged(KeYSelectionEvent e) {
                a.setEnabled(e.getSource().getSelectedProof() != null);
            }
        });
    }

    @Deprecated
    public void enableWhenProofLoaded(final AbstractButton a) {
        a.setEnabled(this.getSelectedProof() != null);
        this.addKeYSelectionListener(new KeYSelectionListener(){

            @Override
            public void selectedNodeChanged(KeYSelectionEvent e) {
            }

            @Override
            public void selectedProofChanged(KeYSelectionEvent e) {
                a.setEnabled(e.getSource().getSelectedProof() != null);
            }
        });
    }

    public void notify(NotificationEvent event) {
        this.ui.notify(event);
    }

    public Profile getProfile() {
        Proof selectedProof = this.getSelectedProof();
        if (selectedProof != null) {
            return selectedProof.getServices().getProfile();
        }
        return AbstractProfile.getDefaultProfile();
    }

    public long getAutomaticApplicationTimeout() {
        if (this.getSelectedProof() != null) {
            return this.getSelectedProof().getSettings().getStrategySettings().getTimeout();
        }
        return ProofSettings.DEFAULT_SETTINGS.getStrategySettings().getTimeout();
    }

    public void setAutomaticApplicationTimeout(long timeout) {
        if (this.getSelectedProof() != null) {
            this.getSelectedProof().getSettings().getStrategySettings().setTimeout(timeout);
        }
        ProofSettings.DEFAULT_SETTINGS.getStrategySettings().setTimeout(timeout);
    }

    public boolean processDelayedCut(final Node invokedNode) {
        if (this.ensureProofLoaded()) {
            String result = CheckedUserInput.showAsDialog("Cut Formula", "Please supply a formula:", null, "", new InspectorForDecisionPredicates(this.getSelectedProof().getServices(), invokedNode, 0, DelayedCutProcessor.getApplicationChecks()), true);
            if (result == null) {
                return false;
            }
            Term formula = InspectorForDecisionPredicates.translate(this.getSelectedProof().getServices(), result);
            DelayedCutProcessor processor = new DelayedCutProcessor(this.getSelectedProof(), invokedNode, formula, 0);
            processor.add(new DelayedCutListener(){

                public void eventRebuildingTree(final int currentTacletNumber, final int totalNumber) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            KeYMediator.this.ui.taskStarted((TaskStartedInfo)new DefaultTaskStartedInfo(TaskStartedInfo.TaskKind.Other, "Rebuilding...", totalNumber));
                            KeYMediator.this.ui.taskProgress(currentTacletNumber);
                        }
                    });
                }

                public void eventEnd(DelayedCut cutInformation) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            KeYMediator.this.ui.resetStatus(this);
                            KeYMediator.this.startInterface(true);
                        }
                    });
                }

                public void eventCutting() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            KeYMediator.this.ui.taskStarted((TaskStartedInfo)new DefaultTaskStartedInfo(TaskStartedInfo.TaskKind.Other, "Cutting...", 0));
                        }
                    });
                }

                public void eventException(Throwable throwable) {
                    KeYMediator.this.startInterface(true);
                    throwable.printStackTrace();
                    KeYMediator.this.notify(new ExceptionFailureEvent("The cut couldnot be processed successfully. In order to preserve consistency the proof is pruned. For more information see details or output of your console.", throwable));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            KeYMediator.this.getSelectedProof().pruneProof(invokedNode);
                        }
                    });
                }
            });
            this.stopInterface(true);
            Thread thread = new Thread((Runnable)processor, "DelayedCutListener");
            thread.start();
        }
        return true;
    }

    public AutoSaver getAutoSaver() {
        return this.autoSaver;
    }

    @Nonnull
    public DefaultListModel<Proof> getCurrentlyOpenedProofs() {
        return this.currentlyOpenedProofs;
    }

    class KeYMediatorSelectionListener
    implements KeYSelectionListener {
        KeYMediatorSelectionListener() {
        }

        @Override
        public void selectedNodeChanged(KeYSelectionEvent e) {
        }

        @Override
        public void selectedProofChanged(KeYSelectionEvent e) {
            KeYMediator.this.setProof(e.getSource().getSelectedProof());
        }
    }

    private final class KeYMediatorProofListener
    implements RuleAppListener,
    AutoModeListener {
        private KeYMediatorProofListener() {
        }

        public void ruleApplied(ProofEvent e) {
            if (KeYMediator.this.isInAutoMode()) {
                return;
            }
            if (e.getSource() == KeYMediator.this.getSelectedProof()) {
                KeYMediator.this.keySelectionModel.defaultSelection();
            }
        }

        public void autoModeStarted(ProofEvent e) {
            KeYMediator.this.resetNrGoalsClosedByHeuristics();
        }

        public void autoModeStopped(ProofEvent e) {
        }
    }

    class KeYMediatorProofTreeListener
    extends ProofTreeAdapter {
        private boolean pruningInProcess;

        KeYMediatorProofTreeListener() {
        }

        public void proofClosed(ProofTreeEvent e) {
            Proof p = e.getSource();
            assert (p.name().equals((Object)KeYMediator.this.getSelectedProof().name()));
            assert (p.closed());
            KeYMediator.this.notify(new ProofClosedNotificationEvent(e.getSource()));
        }

        public void proofPruningInProcess(ProofTreeEvent e) {
            this.pruningInProcess = true;
        }

        public void proofPruned(final ProofTreeEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!e.getSource().find(KeYMediator.this.getSelectedNode())) {
                        KeYMediator.this.keySelectionModel.setSelectedNode(e.getNode());
                    }
                }
            });
            OneStepSimplifier.refreshOSS((Proof)e.getSource());
            this.pruningInProcess = false;
        }

        public void proofGoalsAdded(ProofTreeEvent e) {
            ImmutableList newGoals = e.getGoals();
            if (newGoals.size() == 0) {
                KeYMediator.this.closedAGoal();
            }
        }

        public void proofStructureChanged(ProofTreeEvent e) {
            if (KeYMediator.this.isInAutoMode() || this.pruningInProcess) {
                return;
            }
            Proof p = e.getSource();
            if (p == KeYMediator.this.getSelectedProof()) {
                Node sel_node = KeYMediator.this.getSelectedNode();
                if (!p.find(sel_node)) {
                    KeYMediator.this.keySelectionModel.defaultSelection();
                } else {
                    KeYMediator.this.keySelectionModel.setSelectedNode(sel_node);
                }
            }
        }
    }
}

