/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.core;

import de.uka.ilkd.key.core.KeYSelectionEvent;
import de.uka.ilkd.key.core.KeYSelectionListener;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeYSelectionModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeYSelectionModel.class);
    private Proof proof;
    private boolean goalIsValid = false;
    private Goal selectedGoal;
    private Node selectedNode;
    private final List<KeYSelectionListener> listenerList;
    private final KeYSelectionEvent selectionEvent = new KeYSelectionEvent(this);

    public KeYSelectionModel() {
        this.listenerList = Collections.synchronizedList(new ArrayList(5));
    }

    public void setProof(Proof p) {
        this.proof = Objects.requireNonNull(p);
        Goal g = (Goal)this.proof.openGoals().iterator().next();
        if (g == null) {
            this.selectedNode = (Node)this.proof.root().leavesIterator().next();
        } else {
            this.goalIsValid = true;
            this.selectedNode = g.node();
            this.selectedGoal = g;
        }
    }

    public void setSelectedProof(Proof p) {
        this.goalIsValid = false;
        this.proof = p;
        if (this.proof != null) {
            Goal g = (Goal)this.proof.openGoals().iterator().next();
            if (g == null) {
                this.selectedNode = (Node)this.proof.root().leavesIterator().next();
            } else {
                this.goalIsValid = true;
                this.selectedNode = g.node();
                this.selectedGoal = g;
            }
        } else {
            this.selectedNode = null;
            this.selectedGoal = null;
        }
        this.fireSelectedProofChanged();
    }

    public Proof getSelectedProof() {
        return this.proof;
    }

    public void setSelectedNode(Node n) {
        this.goalIsValid = false;
        this.selectedNode = n;
        this.fireSelectedNodeChanged();
    }

    public void setSelectedGoal(Goal g) {
        this.goalIsValid = true;
        this.selectedGoal = g;
        this.selectedNode = g.node();
        this.fireSelectedNodeChanged();
    }

    public Node getSelectedNode() {
        return this.selectedNode;
    }

    public Goal getSelectedGoal() {
        if (this.proof == null) {
            throw new IllegalStateException("No proof loaded.");
        }
        if (!this.goalIsValid) {
            this.selectedGoal = this.proof.getGoal(this.selectedNode);
            this.goalIsValid = true;
        }
        return this.selectedGoal;
    }

    public boolean isGoal() {
        if (!this.goalIsValid) {
            return this.getSelectedGoal() != null;
        }
        return this.selectedGoal != null;
    }

    public void defaultSelection() {
        Goal g = null;
        Goal firstG = null;
        DefaultSelectionIterator it = new DefaultSelectionIterator();
        while (g == null && it.hasNext()) {
            g = (Goal)it.next();
            if (firstG != null) continue;
            firstG = g;
        }
        if (g != null) {
            this.setSelectedGoal(g);
        } else if (firstG != null) {
            this.setSelectedGoal(firstG);
        } else {
            this.setSelectedNode((Node)this.proof.root().leavesIterator().next());
        }
    }

    public void nearestOpenGoalSelection(Node old) {
        Node n;
        for (n = old; n != null && n.isClosed(); n = n.parent()) {
        }
        if (n == null) {
            if (this.proof.find(old)) {
                this.setSelectedNode(old);
            } else {
                this.setSelectedNode(this.proof.root());
            }
        } else {
            Goal g = this.getFirstOpenGoalBelow(n);
            if (g == null || g.node() == null) {
                this.setSelectedNode(this.proof.root());
            } else {
                this.setSelectedGoal(g);
            }
        }
    }

    private Goal getFirstOpenGoalBelow(Node n) {
        Iterator it = n.leavesIterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (node.isClosed()) continue;
            return this.proof.getGoal(node);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeYSelectionListenerChecked(KeYSelectionListener listener) {
        List<KeYSelectionListener> list = this.listenerList;
        synchronized (list) {
            if (!this.listenerList.contains(listener)) {
                this.addKeYSelectionListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeYSelectionListener(KeYSelectionListener listener) {
        List<KeYSelectionListener> list = this.listenerList;
        synchronized (list) {
            LOGGER.debug("Adding {}", listener.getClass());
            this.listenerList.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeYSelectionListener(KeYSelectionListener listener) {
        List<KeYSelectionListener> list = this.listenerList;
        synchronized (list) {
            LOGGER.debug("Removing {}", listener.getClass());
            this.listenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fireSelectedNodeChanged() {
        List<KeYSelectionListener> list = this.listenerList;
        synchronized (list) {
            for (KeYSelectionListener listener : this.listenerList) {
                listener.selectedNodeChanged(this.selectionEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fireSelectedProofChanged() {
        List<KeYSelectionListener> list = this.listenerList;
        synchronized (list) {
            LOGGER.info("Selected Proof changed, firing...");
            for (KeYSelectionListener listener : this.listenerList) {
                listener.selectedProofChanged(this.selectionEvent);
            }
            LOGGER.info("Selected Proof changed, done firing.");
        }
    }

    protected class DefaultSelectionIterator
    implements Iterator<Goal> {
        private static final int POS_START = 0;
        private static final int POS_LEAVES = 1;
        private static final int POS_GOAL_LIST = 2;
        private int currentPos = 0;
        private Goal nextOne;
        private Iterator<Goal> goalIt;
        private Iterator<Node> nodeIt;

        public DefaultSelectionIterator() {
            this.findNext();
        }

        private void findNext() {
            this.nextOne = null;
            while (this.nextOne == null) {
                switch (this.currentPos) {
                    case 0: {
                        this.currentPos = 1;
                        if (KeYSelectionModel.this.selectedNode != null) {
                            this.nodeIt = KeYSelectionModel.this.selectedNode.leavesIterator();
                            break;
                        }
                        this.nodeIt = null;
                        break;
                    }
                    case 1: {
                        if (this.nodeIt == null || !this.nodeIt.hasNext()) {
                            this.currentPos = 2;
                            if (!KeYSelectionModel.this.proof.openGoals().isEmpty()) {
                                this.goalIt = KeYSelectionModel.this.proof.openGoals().iterator();
                                break;
                            }
                            this.goalIt = null;
                            break;
                        }
                        this.nextOne = KeYSelectionModel.this.proof.getGoal(this.nodeIt.next());
                        break;
                    }
                    case 2: {
                        if (this.goalIt == null || !this.goalIt.hasNext()) {
                            return;
                        }
                        this.nextOne = this.goalIt.next();
                    }
                }
            }
        }

        @Override
        public Goal next() {
            Goal res = this.nextOne;
            this.findNext();
            return res;
        }

        @Override
        public boolean hasNext() {
            return this.nextOne != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

