/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.core;

import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.filter.Filter;
import de.uka.ilkd.key.settings.PathConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log {
    public static final Logger GLOG = LoggerFactory.getLogger((String)"key");
    public static final Logger LDEVEL = LoggerFactory.getLogger((String)"key.devel");
    private static final Logger LOGGER = LoggerFactory.getLogger(Log.class);

    public static Path getCurrentLogFile() {
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        FileAppender fileAppend = (FileAppender)root.getAppender("FILE");
        return Paths.get(fileAppend.getFile(), new String[0]);
    }

    public static void configureLogging(int verbosity) {
        Runtime.getRuntime().addShutdownHook(new Thread(Log::cleanOldLogFiles));
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        Appender consoleAppender = root.getAppender("STDOUT");
        consoleAppender.clearAllFilters();
        ThresholdFilter filter = new ThresholdFilter();
        consoleAppender.addFilter((Filter)filter);
        switch (verbosity) {
            case 4: {
                filter.setLevel("TRACE");
                break;
            }
            case 3: {
                filter.setLevel("DEBUG");
                break;
            }
            case 2: {
                filter.setLevel("INFO");
                break;
            }
            case 1: {
                filter.setLevel("ERROR");
                break;
            }
            case 0: {
                filter.setLevel("OFF");
                break;
            }
            default: {
                filter.setLevel("WARN");
            }
        }
        filter.start();
    }

    private static void cleanOldLogFiles() {
        Path logDir = PathConfig.getLogDirectory().toPath();
        try {
            Stream<Path> files = Files.list(logDir);
            Duration duration = Duration.of(14L, ChronoUnit.DAYS);
            Instant refDate = Instant.now().minus(duration);
            files.forEach(file -> {
                try {
                    FileTime creationTime = (FileTime)Files.getAttribute(file, "creationTime", new LinkOption[0]);
                    Instant dt = creationTime.toInstant();
                    if (dt.isBefore(refDate)) {
                        LOGGER.info("Log file {} is marked for delete as it is older than {} days.", file, (Object)duration);
                        Files.delete(file);
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Could not delete log file {}", file, (Object)e);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Could not read logging directory", (Throwable)e);
        }
    }
}

