/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.core;

import de.uka.ilkd.key.core.DefaultKeYDesktop;
import de.uka.ilkd.key.core.KeYDesktop;
import de.uka.ilkd.key.core.Log;
import de.uka.ilkd.key.core.WebstartMain;
import de.uka.ilkd.key.gui.ExampleChooser;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.RecentFileMenu;
import de.uka.ilkd.key.gui.lemmatagenerator.LemmataAutoModeOptions;
import de.uka.ilkd.key.gui.lemmatagenerator.LemmataHandler;
import de.uka.ilkd.key.macros.ProofMacro;
import de.uka.ilkd.key.macros.SkipMacro;
import de.uka.ilkd.key.proof.init.AbstractProfile;
import de.uka.ilkd.key.proof.io.AutoSaver;
import de.uka.ilkd.key.settings.GeneralSettings;
import de.uka.ilkd.key.settings.PathConfig;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.ProofSettings;
import de.uka.ilkd.key.ui.AbstractMediatorUserInterfaceControl;
import de.uka.ilkd.key.ui.ConsoleUserInterfaceControl;
import de.uka.ilkd.key.util.CommandLine;
import de.uka.ilkd.key.util.CommandLineException;
import de.uka.ilkd.key.util.Debug;
import de.uka.ilkd.key.util.KeYConstants;
import de.uka.ilkd.key.util.rifl.RIFLTransformer;
import java.awt.SplashScreen;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.key_project.util.java.IOUtil;
import org.key_project.util.reflection.ClassLoaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import recoder.ParserException;

public final class Main {
    private static final String HELP = "--help";
    private static final String SHOW_PROPERTIES = "--show-properties";
    private static final String AUTO = "--auto";
    private static final String LAST = "--last";
    private static final String AUTO_LOADONLY = "--auto-loadonly";
    private static final String AUTOSAVE = "--autosave";
    private static final String EXPERIMENTAL = "--experimental";
    private static final String NO_PRUNING_CLOSED = "--no-pruning-closed";
    private static final String KEEP_FILEREPOS = "--keep-fileRepos";
    private static final String DEBUG = "--debug";
    private static final String MACRO = "--macro";
    private static final String NO_JMLSPECS = "--no-jmlspecs";
    private static final String TACLET_DIR = "--tacletDir";
    public static final String JUSTIFY_RULES = "--justify-rules";
    private static final String SAVE_ALL_CONTRACTS = "--save-all";
    private static final String TIMEOUT = "--timeout";
    private static final String EXAMPLES = "--examples";
    private static final String RIFL = "--rifl";
    public static final String JKEY_PREFIX = "--jr-";
    public static final String JMAX_RULES = "--jr-maxRules";
    public static final String JPATH_OF_RESULT = "--jr-pathOfResult";
    public static final String JTIMEOUT = "--jr-timeout";
    public static final String JPRINT = "--jr-print";
    public static final String JSAVE_RESULTS_TO_FILE = "--jr-saveProofToFile";
    public static final String JFILE_FOR_AXIOMS = "--jr-axioms";
    public static final String JFILE_FOR_DEFINITION = "--jr-signature";
    private static final String VERBOSITY = "--verbose";
    private static KeYDesktop keyDesktop = new DefaultKeYDesktop();
    private static byte verbosity = 1;
    private static String examplesDir = null;
    private static UiMode uiMode = UiMode.INTERACTIVE;
    private static boolean loadOnly = false;
    private static CommandLine cl;
    private static boolean loadRecentFile;
    private static List<File> fileArguments;
    private static boolean experimentalMode;
    private static File riflFileName;
    private static boolean saveAllContracts;
    private static ProofMacro autoMacro;
    private static final Logger LOGGER;
    public static boolean showExampleChooserIfExamplesDirIsDefined;

    public static void main(String[] args) {
        Locale.setDefault(Locale.US);
        if (Boolean.getBoolean("key.verbose-ui")) {
            verbosity = (byte)4;
        }
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        try {
            cl = Main.createCommandLine();
            cl.parse(args);
            Main.evaluateOptions(cl);
            fileArguments = cl.getFileArguments();
            fileArguments = Main.preProcessInput(fileArguments);
            AbstractMediatorUserInterfaceControl userInterface = Main.createUserInterface(fileArguments);
            Main.loadCommandLineFiles(userInterface, fileArguments);
        }
        catch (ExceptionInInitializerError e) {
            LOGGER.error("D'oh! It seems that KeY was not built properly!", (Throwable)e);
            System.exit(777);
        }
        catch (CommandLineException e) {
            Main.printHeader();
            LOGGER.error("Error in parsing the command: {}", (Object)e.getMessage());
            Main.printUsageAndExit(true, e.getMessage(), -1);
        }
    }

    private static void logInformation() {
        LOGGER.debug("Java Version: {}", (Object)System.getProperty("java.version"));
        LOGGER.debug("Java Runtime: {}", (Object)System.getProperty("java.specification.version"));
        LOGGER.debug("Java VM: {}", (Object)System.getProperty("java.vm"));
        LOGGER.debug("OS: {}", (Object)System.getProperty("java.os"));
        LOGGER.debug("Hardware: {}", (Object)System.getProperty("java.hw"));
        Runtime rt = Runtime.getRuntime();
        LOGGER.debug("Total memory: {} MB", (Object)((double)rt.totalMemory() / 1048576.0));
        LOGGER.debug("Maximum memory:  {} MB", (Object)((double)rt.maxMemory() / 1048576.0));
        LOGGER.debug("Free memory: {} MB", (Object)((double)rt.freeMemory() / 1048576.0));
        LOGGER.debug("Available processors: {}", (Object)rt.availableProcessors());
    }

    public static void loadCommandLineFiles(AbstractMediatorUserInterfaceControl ui, List<File> fileArguments) {
        if (!fileArguments.isEmpty()) {
            ui.setMacro(autoMacro);
            ui.setSaveOnly(saveAllContracts);
            for (File f : fileArguments) {
                ui.loadProblem(f);
            }
            if (ui instanceof ConsoleUserInterfaceControl) {
                System.exit(((ConsoleUserInterfaceControl)ui).allProofsSuccessful ? 0 : 1);
            }
        } else if (Main.getExamplesDir() != null && showExampleChooserIfExamplesDirIsDefined && ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().getShowLoadExamplesDialog()) {
            ui.openExamples();
        }
    }

    private static CommandLine createCommandLine() {
        CommandLine cl = new CommandLine();
        cl.setIndentation(3);
        cl.addSection("Using KeY");
        cl.addText("Usage: ./key [options] [filename]\n\n", false);
        cl.addSection("Options for the KeY-Prover");
        cl.addOption(HELP, null, "display this text");
        cl.addTextPart("--K-help", "display help for technical/debug parameters\n", true);
        cl.addOption(SHOW_PROPERTIES, null, "list all Java properties and exit");
        cl.addOption(LAST, null, "start prover with last loaded problem (only possible with GUI)");
        cl.addOption(AUTOSAVE, "<number>", "save intermediate proof states each n proof steps to a temporary location (default: 0 = off)");
        cl.addOption(EXPERIMENTAL, null, "switch experimental features on");
        cl.addOption(NO_PRUNING_CLOSED, null, "disables pruning and goal back in closed branches (saves memory)");
        cl.addOption(KEEP_FILEREPOS, null, "disables the automatic deletion of temporarydirectories of file repos (for debugging)");
        cl.addSection("Batchmode options:");
        cl.addOption(TACLET_DIR, "<dir>", "load base taclets from a directory, not from internal structures");
        cl.addOption(DEBUG, null, "start KeY in debug mode");
        cl.addOption(AUTO, null, "start automatic prove procedure after initialisation without GUI");
        cl.addOption(AUTO_LOADONLY, null, "load files automatically without proving (for testing)");
        cl.addOption(VERBOSITY, "<number>", "verbosity (default: 1)");
        cl.addOption(NO_JMLSPECS, null, "disable parsing JML specifications");
        cl.addOption(EXAMPLES, "<directory>", "load the directory containing the example files on startup");
        cl.addOption(RIFL, "<filename>", "load RIFL specifications from file (requires GUI and startup file)");
        cl.addOption(MACRO, "<proofMacro>", "apply automatic proof macro");
        cl.addOption(SAVE_ALL_CONTRACTS, null, "save all selected contracts for automatic execution");
        cl.addOption(TIMEOUT, "<timeout>", "timeout for each automatic proof of a problem in ms (default: -1, i.e., no timeout)");
        cl.addSection("Options for justify rules:");
        cl.addOption(JUSTIFY_RULES, "<filename>", "autoprove taclets (options always with prefix --jr) needs the path to the rule file as argument");
        cl.addText("\n", true);
        cl.addText("The '--justify-rules' option has a number of additional parameters you can set.", false);
        cl.addText("The following options only apply if '--justify-rules' is used.", false);
        cl.addText("\n", true);
        cl.addOption(JMAX_RULES, "<number>", "maximum number of rule application to perform (default: 10000)");
        cl.addOption(JPATH_OF_RESULT, "<path>", "store proofs to this folder");
        cl.addOption(JTIMEOUT, "<timeout>", "the timeout for proof of a taclet in ms (default: -1)");
        cl.addOption(JPRINT, "<terminal/disable>", "send output to terminal or disable output");
        cl.addOption(JSAVE_RESULTS_TO_FILE, "<true/false>", "save or drop proofs (then stored to path given by --jr-pathOfResult)");
        cl.addOption(JFILE_FOR_AXIOMS, "<filename>", "read axioms from given file");
        cl.addOption(JFILE_FOR_DEFINITION, "<filename>", "read definitions from given file");
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void evaluateOptions(CommandLine cl) {
        if (cl.isSet(EXPERIMENTAL)) {
            if (verbosity > 0) {
                LOGGER.info("Running in experimental mode ...");
            }
            Main.setEnabledExperimentalFeatures(true);
        } else {
            Main.setEnabledExperimentalFeatures(false);
        }
        if (cl.isSet(VERBOSITY)) {
            try {
                verbosity = (byte)cl.getInteger(VERBOSITY, 3);
            }
            catch (CommandLineException e) {
                if (Debug.ENABLE_DEBUG) {
                    e.printStackTrace();
                }
                LOGGER.warn(e.getMessage());
            }
        }
        Log.configureLogging(verbosity);
        Main.logInformation();
        if (verbosity > 0) {
            Main.printHeader();
        }
        if (cl.isSet(SHOW_PROPERTIES)) {
            try {
                Properties props = System.getProperties();
                for (Map.Entry<Object, Object> e : props.entrySet()) {
                    LOGGER.info("Property: {} = {}", e.getKey(), e.getValue());
                }
            }
            finally {
                System.exit(0);
            }
        }
        if (cl.isSet(AUTO)) {
            uiMode = UiMode.AUTO;
        }
        if (cl.isSet(AUTO_LOADONLY)) {
            uiMode = UiMode.AUTO;
            loadOnly = true;
        }
        if (cl.isSet(AUTOSAVE)) {
            try {
                int eachSteps = cl.getInteger(AUTOSAVE, 0);
                if (eachSteps < 0) {
                    Main.printUsageAndExit(false, "Illegal autosave period (must be a number >= 0)", -5);
                }
                AutoSaver.setDefaultValues((int)eachSteps, (uiMode == UiMode.INTERACTIVE ? 1 : 0) != 0);
            }
            catch (CommandLineException e) {
                if (Debug.ENABLE_DEBUG) {
                    e.printStackTrace();
                }
                LOGGER.warn(e.getMessage());
            }
        }
        if (cl.isSet(HELP)) {
            Main.printUsageAndExit(true, null, 0);
        }
        if (cl.isSet(NO_JMLSPECS)) {
            GeneralSettings.disableSpecs = true;
        }
        if (cl.isSet(TIMEOUT)) {
            if (verbosity >= 3) {
                LOGGER.info("Timeout is set");
            }
            long timeout = -1L;
            try {
                timeout = cl.getLong(TIMEOUT, -1L);
                if (verbosity >= 3) {
                    LOGGER.info("Timeout is: {} ms", (Object)timeout);
                }
            }
            catch (CommandLineException e) {
                if (Debug.ENABLE_DEBUG) {
                    e.printStackTrace();
                }
                LOGGER.warn(e.getMessage());
            }
            if (timeout < -1L) {
                Main.printUsageAndExit(false, "Illegal timeout (must be a number >= -1)", -5);
            }
            ProofSettings.DEFAULT_SETTINGS.getStrategySettings().setTimeout(timeout);
        }
        if (cl.isSet(EXAMPLES)) {
            examplesDir = cl.getString(EXAMPLES, null);
        }
        if (verbosity > 0) {
            if (Debug.ENABLE_DEBUG) {
                LOGGER.info("Running in debug mode");
            }
            if (Debug.ENABLE_ASSERTION) {
                LOGGER.info("Using assertions");
            } else {
                LOGGER.info("Not using assertions");
            }
        }
        if (cl.isSet(EXPERIMENTAL)) {
            if (verbosity > 0) {
                LOGGER.info("Running in experimental mode ...");
            }
            Main.setEnabledExperimentalFeatures(true);
        } else {
            Main.setEnabledExperimentalFeatures(false);
        }
        if (cl.isSet(RIFL)) {
            riflFileName = new File(cl.getString(RIFL, null));
            if (verbosity > 0) {
                LOGGER.info("[RIFL] Loading RIFL specification from {}", (Object)riflFileName);
            }
        }
        if (cl.isSet(LAST)) {
            loadRecentFile = true;
        }
        if (cl.isSet(JUSTIFY_RULES)) {
            Main.evaluateLemmataOptions(cl);
        }
        if (cl.isSet(DEBUG)) {
            Debug.ENABLE_DEBUG = true;
        }
        if (cl.isSet(MACRO)) {
            String macro = cl.getString(MACRO, "");
            for (ProofMacro m : ClassLoaderUtil.loadServices(ProofMacro.class)) {
                if (!macro.equals(m.getClass().getSimpleName())) continue;
                try {
                    autoMacro = (ProofMacro)m.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (InstantiationException e) {
                    LOGGER.warn("Automatic proof macro can not be instantiated!");
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    LOGGER.warn("Automatic proof macro can not be accessed!");
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    LOGGER.warn("Automatic proof macro can not be invoked!");
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    LOGGER.warn("Automatic proof macro can not be called!");
                    e.printStackTrace();
                }
                break;
            }
            if (macro.equals("") || autoMacro instanceof SkipMacro) {
                LOGGER.warn("No automatic proof macro specified.");
            }
        }
        if (cl.isSet(SAVE_ALL_CONTRACTS)) {
            saveAllContracts = true;
        }
        if (cl.isSet(TACLET_DIR)) {
            System.setProperty("org.key_project.stdTacletDirectory", cl.getString(TACLET_DIR, ""));
        }
        if (cl.isSet(NO_PRUNING_CLOSED)) {
            GeneralSettings.noPruningClosed = false;
        }
        if (cl.isSet(KEEP_FILEREPOS)) {
            GeneralSettings.keepFileRepos = true;
        }
    }

    public static void setEnabledExperimentalFeatures(boolean state) {
        experimentalMode = state;
        LOGGER.info("Experimental Features: {}", (Object)state);
    }

    public static boolean isExperimentalMode() {
        return experimentalMode;
    }

    private static void printHeader() {
        LOGGER.info("KeY Version {}", (Object)KeYConstants.VERSION);
        LOGGER.info("\u00a9 Copyright 2001\u20132021 Karlsruhe Institute of Technology, Chalmers University of Technology, and Technische Universit\u00e4t Darmstadt");
        LOGGER.info("KeY is protected by the GNU General Public License");
    }

    private static AbstractMediatorUserInterfaceControl createUserInterface(List<File> fileArguments) {
        RecentFileMenu.RecentFileEntry mostRecent;
        if (uiMode == UiMode.AUTO) {
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    if (verbosity > 0) {
                        String msg;
                        LOGGER.error("Auto mode was terminated by an exception:", e);
                        if (verbosity >= 4) {
                            e.printStackTrace();
                        }
                        if ((msg = e.getMessage()) != null) {
                            LOGGER.info(msg);
                        }
                    }
                    System.exit(-1);
                }
            });
            if (fileArguments.isEmpty()) {
                Main.printUsageAndExit(true, "Error: No file to load from.", -4);
            }
            return new ConsoleUserInterfaceControl(verbosity, loadOnly);
        }
        Main.updateSplashScreen();
        GeneralSettings.noPruningClosed = cl.isSet(NO_PRUNING_CLOSED);
        MainWindow mainWindow = MainWindow.getInstance();
        if (loadRecentFile && (mostRecent = mainWindow.getRecentFiles().getMostRecent()) != null) {
            File mostRecentFile = new File(mostRecent.getAbsolutePath());
            if (mostRecentFile.exists()) {
                fileArguments.add(mostRecentFile);
            } else {
                LOGGER.info("File does not exist anymore: {}", (Object)mostRecentFile);
            }
        }
        Main.ensureExamplesAvailable();
        return mainWindow.getUserInterface();
    }

    public static void ensureExamplesAvailable() {
        File examplesDir;
        File file = examplesDir = Main.getExamplesDir() == null ? ExampleChooser.lookForExamples() : new File(Main.getExamplesDir());
        if (examplesDir.exists()) {
            Main.setExamplesDir(examplesDir.getAbsolutePath());
        } else {
            Main.setExamplesDir(WebstartMain.setupExamples().getAbsolutePath());
        }
    }

    private static void updateSplashScreen() {
        try {
            SplashScreen sp = SplashScreen.getSplashScreen();
            if (sp == null) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void evaluateLemmataOptions(CommandLine options) {
        try {
            LemmataAutoModeOptions opt = new LemmataAutoModeOptions(options, KeYConstants.INTERNAL_VERSION, PathConfig.getKeyConfigDir());
            LemmataHandler handler = new LemmataHandler(opt, AbstractProfile.getDefaultProfile());
            handler.start();
        }
        catch (Exception e) {
            if (Debug.ENABLE_DEBUG) {
                e.printStackTrace();
            }
            Main.printUsageAndExit(false, e.getMessage(), -2);
        }
    }

    public static void printUsageAndExit(boolean printUsage, String offending, int exitValue) {
        PrintStream ps;
        PrintStream printStream = ps = exitValue == 0 ? System.out : System.err;
        if (offending != null) {
            ps.println(offending);
        }
        if (printUsage) {
            cl.printUsage(ps);
        }
        System.exit(exitValue);
    }

    public static File getWorkingDir() {
        if (fileArguments != null && !fileArguments.isEmpty()) {
            File f = fileArguments.get(0);
            if (f.isDirectory()) {
                return f;
            }
            return f.getParentFile();
        }
        return IOUtil.getCurrentDirectory();
    }

    private static List<File> preProcessInput(List<File> filesOnStartup) {
        ArrayList<File> result = new ArrayList<File>();
        if (riflFileName != null) {
            if (filesOnStartup.isEmpty()) {
                LOGGER.info("[RIFL] No Java file to load from.");
                System.exit(-130826);
            }
            File fileNameOnStartUp = filesOnStartup.get(0).getAbsoluteFile();
            try {
                RIFLTransformer transformer = new RIFLTransformer();
                transformer.doTransform(riflFileName, fileNameOnStartUp, RIFLTransformer.getDefaultSavePath((File)fileNameOnStartUp));
                if (verbosity > 0) {
                    LOGGER.info("[RIFL] Writing transformed Java files to {}  ...", (Object)fileNameOnStartUp);
                }
                return transformer.getProblemFiles();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return result;
        }
        return filesOnStartup;
    }

    public static String getExamplesDir() {
        return examplesDir;
    }

    public static void setExamplesDir(String newExamplesDir) {
        examplesDir = newExamplesDir;
    }

    public static KeYDesktop getKeyDesktop() {
        return keyDesktop;
    }

    public static void setKeyDesktop(KeYDesktop keyDesktop) {
        assert (keyDesktop != null);
        Main.keyDesktop = keyDesktop;
    }

    static {
        loadRecentFile = false;
        riflFileName = null;
        saveAllContracts = false;
        autoMacro = new SkipMacro();
        LOGGER = LoggerFactory.getLogger(Main.class);
        showExampleChooserIfExamplesDirIsDefined = true;
    }

    private static enum UiMode {
        INTERACTIVE,
        AUTO;

    }
}

