/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.control.instantiation_model.TacletInstantiationModel;
import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.utilities.GuiUtilities;
import de.uka.ilkd.key.pp.NotationInfo;
import de.uka.ilkd.key.pp.ProgramPrinter;
import de.uka.ilkd.key.pp.SequentViewLogicPrinter;
import de.uka.ilkd.key.pp.VisibleTermLabels;
import de.uka.ilkd.key.rule.Taclet;
import de.uka.ilkd.key.rule.inst.SVInstantiations;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.util.pp.Backend;
import de.uka.ilkd.key.util.pp.StringBackend;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApplyTacletDialog
extends JDialog {
    private static final long serialVersionUID = -411398660828882035L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplyTacletDialog.class);
    protected JButton cancelButton;
    protected JButton applyButton;
    protected KeYMediator mediator;
    protected boolean checkAfterEachInput = true;
    protected TacletInstantiationModel[] model;
    private JTextArea statusArea;

    public ApplyTacletDialog(Frame parent, TacletInstantiationModel[] model, KeYMediator mediator) {
        super(parent, "Choose Taclet Instantiation", false);
        this.mediator = mediator;
        this.model = model;
        this.applyButton = new JButton("Apply");
        this.cancelButton = new JButton("Cancel");
        GuiUtilities.attachClickOnEscListener(this.cancelButton);
        mediator.requestModalAccess(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                ApplyTacletDialog.this.closeDlg();
            }

            @Override
            public void windowClosing(WindowEvent e) {
                ApplyTacletDialog.this.closeDlg();
            }
        });
        this.getRootPane().setDefaultButton(this.applyButton);
    }

    protected KeYMediator mediator() {
        return this.mediator;
    }

    private int countLines(String s) {
        int i = 0;
        int p = 0;
        while ((p = s.indexOf("\n", p)) >= 0) {
            ++i;
            ++p;
        }
        return i + 1;
    }

    protected JPanel createInfoPanel() {
        Collection vars = this.model[0].programVariables().elements();
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setBorder(new TitledBorder("Sequent program variables"));
        JScrollPane scroll = new JScrollPane();
        JTextArea text = !vars.isEmpty() ? new JTextArea(vars.toString(), 2, 40) : new JTextArea("none", 1, 40);
        scroll.setViewportView(text);
        text.setEditable(false);
        panel.add((Component)scroll, "Center");
        return panel;
    }

    protected JPanel createTacletDisplay() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder("Selected Taclet - " + this.model[0].taclet().name()));
        LOGGER.debug("TacletApp: {}", (Object)this.model[0].taclet());
        Taclet taclet = this.model[0].taclet();
        StringBackend backend = new StringBackend(68);
        StringBuilder tacletSB = new StringBuilder();
        StringWriter w = new StringWriter();
        SequentViewLogicPrinter tp = new SequentViewLogicPrinter(new ProgramPrinter((Writer)w), new NotationInfo(), (Backend)backend, this.mediator.getServices(), true, (VisibleTermLabels)MainWindow.getInstance().getVisibleTermLabels());
        tp.printTaclet(taclet, SVInstantiations.EMPTY_SVINSTANTIATIONS, ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().getShowWholeTaclet(), false);
        tacletSB.append(backend.getString());
        panel.setAlignmentY(0.0f);
        JScrollPane scroll = new JScrollPane();
        int nolines = this.countLines(this.model[0].taclet().toString()) + 1;
        if (nolines > 10) {
            nolines = 11;
        }
        JTextArea text = new JTextArea(tacletSB.toString(), nolines, 68);
        text.setEditable(false);
        scroll.setViewportView(text);
        panel.add((Component)scroll, "Center");
        return panel;
    }

    protected abstract void pushAllInputToModel();

    protected abstract int current();

    public boolean checkAfterEachInput() {
        return this.checkAfterEachInput;
    }

    protected JPanel createStatusPanel() {
        JPanel statusPanel = new JPanel(new BorderLayout());
        this.statusArea = new JTextArea();
        this.statusArea.setEditable(false);
        statusPanel.add((Component)new JScrollPane(this.statusArea, 20, 30), "Center");
        statusPanel.setBorder(new TitledBorder("Input validation result"));
        this.setStatus(this.model[this.current()].getStatusString());
        return statusPanel;
    }

    protected JPanel createButtonPanel(ActionListener buttonListener) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.cancelButton.addActionListener(buttonListener);
        this.applyButton.addActionListener(buttonListener);
        c.insets = new Insets(5, 20, 5, 20);
        c.gridx = 0;
        panel.add((Component)this.cancelButton, c);
        c.gridx = 1;
        panel.add((Component)this.applyButton, c);
        panel.setAlignmentY(1.0f);
        return panel;
    }

    protected void setStatus(String s) {
        if (this.statusArea != null) {
            this.statusArea.setText(s);
        }
    }

    protected void closeDlg() {
        this.mediator.freeModalAccess(this);
    }
}

