/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import java.awt.Color;
import java.awt.Frame;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AutoDismissDialog {
    public static final int DEFAULT_DELAY = 5000;
    public static final int DEFAULT_RATE = 25;
    public static final int DEFAULT_DELAY_START_TO_DISPOSE = 2000;
    public static final int DEFAULT_DELAY_DISPOSE_TO_END = 1000;
    private final JDialog dialog;
    private final JPanel messagePanel;
    private final Timer timer;
    private int remainingSteps;
    private final int delay;
    private final int rate;
    private final int delayStartToDispose;
    private final int steps;

    public AutoDismissDialog(Frame parent, String message, int delay, int rate, int delayStartToDispose, int delayDisposeToEnd) {
        this.dialog = new JDialog(parent, "Message", false);
        this.messagePanel = new JPanel();
        this.messagePanel.add(new JLabel(message));
        this.messagePanel.setBackground(new Color(1.0f, 0.7f, 0.7f));
        this.dialog.getContentPane().add(this.messagePanel);
        this.timer = new Timer();
        this.remainingSteps = this.steps = (delay - delayStartToDispose - delayDisposeToEnd) / rate;
        this.delay = delay;
        this.rate = rate;
        this.delayStartToDispose = delayStartToDispose;
        this.dialog.pack();
    }

    public AutoDismissDialog(Frame parent, String message) {
        this(parent, message, 5000, 25, 2000, 1000);
    }

    public AutoDismissDialog(String message) {
        this(null, message);
    }

    public void show() {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                AutoDismissDialog.this.dialog.dispose();
                AutoDismissDialog.this.timer.cancel();
            }
        }, this.delay);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (AutoDismissDialog.this.remainingSteps > 0) {
                    --AutoDismissDialog.this.remainingSteps;
                    float alpha = (float)AutoDismissDialog.this.remainingSteps / (float)AutoDismissDialog.this.steps;
                    float rgValue = 0.7f + 0.3f * (1.0f - alpha);
                    AutoDismissDialog.this.messagePanel.setBackground(new Color(1.0f, rgValue, rgValue));
                }
            }
        }, this.delayStartToDispose, (long)this.rate);
        this.dialog.setVisible(true);
    }
}

