/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.gui.AuxiliaryContractSelectionPanel;
import de.uka.ilkd.key.gui.utilities.GuiUtilities;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.speclang.AuxiliaryContract;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class AuxiliaryContractConfigurator<T extends AuxiliaryContract>
extends JDialog {
    private static final long serialVersionUID = 4882043118399402599L;
    private AuxiliaryContractSelectionPanel<T> contractPanel;
    private JButton okButton;
    private JButton cancelButton;
    private boolean successful = false;

    public AuxiliaryContractConfigurator(String name, AuxiliaryContractSelectionPanel<T> contractPanel, JDialog owner, Services services, T[] contracts, String title) {
        super(owner, name, true);
        this.init(services, contractPanel, (AuxiliaryContract[])contracts, title);
    }

    public AuxiliaryContractConfigurator(String name, AuxiliaryContractSelectionPanel<T> contractPanel, Frame owner, Services services, T[] contracts, String title) {
        super(owner, name, true);
        this.init(services, contractPanel, (AuxiliaryContract[])contracts, title);
    }

    private void init(Services services, AuxiliaryContractSelectionPanel<T> contractPanel, T[] contracts, String title) {
        this.initContractPanel(services, contractPanel, (AuxiliaryContract[])contracts, title);
        this.initButtonPanelAndOkAndCancelButtons();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
    }

    private void initContractPanel(Services services, AuxiliaryContractSelectionPanel<T> contractPanel, T[] contracts, String title) {
        this.contractPanel = contractPanel;
        contractPanel.setContracts((AuxiliaryContract[])contracts, title);
        contractPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    AuxiliaryContractConfigurator.this.okButton.doClick();
                }
            }
        });
        contractPanel.setMinimumSize(new Dimension(800, 500));
        this.getContentPane().add(contractPanel);
    }

    private void initButtonPanelAndOkAndCancelButtons() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 5, 5));
        Dimension buttonDim = new Dimension(100, 27);
        buttonPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)buttonDim.getHeight() + 10));
        this.getContentPane().add(buttonPanel);
        this.initOkButton(buttonDim, buttonPanel);
        this.initCancelButton(buttonDim, buttonPanel);
    }

    private void initOkButton(Dimension dimension, JPanel container) {
        this.okButton = new JButton("OK");
        this.okButton.setPreferredSize(dimension);
        this.okButton.setMinimumSize(dimension);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AuxiliaryContractConfigurator.this.successful = true;
                AuxiliaryContractConfigurator.this.setVisible(false);
                AuxiliaryContractConfigurator.this.dispose();
            }
        });
        container.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private void initCancelButton(Dimension dimension, JPanel container) {
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setPreferredSize(dimension);
        this.cancelButton.setMinimumSize(dimension);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AuxiliaryContractConfigurator.this.successful = false;
                AuxiliaryContractConfigurator.this.setVisible(false);
                AuxiliaryContractConfigurator.this.dispose();
            }
        });
        container.add(this.cancelButton);
        GuiUtilities.attachClickOnEscListener(this.cancelButton);
    }

    public boolean wasSuccessful() {
        return this.successful;
    }

    public T getContract() {
        return this.contractPanel.getContract();
    }
}

