/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.speclang.AuxiliaryContract;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AuxiliaryContractSelectionPanel<T extends AuxiliaryContract>
extends JPanel {
    private static final long serialVersionUID = 129743953718747490L;
    protected final Services services;
    protected final JList<T> contractList;
    private final TitledBorder border;

    public AuxiliaryContractSelectionPanel(Services services, boolean multipleSelection) {
        this.setLayout(new BoxLayout(this, 1));
        this.services = services;
        JScrollPane scrollPane = new JScrollPane();
        this.border = new TitledBorder("Contracts");
        scrollPane.setBorder(this.border);
        Dimension scrollPaneDim = new Dimension(700, 500);
        scrollPane.setPreferredSize(scrollPaneDim);
        scrollPane.setMinimumSize(scrollPaneDim);
        this.add(scrollPane);
        this.contractList = new JList();
        this.contractList.setSelectionMode(multipleSelection ? 2 : 0);
        this.contractList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (AuxiliaryContractSelectionPanel.this.contractList.isSelectionEmpty()) {
                    AuxiliaryContractSelectionPanel.this.contractList.setSelectedIndex(e.getFirstIndex());
                }
            }
        });
        final Services serv = services;
        this.contractList.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 9088858130231994408L;
            private final Font PLAINFONT = this.getFont().deriveFont(0);

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                AuxiliaryContract contract = (AuxiliaryContract)value;
                Component supComp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                JLabel label = new JLabel();
                label.setText(contract.getHtmlText(serv));
                label.setFont(this.PLAINFONT);
                FlowLayout lay = new FlowLayout();
                lay.setAlignment(0);
                JPanel result = new JPanel(lay);
                result.add(label);
                label.setVerticalAlignment(1);
                result.setBackground(supComp.getBackground());
                TitledBorder border = new TitledBorder(BorderFactory.createEtchedBorder(), contract.getDisplayName());
                Font borderFont = border.getTitleFont();
                if (borderFont == null && (borderFont = result.getFont()) == null) {
                    borderFont = this.PLAINFONT;
                }
                border.setTitleFont(borderFont.deriveFont(1));
                result.setBorder(border);
                return result;
            }
        });
        scrollPane.setViewportView(this.contractList);
    }

    @Override
    public synchronized void addMouseListener(MouseListener ml) {
        this.contractList.addMouseListener(ml);
    }

    public void setContracts(T[] contracts, String title) {
        this.contractList.setListData(contracts);
        this.contractList.setSelectedIndex(0);
        if (title != null) {
            this.border.setTitle(title);
        }
        this.updateUI();
    }

    public T getContract() {
        List<T> selection = this.contractList.getSelectedValuesList();
        return this.computeContract(this.services, selection);
    }

    public abstract T computeContract(Services var1, List<T> var2);
}

