/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.abstraction.KeYJavaType;
import de.uka.ilkd.key.java.declaration.ClassDeclaration;
import de.uka.ilkd.key.java.declaration.InterfaceDeclaration;
import de.uka.ilkd.key.java.declaration.TypeDeclaration;
import de.uka.ilkd.key.ldt.HeapLDT;
import de.uka.ilkd.key.logic.Named;
import de.uka.ilkd.key.logic.ProgramElementName;
import de.uka.ilkd.key.logic.op.IObserverFunction;
import de.uka.ilkd.key.logic.op.IProgramMethod;
import de.uka.ilkd.key.util.KeYTypeUtil;
import de.uka.ilkd.key.util.Pair;
import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.key_project.util.collection.ImmutableSet;
import org.key_project.util.java.ObjectUtil;

public class ClassTree
extends JTree {
    private static final long serialVersionUID = -3006761219011776834L;
    private final Map<Pair<KeYJavaType, IObserverFunction>, Icon> targetIcons;
    private final Services services;

    public ClassTree(boolean addContractTargets, boolean skipLibraryClasses, Services services, Map<Pair<KeYJavaType, IObserverFunction>, Icon> targetIcons) {
        super(new DefaultTreeModel(ClassTree.createTree(addContractTargets, skipLibraryClasses, services)));
        this.targetIcons = targetIcons;
        this.services = services;
        this.getSelectionModel().setSelectionMode(1);
        this.setCellRenderer(new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = -6609972972532204432L;

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component result;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Entry entry = (Entry)node.getUserObject();
                if (entry.target == null) {
                    result = super.getTreeCellRendererComponent(tree, value, sel, expanded, true, row, hasFocus);
                } else {
                    result = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                    if (result instanceof JLabel) {
                        ((JLabel)result).setIcon(ClassTree.this.targetIcons.get(new Pair((Object)entry.kjt, (Object)entry.target)));
                    }
                }
                return result;
            }
        });
    }

    public ClassTree(boolean addContractTargets, boolean skipLibraryClasses, Services services) {
        this(addContractTargets, skipLibraryClasses, services, new LinkedHashMap<Pair<KeYJavaType, IObserverFunction>, Icon>());
    }

    private static DefaultMutableTreeNode getChildByString(DefaultMutableTreeNode parentNode, String childString) {
        int numChildren = parentNode.getChildCount();
        for (int i = 0; i < numChildren; ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            Entry te = (Entry)childNode.getUserObject();
            if (!childString.equals(te.string)) continue;
            return childNode;
        }
        return null;
    }

    private static DefaultMutableTreeNode getChildByTarget(DefaultMutableTreeNode parentNode, IObserverFunction target) {
        int numChildren = parentNode.getChildCount();
        for (int i = 0; i < numChildren; ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            Entry te = (Entry)childNode.getUserObject();
            if (!target.equals(te.target)) continue;
            return childNode;
        }
        return null;
    }

    private static void insertIntoTree(DefaultMutableTreeNode rootNode, KeYJavaType kjt, boolean addContractTargets, Services services) {
        String fullClassName = kjt.getFullName();
        int length = fullClassName.length();
        int index = -1;
        DefaultMutableTreeNode node = rootNode;
        do {
            String namePart;
            DefaultMutableTreeNode childNode;
            int lastIndex = index++;
            if ((index = fullClassName.indexOf(".", index)) == -1) {
                index = length;
            }
            if ((childNode = ClassTree.getChildByString(node, namePart = fullClassName.substring(lastIndex + 1, index))) == null) {
                Entry te = new Entry(namePart);
                childNode = new DefaultMutableTreeNode(te);
                node.add(childNode);
            }
            node = childNode;
        } while (index != length);
        ((Entry)node.getUserObject()).kjt = kjt;
        if (addContractTargets) {
            ImmutableSet targets = services.getSpecificationRepository().getContractTargets(kjt);
            IObserverFunction[] targetsArr = (IObserverFunction[])targets.toArray((Object[])new IObserverFunction[targets.size()]);
            Arrays.sort(targetsArr, new Comparator<IObserverFunction>(){

                @Override
                public int compare(IObserverFunction o1, IObserverFunction o2) {
                    if (o1 instanceof IProgramMethod && !(o2 instanceof IProgramMethod)) {
                        return -1;
                    }
                    if (!(o1 instanceof IProgramMethod) && o2 instanceof IProgramMethod) {
                        return 1;
                    }
                    String s1 = o1.name() instanceof ProgramElementName ? ((ProgramElementName)o1.name()).getProgramName() : o1.name().toString();
                    String s2 = o2.name() instanceof ProgramElementName ? ((ProgramElementName)o2.name()).getProgramName() : o2.name().toString();
                    return s1.compareTo(s2);
                }
            });
            for (IObserverFunction target : targetsArr) {
                Entry te = new Entry(ClassTree.getDisplayName(services, target));
                DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(te);
                te.kjt = kjt;
                te.target = target;
                node.add(childNode);
            }
        }
    }

    private static void compressLinearPaths(DefaultMutableTreeNode root) {
        int numChildren = root.getChildCount();
        for (int i = 0; i < numChildren; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)root.getChildAt(i);
            int numGrandChildren = child.getChildCount();
            if (numGrandChildren != 1) continue;
            DefaultMutableTreeNode grandChild = (DefaultMutableTreeNode)child.getFirstChild();
            if (((Entry)grandChild.getUserObject()).target != null) continue;
            child.removeFromParent();
            root.add(grandChild);
            Entry e1 = (Entry)child.getUserObject();
            Entry e2 = (Entry)grandChild.getUserObject();
            e2.string = e1.string + "." + e2.string;
            ClassTree.compressLinearPaths(root);
        }
    }

    public static final String getDisplayName(Services services, IObserverFunction ov) {
        StringBuffer sb = new StringBuffer();
        String prettyName = HeapLDT.getPrettyFieldName((Named)ov);
        if (prettyName != null) {
            sb.append(prettyName);
        } else if (ov.name() instanceof ProgramElementName) {
            sb.append(((ProgramElementName)ov.name()).getProgramName());
        } else {
            sb.append(ov.name());
        }
        if (ov.getNumParams() > 0 || ov instanceof IProgramMethod) {
            sb.append("(");
        }
        for (KeYJavaType paramType : ov.getParamTypes()) {
            sb.append(paramType.getSort().name()).append(", ");
        }
        if (ov.getNumParams() > 0) {
            sb.setLength(sb.length() - 2);
        }
        if (ov.getNumParams() > 0 || ov instanceof IProgramMethod) {
            sb.append(")");
        }
        return sb.toString();
    }

    private static DefaultMutableTreeNode createTree(boolean addContractTargets, boolean skipLibraryClasses, Services services) {
        Set kjts = services.getJavaInfo().getAllKeYJavaTypes();
        Iterator it = kjts.iterator();
        while (it.hasNext()) {
            KeYJavaType kjt = (KeYJavaType)it.next();
            if ((kjt.getJavaType() instanceof ClassDeclaration || kjt.getJavaType() instanceof InterfaceDeclaration) && (!((TypeDeclaration)kjt.getJavaType()).isLibraryClass() || !skipLibraryClasses)) continue;
            it.remove();
        }
        KeYJavaType[] kjtsarr = kjts.toArray(new KeYJavaType[kjts.size()]);
        Arrays.sort(kjtsarr, new Comparator<KeYJavaType>(){

            @Override
            public int compare(KeYJavaType o1, KeYJavaType o2) {
                return o1.getFullName().compareTo(o2.getFullName());
            }
        });
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(new Entry(""));
        for (int i = 0; i < kjtsarr.length; ++i) {
            ClassTree.insertIntoTree(rootNode, kjtsarr[i], addContractTargets, services);
        }
        ClassTree.compressLinearPaths(rootNode);
        return rootNode;
    }

    private void open(KeYJavaType kjt, IObserverFunction target) {
        Vector<DefaultMutableTreeNode> pathVector = new Vector<DefaultMutableTreeNode>();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getModel().getRoot();
        assert (node != null);
        pathVector.add(node);
        LinkedList<KeYJavaType> types = new LinkedList<KeYJavaType>();
        KeYJavaType currentKjt = kjt;
        types.addFirst(currentKjt);
        while (KeYTypeUtil.isInnerType((Services)this.services, (KeYJavaType)currentKjt)) {
            String parentFullName = KeYTypeUtil.getParentName((Services)this.services, (KeYJavaType)kjt);
            currentKjt = KeYTypeUtil.getType((Services)this.services, (String)parentFullName);
            types.addFirst(currentKjt);
        }
        Iterator typesIter = types.iterator();
        KeYJavaType rootType = (KeYJavaType)typesIter.next();
        DefaultMutableTreeNode fullQualifiedNode = this.searchNode(node, rootType.getFullName());
        if (fullQualifiedNode != null) {
            pathVector.add(fullQualifiedNode);
            node = fullQualifiedNode;
        } else {
            String[] segments = rootType.getFullName().split("\\.");
            String accumulatedSegment = null;
            for (String segment : segments) {
                DefaultMutableTreeNode resNode = this.searchNode(node, accumulatedSegment = accumulatedSegment == null ? segment : accumulatedSegment + "." + segment);
                if (resNode == null) continue;
                node = resNode;
                pathVector.add(node);
                accumulatedSegment = null;
            }
        }
        while (typesIter.hasNext()) {
            KeYJavaType innerType = (KeYJavaType)typesIter.next();
            node = this.searchNode(node, innerType.getName());
            pathVector.add(node);
        }
        TreePath path = new TreePath(pathVector.toArray());
        TreePath incompletePath = null;
        if (target != null) {
            DefaultMutableTreeNode methodNode = ClassTree.getChildByTarget(node, target);
            if (methodNode != null) {
                incompletePath = path;
                path = path.pathByAddingChild(methodNode);
            } else {
                incompletePath = path.getParentPath();
            }
        }
        this.expandPath(incompletePath);
        this.setSelectionRow(this.getRowForPath(path));
    }

    protected DefaultMutableTreeNode searchNode(DefaultMutableTreeNode parent, String text) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)parent.getChildAt(i);
            Entry e = (Entry)childNode.getUserObject();
            if (!ObjectUtil.equals((Object)text, (Object)e.string)) continue;
            return childNode;
        }
        return null;
    }

    public void select(KeYJavaType kjt) {
        this.open(kjt, null);
    }

    public void select(KeYJavaType kjt, IObserverFunction target) {
        this.open(kjt, target);
    }

    public DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)this.getModel().getRoot();
    }

    public DefaultMutableTreeNode getSelectedNode() {
        TreePath path = this.getSelectionPath();
        return path != null ? (DefaultMutableTreeNode)path.getLastPathComponent() : null;
    }

    public Entry getSelectedEntry() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        return node != null ? (Entry)node.getUserObject() : null;
    }

    static class Entry {
        public String string;
        public KeYJavaType kjt = null;
        public IObserverFunction target = null;
        public int numMembers = 0;
        public int numSelectedMembers = 0;

        public Entry(String string) {
            this.string = string;
        }

        public String toString() {
            return this.string;
        }
    }
}

