/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.gui.ContractSelectionPanel;
import de.uka.ilkd.key.gui.utilities.GuiUtilities;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.speclang.Contract;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ContractConfigurator
extends JDialog {
    private static final long serialVersionUID = 4002043118399402599L;
    private ContractSelectionPanel contractPanel;
    private JButton okButton;
    private JButton cancelButton;
    private boolean successful = false;

    public ContractConfigurator(JDialog owner, Services services, Contract[] contracts, String title, boolean allowMultipleContracts) {
        super(owner, "Contract Configurator", true);
        this.init(services, contracts, title, allowMultipleContracts);
    }

    public ContractConfigurator(Frame owner, Services services, Contract[] contracts, String title, boolean allowMultipleContracts) {
        super(owner, "Contract Configurator", true);
        this.init(services, contracts, title, allowMultipleContracts);
    }

    private void init(Services services, Contract[] contracts, String title, boolean allowMultipleContracts) {
        this.contractPanel = new ContractSelectionPanel(services, allowMultipleContracts);
        this.contractPanel.setContracts(contracts, title);
        this.contractPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ContractConfigurator.this.okButton.doClick();
                }
            }
        });
        this.contractPanel.setMinimumSize(new Dimension(800, 500));
        this.getContentPane().add(this.contractPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 5, 5));
        Dimension buttonDim = new Dimension(100, 27);
        buttonPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)buttonDim.getHeight() + 10));
        this.getContentPane().add(buttonPanel);
        this.okButton = new JButton("OK");
        this.okButton.setPreferredSize(buttonDim);
        this.okButton.setMinimumSize(buttonDim);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContractConfigurator.this.successful = true;
                ContractConfigurator.this.setVisible(false);
                ContractConfigurator.this.dispose();
            }
        });
        buttonPanel.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setPreferredSize(buttonDim);
        this.cancelButton.setMinimumSize(buttonDim);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContractConfigurator.this.successful = false;
                ContractConfigurator.this.setVisible(false);
                ContractConfigurator.this.dispose();
            }
        });
        buttonPanel.add(this.cancelButton);
        GuiUtilities.attachClickOnEscListener(this.cancelButton);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
    }

    public boolean wasSuccessful() {
        return this.successful;
    }

    public Contract getContract() {
        return this.contractPanel.getContract();
    }
}

