/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.speclang.Contract;
import de.uka.ilkd.key.speclang.DependencyContractImpl;
import de.uka.ilkd.key.speclang.FunctionalBlockContract;
import de.uka.ilkd.key.speclang.FunctionalLoopContract;
import de.uka.ilkd.key.speclang.FunctionalOperationContract;
import de.uka.ilkd.key.speclang.FunctionalOperationContractImpl;
import de.uka.ilkd.key.speclang.InformationFlowContractImpl;
import de.uka.ilkd.key.util.LinkedHashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.key_project.util.collection.DefaultImmutableSet;
import org.key_project.util.collection.ImmutableSet;

public class ContractSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1681223715264203991L;
    private static final Map<Class<?>, Integer> CONTRACT_TYPE_ORDER = new LinkedHashMap();
    private final Services services;
    private final JList<Contract> contractList;
    private final TitledBorder border;
    private Contract[] contracts = new Contract[0];
    private boolean grayOutAuxiliaryContracts = false;

    public ContractSelectionPanel(Services services, boolean multipleSelection) {
        this.setLayout(new BoxLayout(this, 1));
        this.services = services;
        JScrollPane scrollPane = new JScrollPane();
        this.border = new TitledBorder("Contracts");
        scrollPane.setBorder(this.border);
        Dimension scrollPaneDim = new Dimension(700, 500);
        scrollPane.setPreferredSize(scrollPaneDim);
        scrollPane.setMinimumSize(scrollPaneDim);
        this.add(scrollPane);
        this.contractList = new JList();
        this.contractList.setSelectionMode(multipleSelection ? 2 : 0);
        this.contractList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ContractSelectionPanel.this.contractList.isSelectionEmpty()) {
                    ContractSelectionPanel.this.contractList.setSelectedIndex(e.getFirstIndex());
                }
            }
        });
        final Services serv = services;
        this.contractList.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 9066658130231994408L;
            private final Font PLAINFONT = this.getFont().deriveFont(0);

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Font borderFont;
                TitledBorder border;
                assert (value != null);
                Contract contract = (Contract)value;
                Component supComp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                HashSet<Contract> appliedContracts = new HashSet<Contract>();
                HashSet<Contract> consideredContracts = new HashSet<Contract>();
                for (Contract c : ContractSelectionPanel.this.contracts) {
                    if (c.isAuxiliary()) continue;
                    consideredContracts.add(c);
                    Proof p = ContractSelectionPanel.this.getClosedProof(c);
                    if (p == null) continue;
                    for (Contract used : p.mgt().getUsedContracts()) {
                        appliedContracts.add(used);
                    }
                }
                int iterations = ContractSelectionPanel.this.contracts.length - consideredContracts.size();
                for (int i = 0; i < iterations; ++i) {
                    for (Contract c : ContractSelectionPanel.this.contracts) {
                        if (consideredContracts.contains(c) || !appliedContracts.contains(c)) continue;
                        consideredContracts.add(c);
                        Proof p = ContractSelectionPanel.this.getClosedProof(c);
                        if (p == null) continue;
                        for (Contract used : p.mgt().getUsedContracts()) {
                            appliedContracts.add(used);
                        }
                    }
                }
                JLabel label = new JLabel();
                label.setText(contract.getHTMLText(serv));
                label.setFont(this.PLAINFONT);
                FlowLayout lay = new FlowLayout();
                lay.setAlignment(0);
                JPanel result = new JPanel(lay);
                result.add(label);
                label.setVerticalAlignment(1);
                result.setBackground(supComp.getBackground());
                if (ContractSelectionPanel.this.grayOutAuxiliaryContracts && contract.isAuxiliary() && !appliedContracts.contains(contract)) {
                    label.setForeground(Color.GRAY);
                    border = new TitledBorder(BorderFactory.createEtchedBorder(), contract.getDisplayName(), 4, 0, null, Color.GRAY);
                    borderFont = border.getTitleFont();
                    if (borderFont == null && (borderFont = result.getFont()) == null) {
                        borderFont = this.PLAINFONT;
                    }
                } else {
                    border = new TitledBorder(BorderFactory.createEtchedBorder(), contract.getDisplayName());
                    borderFont = border.getTitleFont();
                    if (borderFont == null && (borderFont = result.getFont()) == null) {
                        borderFont = this.PLAINFONT;
                    }
                }
                border.setTitleFont(borderFont.deriveFont(1));
                result.setBorder(border);
                return result;
            }
        });
        scrollPane.setViewportView(this.contractList);
    }

    private Proof getClosedProof(Contract c) {
        ImmutableSet proofs = this.services.getSpecificationRepository().getProofs(c);
        for (Proof proof : proofs) {
            if (!proof.mgt().getStatus().getProofClosed()) continue;
            return proof;
        }
        return null;
    }

    @Override
    public synchronized void addMouseListener(MouseListener ml) {
        this.contractList.addMouseListener(ml);
    }

    public void addListSelectionListener(ListSelectionListener lsl) {
        this.contractList.addListSelectionListener(lsl);
    }

    public void setGrayOutAuxiliaryContracts(boolean grayOutAuxiliaryContracts) {
        this.grayOutAuxiliaryContracts = grayOutAuxiliaryContracts;
    }

    public void setContracts(Contract[] contracts, String title) {
        if (contracts == null || contracts.length == 0) {
            this.contracts = new Contract[0];
            this.contractList.setListData((Contract[])this.contracts);
            this.updateUI();
            return;
        }
        Arrays.sort(contracts, new Comparator<Contract>(){

            @Override
            public int compare(Contract c1, Contract c2) {
                Integer o1 = CONTRACT_TYPE_ORDER.get(c1.getClass());
                Integer o2 = CONTRACT_TYPE_ORDER.get(c2.getClass());
                int res = 0;
                if (o1 != null && o2 != null) {
                    res = o1 - o2;
                } else {
                    if (o1 != null) {
                        return -1;
                    }
                    if (o2 != null) {
                        return 1;
                    }
                }
                if (res != 0) {
                    return res;
                }
                res = c1.getDisplayName().compareTo(c2.getDisplayName());
                if (res == 0) {
                    return c1.id() - c2.id();
                }
                return res;
            }
        });
        this.contracts = contracts;
        this.contractList.setListData((Contract[])contracts);
        this.contractList.setSelectedIndex(0);
        if (title != null) {
            this.border.setTitle(title);
        }
        this.updateUI();
    }

    public void setContracts(ImmutableSet<Contract> contracts, String title) {
        this.setContracts((Contract[])contracts.toArray((Object[])new Contract[contracts.size()]), title);
    }

    public void selectContract(Contract contract) {
        this.contractList.setSelectedValue(contract, true);
    }

    public Contract getContract() {
        List<Contract> selection = this.contractList.getSelectedValuesList();
        return ContractSelectionPanel.computeContract(this.services, selection);
    }

    public static Contract computeContract(Services services, List<Contract> selection) {
        if (selection.isEmpty()) {
            return null;
        }
        if (selection.size() == 1) {
            return selection.get(0);
        }
        DefaultImmutableSet contracts = DefaultImmutableSet.nil();
        for (Contract contract : selection) {
            if (contract instanceof FunctionalOperationContract) {
                contracts = contracts.add((Object)((FunctionalOperationContract)contract));
                continue;
            }
            throw new IllegalStateException("Don't know how to combine contracts of kind " + contract.getClass() + "\nContract:\n" + contract.getPlainText(services));
        }
        return services.getSpecificationRepository().combineOperationContracts((ImmutableSet)contracts);
    }

    static {
        CONTRACT_TYPE_ORDER.put(FunctionalOperationContractImpl.class, 0);
        CONTRACT_TYPE_ORDER.put(InformationFlowContractImpl.class, 1);
        CONTRACT_TYPE_ORDER.put(DependencyContractImpl.class, 2);
        CONTRACT_TYPE_ORDER.put(FunctionalBlockContract.class, 3);
        CONTRACT_TYPE_ORDER.put(FunctionalLoopContract.class, 4);
    }
}

