/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.gui.InteractiveRuleApplicationCompletion;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.IObserverFunction;
import de.uka.ilkd.key.logic.op.LocationVariable;
import de.uka.ilkd.key.logic.op.Operator;
import de.uka.ilkd.key.pp.LogicPrinter;
import de.uka.ilkd.key.pp.NotationInfo;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.rule.IBuiltInRuleApp;
import de.uka.ilkd.key.rule.UseDependencyContractApp;
import de.uka.ilkd.key.rule.UseDependencyContractRule;
import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;

public class DependencyContractCompletion
implements InteractiveRuleApplicationCompletion {
    @Override
    public IBuiltInRuleApp complete(IBuiltInRuleApp app, Goal goal, boolean forced) {
        UseDependencyContractApp cApp = (UseDependencyContractApp)app;
        Services services = goal.proof().getServices();
        cApp = cApp.tryToInstantiateContract(services);
        List steps = UseDependencyContractRule.getSteps((List)cApp.getHeapContext(), (PosInOccurrence)cApp.posInOccurrence(), (Sequent)goal.sequent(), (Services)services);
        PosInOccurrence step = DependencyContractCompletion.letUserChooseStep(cApp.getHeapContext(), steps, forced, services);
        if (step == null) {
            return null;
        }
        return cApp.setStep(step);
    }

    private static PosInOccurrence letUserChooseStep(List<LocationVariable> heapContext, List<PosInOccurrence> steps, boolean forced, Services services) {
        Term[] resultHeaps;
        assert (heapContext != null);
        if (steps.size() == 0) {
            return null;
        }
        Object[] heaps = new TermStringWrapper[steps.size()];
        LogicPrinter lp = new LogicPrinter(null, new NotationInfo(), services);
        lp.setLineWidth(120);
        DependencyContractCompletion.extractHeaps(heapContext, steps, (TermStringWrapper[])heaps, lp);
        if (!forced) {
            TermStringWrapper heapWrapper = (TermStringWrapper)JOptionPane.showInputDialog(MainWindow.getInstance(), "Please select base heap configuration:", "Instantiation", 3, null, heaps, heaps.length > 0 ? heaps[0] : null);
            if (heapWrapper == null) {
                return null;
            }
            resultHeaps = heapWrapper.terms;
        } else {
            resultHeaps = heaps[0].terms;
        }
        return DependencyContractCompletion.findCorrespondingStep(steps, resultHeaps);
    }

    public static PosInOccurrence findCorrespondingStep(List<PosInOccurrence> steps, Term[] resultHeaps) {
        for (PosInOccurrence step : steps) {
            boolean match = true;
            for (int j = 0; j < resultHeaps.length; ++j) {
                if (step.subTerm().sub(j).equals(resultHeaps[j])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return step;
        }
        assert (false);
        return null;
    }

    public static void extractHeaps(List<LocationVariable> heapContext, List<PosInOccurrence> steps, TermStringWrapper[] heaps, LogicPrinter lp) {
        int i = 0;
        for (PosInOccurrence step : steps) {
            Operator op = step.subTerm().op();
            int size = op instanceof IObserverFunction ? ((IObserverFunction)op).getStateCount() * heapContext.size() : 1;
            Term[] heapTerms = new Term[size];
            String prettyprint = "<html><tt>" + (size > 1 ? "[" : "");
            for (int j = 0; j < size; ++j) {
                Term heap;
                heapTerms[j] = heap = step.subTerm().sub(j);
                lp.reset();
                try {
                    lp.printTerm(heap);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                prettyprint = prettyprint + (j > 0 ? ", " : "") + LogicPrinter.escapeHTML((String)lp.toString().trim(), (boolean)true);
            }
            prettyprint = prettyprint + (size > 1 ? "]" : "") + "</tt></html>";
            heaps[i++] = new TermStringWrapper(heapTerms, prettyprint);
        }
    }

    @Override
    public boolean canComplete(IBuiltInRuleApp app) {
        return DependencyContractCompletion.checkCanComplete(app);
    }

    public static boolean checkCanComplete(IBuiltInRuleApp app) {
        return app.rule() instanceof UseDependencyContractRule;
    }

    public static final class TermStringWrapper {
        public final Term[] terms;
        final String string;

        public TermStringWrapper(Term[] terms, String string) {
            this.terms = terms;
            this.string = string;
        }

        public String toString() {
            return this.string;
        }
    }
}

