/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.utilities.GuiUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.key_project.util.java.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExampleChooser
extends JDialog {
    public static final String EXAMPLES_PATH = "examples";
    private static final long serialVersionUID = -4405666868752394532L;
    public static final String KEY_FILE_NAME = "project.key";
    private static final String PROOF_FILE_NAME = "project.proof";
    public static final String KEY_EXAMPLE_DIR = "key.examples.dir";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExampleChooser.class);
    private static ExampleChooser instance;
    private final JTree exampleList;
    private final JButton loadButton;
    private final JButton loadProofButton;
    private final JButton cancelButton;
    private final JTabbedPane tabPane;
    private File fileToLoad = null;
    private Example selectedExample;

    private ExampleChooser(File examplesDir) {
        super(MainWindow.getInstance(), "Load Example", true);
        assert (examplesDir != null);
        assert (examplesDir.isDirectory());
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        this.getContentPane().add(listPanel);
        DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode());
        List<Example> examples = ExampleChooser.listExamples(examplesDir);
        for (Example example : examples) {
            example.addToTreeModel(model);
        }
        this.exampleList = new JTree();
        this.exampleList.setModel(model);
        this.exampleList.getSelectionModel().setSelectionMode(1);
        this.exampleList.addTreeSelectionListener(e -> this.updateDescription());
        this.exampleList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ExampleChooser.this.loadButton.doClick();
                }
            }
        });
        JScrollPane exampleScrollPane = new JScrollPane(this.exampleList);
        exampleScrollPane.setBorder(new TitledBorder("Examples"));
        this.tabPane = new JTabbedPane(1);
        JSplitPane split = new JSplitPane(1);
        split.add(exampleScrollPane);
        split.add(this.tabPane);
        split.setDividerLocation(300);
        listPanel.add((Component)split, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 5, 5));
        Dimension buttonDim = new Dimension(140, 27);
        buttonPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)buttonDim.getHeight() + 10));
        this.getContentPane().add(buttonPanel);
        this.loadButton = new JButton("Load Example");
        this.loadButton.addActionListener(e -> {
            if (this.selectedExample == null) {
                throw new RuntimeException("No example selected");
            }
            this.fileToLoad = this.selectedExample.getObligationFile();
            this.setVisible(false);
        });
        buttonPanel.add(this.loadButton);
        this.getRootPane().setDefaultButton(this.loadButton);
        this.loadProofButton = new JButton("Load Proof");
        this.loadProofButton.addActionListener(e -> {
            if (this.selectedExample == null) {
                throw new IllegalStateException("No example selected");
            }
            if (!this.selectedExample.hasProof()) {
                throw new IllegalStateException("Selected example has no proof.");
            }
            this.fileToLoad = this.selectedExample.getProofFile();
            this.setVisible(false);
        });
        buttonPanel.add(this.loadProofButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(e -> {
            this.fileToLoad = null;
            this.setVisible(false);
        });
        buttonPanel.add(this.cancelButton);
        GuiUtilities.attachClickOnEscListener(this.cancelButton);
        DefaultMutableTreeNode firstLeaf = ((DefaultMutableTreeNode)model.getRoot()).getFirstLeaf();
        TreePath pathToFirstLeaf = new TreePath(firstLeaf.getPath());
        this.exampleList.getSelectionModel().setSelectionPath(pathToFirstLeaf);
        this.exampleList.makeVisible(pathToFirstLeaf);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setSize(800, 400);
    }

    public static File lookForExamples() {
        if (System.getProperty(KEY_EXAMPLE_DIR) != null) {
            return new File(System.getProperty(KEY_EXAMPLE_DIR));
        }
        File folder = new File(IOUtil.getProjectRoot(ExampleChooser.class), EXAMPLES_PATH);
        if (!folder.exists()) {
            folder = new File(IOUtil.getClassLocation(ExampleChooser.class), EXAMPLES_PATH);
        }
        return folder;
    }

    private static String fileAsString(File f) {
        try {
            return IOUtil.readFrom((File)f);
        }
        catch (IOException e) {
            LOGGER.error("Could not read file '{}'", (Object)f, (Object)e);
            return "<Error reading file: " + f + ">";
        }
    }

    private static StringBuilder extractDescription(File file, StringBuilder sb, Properties properties) {
        try (BufferedReader r = new BufferedReader(new FileReader(file));){
            String line;
            boolean emptyLineSeen = false;
            while ((line = r.readLine()) != null) {
                String[] entry;
                if (emptyLineSeen) {
                    sb.append(line).append("\n");
                    continue;
                }
                String trimmed = line.trim();
                if (trimmed.length() == 0) {
                    emptyLineSeen = true;
                    continue;
                }
                if (trimmed.startsWith("#") || (entry = trimmed.split(" *[:=] *", 2)).length <= 1) continue;
                properties.put(entry[0], entry[1]);
            }
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
            return sb;
        }
        return sb;
    }

    private void updateDescription() {
        TreePath selectionPath = this.exampleList.getSelectionModel().getSelectionPath();
        if (selectionPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        Object nodeObj = node.getUserObject();
        this.tabPane.removeAll();
        if (nodeObj instanceof Example) {
            Example example = (Example)nodeObj;
            if (example != this.selectedExample) {
                this.addTab(example.getDescription(), "Description", true);
                String fileAsString = ExampleChooser.fileAsString(example.getObligationFile());
                int p = fileAsString.lastIndexOf("\\problem");
                if (p >= 0) {
                    this.addTab(fileAsString.substring(p), "Proof Obligation", false);
                }
                for (File file : example.getAdditionalFiles()) {
                    this.addTab(ExampleChooser.fileAsString(file), file.getName(), false);
                }
                this.loadButton.setEnabled(true);
                this.loadProofButton.setEnabled(example.hasProof());
                this.selectedExample = example;
            }
        } else {
            this.selectedExample = null;
            this.loadButton.setEnabled(false);
            this.loadProofButton.setEnabled(false);
        }
    }

    private void addTab(String string, String name, boolean wrap) {
        JTextArea area = new JTextArea();
        area.setText(string);
        area.setFont(new Font("Monospaced", 0, area.getFont().getSize()));
        area.setCaretPosition(0);
        area.setEditable(false);
        area.setWrapStyleWord(true);
        area.setLineWrap(wrap);
        this.tabPane.add((Component)new JScrollPane(area), name);
    }

    public static File showInstance(String examplesDirString) {
        File examplesDir = examplesDirString == null ? ExampleChooser.lookForExamples() : new File(examplesDirString);
        if (!examplesDir.isDirectory()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), "The examples directory cannot be found.\nPlease install them at " + (String)(examplesDirString == null ? IOUtil.getProjectRoot(ExampleChooser.class) + "/" : examplesDirString), "Error loading examples", 0);
            return null;
        }
        if (instance == null) {
            instance = new ExampleChooser(examplesDir);
        }
        instance.setLocationRelativeTo(instance.getOwner());
        instance.setVisible(true);
        return ExampleChooser.instance.fileToLoad;
    }

    public static List<Example> listExamples(File examplesDir) {
        LinkedList<Example> result;
        block11: {
            result = new LinkedList<Example>();
            File index = new File(new File(examplesDir, "index"), "samplesIndex.txt");
            try {
                BufferedReader br = new BufferedReader(new FileReader(index));
                block9: while (true) {
                    String line;
                    while ((line = br.readLine()) != null) {
                        if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                        File f = new File(examplesDir, line);
                        try {
                            result.add(new Example(f));
                            continue block9;
                        }
                        catch (IOException e) {
                            LOGGER.warn("Cannot parse example {}; ignoring it.", (Object)f, (Object)e);
                        }
                    }
                    break block11;
                    {
                        continue block9;
                        break;
                    }
                    break;
                }
                finally {
                    br.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn("Error while reading samples", (Throwable)e);
            }
        }
        return result;
    }

    public static class Example {
        private static final String DEFAULT_CATEGORY_PATH = "Unsorted";
        private static final String KEY_PATH = "example.path";
        private static final String KEY_NAME = "example.name";
        private static final String KEY_FILE = "example.file";
        private static final String KEY_PROOF_FILE = "example.proofFile";
        private static final String ADDITIONAL_FILE_PREFIX = "example.additionalFile.";
        private static final String EXPORT_FILE_PREFIX = "example.exportFile.";
        private final File exampleFile;
        private final File directory;
        private final String description;
        private final Properties properties;

        public Example(File file) throws IOException {
            this.exampleFile = file;
            this.directory = file.getParentFile();
            this.properties = new Properties();
            StringBuilder sb = new StringBuilder();
            ExampleChooser.extractDescription(file, sb, this.properties);
            this.description = sb.toString();
        }

        public File getDirectory() {
            return this.directory;
        }

        public File getProofFile() {
            return new File(this.directory, this.properties.getProperty(KEY_PROOF_FILE, ExampleChooser.PROOF_FILE_NAME));
        }

        public File getObligationFile() {
            return new File(this.directory, this.properties.getProperty(KEY_FILE, ExampleChooser.KEY_FILE_NAME));
        }

        public String getName() {
            return this.properties.getProperty(KEY_NAME, this.directory.getName());
        }

        public String getDescription() {
            return this.description;
        }

        public File getExampleFile() {
            return this.exampleFile;
        }

        public List<File> getAdditionalFiles() {
            ArrayList<File> result = new ArrayList<File>();
            int i = 1;
            while (this.properties.containsKey(ADDITIONAL_FILE_PREFIX + i)) {
                result.add(new File(this.directory, this.properties.getProperty(ADDITIONAL_FILE_PREFIX + i)));
                ++i;
            }
            return result;
        }

        public List<File> getExportFiles() {
            ArrayList<File> result = new ArrayList<File>();
            int i = 1;
            while (this.properties.containsKey(EXPORT_FILE_PREFIX + i)) {
                result.add(new File(this.directory, this.properties.getProperty(EXPORT_FILE_PREFIX + i)));
                ++i;
            }
            return result;
        }

        public String[] getPath() {
            return this.properties.getProperty(KEY_PATH, DEFAULT_CATEGORY_PATH).split("/");
        }

        public String toString() {
            return this.getName();
        }

        public void addToTreeModel(DefaultTreeModel model) {
            DefaultMutableTreeNode node = this.findChild((DefaultMutableTreeNode)model.getRoot(), this.getPath(), 0);
            node.add(new DefaultMutableTreeNode(this));
        }

        private DefaultMutableTreeNode findChild(DefaultMutableTreeNode root, String[] path, int from) {
            DefaultMutableTreeNode node;
            if (from == path.length) {
                return root;
            }
            Enumeration<TreeNode> en = root.children();
            while (en.hasMoreElements()) {
                node = (DefaultMutableTreeNode)en.nextElement();
                if (!node.getUserObject().equals(path[from])) continue;
                return this.findChild(node, path, from + 1);
            }
            node = new DefaultMutableTreeNode(path[from]);
            root.add(node);
            return this.findChild(node, path, from + 1);
        }

        public boolean hasProof() {
            return this.properties.containsKey(KEY_PROOF_FILE);
        }
    }
}

